/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.Locale;
import net.outer_planes.jso.BasicPacketNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;

public class PresencePacket
extends BasicPacketNode
implements Presence {
    public static final NSI NAME = new NSI("presence", null);
    public static final NSI NAME_PRIORITY = new NSI("priority", null);
    public static final NSI NAME_SHOW = new NSI("show", null);
    public static final NSI NAME_STATUS = new NSI("status", null);

    public PresencePacket(StreamDataFactory sdf) {
        this(sdf, NAME);
    }

    public PresencePacket(StreamDataFactory sdf, NSI name) {
        super(sdf, name);
    }

    public PresencePacket(StreamElement parent, PresencePacket base) {
        super(parent, base);
    }

    public void checkNSI(NSI check) throws IllegalArgumentException {
        if (NSI.NS_LOOSE_COMPARATOR.compare(check, NAME) != 0) {
            throw new IllegalArgumentException("Name must be 'presence'");
        }
    }

    public StreamObject copy(StreamElement p) {
        return new PresencePacket(p, this);
    }

    public void setType(Packet.Type type) throws IllegalArgumentException {
        if (type != null && type != ERROR && !(type instanceof Presence.Type)) {
            throw new IllegalArgumentException("Only ERROR or presence types permitted");
        }
        super.setType(type);
    }

    protected Packet.Type determineType(String name) {
        Packet.Type type = Utilities.equateStrings(INVISIBLE.toString(), name) ? INVISIBLE : (Utilities.equateStrings(PROBE.toString(), name) ? PROBE : (Utilities.equateStrings(SUBSCRIBE.toString(), name) ? SUBSCRIBE : (Utilities.equateStrings(SUBSCRIBED.toString(), name) ? SUBSCRIBED : (Utilities.equateStrings(UNAVAILABLE.toString(), name) ? UNAVAILABLE : (Utilities.equateStrings(UNSUBSCRIBE.toString(), name) ? UNSUBSCRIBE : (Utilities.equateStrings(UNSUBSCRIBED.toString(), name) ? UNSUBSCRIBED : super.determineType(name)))))));
        return type;
    }

    protected StreamElement getPriorityElement() {
        return this.getFirstElement(NAME_PRIORITY.getLocalName());
    }

    public boolean hasPriority() {
        return this.getPriorityElement() != null;
    }

    public int getPriority() {
        StreamElement elem = this.getPriorityElement();
        int pri = 0;
        if (elem != null) {
            try {
                pri = Integer.parseInt(elem.normalizeTrimText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return pri;
    }

    public void setPriority(int p) {
        if (p < -128 || p > 127) {
            throw new IllegalArgumentException("priority must be between -127 and 128 (inclusive)");
        }
        StreamElement elem = this.getPriorityElement();
        if (elem == null) {
            elem = this.addElement(NAME_PRIORITY.getLocalName());
        }
        elem.clearText();
        elem.addText(String.valueOf(p));
    }

    public void removePriority() {
        this.clearElements(NAME_PRIORITY.getLocalName());
    }

    public String getShow() {
        StreamElement elem = this.getFirstElement(NAME_SHOW.getLocalName(), this.getNamespaceURI());
        String show = null;
        if (elem != null) {
            show = elem.normalizeTrimText();
        }
        return show != null ? show : "";
    }

    public void setShow(String s) {
        this.clearElements(NAME_SHOW.getLocalName(), this.getNamespaceURI());
        if (s != null) {
            this.addElement(NAME_SHOW.getLocalName(), this.getNamespaceURI()).addText(s);
        }
    }

    public boolean hasStatus() {
        return this.hasStatus(null);
    }

    public boolean hasStatus(Locale l) {
        return !this.findElementsForLocale(NAME_STATUS.getLocalName(), this.getNamespaceURI(), l).isEmpty();
    }

    public String getStatus() {
        return this.getStatus(null);
    }

    public String getStatus(Locale l) {
        Iterator itr = this.findElementsForLocale(NAME_STATUS.getLocalName(), this.getNamespaceURI(), l).iterator();
        String status = "";
        if (itr.hasNext()) {
            status = ((StreamElement)itr.next()).normalizeTrimText();
        }
        return status;
    }

    public void setStatus(String s) {
        this.setStatus(null, s);
    }

    public void setStatus(Locale l, String s) {
        Iterator itr = this.findElementsForLocale(NAME_STATUS.getLocalName(), this.getNamespaceURI(), l).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (s != null) {
            StreamElement elem = this.addElement(NAME_STATUS.getLocalName(), this.getNamespaceURI());
            elem.addText(s);
            if (l != null) {
                elem.setDeclaredLocale(l);
            }
        }
    }
}

