/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.outer_planes.jso.AbstractBuilder;
import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;

public class ExtensionBuilder
extends AbstractBuilder {
    private Extension _Ext;
    private StreamBuilder _Extended;
    private List _ElemStack = new LinkedList();

    public ExtensionBuilder(Extension x) throws IllegalArgumentException {
        this.setExtension(x);
    }

    public Extension getExtension() {
        return this._Ext;
    }

    private void setExtension(Extension x) throws IllegalArgumentException {
        if (x == null) {
            throw new IllegalArgumentException("Extension cannot be null");
        }
        this._Ext = x;
    }

    public NSI getName() {
        return this.getExtension().getNSI();
    }

    protected StreamElement getCurrentElement() {
        return this._ElemStack.isEmpty() ? null : this._ElemStack.get(0);
    }

    protected void pushElement(StreamElement elem) {
        this._ElemStack.add(0, elem);
    }

    protected StreamElement popElement() {
        return this._ElemStack.isEmpty() ? null : this._ElemStack.remove(0);
    }

    public StreamNode getNode() throws IllegalStateException {
        if (this.getStatus() != COMPLETE) {
            throw new IllegalStateException("Not ready to get the node!");
        }
        return this.getExtension();
    }

    public StreamBuilder buildExtendedData() throws IllegalStateException {
        return this._Extended;
    }

    protected void setExtendedData(StreamBuilder b) {
        this._Extended = b;
    }

    public void addExtendedData(StreamNode node) throws IllegalStateException {
        this.getExtension().add(node);
    }

    public void reset() {
        Extension x = this.getExtension();
        Iterator itr = x.listNodes().iterator();
        this.setStatus(READY);
        while (itr.hasNext()) {
            x.remove((StreamNode)itr.next());
        }
        this._ElemStack.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processText(StreamParseState s) {
        StreamElement ctx = s.getContext();
        String txt = s.getText();
        StreamElement elem = this.getCurrentElement();
        StreamBuilder.Status status = INVALID;
        try {
            if (elem != null) {
                elem.add(ctx.getDataFactory().createText(txt));
                status = PROCESSING;
            }
        }
        finally {
            this.setStatus(status);
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processElementStart(StreamParseState s) {
        StreamElement ctx = s.getContext();
        NSI name = s.getName();
        NSI.Comparator cmpr = NSI.STRICT_COMPARATOR;
        StreamDataFactory sdf = ctx.getDataFactory();
        Extension x = this.getExtension();
        Set attrs = s.getAttributeNames();
        Set nss = s.getNamespacePrefixes(s.getDepth());
        StreamBuilder.Status status = INVALID;
        try {
            if (NSI.NS_LOOSE_COMPARATOR.compare(name, this.getName()) == 0) {
                Iterator attrItr = attrs.iterator();
                Iterator nssItr = nss.iterator();
                while (attrItr.hasNext()) {
                    NSI attrName = (NSI)attrItr.next();
                    String val = s.getAttributeValue(attrName);
                    x.setAttributeValue(attrName, val);
                }
                while (nssItr.hasNext()) {
                    String nsPre = (String)nssItr.next();
                    String nsURI = s.getNamespaceURI(nsPre);
                    x.addNamespace(nsPre, nsURI);
                }
                this.pushElement(x);
                status = PROCESSING;
            } else {
                status = this.processNestedElementStart(s);
            }
        }
        finally {
            this.setStatus(status);
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processElementEnd(StreamParseState s) {
        NSI name = s.getName();
        Extension x = this.getExtension();
        StreamBuilder.Status status = INVALID;
        try {
            this.popElement();
            status = NSI.NS_LOOSE_COMPARATOR.compare(name, this.getName()) == 0 ? COMPLETE : PROCESSING;
        }
        finally {
            this.setStatus(status);
        }
        return this.getStatus();
    }

    protected StreamBuilder.Status processNestedElementStart(StreamParseState s) {
        StreamElement ctx = s.getContext();
        NSI name = s.getName();
        String uri = name.getNamespaceURI();
        StreamDataFactory sdf = ctx.getDataFactory();
        StreamBuilder.Status status = INVALID;
        StreamBuilder b = sdf.createElementBuilder(name, null);
        if (b == null) {
            b = new ElementNode(sdf, name).createBuilder();
        }
        this.setExtendedData(b);
        status = EXTENDED_DATA;
        return status;
    }
}

