/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.outer_planes.jso.AbstractElement;
import net.outer_planes.jso.ElementBuilder;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.util.Utilities;

public class ElementNode
extends AbstractElement {
    private StreamElement _Parent;
    private NSI _Name;
    private List _Nodes = new LinkedList();

    public ElementNode(StreamDataFactory sdf, NSI name) {
        super(sdf);
        this.setNSI(name);
    }

    protected ElementNode(StreamElement p, ElementNode cp) {
        super(p, cp);
        Iterator itr = cp.getNodes().iterator();
        while (itr.hasNext()) {
            StreamNode node = (StreamNode)itr.next();
            node = (StreamNode)node.copy(this);
            this._Nodes.add(node);
        }
    }

    public StreamBuilder createBuilder() {
        return new ElementBuilder(this);
    }

    public NSI getNSI() {
        return this._Name;
    }

    public void setNSI(NSI name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (this._Name != null) {
            this.checkNSI(name);
        }
        this._Name = name;
    }

    public StreamElement getParent() {
        return this._Parent;
    }

    public void setParent(StreamElement p) throws IllegalStateException {
        this.detach();
        this._Parent = p;
    }

    public List listNodes() {
        return new ArrayList(this.getNodes());
    }

    private List getNodes() {
        return this._Nodes;
    }

    public StreamObject copy(StreamElement p) {
        return new ElementNode(p, this);
    }

    public void add(StreamNode node) throws UnsupportedOperationException {
        if (node != null) {
            node.setParent(this);
            this._Nodes.add(node);
        }
    }

    public void insert(int idx, StreamNode node) throws IllegalArgumentException, UnsupportedOperationException {
        if (node != null) {
            this._Nodes.add(idx, node);
            node.setParent(this);
        }
    }

    public void remove(StreamNode node) throws UnsupportedOperationException {
        if (node != null && this._Nodes.remove(node)) {
            node.setParent(null);
        }
    }

    public void clear() {
        this._Nodes.clear();
    }

    protected void checkNSI(NSI check) throws IllegalArgumentException {
        if (!Utilities.isValidString(check.getLocalName())) {
            throw new IllegalArgumentException("Local name cannot be null or \"\"");
        }
    }

    protected void checkElement(StreamElement check) throws IllegalArgumentException {
    }
}

