/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Iterator;
import java.util.Set;
import net.outer_planes.jso.AbstractBuilder;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;

public class ContextBuilder
extends AbstractBuilder {
    private StreamContext _Ctx;
    private StreamBuilder _Extended;

    public ContextBuilder(StreamContext ctx) {
        this.setContext(ctx);
    }

    public StreamContext getContext() {
        return this._Ctx;
    }

    private void setContext(StreamContext ctx) throws IllegalArgumentException {
        if (ctx == null) {
            throw new IllegalArgumentException("StreamContext cannot be null");
        }
        this._Ctx = ctx;
    }

    public NSI getName() {
        return this.getContext().getNSI();
    }

    public StreamNode getNode() throws IllegalStateException {
        if (this.getStatus() != COMPLETE) {
            throw new IllegalStateException("StreamBuilder not complete");
        }
        return this.getContext();
    }

    public void reset() {
        this.setStatus(READY);
    }

    public void addExtendedData(StreamNode node) throws IllegalStateException {
        this.getContext().add(node);
    }

    public StreamBuilder buildExtendedData() throws IllegalStateException {
        return this._Extended;
    }

    private void setExtendedDataBuilder(StreamBuilder b) {
        this._Extended = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamBuilder.Status processElementStart(StreamParseState s) {
        StreamDataFactory sdf = s.getContext().getDataFactory();
        StreamContext ctx = this.getContext();
        NSI name = s.getName();
        StreamBuilder.Status status = StreamBuilder.INVALID;
        try {
            if (name.equals(this.getName())) {
                Set nss = s.getNamespacePrefixes(s.getDepth());
                Set attrs = s.getAttributeNames();
                Iterator itr = nss.iterator();
                while (itr.hasNext()) {
                    String prefix = (String)itr.next();
                    String uri = s.getNamespaceURI(prefix);
                    ctx.addNamespace(prefix, uri);
                }
                itr = attrs.iterator();
                while (itr.hasNext()) {
                    NSI attrName = (NSI)itr.next();
                    String attrVal = s.getAttributeValue(attrName);
                    ctx.setAttributeValue(attrName, attrVal);
                }
                status = PROCESSING;
            } else {
                StreamBuilder extended = sdf.createPacketBuilder(name);
                if (extended == null) {
                    throw new IllegalStateException("Invalid element \"" + name + "\" encountered");
                }
                this.setExtendedDataBuilder(extended);
                status = EXTENDED_DATA;
            }
        }
        finally {
            this.setStatus(status);
        }
        return this.getStatus();
    }

    public StreamBuilder.Status processElementEnd(StreamParseState s) {
        if (!s.getName().equals(this.getName())) {
            this.setStatus(INVALID);
            throw new IllegalStateException("Unknown Element end encountered");
        }
        this.setStatus(COMPLETE);
        return this.getStatus();
    }

    public StreamBuilder.Status processText(StreamParseState s) {
        if (!this.isWhiteSpace(s.getText())) {
            this.setStatus(INVALID);
            throw new IllegalStateException("Text should not be encountered here (text='" + s.getText() + "')");
        }
        return this.getStatus();
    }

    private boolean isWhiteSpace(String test) {
        boolean result = true;
        for (int idx = 0; idx < test.length() && result; ++idx) {
            result = Character.isWhitespace(test.charAt(idx));
        }
        return result;
    }
}

