/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.outer_planes.jso.ContextBuilder;
import net.outer_planes.jso.DataFactory;
import net.outer_planes.jso.JSO;
import net.outer_planes.jso.io.XMLWriter;
import net.outer_planes.jso.ixp.IxpException;
import net.outer_planes.jso.ixp.IxpParser;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamAttribute;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamElementFactory;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.event.StreamFeaturesEvent;
import org.jabberstudio.jso.event.StreamFeaturesListener;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.util.ContextDecorator;
import org.jabberstudio.jso.util.Utilities;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public abstract class AbstractStream
implements Stream,
StreamDataFactory {
    private JSO _JSO;
    private String _NS;
    private StreamSource _Src;
    private Input _Inbound;
    private StreamContext _InCtx;
    private Stream.Status _InStat;
    private List _InPkts = new ArrayList();
    private List _InFeats = new ArrayList();
    private List _InQueue;
    private Output _Outbound;
    private StreamContext _OutCtx;
    private Stream.Status _OutStat;
    private List _OutPkts = new ArrayList();
    private List _OutFeats = new ArrayList();
    private List _OutQueue;
    private List _StatListens = new ArrayList();
    private StreamException _Except = null;
    private Object _InboundStatusLock = new Object();
    private DataFactory _dataFactory;

    public AbstractStream(JSO jso, DataFactory df, String ns, StreamContext inCtx, StreamContext outCtx) {
        this._dataFactory = df;
        this.setupInbound(inCtx);
        this.setupOutbound(outCtx);
        this.setDefaultNamespace(ns);
        this.setJSO(jso);
    }

    protected Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }

    public StreamContext getInboundContext() {
        return this._InCtx;
    }

    public synchronized Stream.Status getInboundStatus() {
        return this._InStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setInboundStatus(Stream.Status next) {
        Object object = this._InboundStatusLock;
        synchronized (object) {
            this._InStat = next;
            this._InboundStatusLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupInbound(StreamContext ctx) throws IllegalArgumentException {
        this._InCtx = new Context(ctx, true);
        this._InStat = Stream.DISCONNECTED;
        Object object = this._InboundStatusLock;
        synchronized (object) {
            this._InboundStatusLock.notify();
        }
    }

    public StreamContext getOutboundContext() {
        return this._OutCtx;
    }

    public synchronized Stream.Status getOutboundStatus() {
        return this._OutStat;
    }

    private synchronized void setOutboundStatus(Stream.Status next) {
        this._OutStat = next;
    }

    private void setupOutbound(StreamContext ctx) throws IllegalArgumentException {
        this._OutCtx = new Context(ctx, false);
        this._OutStat = Stream.DISCONNECTED;
    }

    public Stream.Status getCurrentStatus() {
        return Stream.Status.getAggregateStatus(this.getInboundStatus(), this.getOutboundStatus());
    }

    public StreamSource getSource() {
        return this._Src;
    }

    public JSOImplementation getJSO() {
        return this._JSO;
    }

    private void setJSO(JSO jso) throws IllegalArgumentException {
        if (jso == null) {
            throw new IllegalArgumentException("JSOImplementation cannot be null");
        }
        this._JSO = jso;
    }

    public StreamDataFactory getDataFactory() {
        return this;
    }

    public String getDefaultNamespace() {
        return this._NS;
    }

    private void setDefaultNamespace(String ns) throws IllegalArgumentException {
        if (!Utilities.isValidString(ns)) {
            throw new IllegalArgumentException("Default namespace cannot be null or \"\"");
        }
        this._NS = ns;
        this.getInboundContext().addNamespace("", ns);
        this.getOutboundContext().addNamespace("", ns);
    }

    protected StreamException getStreamException() {
        return this._Except;
    }

    protected synchronized void setStreamException(StreamException except) {
        this._Except = except;
    }

    public synchronized void addStreamStatusListener(StreamStatusListener l) {
        if (l != null) {
            this._StatListens.add(l);
        }
    }

    public synchronized void removeStreamStatusListener(StreamStatusListener l) {
        if (l != null) {
            this._StatListens.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void fireStatusChangedEvent(StreamContext ctx, Stream.Status next, Exception e) {
        void var5_4;
        Stream.Status prev;
        if (ctx == this.getInboundContext()) {
            prev = this.getInboundStatus();
            this.setInboundStatus(next);
        } else if (ctx == this.getOutboundContext()) {
            prev = this.getOutboundStatus();
            this.setOutboundStatus(next);
        } else {
            this.obtainLogger().warn((Object)"Attempt to fire events for unknown context");
            return;
        }
        if (var5_4 != next) {
            void var7_7;
            AbstractStream abstractStream = this;
            synchronized (abstractStream) {
                if (e == null) {
                    e = this.getStreamException();
                }
                Iterator itr = new ArrayList(this._StatListens).iterator();
                StreamStatusEvent evt = new StreamStatusEvent(this, ctx, (Stream.Status)var5_4, next, e);
            }
            while (var7_7.hasNext()) {
                try {
                    void var4_8;
                    ((StreamStatusListener)var7_7.next()).statusChanged((StreamStatusEvent)var4_8);
                }
                catch (Exception e2) {
                    this.obtainLogger().warn((Object)"StreamStatusListener exception thrown", (Throwable)e2);
                }
            }
        }
    }

    public void addPacketListener(PacketListener l) {
        this.addPacketListener(PacketEvent.RECEIVED, l);
        this.addPacketListener(PacketEvent.SENT, l);
    }

    public void removePacketListener(PacketListener l) {
        this.removePacketListener(PacketEvent.RECEIVED, l);
        this.removePacketListener(PacketEvent.SENT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacketListener(PacketEvent.Type type, PacketListener l) {
        if (l != null) {
            if (type == PacketEvent.RECEIVED) {
                List list = this._InPkts;
                synchronized (list) {
                    this._InPkts.add(l);
                }
            }
            if (type == PacketEvent.SENT) {
                List list = this._OutPkts;
                synchronized (list) {
                    this._OutPkts.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacketListener(PacketEvent.Type type, PacketListener l) {
        if (l != null) {
            if (type == PacketEvent.RECEIVED) {
                List list = this._InPkts;
                synchronized (list) {
                    this._InPkts.remove(l);
                }
            }
            if (type == PacketEvent.SENT) {
                List list = this._OutPkts;
                synchronized (list) {
                    this._OutPkts.remove(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void firePacketTransferredEvent(PacketEvent.Type type) {
        void var5_6;
        AbstractStream abstractStream = this;
        synchronized (abstractStream) {
            void var2_4;
            Iterator pItr;
            ArrayList listeners;
            List queue;
            StreamContext ctx;
            if (type == PacketEvent.RECEIVED) {
                ctx = this.getInboundContext();
                queue = this.getInboundQueue();
                listeners = new ArrayList(this._InPkts);
                pItr = new ArrayList(queue).iterator();
            } else if (type == PacketEvent.SENT) {
                ctx = this.getOutboundContext();
                queue = this.getOutboundQueue();
                listeners = new ArrayList(this._OutPkts);
                pItr = new ArrayList(queue).iterator();
            } else {
                this.obtainLogger().warn((Object)"Attempt to process events for non-existent type");
                return;
            }
            var2_4.clear();
        }
        while (var5_6.hasNext()) {
            void var3_5;
            void var4_3;
            Packet p = (Packet)var5_6.next();
            String uri = p.getNamespaceURI();
            String ln = p.getLocalName();
            PacketEvent evt = new PacketEvent((StreamContext)var4_3, p, type);
            Iterator lItr = var3_5.iterator();
            try {
                if (p instanceof StreamFeatureset) {
                    this.fireFeaturesReported(type, (StreamFeatureset)p);
                }
            }
            catch (Throwable t) {
                this.obtainLogger().warn((Object)"StreamFeatures exception thrown", t);
            }
            while (lItr.hasNext()) {
                try {
                    ((PacketListener)lItr.next()).packetTransferred(evt);
                }
                catch (Throwable t) {
                    this.obtainLogger().warn((Object)"PacketListener exception thrown", t);
                }
            }
            if (p instanceof StreamError) {
                this.setStreamException(new StreamException((StreamError)p));
            }
            p.detach();
        }
    }

    public void addStreamFeaturesListener(StreamFeaturesListener l) {
        this.addStreamFeaturesListener(PacketEvent.RECEIVED, l);
        this.addStreamFeaturesListener(PacketEvent.SENT, l);
    }

    public void removeStreamFeaturesListener(StreamFeaturesListener l) {
        this.removeStreamFeaturesListener(PacketEvent.RECEIVED, l);
        this.removeStreamFeaturesListener(PacketEvent.SENT, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStreamFeaturesListener(PacketEvent.Type type, StreamFeaturesListener l) {
        if (l != null) {
            if (type == PacketEvent.RECEIVED) {
                List list = this._InFeats;
                synchronized (list) {
                    this._InFeats.add(l);
                }
            }
            if (type == PacketEvent.SENT) {
                List list = this._OutFeats;
                synchronized (list) {
                    this._OutFeats.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStreamFeaturesListener(PacketEvent.Type type, StreamFeaturesListener l) {
        if (l != null) {
            if (type == PacketEvent.RECEIVED) {
                List list = this._InFeats;
                synchronized (list) {
                    this._InFeats.remove(l);
                }
            }
            if (type == PacketEvent.SENT) {
                List list = this._OutFeats;
                synchronized (list) {
                    this._OutFeats.remove(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void fireFeaturesReported(PacketEvent.Type type, StreamFeatureset feats) {
        void var5_5;
        Iterator itr = null;
        AbstractStream abstractStream = this;
        synchronized (abstractStream) {
            StreamContext ctx;
            if (type == PacketEvent.RECEIVED) {
                ctx = this.getInboundContext();
                itr = new ArrayList(this._InFeats).iterator();
            } else if (type == PacketEvent.SENT) {
                ctx = this.getOutboundContext();
                itr = new ArrayList(this._OutFeats).iterator();
            } else {
                this.obtainLogger().warn((Object)"Attempt to process stream features events for non-existent type");
                return;
            }
        }
        StreamFeaturesEvent sfe = new StreamFeaturesEvent((StreamContext)var5_5, feats, type);
        while (itr.hasNext()) {
            ((StreamFeaturesListener)itr.next()).featuresReported(sfe);
        }
    }

    protected synchronized List getInboundQueue() {
        if (this._InQueue == null) {
            this._InQueue = Collections.synchronizedList(new LinkedList());
        }
        return this._InQueue;
    }

    protected synchronized List getOutboundQueue() {
        if (this._OutQueue == null) {
            this._OutQueue = Collections.synchronizedList(new LinkedList());
        }
        return this._OutQueue;
    }

    public synchronized void connect(StreamSource src) throws IllegalArgumentException, StreamException {
        Logger log = this.obtainLogger();
        if (this.getCurrentStatus().isConnected()) {
            return;
        }
        if (src == null) {
            throw new IllegalArgumentException("StreamSource cannot be null");
        }
        try {
            this.setStreamException(null);
            src.connect(this);
            this._Src = src;
            this._Outbound = new Output(this.getSource());
            this._Inbound = new Input(this.getSource());
            this.fireStatusChangedEvent(this.getOutboundContext(), Stream.CONNECTED, null);
            this.fireStatusChangedEvent(this.getInboundContext(), Stream.CONNECTED, null);
        }
        catch (Exception e) {
            StreamException se = new StreamException(this.getDataFactory().createStreamError("undefined-condition"), (Throwable)e);
            this.obtainLogger().debug((Object)"throwing StreamException for connect", (Throwable)se);
            throw se;
        }
    }

    public synchronized void disconnect() throws StreamException {
        Logger log = this.obtainLogger();
        StreamException except = this.getStreamException();
        if (this.getCurrentStatus().isDisconnected()) {
            return;
        }
        log.debug((Object)"disconnecting stream...");
        try {
            try {
                this._Src.disconnect(this);
                this._Inbound = null;
                this._Outbound = null;
                this._Src = null;
            }
            catch (IOException ioe) {
                except = new StreamException(this.getDataFactory().createStreamError("remote-connection-failed"), (Throwable)ioe);
                this.obtainLogger().debug((Object)"throwing (I/O) StreamException for disconnect", (Throwable)except);
                throw except;
            }
            catch (Exception e) {
                except = new StreamException(this.getDataFactory().createStreamError("undefined-condition"), (Throwable)e);
                this.obtainLogger().debug((Object)"throwing (general) StreamException for disconnect", (Throwable)except);
                throw except;
            }
            Object var5_3 = null;
            if (this.getStreamException() != null) {
                except = this.getStreamException();
            }
            this.fireStatusChangedEvent(this.getOutboundContext(), Stream.DISCONNECTED, except);
            this.fireStatusChangedEvent(this.getInboundContext(), Stream.DISCONNECTED, except);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.getStreamException() != null) {
                except = this.getStreamException();
            }
            this.fireStatusChangedEvent(this.getOutboundContext(), Stream.DISCONNECTED, except);
            this.fireStatusChangedEvent(this.getInboundContext(), Stream.DISCONNECTED, except);
            throw throwable;
        }
    }

    public synchronized void open() throws StreamException {
        this.open(0L);
    }

    public void open(long timeout) throws StreamException {
        Logger log = this.obtainLogger();
        StreamException except = null;
        if (!this.getCurrentStatus().isConnected()) {
            return;
        }
        try {
            this.setupOpen();
            this.openOutbound();
            this.openInbound(timeout);
        }
        catch (StreamException se) {
            except = se;
        }
        catch (Exception e) {
            except = new StreamException(this.getDataFactory().createStreamError("undefined-condition"), (Throwable)e);
        }
        if (except != null) {
            try {
                this.close();
            }
            catch (Exception e) {
                this.obtainLogger().info((Object)"Exception thrown on open->close", (Throwable)e);
            }
            try {
                this.disconnect();
            }
            catch (Exception e) {
                this.obtainLogger().info((Object)"Exception thrown on open->disconnect", (Throwable)e);
            }
            this.obtainLogger().debug((Object)"throwing StreamException for open", (Throwable)except);
            throw except;
        }
    }

    protected abstract void setupOpen() throws Exception;

    public void openOutbound() throws StreamException {
        StreamContext out = this.getOutboundContext();
        try {
            if (out.getCurrentStatus().isOpened()) {
                return;
            }
            this.setupOpen();
            if (!Utilities.isValidString(out.getNamespaceURI(""))) {
                out.addNamespace("", this.getDefaultNamespace());
            }
            if (!Utilities.isValidString(out.getNamespacePrefix(out.getNamespaceURI()))) {
                out.addNamespace("stream", out.getNamespaceURI());
            }
            this._Outbound.sendOpen();
            this.fireStatusChangedEvent(out, Stream.OPENED, null);
        }
        catch (IOException ioe) {
            StreamError err = this.getDataFactory().createStreamError("remote-connection-failed");
            StreamException se = new StreamException(err, (Throwable)ioe);
            this.obtainLogger().debug((Object)"throwing (I/O) StreamException for open(outbound)", (Throwable)se);
            throw se;
        }
        catch (Exception e) {
            StreamError err = this.getDataFactory().createStreamError("undefined-condition");
            StreamException se = new StreamException(err, (Throwable)e);
            this.obtainLogger().debug((Object)"throwing (general) StreamException for open(outbound)", (Throwable)se);
            throw se;
        }
    }

    public void openInbound() throws StreamException {
        this.openInbound(0L);
    }

    public boolean tryOpenInbound() throws StreamException {
        this.process();
        return this.getInboundStatus().isOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openInbound(long timeout) throws StreamException {
        long wait_time = 100L;
        this.process();
        for (long total_wait = 0L; this.getInboundStatus().isConnected() && !this.getInboundStatus().isOpened() && (timeout <= 0L || total_wait <= timeout); total_wait += wait_time) {
            Object object = this._InboundStatusLock;
            synchronized (object) {
                try {
                    this._InboundStatusLock.wait(wait_time);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.process();
        }
        if (this.getInboundStatus().isDisconnected()) {
            throw new StreamException(this.getDataFactory().createStreamError("remote-connection-failed"));
        }
        if (!this.getInboundStatus().isOpened()) {
            throw new StreamException(this.getDataFactory().createStreamError("connection-timeout"));
        }
    }

    public void drop() throws StreamException {
        Logger log = this.obtainLogger();
        try {
            this._Outbound = new Output(this.getSource());
            this._Inbound = new Input(this.getSource());
            this.fireStatusChangedEvent(this.getInboundContext(), Stream.CONNECTED, null);
            this.fireStatusChangedEvent(this.getOutboundContext(), Stream.CONNECTED, null);
        }
        catch (Exception e) {
            StreamException se = new StreamException(this.getDataFactory().createStreamError("undefined-condition"), (Throwable)e);
            this.obtainLogger().info((Object)"throwing StreamException for drop", (Throwable)se);
            throw se;
        }
    }

    public void close() throws StreamException {
        this.close(null, 0L);
    }

    public void close(long timeout) throws StreamException {
        this.close(null, timeout);
    }

    public synchronized void close(StreamException se) throws StreamException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(StreamException se, long timeout) throws StreamException {
        block13: {
            Logger log = this.obtainLogger();
            if (!this.getInboundStatus().isOpened() && !this.getOutboundStatus().isOpened()) {
                return;
            }
            try {
                this.setStreamException(se);
                if (this.getOutboundStatus().isOpened()) {
                    this._Outbound.sendClose(se);
                    this.fireStatusChangedEvent(this.getOutboundContext(), Stream.CLOSED, se);
                }
                int wait_time = 100;
                int total_wait = 0;
                while (this.getInboundStatus().isOpened()) {
                    this.process();
                    if (timeout > 0L && (long)total_wait > timeout) {
                        throw new StreamException(this.getDataFactory().createStreamError("remote-connection-failed"));
                    }
                    Object object = this._InboundStatusLock;
                    synchronized (object) {
                        try {
                            this._InboundStatusLock.wait(wait_time);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    total_wait += wait_time;
                    wait_time *= 2;
                }
            }
            catch (Exception e) {
                this.obtainLogger().info((Object)"exception thrown while closing", (Throwable)e);
                if (se != null) break block13;
                if (e instanceof StreamException) {
                    se = (StreamException)e;
                }
                StreamError err = this.getDataFactory().createStreamError("undefined-condition");
                err.setText(e.getMessage());
                se = new StreamException(err);
            }
        }
        if (se != null) {
            this.obtainLogger().debug((Object)"throwing exception for close", (Throwable)se);
            throw se;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Packet p) throws StreamException {
        StreamError err = null;
        StreamException except = null;
        if (!this.getOutboundStatus().isOpened()) {
            return;
        }
        AbstractStream abstractStream = this;
        synchronized (abstractStream) {
            try {
                this._Outbound.sendPacket(p);
            }
            catch (IOException ioe) {
                err = this.getDataFactory().createStreamError("remote-connection-failed");
                except = new StreamException(err, (Throwable)ioe);
            }
            catch (Exception e) {
                err = this.getDataFactory().createStreamError("undefined-condition");
                except = new StreamException(err, (Throwable)e);
            }
        }
        this.firePacketTransferredEvent(PacketEvent.SENT);
        if (except != null) {
            try {
                this.close(except);
            }
            catch (StreamException se) {
                this.obtainLogger().info((Object)"stream exception thrown on send->close", (Throwable)se);
            }
            try {
                this.disconnect();
            }
            catch (StreamException se) {
                this.obtainLogger().info((Object)"stream exception thrown on send->disconnect", (Throwable)se);
            }
            this.obtainLogger().debug((Object)"throwing exception for send", (Throwable)except);
            throw except;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws StreamException {
        Logger log = this.obtainLogger();
        StreamError err = null;
        StreamException except = null;
        StreamException caught = null;
        if (this.getInboundStatus().isConnected()) {
            AbstractStream abstractStream = this;
            synchronized (abstractStream) {
                try {
                    this._Inbound.process();
                }
                catch (IOException ioe) {
                    err = this.getDataFactory().createStreamError("remote-connection-failed");
                    caught = new StreamException(err, (Throwable)ioe);
                }
                catch (IxpException ixpe) {
                    err = this.getDataFactory().createStreamError("invalid-xml");
                    caught = new StreamException(err, (Throwable)ixpe);
                }
                catch (RuntimeException re) {
                    err = this.getDataFactory().createStreamError("undefined-condition");
                    caught = new StreamException(err, (Throwable)re);
                }
                except = this.getStreamException();
            }
        }
        if (except == null) {
            except = caught;
        }
        if (except == null) {
            except = this.getStreamException();
        }
        if (except != null) {
            Stream.Status outStat = this.getOutboundStatus();
            if (outStat != CLOSED && !outStat.isOpened()) {
                try {
                    this.openOutbound();
                }
                catch (Exception e) {
                    this.obtainLogger().error((Object)"failed to open outbound stream", (Throwable)e);
                }
            }
            try {
                if (this.getOutboundStatus().isOpened()) {
                    this.close(caught == this.getStreamException() ? null : caught);
                }
            }
            catch (StreamException se) {
                this.obtainLogger().info((Object)"stream exception thrown on process->close", (Throwable)se);
            }
            try {
                this.disconnect();
            }
            catch (StreamException se) {
                this.obtainLogger().info((Object)"stream exception thrown on process->disconnect", (Throwable)se);
            }
            this.obtainLogger().debug((Object)"throwing exception for process", (Throwable)except);
            throw except;
        }
    }

    public StreamElement createElement(NSI name) {
        return this._dataFactory.createElement(name);
    }

    public StreamElement createElement(String name) {
        return this._dataFactory.createElement(name);
    }

    public StreamElement createElement(String name, String uri) {
        return this._dataFactory.createElement(name, uri);
    }

    public StreamBuilder createElementBuilder(NSI name) {
        return this._dataFactory.createElementBuilder(name);
    }

    public StreamBuilder createElementBuilder(NSI name, Class iface) {
        return this._dataFactory.createElementBuilder(name, iface);
    }

    public StreamElement createElementNode(NSI name) {
        return this._dataFactory.createElementNode(name);
    }

    public StreamElement createElementNode(NSI name, Class iface) {
        return this._dataFactory.createElementNode(name, iface);
    }

    public PacketError createError(int code) {
        return this._dataFactory.createError(code);
    }

    public PacketError createError(int code, String msg) {
        return this._dataFactory.createError(code, msg);
    }

    public StreamBuilder createExtensionBuilder(NSI name) {
        return this._dataFactory.createExtensionBuilder(name);
    }

    public StreamBuilder createExtensionBuilder(NSI name, Class iface) {
        return this._dataFactory.createExtensionBuilder(name, iface);
    }

    public Extension createExtensionNode(NSI name) {
        return this._dataFactory.createExtensionNode(name);
    }

    public Extension createExtensionNode(NSI name, Class iface) {
        return this._dataFactory.createExtensionNode(name, iface);
    }

    public JID createJID(Object spec) {
        return this._dataFactory.createJID(spec);
    }

    public JID createJID(String node, String domain, String resource) {
        return this._dataFactory.createJID(node, domain, resource);
    }

    public NSI createNSI(String name, String uri) {
        return this._dataFactory.createNSI(name, uri);
    }

    public StreamBuilder createPacketBuilder(NSI name) {
        return this._dataFactory.createPacketBuilder(name);
    }

    public StreamBuilder createPacketBuilder(NSI name, Class iface) {
        return this._dataFactory.createPacketBuilder(name, iface);
    }

    public PacketError createPacketError(PacketError.Type type, String cond) {
        return this._dataFactory.createPacketError(type, cond);
    }

    public Packet createPacketNode(NSI name) {
        return this._dataFactory.createPacketNode(name);
    }

    public Packet createPacketNode(NSI name, Class iface) {
        return this._dataFactory.createPacketNode(name, iface);
    }

    public StreamError createStreamError(String cond) {
        return this._dataFactory.createStreamError(cond);
    }

    public StreamText createText(String txt) {
        return this._dataFactory.createText(txt);
    }

    public XPath createXPath(String expr) throws SAXPathException {
        return this._dataFactory.createXPath(expr);
    }

    public XPath createXPath(String expr, Map nss) throws SAXPathException {
        return this._dataFactory.createXPath(expr, nss);
    }

    public Map getNamespaceMappings() {
        return this._dataFactory.getNamespaceMappings();
    }

    public Set getSupportedElements() {
        return this._dataFactory.getSupportedElements();
    }

    public boolean isSupportedElement(NSI name, Class iface) {
        return this._dataFactory.isSupportedElement(name, iface);
    }

    public void putNamespaceMapping(String prefix, String uri) {
        this._dataFactory.putNamespaceMapping(prefix, uri);
    }

    public void registerElementFactory(StreamElementFactory sef) {
        this._dataFactory.registerElementFactory(sef);
    }

    public void registerElementFactory(NSI name, StreamElementFactory sef) {
        this._dataFactory.registerElementFactory(name, sef);
    }

    public void removeNamespaceMapping(String prefix) {
        this._dataFactory.removeNamespaceMapping(prefix);
    }

    public void setNamespaceMappings(Map nss) {
        this._dataFactory.setNamespaceMappings(nss);
    }

    public void unregisterElementFactory(StreamElementFactory sef) {
        this._dataFactory.unregisterElementFactory(sef);
    }

    public void unregisterElementFactory(NSI name, StreamElementFactory sef) {
        this._dataFactory.unregisterElementFactory(name, sef);
    }

    protected StreamElementFactory getElementFactory(NSI name, Class iface) {
        return this._dataFactory.getElementFactory(name, iface);
    }

    protected void registerElementFactoryDirect(NSI name, StreamElementFactory sef) {
        this._dataFactory.registerElementFactoryDirect(name, sef);
    }

    protected void unregisterElementFactoryDirect(NSI name, StreamElementFactory sef) {
        this._dataFactory.unregisterElementFactoryDirect(name, sef);
    }

    private class Context
    extends ContextDecorator {
        private StreamContext _Base;
        private boolean _Inbound;

        public Context(StreamContext base, boolean inbound) {
            this.setContext(base);
            this._Inbound = inbound;
        }

        protected StreamContext getDecoratedContext() {
            return this._Base;
        }

        protected void setContext(StreamContext ctx) throws IllegalArgumentException {
            if (ctx == null) {
                throw new IllegalArgumentException("StreamContext cannot be null");
            }
            this._Base = ctx;
        }

        public boolean isInbound() {
            return this._Inbound;
        }

        public boolean isOutbound() {
            return !this._Inbound;
        }

        public Stream getStream() {
            return AbstractStream.this;
        }

        public StreamDataFactory getFactory() {
            return AbstractStream.this.getDataFactory();
        }

        public StreamDataFactory getDataFactory() {
            return AbstractStream.this.getDataFactory();
        }

        public PacketRouter getRouter() {
            return AbstractStream.this;
        }

        public Stream.Status getCurrentStatus() {
            return this._Inbound ? AbstractStream.this.getInboundStatus() : AbstractStream.this.getOutboundStatus();
        }

        public StreamObject copy(StreamElement p) {
            return new Context(this.getDecoratedContext(), this.isInbound());
        }
    }

    private class Output {
        private StreamSource _Writer;
        private XMLWriter _Exporter;

        public Output(StreamSource out) {
            StreamContext ctx = AbstractStream.this.getOutboundContext();
            this._Writer = out;
            this._Exporter = new XMLWriter(ctx);
        }

        public void sendOpen() throws IOException {
            String uri;
            StreamContext ctx = AbstractStream.this.getOutboundContext();
            StringBuffer buffer = new StringBuffer();
            Map attrs = ctx.getAttributes();
            boolean procDefaultNS = false;
            boolean procThisNS = false;
            String charset = ctx.obtainCharset().name();
            buffer.append("<").append(ctx.getQualifiedName());
            Iterator<Object> itr = ctx.getDeclaredNamespaces().iterator();
            while (itr.hasNext()) {
                StreamNamespace ns = (StreamNamespace)itr.next();
                String uri2 = ns.getURI();
                String prefix = ns.getPrefix();
                uri2 = this.encodeAttributeValue(uri2);
                buffer.append(" ");
                buffer.append("xmlns");
                if (Utilities.isValidString(prefix)) {
                    buffer.append(":").append(prefix);
                } else {
                    procDefaultNS = true;
                }
                buffer.append("=").append("'").append(uri2).append("'");
                if (!Utilities.equateStrings(uri2, ctx.getNamespaceURI())) continue;
                procThisNS = true;
            }
            if (!procDefaultNS) {
                uri = this.encodeAttributeValue(AbstractStream.this.getDefaultNamespace());
                buffer.append(" ");
                buffer.append("xmlns");
                buffer.append("=").append("'").append(uri).append("'");
            }
            if (!procThisNS) {
                uri = this.encodeAttributeValue(ctx.getNamespaceURI());
                String prefix = ctx.getNamespacePrefix();
                if (prefix == null) {
                    prefix = "stream";
                }
                buffer.append(" ");
                buffer.append("xmlns:").append(prefix);
                buffer.append("=").append("'").append(uri).append("'");
            }
            itr = attrs.keySet().iterator();
            while (itr.hasNext()) {
                NSI name = (NSI)itr.next();
                StreamAttribute attr = (StreamAttribute)attrs.get(name);
                String val = this.encodeAttributeValue(attr.getValue());
                buffer.append(" ");
                buffer.append(attr.getQualifiedName()).append("=").append("'").append(val).append("'");
            }
            buffer.append(">");
            byte[] output = buffer.toString().getBytes(charset);
            this._Writer.write(output, 0, output.length);
        }

        public void sendPacket(Packet p) throws IOException {
            StreamContext ctx = AbstractStream.this.getOutboundContext();
            String buffer = " ";
            String charset = ctx.obtainCharset().name();
            if (p != null) {
                this._Exporter.getContext().add(p);
                buffer = this._Exporter.write(p);
                this._Exporter.getContext().remove(p);
            }
            byte[] output = buffer.getBytes(charset);
            this._Writer.write(output, 0, output.length);
            if (p != null) {
                AbstractStream.this.getOutboundQueue().add(p);
            }
        }

        public void sendClose(StreamException se) throws IOException {
            StreamContext ctx = AbstractStream.this.getOutboundContext();
            StringBuffer buffer = new StringBuffer();
            if (se != null) {
                buffer.append(this._Exporter.write(se.asNode(ctx)).toString());
            }
            buffer.append("</").append(ctx.getQualifiedName()).append(">");
            byte[] output = buffer.toString().getBytes("UTF-8");
            this._Writer.write(output, 0, output.length);
        }

        private String encodeAttributeValue(String attr) {
            StringBuffer buffer = new StringBuffer();
            block7: for (int idx = 0; idx < attr.length(); ++idx) {
                char ch = attr.charAt(idx);
                switch (ch) {
                    case '&': {
                        buffer.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        buffer.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        buffer.append("&gt;");
                        continue block7;
                    }
                    case '\'': {
                        buffer.append("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        buffer.append("&quot;");
                        continue block7;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
            }
            return buffer.toString();
        }
    }

    private class Input {
        private IxpParser _Parser;
        private List _BuildStack = new LinkedList();
        private boolean _Opened = false;

        public Input(StreamSource in) {
            StreamContext ctx = AbstractStream.this.getInboundContext();
            this._Parser = new IxpParser(AbstractStream.this.getInboundContext(), in);
            this.pushBuilder(ctx.getNSI(), new ContextBuilder(this, ctx, AbstractStream.this){
                private final /* synthetic */ AbstractStream val$this$0;
                private final /* synthetic */ Input this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void addExtendedData(StreamNode data) {
                    Packet packet = (Packet)data;
                    String uri = packet.getNamespaceURI();
                    String ln = packet.getLocalName();
                    Locale lang = this.getContext().getLocale();
                    Locale declared = packet.getDeclaredLocale();
                    if (declared == null) {
                        packet.setDeclaredLocale(lang);
                    }
                    if (data instanceof StreamError) {
                        Input.access$000(this.this$1).setStreamException(new StreamException((StreamError)data));
                    }
                    super.addExtendedData(data);
                    Input.access$000(this.this$1).getInboundQueue().add(packet);
                    Input.access$000(this.this$1).firePacketTransferredEvent(PacketEvent.RECEIVED);
                }

                public StreamBuilder.Status processElementStart(StreamParseState state) {
                    StreamBuilder.Status stat = super.processElementStart(state);
                    if (stat == StreamBuilder.PROCESSING) {
                        Input.access$000(this.this$1).fireStatusChangedEvent(this.getContext(), Stream.OPENED, null);
                    }
                    return stat;
                }

                public StreamBuilder.Status processElementEnd(StreamParseState state) {
                    StreamBuilder.Status stat = super.processElementEnd(state);
                    if (stat == StreamBuilder.COMPLETE) {
                        Input.access$000(this.this$1).fireStatusChangedEvent(this.getContext(), Stream.CLOSED, Input.access$000(this.this$1).getStreamException());
                        try {
                            Input.access$000(this.this$1).close();
                        }
                        catch (StreamException se) {
                            Input.access$000(this.this$1).obtainLogger().info((Object)"Somewhat unexpected stream exception thrown", (Throwable)se);
                        }
                        try {
                            Input.access$000(this.this$1).disconnect();
                        }
                        catch (StreamException se) {
                            Input.access$000(this.this$1).obtainLogger().info((Object)"Somewhat unexpected stream exception thrown", (Throwable)se);
                        }
                    }
                    return stat;
                }
            });
        }

        private final boolean isOpened() {
            return this._Opened;
        }

        private final void setOpened(boolean open) {
            this._Opened = open;
        }

        public synchronized void process() throws IOException, IxpException {
            StreamParseState ps;
            Logger log = AbstractStream.this.obtainLogger();
            BuilderPlace place = this.topBuilder();
            StreamBuilder b = place != null ? place.builder : null;
            NSI name = place != null ? place.name : null;
            boolean opened = this.isOpened();
            while (b != null && name != null && (ps = this._Parser.process()) != null) {
                if (ps.getType() == StreamParseState.ELEMENT_START) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("processing start of element (" + ps.getName() + ")"));
                    }
                    while (b.processElementStart(ps) == StreamBuilder.EXTENDED_DATA) {
                        log.debug((Object)"pushing extended data");
                        b = b.buildExtendedData();
                        name = ps.getName();
                        this.pushBuilder(name, b);
                    }
                    this.setOpened(true);
                    if (opened) continue;
                    break;
                }
                if (ps.getType() == StreamParseState.ELEMENT_END) {
                    boolean complete = false;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("processing end of element (" + ps.getName() + ")"));
                    }
                    do {
                        boolean bl = complete = b.processElementEnd(ps) == StreamBuilder.COMPLETE;
                        if (!complete) continue;
                        StreamNode node = b.getNode();
                        log.debug((Object)"popping extended data");
                        this.popBuilder();
                        place = this.topBuilder();
                        if (place != null) {
                            b = place.builder;
                            name = place.name;
                            b.addExtendedData(node);
                            continue;
                        }
                        name = null;
                    } while (complete && ps.getName().equals(name));
                    continue;
                }
                if (ps.getType() != StreamParseState.TEXT) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("processing text (" + ps.getText() + ")"));
                }
                b.processText(ps);
            }
            if (this._Parser.isEOD()) {
                log.debug((Object)"end of document...");
                AbstractStream.this.fireStatusChangedEvent(AbstractStream.this.getInboundContext(), Stream.DISCONNECTED, null);
            }
        }

        private BuilderPlace topBuilder() {
            return this._BuildStack.isEmpty() ? null : this._BuildStack.get(0);
        }

        private void pushBuilder(NSI name, StreamBuilder b) {
            this._BuildStack.add(0, new BuilderPlace(name, b));
        }

        private BuilderPlace popBuilder() {
            return this._BuildStack.isEmpty() ? null : this._BuildStack.remove(0);
        }

        static /* synthetic */ AbstractStream access$000(Input x0) {
            return x0.AbstractStream.this;
        }

        public class BuilderPlace {
            public final NSI name;
            public final StreamBuilder builder;

            public BuilderPlace(NSI name, StreamBuilder b) {
                this.name = name;
                this.builder = b;
            }
        }
    }
}

