/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.outer_planes.jso.AbstractAttribute;
import net.outer_planes.jso.AbstractNode;
import net.outer_planes.jso.NamespaceNode;
import net.outer_planes.jso.io.XMLReader;
import net.outer_planes.jso.io.XMLWriter;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamAttribute;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.StreamObjectVisitor;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.format.LocaleFormat;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.util.Utilities;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.VariableContext;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public abstract class AbstractElement
extends AbstractNode
implements StreamElement {
    public static final NSI NON_NSI = new NSI(null, null);
    public static final NSI ATTRNAME_ID = new NSI("id", null);
    public static final NSI ATTRNAME_XMLLANG = new NSI("lang", "http://www.w3.org/XML/1998/namespace");
    private Map _Nss = new TreeMap();
    private Map _Attrs = new TreeMap(NSI.NS_LOOSE_COMPARATOR);
    private XPath _LocalePath;
    static /* synthetic */ Class class$net$outer_planes$jso$AbstractElement;

    public AbstractElement(StreamDataFactory sdf) {
        super(sdf);
    }

    public AbstractElement(StreamElement parent, AbstractElement base) {
        super(base.getDataFactory());
        this.setParent(parent);
        this.setNSI(base.getNSI());
        this.setDeclaredNamespaces(base.getDeclaredNamespaces());
        this.setAttributes(base.getAttributes());
    }

    public abstract StreamBuilder createBuilder();

    protected XPath getLocaleXPath() {
        if (this._LocalePath == null) {
            try {
                this._LocalePath = this.getDataFactory().createXPath("*[(not($ln) or local-name()=$ln) and (not($ns) or namespace-uri()=$ns) and locale-match($lang)]");
                this._LocalePath.setVariableContext((VariableContext)new SimpleVariableContext());
                Utilities.setupNamespaces(this._LocalePath, Collections.singletonMap("app", this.getNamespaceURI()));
            }
            catch (SAXPathException saxpe) {
                this.obtainLogger().error((Object)"Could not create Locale-based XPath object", (Throwable)saxpe);
            }
        }
        return this._LocalePath;
    }

    public String getLocalName() {
        return this.getNSI().getLocalName();
    }

    public String getNamespacePrefix() {
        return this.getNamespacePrefix(this.getNamespaceURI());
    }

    public String getNamespaceURI() {
        StreamElement parent = this.getParent();
        String uri = this.getNSI().getNamespaceURI();
        if (uri == null && parent != null) {
            uri = parent instanceof StreamContext ? parent.getNamespaceURI("") : parent.getNamespaceURI();
        }
        return uri;
    }

    public String getQualifiedName() {
        StringBuffer buffer = new StringBuffer();
        String prefix = this.getNamespacePrefix();
        String local = this.getLocalName();
        if (prefix != null) {
            buffer.append(prefix).append(":");
        }
        buffer.append(local);
        return buffer.toString();
    }

    public abstract void setNSI(NSI var1) throws IllegalArgumentException;

    public Set getDeclaredNamespaces() {
        TreeSet vals = new TreeSet(new Comparator(){

            public int compare(Object cmp1, Object cmp2) {
                return cmp1.toString().compareTo(cmp2.toString());
            }
        });
        vals.addAll(this._Nss.values());
        return vals;
    }

    public void setDeclaredNamespaces(Set nss) {
        Iterator itr = nss.iterator();
        while (itr.hasNext()) {
            StreamNamespace ns = (StreamNamespace)itr.next();
            this._Nss.put(ns.getPrefix(), ns.copy(this));
        }
    }

    public StreamNamespace getNamespaceByURI(String uri) {
        return this.getNamespaceByURI(uri, true);
    }

    protected StreamNamespace getNamespaceByURI(String uri, boolean deep) {
        Set nss = this.getDeclaredNamespaces();
        Iterator nsItr = nss.iterator();
        StreamNamespace ns = null;
        if (uri == null) {
            uri = "";
        }
        if (Utilities.equateStrings("http://www.w3.org/XML/1998/namespace", uri)) {
            ns = new NamespaceNode(this, "xml", "http://www.w3.org/XML/1998/namespace");
        }
        while (ns == null && nsItr.hasNext()) {
            StreamNamespace test = (StreamNamespace)nsItr.next();
            if (!Utilities.equateStrings(test.getURI(), uri)) continue;
            ns = test;
        }
        if (ns == null && this.getParent() != null && deep) {
            ns = this.getParent().getNamespaceByURI(uri);
        }
        return ns;
    }

    public StreamNamespace getNamespaceByPrefix(String prefix) {
        return this.getNamespaceByPrefix(prefix, true);
    }

    protected StreamNamespace getNamespaceByPrefix(String prefix, boolean deep) {
        Set nss = this.getDeclaredNamespaces();
        Iterator nsItr = nss.iterator();
        StreamNamespace ns = null;
        if (prefix == null) {
            prefix = "";
        }
        if (Utilities.equateStrings("xml", prefix)) {
            ns = new NamespaceNode(this, "xml", "http://www.w3.org/XML/1998/namespace");
        }
        while (ns == null && nsItr.hasNext()) {
            StreamNamespace test = (StreamNamespace)nsItr.next();
            if (!Utilities.equateStrings(test.getPrefix(), prefix)) continue;
            ns = test;
        }
        if (ns == null && this.getParent() != null && deep) {
            ns = this.getParent().getNamespaceByPrefix(prefix);
        }
        return ns;
    }

    public String getNamespacePrefix(String uri) throws IllegalArgumentException {
        StreamNamespace ns = this.getNamespaceByURI(uri);
        return ns != null ? ns.getPrefix() : null;
    }

    public String getNamespaceURI(String prefix) throws IllegalArgumentException {
        StreamNamespace ns = this.getNamespaceByPrefix(prefix);
        return ns != null ? ns.getURI() : null;
    }

    public void addNamespace(String prefix, String uri) throws UnsupportedOperationException {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        NamespaceNode ns = new NamespaceNode(this, prefix, uri);
        StreamNamespace currentNS = this.getNamespaceByPrefix(ns.getPrefix(), false);
        this.addNamespace(ns);
    }

    public void addNamespace(StreamNamespace ns) {
        this._Nss.put(ns.getPrefix(), ns);
    }

    public void removeNamespace(String prefix, String uri) throws UnsupportedOperationException {
        if (uri == null) {
            uri = "";
        }
        this.removeNamespace(this.getNamespaceByURI(uri, false));
    }

    public void removeNamespace(StreamNamespace ns) {
        this._Nss.remove(ns.getPrefix());
    }

    public Map getAttributes() {
        return this._Attrs;
    }

    public void setAttributes(Map attrs) {
        Iterator itr = attrs.values().iterator();
        while (itr.hasNext()) {
            StreamAttribute attr = (StreamAttribute)itr.next();
            this._Attrs.put(attr.getNSI(), attr.copy(this));
        }
    }

    public String getAttributeValue(String name) throws IllegalArgumentException {
        return this.getAttributeValue(new NSI(name, null));
    }

    public String getAttributeValue(String name, String ns) throws IllegalArgumentException {
        return this.getAttributeValue(new NSI(name, ns));
    }

    public String getAttributeValue(NSI name) throws IllegalArgumentException {
        Object val = this.getAttributeObject(name);
        return val != null ? val.toString() : null;
    }

    protected Object getAttributeObject(String name) throws IllegalArgumentException {
        return this.getAttributeObject(new NSI(name, null));
    }

    protected Object getAttributeObject(String name, String ns) throws IllegalArgumentException {
        return this.getAttributeObject(new NSI(name, ns));
    }

    protected Object getAttributeObject(NSI name) throws IllegalArgumentException {
        ObjectAttribute attr;
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Attribute local name cannot be null or \"\"");
        }
        if (name.getNamespaceURI() == null) {
            name = new NSI(name.getLocalName(), "");
        }
        return (attr = (ObjectAttribute)this._Attrs.get(name)) != null ? attr.getObject() : null;
    }

    public void setAttributeValue(String name, String val) throws IllegalArgumentException, UnsupportedOperationException {
        this.setAttributeValue(new NSI(name, null), val);
    }

    public void setAttributeValue(String name, String ns, String val) throws IllegalArgumentException, UnsupportedOperationException {
        this.setAttributeValue(new NSI(name, ns), val);
    }

    public void setAttributeValue(NSI name, String val) throws IllegalArgumentException, UnsupportedOperationException {
        this.setAttributeObject(name, (Object)val);
    }

    protected void setAttributeObject(String name, Object val) throws IllegalArgumentException {
        this.setAttributeObject(new NSI(name, null), val);
    }

    protected void setAttributeObject(String name, String ns, Object val) throws IllegalArgumentException {
        this.setAttributeObject(new NSI(name, ns), val);
    }

    protected void setAttributeObject(NSI name, Object val) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (!Utilities.isValidString(name.getLocalName())) {
            throw new IllegalArgumentException("Attribute local name cannot be null or \"\"");
        }
        if (val == null) {
            if (this._Attrs.containsKey(name)) {
                this._Attrs.remove(name);
            }
        } else {
            ObjectAttribute attr = (ObjectAttribute)this._Attrs.get(name);
            if (attr != null) {
                attr.setObject(val);
            } else {
                if (name.getNamespaceURI() == null) {
                    name = new NSI(name.getLocalName(), "");
                }
                this._Attrs.put(name, new ObjectAttribute(this, name, val));
            }
        }
    }

    public String getLanguage() {
        String lang = this.getDeclaredLanguage();
        return Utilities.isValidString(lang) ? lang : super.getLanguage();
    }

    public String getID() {
        return this.getAttributeValue(ATTRNAME_ID);
    }

    public void setID(String id) {
        this.setAttributeValue(ATTRNAME_ID, id);
    }

    public String getDeclaredLanguage() {
        String lang = this.getAttributeValue(ATTRNAME_XMLLANG);
        return lang != null ? lang : "";
    }

    public void setDeclaredLanguage(String lang) throws UnsupportedOperationException {
        if (!Utilities.isValidString(lang)) {
            lang = null;
        }
        this.setAttributeValue(ATTRNAME_XMLLANG, lang);
    }

    public Locale getLocale() {
        Locale lang = this.getDeclaredLocale();
        return lang != null ? lang : super.getLocale();
    }

    public Locale getDeclaredLocale() {
        Object val = this.getAttributeObject(ATTRNAME_XMLLANG);
        Locale lang = null;
        if (val instanceof LocaleWrapper) {
            lang = ((LocaleWrapper)val).getLocale();
        } else if (val != null) {
            try {
                lang = (Locale)LocaleFormat.getInstance().parseObject(val.toString());
                this.setDeclaredLocale(lang);
            }
            catch (Exception e) {
                this.obtainLogger().warn((Object)"Could not parse xml:lang into locale", (Throwable)e);
            }
        }
        return lang;
    }

    public void setDeclaredLocale(Locale lang) {
        LocaleWrapper lw = lang != null ? new LocaleWrapper(lang) : null;
        this.setAttributeObject(ATTRNAME_XMLLANG, (Object)lw);
    }

    public List listText() {
        Iterator itr = this.listNodes().iterator();
        LinkedList<StreamNode> text = new LinkedList<StreamNode>();
        while (itr.hasNext()) {
            StreamNode node = (StreamNode)itr.next();
            if (!(node instanceof StreamText)) continue;
            text.add(node);
        }
        return text;
    }

    public String normalizeText() {
        Iterator itr = this.listText().iterator();
        StringBuffer buffer = new StringBuffer();
        while (itr.hasNext()) {
            StreamText text = (StreamText)itr.next();
            buffer.append(text.getValue());
        }
        return buffer.toString();
    }

    public String normalizeTrimText() {
        Iterator itr = this.listText().iterator();
        StringBuffer buffer = new StringBuffer();
        while (itr.hasNext()) {
            StreamText text = (StreamText)itr.next();
            String val = text.getValue();
            buffer.append(val.replaceAll("\\s+", " ").trim());
        }
        return buffer.toString().trim();
    }

    public StreamText addText(String txt) {
        StreamText node = null;
        if (Utilities.isValidString(txt)) {
            StreamDataFactory sdf = this.getDataFactory();
            node = sdf.createText(txt);
            this.add(node);
        }
        return node;
    }

    public void clearText() {
        Iterator itr = this.listText().iterator();
        while (itr.hasNext()) {
            this.remove((StreamText)itr.next());
        }
    }

    public List listElements() {
        return this.listElements(NON_NSI, null);
    }

    public List listElements(Class iface) {
        return this.listElements(NON_NSI, iface);
    }

    public List listElements(String name) {
        NSI nsi = !Utilities.isValidString(name) ? NON_NSI : new NSI(name, null);
        return this.listElements(nsi, null);
    }

    public List listElements(String name, Class iface) {
        NSI nsi = !Utilities.isValidString(name) ? NON_NSI : new NSI(name, null);
        return this.listElements(nsi, iface);
    }

    public List listElements(String name, String ns) {
        return this.listElements(new NSI(name, ns), null);
    }

    public List listElements(String name, String ns, Class iface) {
        return this.listElements(new NSI(name, ns), iface);
    }

    public List listElements(NSI name) {
        return this.listElements(name, null);
    }

    public List listElements(NSI name, Class iface) {
        NSI.Comparator cmp = new NSI.Comparator(false, false);
        List elems = this.listNodes();
        Iterator itr = elems.iterator();
        if (name == null) {
            name = NON_NSI;
        }
        while (itr.hasNext()) {
            StreamNode node = (StreamNode)itr.next();
            if (node instanceof StreamElement) {
                StreamElement test = (StreamElement)node;
                NSI nsi = new NSI(test.getLocalName(), test.getNamespaceURI());
                boolean valid = cmp.compare(name, nsi) == 0;
                if (valid = valid && (iface == null || iface.isInstance(test))) continue;
                itr.remove();
                continue;
            }
            itr.remove();
        }
        return elems;
    }

    public StreamElement getFirstElement() {
        return this.getFirstElement(NON_NSI, null);
    }

    public StreamElement getFirstElement(Class iface) {
        return this.getFirstElement(NON_NSI, iface);
    }

    public StreamElement getFirstElement(String name) {
        NSI nsi = !Utilities.isValidString(name) ? NON_NSI : new NSI(name, null);
        return this.getFirstElement(nsi, null);
    }

    public StreamElement getFirstElement(String name, Class iface) {
        NSI nsi = !Utilities.isValidString(name) ? NON_NSI : new NSI(name, null);
        return this.getFirstElement(nsi, iface);
    }

    public StreamElement getFirstElement(String name, String ns) {
        return this.getFirstElement(new NSI(name, ns), null);
    }

    public StreamElement getFirstElement(String name, String ns, Class iface) {
        return this.getFirstElement(new NSI(name, ns), iface);
    }

    public StreamElement getFirstElement(NSI name) {
        return this.getFirstElement(name, null);
    }

    public StreamElement getFirstElement(NSI name, Class iface) {
        Iterator itr = this.listElements(name, iface).iterator();
        return itr.hasNext() ? itr.next() : null;
    }

    public List findElementsForLocale(String ln, String ns, Locale l) {
        return this.findElementsForLocale(new NSI(ln, ns), l);
    }

    public List findElementsForLocale(NSI name, Locale l) {
        String ns;
        String ln;
        XPath xpath = this.getLocaleXPath();
        SimpleVariableContext varCtx = (SimpleVariableContext)xpath.getVariableContext();
        List found = Collections.EMPTY_LIST;
        if (name != null) {
            ln = name.getLocalName();
            ns = name.getNamespaceURI();
        } else {
            ln = null;
            ns = null;
        }
        if (l != null) {
            varCtx.setVariableValue("ln", (Object)ln);
            varCtx.setVariableValue("ns", (Object)ns);
            varCtx.setVariableValue("lang", (Object)l);
            xpath.setVariableContext((VariableContext)varCtx);
            try {
                found = xpath.selectNodes((Object)this);
            }
            catch (JaxenException je) {
                this.obtainLogger().error((Object)"XPath evaluation failed locating subjects for locale", (Throwable)je);
            }
        } else {
            l = this.getLocale();
            if (l != Locale.getDefault()) {
                found = this.findElementsForLocale(name, l);
            }
            if (found.isEmpty()) {
                found = this.findElementsForLocale(name, new Locale(Locale.getDefault().getLanguage()));
            }
        }
        return found;
    }

    public StreamElement addElement(String name) {
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("Local name cannot be null or \"\"");
        }
        return this.addElement(this.getDataFactory().createNSI(name, this.getNamespaceURI()), null);
    }

    public StreamElement addElement(String name, Class iface) {
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("Local name cannot be null or \"\"");
        }
        return this.addElement(this.getDataFactory().createNSI(name, this.getNamespaceURI()), iface);
    }

    public StreamElement addElement(String name, String uri) {
        if (!Utilities.isValidString(name) && uri == null) {
            throw new IllegalArgumentException("Local name and namespace URI cannot both be null or \"\"");
        }
        if (uri == null) {
            uri = this.getNamespaceURI();
        }
        return this.addElement(this.getDataFactory().createNSI(name, uri), null);
    }

    public StreamElement addElement(String name, String uri, Class iface) {
        if (!Utilities.isValidString(name) && !Utilities.isValidString(uri)) {
            throw new IllegalArgumentException("Local name and namespace URI cannot both be null or \"\"");
        }
        return this.addElement(this.getDataFactory().createNSI(name, uri), iface);
    }

    public StreamElement addElement(NSI name) {
        return this.addElement(name, null);
    }

    public StreamElement addElement(NSI name, Class iface) {
        StreamDataFactory sdf = this.getDataFactory();
        if (name.getNamespaceURI() == null) {
            name = new NSI(name.getLocalName(), this.getNamespaceURI());
        }
        StreamElement elem = sdf.createElementNode(name, iface);
        this.add(elem);
        return elem;
    }

    public void clearElements() {
        this.clearElements(NON_NSI, null);
    }

    public void clearElements(Class iface) {
        this.clearElements(NON_NSI, iface);
    }

    public void clearElements(String name) {
        this.clearElements(new NSI(name, null), null);
    }

    public void clearElements(String name, Class iface) {
        this.clearElements(new NSI(name, null), iface);
    }

    public void clearElements(String name, String uri) {
        this.clearElements(new NSI(name, uri), null);
    }

    public void clearElements(String name, String uri, Class iface) {
        this.clearElements(new NSI(name, uri), iface);
    }

    public void clearElements(NSI name) {
        this.clearElements(name, null);
    }

    public void clearElements(NSI name, Class iface) {
        Iterator itr = this.listElements(name, iface).iterator();
        while (itr.hasNext()) {
            this.remove((StreamElement)itr.next());
        }
    }

    public int indexOf(StreamNode node) {
        return this.listNodes().indexOf(node);
    }

    protected abstract void checkNSI(NSI var1) throws IllegalArgumentException;

    protected abstract void checkElement(StreamElement var1) throws IllegalArgumentException;

    public void reset() {
        this.reset(null, null);
    }

    public void reset(NSI name) throws IllegalArgumentException {
        this.reset(name, null);
    }

    public void reset(StreamElement base) throws IllegalArgumentException {
        this.reset(null, base);
    }

    public void reset(NSI name, StreamElement base) throws IllegalArgumentException {
        if (name == null && base != null) {
            name = base.getNSI();
        }
        if (name != null) {
            this.checkNSI(name);
        }
        if (base != null) {
            this.checkElement(base);
        }
        Iterator<Object> itr = new LinkedList(this.getDeclaredNamespaces()).iterator();
        while (itr.hasNext()) {
            ((StreamNamespace)itr.next()).detach();
        }
        itr = new LinkedList(this.getAttributes().values()).iterator();
        while (itr.hasNext()) {
            ((StreamAttribute)itr.next()).detach();
        }
        itr = new LinkedList(this.listNodes()).iterator();
        while (itr.hasNext()) {
            ((StreamNode)itr.next()).detach();
        }
        if (name != null) {
            this.setNSI(name);
        }
        if (base != null) {
            itr = base.getDeclaredNamespaces().iterator();
            while (itr.hasNext()) {
                StreamNamespace ns = (StreamNamespace)itr.next();
                this.addNamespace((StreamNamespace)ns.copy());
            }
            itr = base.getAttributes().values().iterator();
            while (itr.hasNext()) {
                StreamAttribute attr = (StreamAttribute)itr.next();
                this.setAttributeValue(attr.getNSI(), attr.getValue());
            }
            itr = base.listNodes().iterator();
            while (itr.hasNext()) {
                StreamNode node = (StreamNode)itr.next();
                if (node instanceof StreamElement) {
                    StreamElement elem = (StreamElement)node;
                    if (Utilities.equateStrings(this.getNamespaceURI(), elem.getNamespaceURI())) {
                        elem.reset(new NSI(elem.getLocalName(), this.getNamespaceURI()));
                    }
                }
                this.add((StreamNode)node.copy());
            }
        }
    }

    public void reset(String val) throws IllegalArgumentException {
        StreamElement in = new XMLReader(this).read(val);
        this.reset(in);
    }

    public boolean equals(Object cmp) {
        return this == cmp;
    }

    public void accept(StreamObjectVisitor v) {
        v.visit(this);
    }

    public String toString() {
        return new XMLWriter(this).write(this);
    }

    protected static class ObjectAttribute
    extends AbstractAttribute {
        private NSI _Name;
        private Object _Val;

        public ObjectAttribute(StreamElement p, NSI name, Object val) {
            super(p);
            this.setNSI(name);
            this.setObject(val);
        }

        public NSI getNSI() {
            return this._Name;
        }

        private void setNSI(NSI name) {
            if (name == null) {
                throw new IllegalArgumentException("Name cannot be null");
            }
            if (!Utilities.isValidString(name.getLocalName())) {
                throw new IllegalArgumentException("Local name cannot be null");
            }
            if (name.getNamespaceURI() == null) {
                name = new NSI(name.getLocalName(), "");
            }
            this._Name = name;
        }

        public Object getObject() {
            return this._Val;
        }

        public void setObject(Object val) {
            this._Val = val;
        }

        public String getValue() {
            return this.getObject() != null ? this.getObject().toString() : "";
        }

        public void setValue(String val) throws IllegalArgumentException {
            this.setObject(val);
        }

        public StreamObject copy(StreamElement p) {
            return new ObjectAttribute(p, this.getNSI(), this.getObject());
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getNSI()).append("=").append(this.getValue());
            return buffer.toString();
        }
    }

    protected static class LocaleWrapper {
        private Locale _Locale;
        private String _Spec;

        public LocaleWrapper(Locale l) {
            this._Locale = l;
        }

        public final Locale getLocale() {
            return this._Locale;
        }

        public final String toString() {
            if (this._Spec == null) {
                this._Spec = LocaleFormat.getInstance().format(this.getLocale());
            }
            return this._Spec;
        }

        public final boolean equals(Object cmp) {
            return cmp != null ? this.toString().equals(cmp) : false;
        }

        public static final LocaleWrapper fromString(String spec) {
            Locale lang = null;
            try {
                lang = (Locale)LocaleFormat.getInstance().parseObject(spec);
            }
            catch (Exception e) {
                Logger.getLogger((Class)(class$net$outer_planes$jso$AbstractElement == null ? (class$net$outer_planes$jso$AbstractElement = AbstractElement.class$("net.outer_planes.jso.AbstractElement")) : class$net$outer_planes$jso$AbstractElement)).warn((Object)"Could not parse xml:lang into Locale", (Throwable)e);
            }
            return lang != null ? new LocaleWrapper(lang) : null;
        }
    }
}

