/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server.util;

public class WildCardPattern {
    private int filterType;
    public static final int ANY = 0;
    public static final int STARTSWITH = 1;
    public static final int ENDSWITH = 2;
    public static final int CONTAINS = 7;
    public static final int EQUALS = 4;
    private String[] tokens;
    private String[] lcTokens;

    public WildCardPattern(String pattern) {
        String match = pattern;
        if (pattern == null || pattern.length() == 0 || pattern.equals("*")) {
            this.filterType = 0;
        } else {
            this.filterType = 0;
            if (match.startsWith("*")) {
                this.filterType |= 2;
            }
            if (match.endsWith("*")) {
                this.filterType |= 1;
            }
            if (this.filterType == 0) {
                this.filterType = 4;
            }
            if ((this.filterType & 2) != 0 && (this.filterType & 1) != 0) {
                this.filterType = 7;
                this.tokens = match.split("[*\\s]");
                this.lcTokens = pattern.toLowerCase().split("[*\\s]");
            } else {
                this.tokens = new String[1];
                this.tokens[0] = pattern;
                this.lcTokens = new String[1];
                this.lcTokens[0] = pattern.toLowerCase();
            }
        }
    }

    public WildCardPattern(String pattern, int filterType) {
        this.filterType = filterType;
        switch (filterType) {
            case 1: 
            case 2: 
            case 4: {
                this.tokens = new String[1];
                this.tokens[0] = pattern;
                this.lcTokens = new String[1];
                this.lcTokens[0] = pattern.toLowerCase();
                break;
            }
            case 7: {
                this.tokens = pattern.split("[*\\s]");
                this.lcTokens = pattern.toLowerCase().split("[*\\s]");
                break;
            }
        }
    }

    public boolean match(String input) {
        if (input == null || input.trim().length() == 0) {
            return false;
        }
        if (this.filterType == 0) {
            return true;
        }
        switch (this.filterType) {
            case 4: {
                return input.equals(this.tokens[0]);
            }
            case 7: {
                return this.matchTokens(input, this.tokens);
            }
            case 1: {
                return input.startsWith(this.tokens[0]);
            }
            case 2: {
                return input.endsWith(this.tokens[0]);
            }
        }
        return true;
    }

    public boolean matchIgnoreCase(String input) {
        if (input == null || input.trim().length() == 0) {
            return false;
        }
        if (this.filterType == 0) {
            return true;
        }
        String lcInput = input.toLowerCase();
        switch (this.filterType) {
            case 4: {
                return lcInput.equals(this.lcTokens[0]);
            }
            case 7: {
                return this.matchTokens(lcInput, this.lcTokens);
            }
            case 1: {
                return lcInput.startsWith(this.lcTokens[0]);
            }
            case 2: {
                return lcInput.endsWith(this.lcTokens[0]);
            }
        }
        return true;
    }

    private boolean matchTokens(String pattern, String[] t) {
        int index = 0;
        for (int i = 0; i < t.length; ++i) {
            int newIndex = pattern.indexOf(t[i], index);
            if (newIndex < index) {
                return false;
            }
            index = newIndex + t[i].length();
        }
        return true;
    }

    public int getFilterType() {
        return this.filterType;
    }
}

