/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ConfigReader {
    private static ConfigReader _smInstance;
    private Properties props;
    private String _fileName;

    private ConfigReader(String fileName) {
        this._fileName = fileName;
    }

    public static void initialize(String fileName) throws Exception {
        _smInstance = new ConfigReader(fileName);
        _smInstance.load();
    }

    public static ConfigReader getInstance() {
        return _smInstance;
    }

    private boolean load() throws Exception {
        boolean ret = true;
        this.props = new Properties();
        File f = new File(this._fileName);
        FileInputStream is = new FileInputStream(f);
        this.props.load(is);
        is.close();
        return ret;
    }

    public String getSetting(String name, String defaultValue) {
        String s = this.props.getProperty(name, defaultValue);
        if (s != null && (s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String getSetting(String name) {
        String s = this.getSetting(name, null);
        if (s != null && (s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String[] getSettingKeys(String startswith) {
        Vector<String> v = new Vector<String>();
        Enumeration<Object> e = this.props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(startswith)) continue;
            v.add(key);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }
}

