/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server.tiger;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.util.SecureByteChannel;
import com.iplanet.im.server.util.SecureByteChannelListener;
import com.sun.im.service.util.Worker;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;

public class SecureByteChannelImpl
implements SecureByteChannel {
    ByteChannel clearChannel;
    SSLEngine sslEngine;
    SSLContext ctx;
    ByteBuffer appReadBuffer = null;
    ByteBuffer netReadBuffer = null;
    ByteBuffer netWriteBuffer = null;
    SecureByteChannelListener listener;
    ByteBuffer empty = ByteBuffer.wrap(new byte[0]);
    Worker worker;
    boolean usetls = false;
    boolean tightLoop = true;
    boolean handshakeComplete = false;

    public SecureByteChannelImpl(ByteChannel channel, SSLContext ctx, Worker worker) {
        this.clearChannel = channel;
        this.ctx = ctx;
        this.worker = worker;
    }

    public synchronized int read(ByteBuffer dst) throws IOException {
        int nbytes = 0;
        int r = 0;
        if (this.usetls) {
            SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
            if (this.appReadBuffer.position() > 0) {
                int capacity = dst.remaining();
                if (this.appReadBuffer.position() > capacity) {
                    this.appReadBuffer.flip();
                    dst.put(this.appReadBuffer.array(), 0, capacity);
                    this.appReadBuffer.position(capacity);
                    this.appReadBuffer.compact();
                    this.appReadBuffer.flip();
                    this.scheduleNewRead();
                    return capacity;
                }
                this.appReadBuffer.flip();
                dst.put(this.appReadBuffer.array(), 0, this.appReadBuffer.limit());
                nbytes += this.appReadBuffer.limit();
            }
            this.appReadBuffer.clear();
            r = this.clearChannel.read(this.netReadBuffer);
            this.netReadBuffer.flip();
            SSLEngineResult res = null;
            if (dst.remaining() < this.appReadBuffer.limit()) {
                res = this.sslEngine.unwrap(this.netReadBuffer, this.appReadBuffer);
                if (this.appReadBuffer.position() > dst.remaining()) {
                    r = dst.remaining();
                    this.appReadBuffer.flip();
                    dst.put(this.appReadBuffer.array(), 0, r);
                    this.appReadBuffer.position(r);
                    this.appReadBuffer.compact();
                    this.appReadBuffer.flip();
                    nbytes += r;
                    this.scheduleNewRead();
                } else {
                    this.appReadBuffer.flip();
                    dst.put(this.appReadBuffer.array(), 0, this.appReadBuffer.limit());
                    nbytes += this.appReadBuffer.limit();
                    this.appReadBuffer.clear();
                }
            } else {
                res = this.sslEngine.unwrap(this.netReadBuffer, dst);
                nbytes += res.bytesProduced();
            }
            if (this.netReadBuffer.remaining() > 0) {
                this.netReadBuffer.compact();
                if (this.handshakeComplete) {
                    this.scheduleNewRead();
                }
            } else {
                this.netReadBuffer.clear();
            }
            this.handleResult(res);
            this.tightLoop = res.bytesConsumed() == 0;
        } else {
            nbytes += this.clearChannel.read(dst);
        }
        return nbytes;
    }

    private void scheduleNewRead() {
        this.worker.addRunnable(new Runnable(){

            public void run() {
                SecureByteChannelImpl.this.listener.process();
            }
        });
    }

    public synchronized int write(ByteBuffer dst) throws IOException {
        int nbytes = 0;
        if (this.usetls) {
            SSLEngineResult res;
            while ((res = this.sslEngine.wrap(dst, this.netWriteBuffer)).getStatus() == SSLEngineResult.Status.OK) {
                this.netWriteBuffer.flip();
                int w = this.clearChannel.write(this.netWriteBuffer);
                nbytes += w;
                if (this.netWriteBuffer.hasRemaining()) {
                    this.netWriteBuffer.compact();
                    this.netWriteBuffer.position(this.netWriteBuffer.limit());
                    this.netWriteBuffer.limit(this.netWriteBuffer.capacity());
                } else {
                    this.netWriteBuffer.clear();
                }
                if (!this.handshakeComplete) {
                    this.handleResult(res);
                }
                if (dst.hasRemaining()) continue;
                break;
            }
        } else {
            nbytes = this.clearChannel.write(dst);
        }
        return nbytes;
    }

    public boolean isOpen() {
        return this.clearChannel.isOpen();
    }

    public synchronized void close() throws IOException {
        if (this.usetls) {
            this.sslEngine.closeOutbound();
        }
        this.clearChannel.close();
    }

    private void handleResult(SSLEngineResult res) {
        switch (res.getStatus()) {
            case OK: {
                this.handleHandshakeResult(res.getHandshakeStatus());
                break;
            }
            case BUFFER_OVERFLOW: {
                this.listener.securityHandshakeFailed();
                break;
            }
        }
    }

    private void handleHandshakeResult(SSLEngineResult.HandshakeStatus hs) {
        switch (hs) {
            case NOT_HANDSHAKING: 
            case FINISHED: {
                if (this.handshakeComplete) break;
                this.handshakeComplete = true;
                this.listener.securityHandshakeComplete();
                break;
            }
            case NEED_TASK: {
                final Runnable r = this.sslEngine.getDelegatedTask();
                if (r == null) break;
                this.worker.addRunnable(new Runnable(){

                    public void run() {
                        r.run();
                        SSLEngineResult.HandshakeStatus hs = SecureByteChannelImpl.this.sslEngine.getHandshakeStatus();
                        SecureByteChannelImpl.this.handleHandshakeResult(hs);
                    }
                });
                break;
            }
            case NEED_UNWRAP: {
                if (this.netReadBuffer.position() <= 0 || this.tightLoop) break;
                this.scheduleNewRead();
                break;
            }
            case NEED_WRAP: {
                this.worker.addRunnable(new Runnable(){

                    public void run() {
                        try {
                            SecureByteChannelImpl.this.write(SecureByteChannelImpl.this.empty);
                        }
                        catch (IOException ioe) {
                            Log.printStackTrace(ioe);
                            SecureByteChannelImpl.this.listener.securityHandshakeFailed();
                        }
                    }
                });
                break;
            }
        }
    }

    public boolean startTLS(ByteBuffer bb, SecureByteChannelListener listener) {
        this.listener = listener;
        try {
            this.sslEngine = this.ctx.createSSLEngine();
            this.sslEngine.setUseClientMode(false);
            this.sslEngine.setEnabledCipherSuites(this.sslEngine.getSupportedCipherSuites());
            String[] cipherSuite = this.sslEngine.getEnabledCipherSuites();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < cipherSuite.length; ++i) {
                buf.append(cipherSuite[i]);
                buf.append(", ");
            }
            SSLSession ssls = this.sslEngine.getSession();
            this.netReadBuffer = ByteBuffer.allocate(ssls.getPacketBufferSize());
            this.netWriteBuffer = ByteBuffer.allocate(ssls.getPacketBufferSize());
            this.appReadBuffer = ByteBuffer.allocate(ssls.getApplicationBufferSize());
            this.usetls = true;
            this.sslEngine.beginHandshake();
            this.clearChannel.write(bb);
            Log.debug("[SecureByteChannel] TLS started for " + this.clearChannel.toString());
            return true;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.warning("[SecureByteChannel] TLS handshake failed " + this.clearChannel.toString());
            return false;
        }
    }
}

