/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.ComponentPacketDispatcher;
import com.iplanet.im.server.DiscoHandler;
import com.iplanet.im.server.Discoverable;
import com.iplanet.im.server.GatewayedEndPoint;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.StreamEndPoint;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.x.disco.DiscoIdentity;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;

public class XMPPComponentSession
extends StreamEndPoint
implements StreamStatusListener,
Discoverable,
RemoteSession {
    StreamEndPoint _session;
    private String _name = "";
    private String _category = "";
    private String _type = "";
    private String[] _namespaces = new String[0];
    private String _password;
    private boolean _autoSubscribe = false;
    private ComponentPacketDispatcher rq = null;
    private Map _gatewayedEndPoints = new HashMap();
    private boolean _initialized = false;
    DiscoHandler _discoHandler;
    private Hashtable _clients = new Hashtable();

    public XMPPComponentSession(JID jid, String password, String name, String type, String category, boolean autoSubscribe) {
        this.setJID(jid);
        this._category = category;
        this._type = type;
        this._autoSubscribe = autoSubscribe;
        this._password = password;
        this.setUser(new BaseUser("", jid.getDomain()));
        this.getUser().addSession(this);
        NMS.addRemoteSession(this.getJID(), (RemoteSession)this);
        Log.debug("XMPPComponentSession[" + this.getJID() + "] created");
    }

    public XMPPComponentSession(StreamEndPoint session) {
        super(session.getJID());
        this._session = session;
        this._session.getStream().addStreamStatusListener((StreamStatusListener)this);
        this.setUser(new BaseUser("", this.getJID().getDomain()));
        this.getUser().addSession(this);
        NMS.addRemoteSession(this.getJID(), (RemoteSession)this);
        Log.debug("XMPPComponentSession[" + this.getJID() + "] created");
    }

    public Stream getStream() {
        return this._session != null ? this._session.getStream() : null;
    }

    public void reset(StreamEndPoint session, ComponentPacketDispatcher dispatcher) {
        if (session != null) {
            Log.debug("Session is not null");
            session.setJID(this.getJID());
            session.getStream().addStreamStatusListener((StreamStatusListener)this);
            session.setUser(this.getUser());
            this._session = session;
            if (this.getUser().getSession() == null) {
                this.getUser().addSession(this);
            }
            this.rq = dispatcher;
            this.rq.discoHandler.addDiscoverable(this.getJID().toString(), this);
            Iterator i = this._clients.values().iterator();
            while (i.hasNext()) {
                StreamEndPoint ep = (StreamEndPoint)i.next();
                Presence p = ep.getPresence();
                if (p == null) continue;
                p = (Presence)p.copy();
                p.setTo(this.getJID());
                session.send((Packet)p);
            }
        }
        this._session = session;
        Log.debug("XMPPComponentSession[" + this._session.getJID() + "] reset");
    }

    public void statusChanged(StreamStatusEvent event) {
        if (event.getNextStatus().equals((Object)Stream.DISCONNECTED) && event.getStream() == this.getStream()) {
            Log.debug("XMPPComponentSession[" + this.getJID() + "] disconnected");
            Iterator i = this.gatewayedEndPointsIterator();
            while (i.hasNext()) {
                GatewayedEndPoint gwe = (GatewayedEndPoint)i.next();
                Log.debug("XMPPComponentSession[" + this.getJID() + "] closing gatewayed endpoint: " + gwe.getJID());
                gwe.closedByStream();
                this.removeGatewayedEndPoint(gwe);
            }
            this._session = null;
        }
    }

    public void send(StreamEndPoint session, Packet p) throws StreamException {
        try {
            if (this._autoSubscribe && p instanceof Presence && Presence.SUBSCRIBE.equals((Object)p.getType())) {
                PresenceHandler ph = this.rq.presenceHandler;
                ph.autoSubscribed(session, session.getJID(), p.getTo(), session.getUser(), this.getEndPoint(p.getTo()).getUser());
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        if (p instanceof Presence && p.getTo().equals(this.getJID())) {
            if (p.getType() == null) {
                this._clients.put(session.getJID(), session);
                session.getUser().addListener(this);
            } else if (Presence.UNAVAILABLE.equals((Object)p.getType())) {
                this._clients.remove(session.getJID());
                session.getUser().removeListener(this);
            }
        }
        if (this._session != null) {
            this._session.send(this._session.duplicate(p));
        } else {
            Log.warning("XMPPComponentSession[" + this.getJID() + "] is disconnected");
            session.sendError(p, PacketError.CANCEL, "recipient-unavailable", "Component:accept is not connected");
        }
    }

    public String getPassword() {
        return this._password;
    }

    public boolean autoSubscribe() {
        return this._autoSubscribe;
    }

    public void setJID(JID jid) {
        super.setJID(jid);
        if (this._session != null) {
            this._session.setJID(jid);
        }
    }

    public void close() {
        this._session = null;
    }

    boolean validate(Packet packet) {
        return true;
    }

    public PacketError.Type fillInfo(DiscoInfoQuery query, JID jid, String node, StreamEndPoint session) {
        return null;
    }

    public PacketError.Type fillItems(DiscoItemsQuery query, JID jid, String node, StreamEndPoint session) {
        return null;
    }

    public PacketError.Type updateItems(DiscoItemsQuery query, JID jid, StreamEndPoint session) {
        return null;
    }

    public String getName() {
        return this._name;
    }

    public String getCategory() {
        return this._category;
    }

    public String getType() {
        return this._type;
    }

    public String[] getNamespaces() {
        return this._namespaces;
    }

    public PacketError.Type fillAgentInfo(StreamElement agentElement, StreamEndPoint session) {
        return null;
    }

    public PacketError.Type fillBrowseInfo(JID jid, StreamElement item, StreamEndPoint session) {
        return null;
    }

    private void initialize(DiscoInfoQuery query) {
        Log.debug("[XMPPComponent:" + this.getJID() + "] parsing disco#info response");
        Iterator i = query.listIdentities().iterator();
        if (i.hasNext()) {
            DiscoIdentity di = (DiscoIdentity)i.next();
            this._name = di.getName();
            this._category = di.getCategory();
            this._type = di.getType();
            Log.debug("[XMPPComponent:" + this.getJID() + "] identity name='" + this._name + "' cat=" + this._category + " type=" + this._type);
        }
        Set features = query.getFeatures();
        this._namespaces = new String[features.size()];
        int n = 0;
        Iterator f = features.iterator();
        while (f.hasNext()) {
            this._namespaces[n++] = (String)f.next();
        }
        Log.debug("[XMPPComponent:" + this.getJID() + "] namespaces=" + this._namespaces);
        this._initialized = true;
    }

    public synchronized void process(StreamEndPoint session, Packet packet, DiscoHandler discoHandler) {
        if (!(packet instanceof InfoQuery)) {
            return;
        }
        if (InfoQuery.RESULT.equals((Object)packet.getType())) {
            Log.debug("[XMPPComponent:" + this.getJID() + "] processing info/query result");
            List queryNodes = packet.listElements(DiscoInfoQuery.NAME);
            if (queryNodes.size() > 0) {
                StreamElement query = (StreamElement)queryNodes.get(0);
                if (!query.listElements("error").isEmpty() || !packet.listElements("error").isEmpty()) {
                    this.sendInfoRequest(session, DiscoHandler.NAME_AGENTS);
                } else {
                    this.initialize((DiscoInfoQuery)query);
                }
                return;
            }
            if (!this._initialized && (queryNodes = packet.listElements(DiscoHandler.NAME_BROWSE)).size() > 0) {
                StreamElement query = (StreamElement)queryNodes.get(0);
                if (query.listElements("error").isEmpty() && packet.listElements("error").isEmpty()) {
                    this._name = query.getAttributeValue("jid");
                    this._category = query.getAttributeValue("category");
                    this._type = query.getAttributeValue("type");
                    List features = query.listElements("ns");
                    this._namespaces = new String[features.size()];
                    int n = 0;
                    Iterator f = features.iterator();
                    while (f.hasNext()) {
                        this._namespaces[n++] = ((StreamElement)f.next()).normalizeText();
                    }
                }
                return;
            }
        }
    }

    public void processAuthentication(StreamEndPoint session, StreamElement query) {
    }

    public void processAgentInfo(StreamEndPoint session, StreamElement query) {
    }

    public void processBrowseResponse(StreamEndPoint session, StreamElement query) {
    }

    public void processInfoResponse(StreamEndPoint session, StreamElement query) {
    }

    public void processItemsResponse(StreamEndPoint session, StreamElement query) {
    }

    private void sendInfoRequest(RemoteSession s, NSI name) {
        StreamDataFactory sdf = s.getDataFactory();
        try {
            Packet p = sdf.createPacketNode(AbstractHandler.IQ_NAME, InfoQuery.class);
            p.setType((Packet.Type)InfoQuery.GET);
            p.setFrom(NMS.getJID());
            p.setTo(this.getJID());
            StreamElement query = sdf.createElementNode(name, null);
            p.add((StreamNode)query);
            s.send(null, p);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    private void sendInfoRequest(StreamEndPoint s, NSI name) {
        StreamDataFactory sdf = s.getDataFactory();
        try {
            Packet p = sdf.createPacketNode(AbstractHandler.IQ_NAME, InfoQuery.class);
            p.setType((Packet.Type)InfoQuery.GET);
            p.setFrom(NMS.getJID());
            p.setTo(this.getJID());
            StreamElement query = sdf.createElementNode(name, null);
            p.add((StreamNode)query);
            s.send(p);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public StreamEndPoint getEndPoint(JID jid) {
        if (jid == null) {
            return null;
        }
        if (this.getJID().equals(jid)) {
            return this;
        }
        LocalUser lu = null;
        try {
            lu = RealmManager.getUser(jid.toBareJID().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (lu != null) {
            return lu.getSession(jid.getResource());
        }
        if (this.getJID().getDomain().equalsIgnoreCase(jid.getDomain()) && jid.hasNode()) {
            return new GatewayedEndPoint(this, jid);
        }
        return null;
    }

    public synchronized void addGatewayedEndPoint(GatewayedEndPoint gwe) {
        this._gatewayedEndPoints.put(gwe.getJID().getResource(), gwe);
    }

    public synchronized void removeGatewayedEndPoint(GatewayedEndPoint gwe) {
        this._gatewayedEndPoints.remove(gwe.getJID().getResource());
    }

    public Iterator gatewayedEndPointsIterator() {
        return this._gatewayedEndPoints.values().iterator();
    }

    public ClientPacketDispatcher getDispatcher() {
        return this.rq;
    }
}

