/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.XMPPComponentSession;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.StringUtility;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;

public class XMPPComponent {
    protected static final String PASSWORD_OPTION = ".password";
    protected static final String JID_OPTION = ".jid";
    protected static final String NAME_OPTION = ".name";
    protected static final String CATEGORY_OPTION = ".category";
    protected static final String TYPE_OPTION = ".type";
    protected static final String NAMESPACE_OPTION = ".namespaces";
    protected static final String AUTOSUBSCRIBE_OPTION = ".autosubscribe";
    protected static final String COMPONENT_PASSWORD_OPTION = "iim_server.components.password";
    protected static final String COMPONENTS = "iim_server.components";
    public static final String DEFAULT_CALAGENT = "agent-calendar.";
    private static final String PARAM_PROVIDERS = "jms.providers";
    private static HostPort serverHostPort;
    protected static final String PREFIX_AGENT_NAME = "iim_agent.";
    protected static final String SUFFIX_ENABLE = "enable";
    protected static final String AGENT_ENABLE = "iim_agent.enable";
    static ServerConfig sc;
    public static final String GATEWAY = "gateway";
    private static Hashtable _components;

    public static XMPPComponentSession loadComponent(String basename) throws Exception {
        XMPPComponentSession s = null;
        String password = sc.getSetting(COMPONENT_PASSWORD_OPTION, "");
        password = sc.getSetting(basename + PASSWORD_OPTION, password);
        String sJID = sc.getSetting(basename + JID_OPTION, null);
        JID jid = null;
        if (sJID != null) {
            try {
                jid = new JID(sJID);
            }
            catch (JIDFormatException jfe) {
                Log.debug("[XMPPComponent]: compJID is not in a valid jid format: " + sJID);
                sJID = DEFAULT_CALAGENT + serverHostPort.getHostName();
                jid = new JID(sJID);
                Log.debug("[XMPPComponent]: Falling back to default compJID: " + jid);
            }
        }
        if (jid != null) {
            String name = sc.getSetting(basename + NAME_OPTION, "");
            String type = sc.getSetting(basename + TYPE_OPTION, null);
            String category = sc.getSetting(basename + CATEGORY_OPTION, null);
            boolean autoSubscribe = StringUtility.getBoolean((String)sc.getSetting(basename + AUTOSUBSCRIBE_OPTION), (boolean)false);
            s = new XMPPComponentSession(jid, password, name, type, category, autoSubscribe);
            _components.put(jid.toString(), s);
            Log.info("[XMPPComponent:" + jid + "] loaded component " + basename);
        }
        return s;
    }

    public static XMPPComponentSession loadComponent(JID jid, String password) {
        XMPPComponentSession s = null;
        if (jid != null) {
            s = new XMPPComponentSession(jid, password, null, null, null, false);
            _components.put(jid.toString(), s);
            Log.info("[XMPPComponent:" + jid + "] loaded implied component");
        }
        return s;
    }

    private static void initDefaultAgentCalendar(ServerConfig sc) {
        Log.debug("Initialize default agent_calendar");
        String s = sc.getSetting(PARAM_PROVIDERS);
        if (s != null) {
            Log.debug("[XMPPComponent#intiDefaultAgentCalendar] Found jms.providers");
            JID jid = null;
            jid = new JID(DEFAULT_CALAGENT + serverHostPort.getHostName());
            Log.debug("[XMPPComponent#initDefaultAGentCalendar] Default agent_handler uid " + jid.toString());
            XMPPComponentSession session = XMPPComponent.loadComponent(jid, "");
            if (session != null) {
                _components.put(DEFAULT_CALAGENT, session);
            }
        } else {
            Log.debug("[XMPPComponent#initDefaultAgentCalendar] Not found jms.providers");
        }
    }

    public static XMPPComponentSession get(JID jid) {
        if (jid == null) {
            return null;
        }
        XMPPComponentSession s = (XMPPComponentSession)_components.get(jid.toString());
        if (s == null) {
            s = (XMPPComponentSession)_components.get(jid.toBareJID().toString());
        }
        if (s == null) {
            s = (XMPPComponentSession)_components.get(jid.getDomain());
        }
        return s;
    }

    static {
        sc = ServerConfig.getServerConfig();
        _components = new Hashtable();
        serverHostPort = Boolean.valueOf(sc.getSetting("iim_server.usesslport", "false")) != false ? new HostPort(sc.getSetting("iim_server.sslport"), 5222) : new HostPort(sc.getSetting("iim_server.port"), 5222);
        boolean agentEnabled = StringUtility.getBoolean((String)sc.getSetting(AGENT_ENABLE, "false").trim(), (boolean)false);
        if (agentEnabled) {
            String s = sc.getSetting(COMPONENTS);
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    boolean componentEnabled = true;
                    String basename = st.nextToken().trim();
                    componentEnabled = StringUtility.getBoolean((String)sc.getSetting(PREFIX_AGENT_NAME + basename + "." + SUFFIX_ENABLE, "true").trim(), (boolean)true);
                    if (!componentEnabled) continue;
                    try {
                        Log.debug("Component baseName " + basename);
                        XMPPComponentSession session = XMPPComponent.loadComponent(basename);
                        if (session == null) continue;
                        _components.put(basename, session);
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                    }
                }
            }
        } else {
            XMPPComponent.initDefaultAgentCalendar(sc);
        }
    }
}

