/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class WatchdogComponent {
    protected boolean _up;
    protected boolean _running;
    protected boolean _operational;
    private String _pidFileName;
    private File _pidFile;
    private int _pid;
    private String _module;
    private ArrayList _failuresList;
    private int _numberOfFailures;
    private int _numberOfCycles;
    private int _defaultNbOfCycles = 10;
    private String _configFile;

    WatchdogComponent(String configFile, String pidFileName, String module, Integer numberOfCycles) {
        this._configFile = configFile;
        this._pidFileName = pidFileName;
        try {
            this._pidFile = new File(pidFileName);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        this._module = module;
        this._numberOfCycles = numberOfCycles != null ? numberOfCycles : this._defaultNbOfCycles;
        this.init();
    }

    WatchdogComponent(String configFile, String pidFileName, String module) {
        this(configFile, pidFileName, module, null);
    }

    private void reset() {
        this._up = false;
        this._running = false;
        this._operational = false;
        this._pid = 0;
        this._numberOfFailures = 0;
    }

    private void init() {
        this._failuresList = new ArrayList();
        this.reset();
    }

    public int getNumberOfCycles() {
        return this._failuresList.size();
    }

    private void failuresCountRefresh() {
        int rv = 0;
        for (int i = 0; i < this._failuresList.size(); ++i) {
            boolean tmp = (Boolean)this._failuresList.get(i);
            if (tmp) continue;
            ++rv;
        }
        this._numberOfFailures = rv;
    }

    public int failuresCount() {
        return this._numberOfFailures;
    }

    private void addCycleStatus(boolean cycleStatus) {
        this._failuresList.add(new Boolean(cycleStatus));
        if (this._failuresList.size() > this._numberOfCycles) {
            this._failuresList.remove(0);
        }
        this.failuresCountRefresh();
    }

    private int getPid(File myFile) {
        int myPid = 0;
        String tmp = "0";
        try {
            if (myFile.exists()) {
                if (myFile.toString().equals(this._pidFileName)) {
                    this._up = true;
                }
                BufferedReader reader = new BufferedReader(new FileReader(myFile));
                tmp = reader.readLine();
                reader.close();
            } else {
                Log.error("pid file not found: " + myFile.getAbsolutePath());
                if (myFile.toString().equals(this._pidFileName)) {
                    this.reset();
                }
            }
            try {
                myPid = Integer.parseInt(tmp.trim());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return myPid;
    }

    private int getPid() {
        return this.getPid(this._pidFile);
    }

    protected int getPid(String myFileName) {
        return this.getPid(new File(myFileName));
    }

    protected String getModule() {
        return this._module;
    }

    private boolean checkRunning() {
        this._running = false;
        try {
            this._pid = this.getPid();
            if (this._pid > 1) {
                this._running = this.runCmd("/bin/ps -p" + this._pid, false) == 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._running;
    }

    protected boolean checkOperational() {
        this._operational = this._running;
        return this._operational;
    }

    public boolean isOperational() {
        return this._operational;
    }

    protected int runCmd(String myCmd, boolean output) {
        int rv = -1;
        try {
            Process p = Runtime.getRuntime().exec(myCmd);
            if (output) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                new Thread(new ConsoleOutputRunnable(stdInput)).start();
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                new Thread(new ConsoleOutputRunnable(stdErr)).start();
            }
            rv = p.waitFor();
        }
        catch (Exception e) {
            // empty catch block
        }
        return rv;
    }

    protected int runCmd(String myCmd) {
        return this.runCmd(myCmd, true);
    }

    public int restart() {
        if (this._pidFile.exists()) {
            this.runCmd(WatchdogComponent.getCommandString(this._module, "stop", this._configFile));
        }
        return this.runCmd(WatchdogComponent.getCommandString(this._module, "start", this._configFile));
    }

    public boolean check() {
        boolean cycleStatus = false;
        if (this._running && this.checkOperational()) {
            cycleStatus = true;
        } else if (this.checkRunning() && this.checkOperational()) {
            cycleStatus = true;
        }
        this.addCycleStatus(cycleStatus);
        return cycleStatus;
    }

    public int watchRV() {
        int rv = -1;
        if (!this.check()) {
            rv = this.restart();
        }
        return rv;
    }

    public boolean watch() {
        return this.watchRV() >= 0;
    }

    private static String getCommandString(String module, String action, String configFile) {
        String _administrativeBin = "sh imadmin -c ";
        String _adminStartCmd = "start";
        String _adminStopCmd = "stop";
        String _adminRestartCmd = "refresh";
        String _adminServerSuffix = "server";
        String _adminMuxSuffix = "multiplexor";
        String _adminCalBotSuffix = "agent-calendar";
        String _adminAllSuffix = "legacy";
        String _serverLabel = "server";
        String _muxLabel = "mux";
        String _calbotLabel = "calbot";
        String _startLabel = "start";
        String _stopLabel = "stop";
        String _restartLabel = "restart";
        String rv = "sh imadmin -c " + configFile;
        if ((module.equalsIgnoreCase("all") || module.equalsIgnoreCase("server") || module.equalsIgnoreCase("mux") || module.equalsIgnoreCase("calbot")) && (action.equalsIgnoreCase("start") || action.equalsIgnoreCase("stop") || action.equalsIgnoreCase("restart"))) {
            rv = rv + " ";
            rv = action.equalsIgnoreCase("start") ? rv + "start" : (action.equalsIgnoreCase("stop") ? rv + "stop" : rv + "refresh");
            rv = rv + " ";
            rv = module.equalsIgnoreCase("server") ? rv + "server" : (module.equalsIgnoreCase("mux") ? rv + "multiplexor" : (module.equalsIgnoreCase("calbot") ? rv + "agent-calendar" : rv + "legacy"));
        } else {
            rv = "";
        }
        return rv;
    }

    static class ConsoleOutputRunnable
    implements Runnable {
        BufferedReader stdInput;

        ConsoleOutputRunnable(BufferedReader stdInput) {
            this.stdInput = stdInput;
        }

        public void run() {
            String s = null;
            try {
                while ((s = this.stdInput.readLine()) != null) {
                    System.out.println(s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

