/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.WatchdogComponent;
import com.iplanet.im.server.WatchdogComponentJSO;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.StringUtility;
import java.io.File;

public class Watchdog {
    private static boolean _verbose = false;
    private static boolean _watchServer;
    private static boolean _watchMux;
    private static boolean _watchCalBot;
    private static boolean _useMFWK;
    private static boolean _useSSL;
    private static int period;
    private static String _configFile;
    private static int _timeout;
    private static int _numberOfCycles;
    private static int _maxRetries;
    private static String _cwd;
    private static String _varDir;
    private static String _logDir;
    private static String _serverPidFile;
    private static String _muxPidFile;
    private static String _calBotPidFile;
    private static String _serverJmxPortFile;
    private static HostPort _muxHostPort;
    private static HostPort _serverHostPort;
    private static final String PERIOD = "iim_wd.period";
    private static final String MAX_RETRIES = "iim_wd.maxretries";

    public static String getCWD() {
        File f = new File(".");
        String cwd = f.getAbsolutePath();
        return cwd.substring(0, cwd.length() - 1);
    }

    private static void myPrint(boolean newLine, String stuffToPiout) {
        if (_verbose) {
            if (newLine) {
                System.out.println(stuffToPiout);
            } else {
                System.out.print(stuffToPiout);
            }
        }
    }

    private static void myPrint(String stuffToPiout) {
        Watchdog.myPrint(true, stuffToPiout);
    }

    private static boolean loadConf() {
        boolean rv = false;
        try {
            ServerConfig sc = ServerConfig.getFreshServerConfig();
            try {
                period = Integer.parseInt(sc.getSetting(PERIOD, "300"));
            }
            catch (Exception e) {
                Log.error("unable to parse watchdog period value from config file. Defaulting to 5 minutes");
                Log.printStackTrace(e);
                period = 300;
            }
            period *= 1000;
            _watchServer = StringUtility.getBoolean((String)sc.getSetting("iim_server.enable", "true"), (boolean)true);
            _watchMux = StringUtility.getBoolean((String)sc.getSetting("iim_mux.enable", "false"), (boolean)true);
            _watchCalBot = StringUtility.getBoolean((String)sc.getSetting("iim_agent.enable", "false"), (boolean)false);
            Log.debug("_watchCalBot?[" + _watchCalBot + "]");
            _maxRetries = Integer.parseInt(sc.getSetting(MAX_RETRIES, "3"));
            _varDir = sc.getSetting("iim.instancevardir", "..") + File.separator;
            _logDir = _varDir + "log" + File.separator;
            _serverPidFile = _logDir + sc.getSetting("iim.pidfile", "xmppd.pid");
            _muxPidFile = _logDir + "mux.pid";
            _calBotPidFile = _logDir + "agent-calendar.pid";
            _serverJmxPortFile = _logDir + "xmppd.jmx";
            _muxHostPort = new HostPort(sc.getSetting("iim_mux.listenport", "5222"), 5222);
            _serverHostPort = new HostPort(sc.getSetting("iim_server.port", "5269"), 5269);
            rv = true;
            _useSSL = StringUtility.getBoolean((String)sc.getSetting("iim_mux.usessl", "off"), (boolean)false);
            Log.info("Starting watchdog using [" + _configFile + "] as configuration file");
            Log.debug("watchdog main parameters: monitoring server?[" + _watchServer + "] monitoring multiplexor?[" + _watchMux + "] monitoring agents?[" + _watchCalBot + "] period [" + period + "]ms fail over after [" + _maxRetries + "] retries var dir [" + _varDir + "] log dir[" + _logDir + "]");
            Log.debug("server main parameters: server hostport [" + _serverHostPort.toString() + "] server jmx file [" + _serverJmxPortFile + "] server pid file [" + _serverPidFile + "]");
            Log.debug("multiplexor main parameters: multiplexor hostport [" + _muxHostPort + "] SSL on?[" + _useSSL + "] multiplexor pid file[" + _muxPidFile + "]");
            Log.debug("agents main parameters: calendar agent pid file [" + _calBotPidFile + "]");
            _useMFWK = StringUtility.getBoolean((String)sc.getSetting("iim_server.monitor.enable"), (boolean)true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rv;
    }

    private static void usage() {
        Watchdog.myPrint("Usage: config file must be specified");
    }

    public static void main(String[] args) {
        boolean keepLooping = true;
        _cwd = Watchdog.getCWD();
        try {
            Object[] params;
            Class[] paramTypes;
            Class<?> javaLangString;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-c")) {
                    if (i + 1 < args.length) {
                        _configFile = args[++i];
                    } else {
                        Watchdog.usage();
                    }
                }
                if (!args[i].equalsIgnoreCase("-v")) continue;
                _verbose = true;
            }
            ServerConfig.init(_configFile);
            Log.init("iim_wd");
            Log.notice("Loading configuration from " + _configFile);
            Watchdog.loadConf();
            WatchdogComponent wdcServer = null;
            try {
                ClassLoader.getSystemClassLoader().loadClass("com.sun.mfwk.util.instrum.MfStatus");
            }
            catch (Exception e) {
                _useMFWK = false;
            }
            if (_useMFWK) {
                try {
                    javaLangString = ClassLoader.getSystemClassLoader().loadClass("java.lang.String");
                    paramTypes = new Class[]{javaLangString, javaLangString, javaLangString, javaLangString};
                    params = new Object[]{_configFile, _serverPidFile, "server", _serverJmxPortFile};
                    wdcServer = (WatchdogComponent)Class.forName("com.iplanet.im.server.WatchdogComponentMFWK").getDeclaredConstructor(paramTypes).newInstance(params);
                    Log.notice("JES Monitoring framework found");
                }
                catch (Exception e) {
                    _useMFWK = false;
                }
            }
            if (!_useMFWK) {
                try {
                    Log.info("Not using Monitoring framework");
                    javaLangString = ClassLoader.getSystemClassLoader().loadClass("java.lang.String");
                    paramTypes = new Class[]{javaLangString, javaLangString, javaLangString, ClassLoader.getSystemClassLoader().loadClass("com.sun.im.service.util.HostPort")};
                    params = new Object[]{_configFile, _serverPidFile, "server", _serverHostPort};
                    wdcServer = (WatchdogComponent)Class.forName("com.iplanet.im.server.WatchdogComponentJSO").getDeclaredConstructor(paramTypes).newInstance(params);
                }
                catch (Exception e) {
                    Log.error("Failed to start watchdog: " + e);
                    Log.printStackTrace(e);
                    return;
                }
            }
            WatchdogComponentJSO wdcMux = new WatchdogComponentJSO(_useSSL, _configFile, _muxPidFile, "mux", _muxHostPort);
            WatchdogComponent wdcCalBot = new WatchdogComponent(_configFile, _calBotPidFile, "calbot");
            boolean calbotUnconfigured = false;
            while (keepLooping) {
                String msg;
                boolean muxRestarted = false;
                if (Watchdog.loadConf()) {
                    if (_watchServer && wdcServer.watch()) {
                        Log.info("Server restarted. Forcing Multiplexor restart");
                        if (_watchMux) {
                            wdcMux.restart();
                        }
                        muxRestarted = true;
                        Log.debug("Server and Multiplexor restarted");
                    }
                    Log.info("Server failed " + wdcServer.failuresCount() + " times in the last " + wdcServer.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                    if (_watchMux && !muxRestarted && wdcMux.watch()) {
                        Log.info("Multiplexor restarted");
                        Watchdog.myPrint("muliplexor restarted");
                    }
                    Log.debug("Multiplexor failed " + wdcMux.failuresCount() + " times in the last " + wdcMux.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                    if (_watchCalBot && !calbotUnconfigured) {
                        wdcCalBot.watchRV();
                        Log.debug("Agent:Calendar failed " + wdcCalBot.failuresCount() + " times in the last " + wdcCalBot.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                        if (wdcCalBot.failuresCount() > _maxRetries) {
                            calbotUnconfigured = true;
                            msg = "Restarted Agent:Calendar " + _maxRetries + " times in " + wdcCalBot.getNumberOfCycles() + " cycles - Disabling Agent:Calendar watching";
                            System.out.println(msg);
                            Log.warning(msg);
                        }
                    }
                    if (_watchMux && wdcMux.failuresCount() > _maxRetries && !wdcMux.check() || _watchServer && wdcServer.failuresCount() > _maxRetries && !wdcServer.check()) {
                        keepLooping = false;
                        msg = "Failing over as watchdog restarted services " + _maxRetries + " times within " + wdcServer.getNumberOfCycles() + " cycles";
                        Log.error(msg);
                        Watchdog.myPrint(msg);
                    }
                    Log.debug("Will check again in " + period);
                    Thread.sleep(period);
                    continue;
                }
                keepLooping = false;
                msg = "Could not reload configuration file";
                Log.fatal(msg);
                Watchdog.myPrint(msg);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        _useMFWK = true;
        _useSSL = false;
        period = 120000;
        _configFile = ".." + File.separator + "config" + File.separator + "iim.conf";
        _timeout = 10;
        _numberOfCycles = 10;
        _maxRetries = 3;
        _varDir = "..";
        _muxPidFile = ".." + File.separator + "log" + File.separator + "mux.pid";
        _calBotPidFile = ".." + File.separator + "log" + File.separator + "calimbot.pid";
    }
}

