/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.RealmException;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.x.info.VersionQuery;

public class VersionHandler
extends AbstractHandler {
    public static String NAMESPACE = "jabber:iq:version";
    public static String _os = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + " / JVM " + System.getProperty("java.vm.version");

    public void process(StreamEndPoint session, Packet packet) {
        block6: {
            Object errorText = null;
            Object errorType = null;
            Log.debug("[Version] new packet received");
            if (!session.validate(packet)) {
                return;
            }
            JID to = packet.getTo();
            if (to.getNode() != null && to.getNode().length() != 0) {
                try {
                    BaseUser u = this.getUser(packet.getTo().toBareJID());
                    if (u != null) {
                        super.deliver(session, packet, u);
                        break block6;
                    }
                    session.sendError(packet, PacketError.CANCEL, "item-not-found", to.toString() + " not found");
                }
                catch (RealmException re) {
                    Log.printStackTrace((Exception)((Object)re));
                    session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage());
                }
            } else {
                StreamDataFactory sdf = session.getDataFactory();
                VersionQuery responseQuery = (VersionQuery)sdf.createElementNode(new NSI("query", "jabber:iq:version"), null);
                responseQuery.setName("Hermod");
                responseQuery.setVersion("7.0");
                responseQuery.setOS(_os);
                session.sendResult(packet, (StreamElement)responseQuery);
            }
        }
    }
}

