/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.FileUserSettings;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LDAPUserSettings;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.PrivacyHandler;
import com.iplanet.im.server.RosterHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.core.PrivacyList;
import org.jabberstudio.jso.x.core.PrivacyQuery;
import org.jabberstudio.jso.x.core.RosterItem;
import org.jabberstudio.jso.x.core.RosterQuery;

public class UserSettings {
    static UserSettingsStorageProvider s;

    public static UserSettingsStorageProvider get() {
        if (s == null) {
            s = NMS.getPropStore() == 1 ? new LDAPUserSettings() : new FileUserSettings();
        }
        return s;
    }

    protected Properties getUserProperties(CollaborationPrincipal u) throws Exception {
        return null;
    }

    protected void saveUserProperties(Properties p, CollaborationPrincipal u, boolean merge) throws Exception {
    }

    public static StreamElement getRoster(CollaborationPrincipal u, StreamEndPoint session) throws Exception {
        String xml = s.getRoster(u);
        String dxml = s.getDynamicRoster(u);
        if (xml == null) {
            return null;
        }
        StreamElement r = null;
        StreamElement dr = null;
        try {
            dr = dxml == null ? null : RosterHandler.buildRosterQuery(dxml, session);
        }
        catch (Exception e) {
            dr = null;
        }
        try {
            r = RosterHandler.buildRosterQuery(xml, session);
        }
        catch (Exception e1) {
            r = null;
        }
        return UserSettings.getMergedRoster(r, dr);
    }

    public static void saveRoster(CollaborationPrincipal u, String roster) throws Exception {
        s.saveRoster(u, roster);
    }

    public static StreamElement getPrivateSettings(CollaborationPrincipal u, StreamEndPoint session, String namespace) throws Exception {
        String xml = s.getPrivateSettings(u, namespace);
        String dxml = s.getDynamicPrivateSettings(u, namespace);
        if (xml == null) {
            return null;
        }
        StreamElement p = null;
        StreamElement dp = null;
        try {
            dp = dxml == null ? null : session.importElement(dxml);
        }
        catch (Exception e) {
            dp = null;
        }
        p = session.importElement(xml);
        if ("private_sunmsgr".equalsIgnoreCase(namespace)) {
            return UserSettings.getMergedSunmsgr(p, dp);
        }
        if ("private_storage".equalsIgnoreCase(namespace)) {
            return UserSettings.getMergedStorage(p, dp);
        }
        return UserSettings.getMergedPrivateSettings(p, dp);
    }

    public static void savePrivateSettings(CollaborationPrincipal u, String p, String namespace) throws Exception {
        s.savePrivateSettings(u, namespace, p);
    }

    public static StreamElement getPrivacy(CollaborationPrincipal u, StreamEndPoint session) throws Exception {
        String xml = s.getPrivacy(u);
        String dxml = s.getDynamicPrivacy(u);
        if (xml == null) {
            return null;
        }
        PrivacyQuery p = null;
        PrivacyQuery dp = null;
        try {
            dp = dxml == null ? null : PrivacyHandler.buildQuery(dxml, session);
        }
        catch (Exception e) {
            dp = null;
        }
        try {
            p = PrivacyHandler.buildQuery(xml, session);
        }
        catch (Exception e1) {
            p = null;
        }
        return UserSettings.getMergedPrivacy((StreamElement)p, (StreamElement)dp);
    }

    public static void savePrivacy(CollaborationPrincipal u, String p) throws Exception {
        s.savePrivacy(u, p);
    }

    public static StreamElement getNewsRoster(CollaborationPrincipal u, StreamEndPoint session) throws Exception {
        String xml = s.getNewsRoster(u);
        String dxml = s.getDynamicNewsRoster(u);
        StreamElement n = null;
        StreamElement dn = null;
        try {
            dn = RosterHandler.buildRosterQuery(dxml, session);
        }
        catch (Exception e) {
            dn = null;
        }
        try {
            n = RosterHandler.buildRosterQuery(xml, session);
        }
        catch (Exception e1) {
            n = null;
        }
        return UserSettings.getMergedNewsRoster(n, dn, u);
    }

    public static void saveNewsRoster(CollaborationPrincipal u, String p) throws Exception {
        s.saveNewsRoster(u, p);
    }

    static StreamElement getMergedPrivacy(StreamElement val, StreamElement dval) throws Exception {
        Log.debug("getMergedPrivacy " + val + " / " + dval);
        if (dval == null) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        try {
            PrivacyQuery pq = (PrivacyQuery)val;
            PrivacyQuery dpq = (PrivacyQuery)dval;
            Iterator i = pq.listPrivacyLists().iterator();
            while (i.hasNext()) {
                PrivacyList plist = (PrivacyList)i.next();
                String name = plist.getName();
                PrivacyList pl = dpq.getPrivacyList(name);
                if (pl != null) continue;
                dpq.add((StreamNode)plist);
            }
            if (!dpq.hasActive() && pq.hasActive()) {
                dpq.setActive(pq.getActive());
            }
            if (!dpq.hasDefault() && pq.hasDefault()) {
                dpq.setDefault(pq.getDefault());
            }
            return dpq;
        }
        catch (Exception ex) {
            return val;
        }
    }

    static RosterItem.SubscriptionType mergedSubscription(RosterItem.SubscriptionType stype1, RosterItem.SubscriptionType stype2) throws Exception {
        Log.debug("[LDAPUserSettings] mergedSubscription: " + stype1 + " / " + stype2);
        if (stype1.equals((Object)RosterItem.BOTH)) {
            return stype1;
        }
        if (stype2.equals((Object)RosterItem.BOTH)) {
            return stype2;
        }
        if (stype1.equals((Object)RosterItem.NONE)) {
            return stype2;
        }
        if (stype2.equals((Object)RosterItem.NONE)) {
            return stype1;
        }
        if (stype1.equals((Object)stype2)) {
            return stype1;
        }
        return RosterItem.BOTH;
    }

    static StreamElement getMergedRoster(StreamElement val, StreamElement dval) throws Exception {
        Log.debug("getMergedRoster " + val + " / " + dval);
        if (dval == null) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        try {
            RosterQuery rq = (RosterQuery)val;
            RosterQuery drq = (RosterQuery)dval;
            Iterator i = drq.listElements().iterator();
            while (i.hasNext()) {
                RosterItem ditem = (RosterItem)i.next();
                JID jid = ditem.getJID();
                RosterItem item = rq.getItem(jid);
                if (item != null) {
                    Iterator j = ditem.listGroups().iterator();
                    while (j.hasNext()) {
                        item.addGroup((String)j.next());
                    }
                    item.setSubscription(UserSettings.mergedSubscription(item.getSubscription(), ditem.getSubscription()));
                    continue;
                }
                rq.add((StreamNode)ditem);
            }
            return rq;
        }
        catch (Exception ex) {
            return val;
        }
    }

    static StreamElement getMergedNewsRoster(StreamElement val, StreamElement dval, CollaborationPrincipal user) throws Exception {
        Log.debug("getMergedNewsRoster: " + val + " / " + dval);
        if (dval == null) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        try {
            StreamElement newsRosterElem;
            StreamElement se = val;
            StreamElement dse = dval;
            StreamElement entities = se.getFirstElement("affiliations");
            StreamElement dentities = dse.getFirstElement("affiliations");
            HashSet<String> s = new HashSet<String>();
            Iterator i = entities.listElements("entity").iterator();
            while (i.hasNext()) {
                newsRosterElem = (StreamElement)i.next();
                String nodeName = newsRosterElem.getAttributeValue("node");
                s.add(nodeName);
            }
            i = dentities.listElements("entity").iterator();
            while (i.hasNext()) {
                newsRosterElem = (StreamElement)i.next();
                String name = newsRosterElem.getAttributeValue("node");
                if (s.contains(name)) continue;
                newsRosterElem.setAttributeValue("jid", ((IMPrincipal)user).getJID().toString());
                entities.add((StreamNode)newsRosterElem);
            }
            return se;
        }
        catch (Exception ex) {
            return val;
        }
    }

    static StreamElement getMergedStorage(StreamElement val, StreamElement dval) throws Exception {
        Log.debug("getMergedStorage " + val + " / " + dval);
        if (dval == null) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        try {
            String jid;
            StreamElement e;
            StreamElement se = val;
            StreamElement dse = dval;
            HashSet<String> s = new HashSet<String>();
            Iterator i = se.listElements("conference").iterator();
            while (i.hasNext()) {
                e = (StreamElement)i.next();
                jid = e.getAttributeValue("jid");
                s.add(jid);
            }
            i = dse.listElements("conference").iterator();
            while (i.hasNext()) {
                e = (StreamElement)i.next();
                jid = e.getAttributeValue("jid");
                if (s.contains(jid)) continue;
                se.add((StreamNode)e);
            }
            return se;
        }
        catch (Exception ex) {
            return val;
        }
    }

    static StreamElement getMergedSunmsgr(StreamElement val, StreamElement dval) throws Exception {
        Log.debug("getMergedSunmsgr " + val + " / " + dval);
        if (dval == null) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        try {
            StreamElement se = val;
            StreamElement dse = dval;
            Iterator i = dse.listElements().iterator();
            while (i.hasNext()) {
                se.add((StreamNode)((StreamElement)i.next()));
            }
            return se;
        }
        catch (Exception ex) {
            return val;
        }
    }

    static StreamElement getMergedPrivateSettings(StreamElement val, StreamElement dval) throws Exception {
        Log.debug("getMergedPrivateSettings " + val + " / " + dval);
        if (dval == null) {
            return val;
        }
        if (val == null) {
            return dval;
        }
        try {
            StreamElement se = val;
            StreamElement dse = dval;
            Iterator i = dse.listElements().iterator();
            while (i.hasNext()) {
                StreamElement e = (StreamElement)i.next();
                se.add((StreamNode)e);
            }
            return se;
        }
        catch (Exception ex) {
            return val;
        }
    }
}

