/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.util.LazyDate;
import com.sun.im.provider.RealmException;
import java.util.Date;
import java.util.TimeZone;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.x.info.TimeQuery;

public class TimeHandler
extends AbstractHandler {
    static TimeZone tz = TimeZone.getDefault();

    public void process(StreamEndPoint session, Packet packet) {
        block6: {
            Object errorText = null;
            Object errorType = null;
            Log.debug("[Time] new packet received");
            if (!session.validate(packet)) {
                return;
            }
            JID to = packet.getTo();
            if (to.getNode() != null && to.getNode().length() != 0) {
                try {
                    BaseUser u = this.getUser(packet.getTo().toBareJID());
                    if (u != null) {
                        super.deliver(session, packet, u);
                        break block6;
                    }
                    session.sendError(packet, PacketError.CANCEL, "item-not-found", to.toString() + " not found");
                }
                catch (RealmException re) {
                    Log.printStackTrace((Exception)((Object)re));
                    session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage());
                }
            } else {
                StreamDataFactory sdf = session.getDataFactory();
                TimeQuery responseQuery = (TimeQuery)sdf.createElementNode(new NSI("query", "jabber:iq:time"), null);
                Date d = LazyDate.getDate();
                responseQuery.setDisplay(d.toString());
                responseQuery.setTimezone(tz.getDisplayName());
                responseQuery.setTime(d);
                session.sendResult(packet, (StreamElement)responseQuery);
            }
        }
    }
}

