/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import java.nio.ByteBuffer;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.tls.StartTLSPacket;

public class StartTLSHandler
extends AbstractHandler {
    public void process(StreamEndPoint ep, Packet packet) {
        ClientSession session = (ClientSession)ep;
        if (packet.getNSI().equals(StartTLSPacket.NAME_STARTTLS)) {
            Packet proceed = session.getDataFactory().createPacketNode(StartTLSPacket.NAME_PROCEED);
            boolean sent = false;
            try {
                ByteBuffer bb = ByteBuffer.wrap(proceed.toString().getBytes("UTF-8"));
                sent = session.startTLS(bb);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
            if (!sent) {
                session.close();
            }
        } else if (packet.getNSI().equals(StartTLSPacket.NAME_PROCEED)) {
            // empty if block
        }
    }
}

