/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.EndPoint;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NewsChannel;
import com.iplanet.im.server.util.WildCardPattern;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public final class Settings {
    Hashtable topics = new Hashtable();
    Hashtable rooms = new Hashtable();
    private static Settings s;

    public static synchronized Settings getSettings() {
        if (s == null) {
            s = new Settings();
            s.load();
        }
        return s;
    }

    public static synchronized void reset() {
        s = null;
    }

    private Settings() {
    }

    public boolean load() {
        String s;
        boolean ret;
        Properties p = new Properties();
        Object domain = null;
        try {
            File f = new File(NMS.getDBDir(), "storage.properties");
            FileInputStream is = new FileInputStream(f);
            p.load(is);
            ret = true;
            is.close();
        }
        catch (Exception e) {
            Log.warning("Failed to open storage.properties file: " + e.toString());
            ret = false;
        }
        int topicndx = 1;
        while (!(s = p.getProperty("topic" + topicndx, "error")).equals("error")) {
            NewsChannel nc = new NewsChannel(s, null);
            this.topics.put(nc.getJID().toString(), nc);
            ++topicndx;
        }
        return ret;
    }

    private boolean save() {
        try {
            Log.debug("Saving the room-topic lists ");
            Properties p = new Properties();
            File f = new File(NMS.getDBDir(), "storage.properties");
            File tmpfile = PlatformUtil.getTempFile((File)f);
            FileOutputStream os = new FileOutputStream(tmpfile);
            int i = 1;
            Iterator iter = this.topics.values().iterator();
            while (iter.hasNext()) {
                NewsChannel nc = (NewsChannel)iter.next();
                p.put("topic" + i, nc.getName() + "@" + nc.getJID().getDomain());
                ++i;
            }
            p.store(os, "nms");
            os.close();
            PlatformUtil.renameTempFile((File)tmpfile, (File)f);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.error("Failed to save server properties: " + e.toString());
            return false;
        }
    }

    protected boolean exists(EndPoint d) {
        return this.getNewsChannel(d.getUID()) != null;
    }

    boolean addNewsChannel(NewsChannel nc, BaseUser u) {
        this.topics.put(nc.getJID().toString(), nc);
        return this.save();
    }

    void removeNewsChannel(NewsChannel nc, BaseUser u) {
        if ((nc = (NewsChannel)this.topics.get(nc.getJID().toString())) != null) {
            this.topics.remove(nc.getJID().toString());
            this.save();
        }
    }

    NewsChannel getNewsChannel(String address) {
        String id = address;
        id = StringUtility.appendDomainToAddress((String)id, (String)NMS.getName());
        return (NewsChannel)this.topics.get(id);
    }

    NewsChannel[] getNewsChannels(String pattern) {
        LinkedList<NewsChannel> v = new LinkedList<NewsChannel>();
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            return this.getOneNewsChannelArray(pattern);
        }
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            NewsChannel nc = (NewsChannel)iter.next();
            if (!wcp.match(nc.getName())) continue;
            v.add(nc);
        }
        if (v.size() > 0) {
            NewsChannel[] ra = new NewsChannel[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (NewsChannel)iter2.next();
            }
            return ra;
        }
        return null;
    }

    NewsChannel[] getNewsChannels(BaseUser u, String pattern, int access, boolean useDefaultDomain) {
        String userDomain = null;
        userDomain = useDefaultDomain ? NMS.getName() : u.getDomainName();
        if (!IMPolicyManager.canAccessNews(u)) {
            return null;
        }
        LinkedList<NewsChannel> v = new LinkedList<NewsChannel>();
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            NewsChannel[] oneNewsChannelArray = this.getOneNewsChannelArray(pattern);
            if (oneNewsChannelArray != null && oneNewsChannelArray[0].getJID().getDomain().equalsIgnoreCase(userDomain)) {
                return oneNewsChannelArray;
            }
            return null;
        }
        Iterator iter = this.topics.values().iterator();
        while (iter.hasNext()) {
            NewsChannel nc = (NewsChannel)iter.next();
            if (!nc.getJID().getDomain().equalsIgnoreCase(userDomain) || !wcp.match(nc.getName())) continue;
            v.add(nc);
        }
        if (v.size() > 0) {
            NewsChannel[] ra = new NewsChannel[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (NewsChannel)iter2.next();
            }
            return ra;
        }
        Log.debug("[Settings#getNewsChannels]Returning null array of newschannels");
        return null;
    }

    NewsChannel[] getOneNewsChannelArray(String address) {
        NewsChannel r = this.getNewsChannel(address);
        if (r != null) {
            NewsChannel[] ra = new NewsChannel[]{r};
            return ra;
        }
        return null;
    }

    public void updateDestination(EndPoint d) throws Exception {
        if (this.topics.get(d.getUID()) == null) {
            throw new Exception("News Channel " + d.getUID() + " does not exist");
        }
        this.topics.put(d.getUID(), d);
        this.save();
    }
}

