/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.OutDialbackConnection;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.RemoteEndPoint;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.ServerSocketListener;
import java.nio.channels.ByteChannel;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.dialback.DialbackResult;
import org.jabberstudio.jso.dialback.DialbackVerify;
import org.jabberstudio.jso.event.StreamStatusEvent;

public class ServerSession
extends ClientSession {
    ServerSocketListener _serverSocketListener;
    S2SSession s2s;
    OutDialbackConnection dialbackStream = null;
    String inDialbackID = null;
    boolean dialbackComplete = false;

    protected ServerSession() throws StreamException {
    }

    protected ServerSession(ByteChannel channel) throws StreamException {
        super(channel);
    }

    protected ServerSession(ServerSocketListener selector, ByteChannel channel) throws StreamException {
        super(selector, channel);
    }

    void setParent(S2SSession s2s) {
        this.s2s = s2s;
    }

    private void sendUnavailable(RemoteEndPoint ep) {
        Presence p = ep.getPresence();
        Log.debug("ServerSession[" + this.getJID() + "] DEBUG sendUnavailable p=" + p);
        if (p != null && !Presence.UNAVAILABLE.equals((Object)p.getType())) {
            Log.debug("ServerSession[" + this.getJID() + "] sending unavailable presence on behalf of user");
            p = (Presence)ep.getDataFactory().createPacketNode(PresenceHandler.NAME, Presence.class);
            p.setType((Packet.Type)Presence.UNAVAILABLE);
            p.setFrom(ep.getJID());
            this.rq.handle(ep, (Packet)p);
        }
    }

    public void statusChanged(StreamStatusEvent event) {
        super.statusChanged(event);
        StreamContext sc = event.getContext();
        if (!event.getPreviousStatus().equals((Object)Stream.OPENED) || event.getNextStatus().equals((Object)Stream.CLOSED) || event.getNextStatus().equals((Object)Stream.DISCONNECTED)) {
            // empty if block
        }
        if (this.s2s != null && event.getNextStatus().equals((Object)Stream.DISCONNECTED) && (event.getPreviousStatus().equals((Object)Stream.CLOSED) || event.getPreviousStatus().equals((Object)Stream.OPENED)) && this.s2s.getInbound() == this) {
            this.s2s.setInbound(null);
        }
    }

    boolean validate(Packet packet) {
        String resource;
        if (!this.serverSession) {
            return super.validate(packet);
        }
        JID from = packet.getFrom();
        if (from != null && ((resource = from.getResource()) == null || resource.length() == 0 || this.getUser().getSession(resource) == null)) {
            Log.info("User[" + this.getJID() + "] invalid from: " + from);
        }
        if (packet.getFrom() == null) {
            packet.setFrom(this.getJID());
        }
        return true;
    }

    boolean isReady() {
        return this.dialbackComplete;
    }

    public void startDialback(DialbackResult resultPacket) {
        Log.debug("ServerSession[" + this.getJID() + "] startDialback key=" + resultPacket.getKey() + " stream=" + this.getStream());
        try {
            this.dialbackStream = new OutDialbackConnection(this, this.s2s.getRemoteHost(), this.s2s.getRemoteDomain(), this.s2s.usessl(), resultPacket.getKey(), this.getStream().getOutboundContext().getID());
        }
        catch (Exception e) {
            this.finishDialback(DialbackResult.INVALID);
        }
    }

    public void finishDialback(DialbackResult.Type type) {
        DialbackResult p = (DialbackResult)this.getDataFactory().createPacketNode(DialbackResult.NAME);
        p.setFrom(NMS.getJID());
        p.setTo(this.getJID());
        p.setType((Packet.Type)type);
        try {
            this.getStream().send((Packet)p);
            Log.debug("ServerSession[" + this.getJID() + "] sent final dialback result");
        }
        catch (Exception e) {
            Log.debug("ServerSession[" + this.getJID() + "] failed to send dialback result");
        }
    }

    public void finishDialback(DialbackVerify vfyResponse) {
        this.setJID(vfyResponse.getFrom());
        if (DialbackResult.VALID.equals((Object)vfyResponse.getType())) {
            Log.debug("ServerSession[" + this.getJID() + "] dialback successful");
            this.finishDialback(DialbackResult.VALID);
            this.dialbackComplete = true;
        } else {
            this.finishDialback(DialbackResult.INVALID);
            Log.debug("ServerSession[" + this.getJID() + "] dialback failed");
            if (this.s2s.getInbound() == this) {
                this.s2s.setInbound(null);
            }
            this.close();
        }
    }
}

