/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.Discoverable;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.RealmException;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import java.util.Set;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;

public class SearchHandler
extends AbstractHandler
implements Discoverable {
    UserSettingsStorageProvider us = RealmManager.getUserSettingsStorageProvider();
    private static NSI NSI_ITEM = new NSI("item", null);
    private static NSI NSI_NICK = new NSI("nick", null);
    private static NSI NSI_EMAIL = new NSI("email", null);
    private static NSI NSI_FIRST = new NSI("first", null);
    private static NSI NSI_LAST = new NSI("last", null);
    private static NSI NSI_PROPERTY = new NSI("property", null);
    private static NSI NSI_VALUE = new NSI("value", null);
    public static String NAMESPACE = "jabber:iq:search";
    public static NSI NAME = new NSI("query", NAMESPACE);
    public static String X_NAMESPACE = "sun:xmpp:properties";
    public static NSI X_NAME = new NSI("x", X_NAMESPACE);
    public static NSI NSI_NEVER_USED = new NSI("never", null);
    static MonitorTransactionFactory tranFactory = null;

    /*
     * Unable to fully structure code
     */
    public void process(StreamEndPoint session, Packet packet) {
        errorText = null;
        errorType = null;
        Log.debug("[Search] new search packet received.");
        if (!session.validate(packet)) {
            return;
        }
        sdf = session.getDataFactory();
        queryNodes = packet.listElements("query");
        query = (StreamElement)queryNodes.get(0);
        responseQuery = sdf.createElementNode(SearchHandler.NAME, null);
        if (packet.getType().equals((Object)InfoQuery.GET)) {
            Log.debug("[Search] get searchable attributes");
            fac = session.getDataFactory();
            responseQuery.add((StreamNode)sdf.createElementNode(SearchHandler.NSI_NICK, null));
            responseQuery.add((StreamNode)sdf.createElementNode(SearchHandler.NSI_EMAIL, null));
            responseQuery.add((StreamNode)sdf.createElementNode(SearchHandler.NSI_FIRST, null));
            responseQuery.add((StreamNode)sdf.createElementNode(SearchHandler.NSI_LAST, null));
            session.sendResult(packet, responseQuery);
        } else if (packet.getType().equals((Object)InfoQuery.SET)) {
            pattern = null;
            byUid = false;
            type = 0;
            first = null;
            last = null;
            transaction = null;
            if (SearchHandler.tranFactory != null) {
                transaction = SearchHandler.tranFactory.startTransaction();
            }
            i = query.listElements().iterator();
            while (i.hasNext()) {
                filterElement = (StreamElement)i.next();
                pattern = filterElement.normalizeText();
                if (pattern != null && (pattern = pattern.trim()).length() > 0) {
                    if (filterElement.getLocalName().equals("nick")) {
                        type = 2;
                        domain = StringUtility.getDomainFromAddress((String)pattern, null);
                        if (domain == null || !domain.equalsIgnoreCase(NMS.getName())) break;
                        pattern = StringUtility.getLocalPartFromAddress((String)pattern);
                        break;
                    }
                    if (filterElement.getLocalName().equals("email")) {
                        type = 4;
                        break;
                    }
                    type = 1;
                    if (!(pattern = StringUtility.substitute((String)pattern, (String)" ", (String)"*")).startsWith("*")) {
                        pattern = "*" + pattern;
                    }
                    if (!pattern.endsWith("*")) {
                        pattern = pattern + "*";
                    }
                    while (pattern.indexOf("**") >= 0) {
                        pattern = StringUtility.substitute((String)pattern, (String)"**", (String)"*");
                    }
                    if (filterElement.getLocalName().equals("first")) {
                        first = pattern;
                        break;
                    }
                    last = pattern;
                    break;
                }
                pattern = null;
            }
            if (type == 1 && first != null && last != null) {
                pattern = first + " " + last;
            }
            Log.debug("[Search] pattern=" + pattern);
            if (pattern != null) {
                try {
                    srch = RealmManager.search(session.getUser(), pattern, type, null);
                    p = srch.getPrincipals();
                    if (p == null) ** GOTO lbl124
                    for (i = 0; i < p.length; ++i) {
                        if (p[i] instanceof BaseUser && p[i].getDomainName().equalsIgnoreCase(session.getJID().getDomain())) {
                            try {
                                if (!this.us.hasRoster((CollaborationPrincipal)((BaseUser)p[i]))) {
                                    p[i].setProperty("last", "never");
                                }
                            }
                            catch (Exception e) {
                                Log.printStackTrace(e);
                            }
                        }
                        item = sdf.createElementNode(SearchHandler.NSI_ITEM, null);
                        item.setAttributeValue("jid", p[i].getJID().toString());
                        nick = sdf.createElementNode(SearchHandler.NSI_NICK, null);
                        nick.addText(p[i].getUID());
                        item.add((StreamNode)nick);
                        name = sdf.createElementNode(SearchHandler.NSI_FIRST, null);
                        name.addText(p[i].getDisplayName());
                        item.add((StreamNode)name);
                        mail = p[i].getProperty("mail");
                        if (mail != null) {
                            email = sdf.createElementNode(SearchHandler.NSI_EMAIL, null);
                            email.addText(mail);
                            item.add((StreamNode)email);
                        }
                        x = sdf.createElementNode(SearchHandler.X_NAME, null);
                        props = p[i].propertyNames();
                        while (props.hasMoreElements()) {
                            prop = (String)props.nextElement();
                            values = p[i].getValue(prop);
                            if (values == null) continue;
                            eProp = sdf.createElementNode(SearchHandler.NSI_PROPERTY);
                            eProp.setAttributeValue("name", prop);
                            if (values instanceof String) {
                                eVal = sdf.createElementNode(SearchHandler.NSI_VALUE);
                                eVal.addText((String)values);
                                eProp.add((StreamNode)eVal);
                            } else if (values instanceof Set) {
                                v = ((Set)values).iterator();
                                while (v.hasNext()) {
                                    eVal = sdf.createElementNode(SearchHandler.NSI_VALUE);
                                    eVal.addText(v.next().toString());
                                    eProp.add((StreamNode)eVal);
                                }
                            }
                            x.add((StreamNode)eProp);
                        }
                        item.add((StreamNode)x);
                        responseQuery.add((StreamNode)item);
                    }
                }
                catch (RealmException re) {
                    errorType = PacketError.CANCEL;
                    errorText = re.getMessage();
                    Log.printStackTrace((Exception)re);
                }
            } else {
                errorType = PacketError.MODIFY;
                errorText = "Pattern missing or too short";
            }
lbl124:
            // 4 sources

            if (errorType == null) {
                session.sendResult(packet, responseQuery, transaction);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else {
            session.sendError(packet, PacketError.CANCEL, "bad-request", "IQ request types are set or get, period.");
        }
    }

    public PacketError.Type fillInfo(DiscoInfoQuery query, JID jid, String node, StreamEndPoint session) {
        if (node == null) {
            query.addIdentity(this.getCategory(), this.getType(), this.getName());
            query.addFeature(NAMESPACE);
        } else if (node.equals("")) {
            query.addIdentity(this.getCategory(), this.getType(), this.getName());
            query.addFeature(NAMESPACE);
        } else {
            try {
                Log.debug("[SearchHandler] fillInfo for node: " + node);
                JID entryJID = new JID(node);
                if (entryJID.getNode().equals("")) {
                    String groupDN = JIDUtil.decodedResource((JID)entryJID);
                    Log.debug("[SearchHandler] fillInfo for groupDN: " + groupDN);
                    NMSGroup group = RealmManager.getGroup(session.getUser(), groupDN, false);
                    if (group != null) {
                        query.addIdentity("x-entry", "group", group.getDisplayName());
                    }
                } else {
                    String uid = JIDUtil.decodedJID((JID)entryJID.toBareJID());
                    Log.debug("[SearchHandler] fillInfo for uid: " + uid);
                    LocalUser user = RealmManager.getUser(session.getUser(), uid);
                    if (user != null) {
                        query.addIdentity("x-entry", "contact", user.getDisplayName());
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public PacketError.Type fillItems(DiscoItemsQuery query, JID jid, String node, StreamEndPoint session) {
        if (node != null) {
            try {
                Log.debug("[SearchHandler] fillItems node= " + node);
                String groupDN = JIDUtil.decodedResource((JID)new JID(node));
                Log.debug("[SearchHandler] fillItems groupDN= " + groupDN);
                NMSGroup group = null;
                IMPrincipal[] p = null;
                if (groupDN != null) {
                    group = RealmManager.getGroup(session.getUser(), groupDN, true);
                }
                if (group != null) {
                    p = group.getMembers();
                }
                if (p != null) {
                    for (int i = 0; i < p.length; ++i) {
                        query.addItem(p[i].getJID(), null, p[i].getDisplayName());
                    }
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.error("[SearchHandler#fillInfo ] " + e.toString());
                return PacketError.CANCEL;
            }
        }
        return null;
    }

    public PacketError.Type updateItems(DiscoItemsQuery query, JID jid, StreamEndPoint session) {
        return PacketError.MODIFY;
    }

    public String getName() {
        return "User Directory Service";
    }

    public PacketError.Type fillAgentInfo(StreamElement agentElement, StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        agentElement.add((StreamNode)sdf.createElementNode(new NSI("search", null), null));
        StreamElement service = sdf.createElementNode(new NSI("service", null), null);
        service.add((StreamNode)sdf.createText("jud"));
        agentElement.add((StreamNode)service);
        return null;
    }

    public String getCategory() {
        return "directory";
    }

    public String getType() {
        return "user";
    }

    public String[] getNamespaces() {
        String[] ns = new String[]{NAMESPACE};
        return ns;
    }

    public PacketError.Type fillBrowseInfo(JID jid, StreamElement query, StreamEndPoint session) {
        return null;
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                tranFactory = monitor.getTransactionFactory("search");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

