/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.DSAMESSOProvider;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.SSOProvider;
import com.sun.im.service.util.StringUtility;
import java.util.Map;
import java.util.Set;

public class SSO {
    private static final String SSOTOKEN_ATTR = "ssotoken";
    private static final String SSOProviderName = "iim_server.ssoprovider";
    private static final String usessoName = "iim_server.usesso";
    private static final String ssoUpdateName = "iim_server.sso.update";
    private static boolean _update = false;
    protected static final int NO_SSO = 0;
    protected static final int USE_SSO = 1;
    protected static final int SSO_ONLY = -1;
    private static SSOProvider _provider = null;
    private static int mode = 0;

    public static int getMode() {
        return mode;
    }

    public static void init() {
        ServerConfig sc = ServerConfig.getServerConfig();
        if (SSO.getMode() == 0) {
            return;
        }
        String providerClassName = sc.getSetting(SSOProviderName);
        if (providerClassName != null) {
            try {
                _provider = (SSOProvider)Class.forName(providerClassName).newInstance();
            }
            catch (Exception e) {
                Log.error("Failed to load SSO provider " + providerClassName + " : " + e.toString());
                Log.printStackTrace(e);
                _provider = null;
            }
        } else {
            try {
                Class<?> c = Class.forName("com.iplanet.am.sdk.AMException");
                _provider = new DSAMESSOProvider();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.printStackTrace(e);
                Log.info("Not using Single-Sign-On");
                _provider = null;
            }
        }
        try {
            if (_provider != null) {
                _provider.open();
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            _provider = null;
        }
    }

    protected static boolean usingIdentity() {
        return _provider instanceof DSAMESSOProvider;
    }

    protected static boolean refresh(BaseUser u) {
        if (_provider != null && _update && u.getValue(SSOTOKEN_ATTR) != null) {
            Log.debug("Refreshing session of user " + u.getUID());
            return _provider.refresh(u.getJID().toBareJID().toString());
        }
        return true;
    }

    public static boolean isEnabled() {
        return _provider != null;
    }

    public static boolean verify(String uid, String token, Map attrs, Set attributeNames) {
        String UID;
        boolean res = false;
        if (_provider != null && (res = _provider.verify(UID = StringUtility.unquoteSpecialCharacters((String)uid), token, attrs, attributeNames))) {
            attrs.put(SSOTOKEN_ATTR, token);
        }
        return res;
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        String t = sc.getSetting(usessoName, "0");
        if (t != null) {
            mode = Integer.parseInt(t);
        }
        t = sc.getSetting(ssoUpdateName, "true");
        try {
            _update = StringUtility.getBoolean((String)t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

