/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.CertPasswordCallback;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.mozilla.jss.CertDatabaseException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.KeyDatabaseException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.SSLServerSocket;
import org.mozilla.jss.ssl.SSLSocket;

public class SSLContextManager {
    public static final String SERVER_SECCONFIGDIR = "iim_server.secconfigdir";
    public static final String SECCONFIGDIR = "iim.secconfigdir";
    public static final String SERVER_KEYDBPREFIX = "iim_server.keydbprefix";
    public static final String KEYDBPREFIX = "iim.keydbprefix";
    public static final String SERVER_CERTDBPREFIX = "iim_server.certdbprefix";
    public static final String CERTDBPREFIX = "iim.certdbprefix";
    public static final String SERVER_SECMODFILE = "iim_server.secmodfile";
    public static final String SECMODFILE = "iim.secmodfile";
    public static final String SERVER_CERTNICKNAME = "iim_server.certnickname";
    public static final String CERTNICKNAME = "iim.certnickname";
    public static final String KEYSTORE = "iim_server.sslkeystore";
    public static final String SERVER_KEYSTOREPASSWORDFILE = "iim_server.keystorepasswordfile";
    public static final String KEYSTOREPASSWORDFILE = "iim.sslpasswordfile";
    public static final String SERVER_TRUST_ALL_CERT = "iim_server.trust_all_cert";
    static boolean useJSS = false;
    static String _certNickname = "Server-Cert";

    private static String getKeyStorePassword(String secconfdir) {
        ServerConfig sc = ServerConfig.getServerConfig();
        String passfile = sc.getSetting(KEYSTOREPASSWORDFILE, secconfdir + File.separator + "sslpassword.conf");
        passfile = sc.getSetting(SERVER_KEYSTOREPASSWORDFILE, passfile);
        String pass = null;
        try {
            BufferedReader br = new BufferedReader(new FileReader(passfile));
            String nextLine = pass = br.readLine();
            while (nextLine != null) {
                if (nextLine.indexOf(58) != -1 && nextLine.startsWith("Internal (Software) Token")) {
                    StringTokenizer st = new StringTokenizer(nextLine, ":");
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                    }
                    if (st.hasMoreTokens()) {
                        pass = st.nextToken();
                        break;
                    }
                }
                pass = nextLine;
                nextLine = br.readLine();
            }
        }
        catch (IOException ie) {
            Log.error("[JSS] Error reading " + passfile);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return pass;
    }

    public static SSLContext getInstance() {
        ServerConfig sc = ServerConfig.getServerConfig();
        String confDir = NMS.getConfigDir();
        if (confDir == null) {
            confDir = ".";
        }
        String secconfdir = sc.getSetting(SECCONFIGDIR, confDir);
        String keyStorePath = sc.getSetting(KEYSTORE, null);
        if (keyStorePath == null && !(useJSS = SSLContextManager.initJSS())) {
            return null;
        }
        String pass = SSLContextManager.getKeyStorePassword(secconfdir);
        if (pass == null) {
            return null;
        }
        char[] passphrase = pass.toCharArray();
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            if (!useJSS) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("jks");
                ks.load(new FileInputStream(keyStorePath), passphrase);
                kmf.init(ks, passphrase);
                ctx.init(kmf.getKeyManagers(), null, null);
            }
            return ctx;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    private static boolean initJSS() {
        ServerConfig sc = ServerConfig.getServerConfig();
        String confDir = NMS.getConfigDir();
        if (confDir == null) {
            confDir = ".";
        }
        String secconfdir = sc.getSetting(SECCONFIGDIR, confDir);
        secconfdir = sc.getSetting(SERVER_SECCONFIGDIR, secconfdir);
        String keydbprefix = sc.getSetting(KEYDBPREFIX, "");
        keydbprefix = sc.getSetting(SERVER_KEYDBPREFIX, keydbprefix);
        String certdbprefix = sc.getSetting(CERTDBPREFIX, "");
        certdbprefix = sc.getSetting(SERVER_CERTDBPREFIX, certdbprefix);
        String secmodfile = sc.getSetting(SECMODFILE, "secmod.db");
        secmodfile = sc.getSetting(SERVER_SECMODFILE, secmodfile);
        _certNickname = sc.getSetting(CERTNICKNAME, _certNickname);
        _certNickname = sc.getSetting(SERVER_CERTNICKNAME, _certNickname);
        String trust_all_cert = sc.getSetting(SERVER_TRUST_ALL_CERT, "false");
        System.setProperty("com.iplanet.im.trust_all_server_certs", trust_all_cert);
        String pass = SSLContextManager.getKeyStorePassword(secconfdir);
        if (pass == null) {
            return false;
        }
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(secconfdir, keydbprefix, certdbprefix, secmodfile);
            vals.passwordCallback = new CertPasswordCallback(pass);
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
            Log.info("JSS is initialized");
            return true;
        }
        catch (KeyDatabaseException kdbe) {
            Log.error("Couldn't open the key database");
        }
        catch (CertDatabaseException cdbe) {
            Log.error("Couldn't open the certificate database");
        }
        catch (AlreadyInitializedException aie) {
            Log.error("CryptoManager already initialized");
        }
        catch (GeneralSecurityException e) {
            Log.error("General security exception while initializing");
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return false;
    }

    public static ServerSocket getSSLServerSocket(int port, InetAddress addr) throws SocketException {
        SSLContextManager.initJSS();
        SSLServerSocket.configServerSessionIDCache((int)0, (int)0, (int)0, null);
        SSLSocket.setCipherPolicy((SSLSocket.CipherPolicy)SSLSocket.CipherPolicy.EXPORT);
        try {
            SSLServerSocket s = new SSLServerSocket(port, 10, addr);
            s.setServerCertNickname(_certNickname);
            return s;
        }
        catch (Exception e) {
            Log.error("Exception occured while creating ssl socket");
            Log.printStackTrace(e);
            return null;
        }
    }
}

