/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ContentFilters;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.PassThruHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPByteStream;
import com.sun.im.provider.RealmException;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.x.si.SIProfile;
import org.jabberstudio.jso.x.si.SIQuery;
import org.jabberstudio.jso.x.sift.FileTransferProfile;

public class SIHandler
extends PassThruHandler {
    public void process(StreamEndPoint session, Packet packet) {
        if (!session.validate(packet)) {
            return;
        }
        JID to = packet.getTo();
        if (to != null && to.getNode() != null && to.getNode().length() != 0) {
            if (ContentFilters.enabled()) {
                XMPPByteStream bs = new XMPPByteStream(session, packet.getID());
                SIQuery si = (SIQuery)packet.listElements(SIQuery.NAME).get(0);
                SIProfile profile = si.getProfile();
                if (profile instanceof FileTransferProfile) {
                    bs.setName(((FileTransferProfile)profile).getName());
                }
                bs.setSID(si.getID());
                super.process(session, packet);
            } else {
                try {
                    BaseUser u = this.getUser(to.toBareJID());
                    if (u != null) {
                        this.deliver(session, packet, u);
                    } else {
                        session.sendError(packet, PacketError.CANCEL, "item-not-found", to.toString() + " not found");
                    }
                }
                catch (RealmException re) {
                    Log.printStackTrace((Exception)((Object)re));
                    session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage());
                    return;
                }
            }
        }
    }

    public boolean processIQReply(StreamEndPoint session, Packet packet) {
        if (!ContentFilters.enabled()) {
            return false;
        }
        String id = packet.getID();
        JID to = packet.getTo();
        if (id == null || to == null) {
            return false;
        }
        try {
            SIQuery si;
            List elements;
            BaseUser u = this.getUser(to.toBareJID());
            StreamEndPoint rcptSession = u.getSession(to.getResource());
            if (rcptSession == null) {
                return false;
            }
            XMPPByteStream bs = rcptSession.getByteStream(id);
            if (bs == null) {
                return false;
            }
            if (rcptSession.removeByteStream(id) != null) {
                Log.debug("[SIHandler] Removed byte stream from " + to.toString());
            }
            if (packet.getType() == InfoQuery.RESULT && (elements = packet.listElements(SIQuery.NAME)).size() > 0 && IBBHandler.NAMESPACE.equals((si = (SIQuery)elements.get(0)).getPreferredStreamMethod())) {
                Log.debug("[SIHandler] Preferred method is ibb. Adding byte stream for " + to.toString());
                rcptSession.addByteStream(bs.getSID(), bs);
            }
            super.process(session, packet);
            return true;
        }
        catch (RealmException re) {
            Log.printStackTrace((Exception)((Object)re));
            return false;
        }
    }
}

