/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.ServerSession;
import com.iplanet.im.server.StreamEndPoint;
import java.util.Hashtable;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.dialback.DialbackResult;
import org.jabberstudio.jso.dialback.DialbackUtilities;
import org.jabberstudio.jso.dialback.DialbackVerify;

public class S2SPacketDispatcher
extends ClientPacketDispatcher {
    private static Hashtable _dialbackRequests = new Hashtable();

    protected S2SPacketDispatcher() {
    }

    public void handle(StreamEndPoint session, Packet packet) {
        Log.debug("[S2SPacketDispatcher] / handle():");
        JID sessionJID = session.getJID();
        if (sessionJID == null) {
            sessionJID = packet.getFrom();
        }
        S2SSession s2s = (S2SSession)NMS.getRemoteSession(sessionJID);
        if (packet instanceof DialbackVerify) {
            DialbackVerify vfyPacket = (DialbackVerify)packet;
            String key = vfyPacket.getKey();
            Packet.Type type = vfyPacket.getType();
            Log.debug("[S2SPacketDispatcher] verify to=" + vfyPacket.getTo() + " from=" + vfyPacket.getFrom() + " id=" + vfyPacket.getID() + " key=" + key + " type=" + vfyPacket.getType());
            if (type != null) {
                Log.warning("[S2SPacketDispatcher] not expecting a verify response packet on incoming connection!");
            } else {
                S2SPacketDispatcher.doDialbackCheck((Packet)vfyPacket, session.getStream());
            }
            return;
        }
        if (packet instanceof DialbackResult) {
            DialbackResult resPacket = (DialbackResult)packet;
            String key = resPacket.getKey();
            Packet.Type type = resPacket.getType();
            Log.debug("[S2SPacketDispatcher] result to=" + resPacket.getTo() + " from=" + resPacket.getFrom() + " id=" + resPacket.getID() + " key=" + key + " type=" + resPacket.getType());
            if (type == null) {
                Log.debug("Received an initiating db:Result Packet");
                if (s2s == null) {
                    Log.warning("S2SSession[" + sessionJID + "] registering new s2s session");
                    ((ServerSession)session).setParent(s2s);
                    s2s = new S2SSession(sessionJID, (ServerSession)session);
                    NMS.addRemoteSession(sessionJID, (RemoteSession)s2s);
                }
                ((ServerSession)session).setParent(s2s);
                s2s.setInbound((ServerSession)session);
                ((ServerSession)session).startDialback(resPacket);
            } else {
                Log.warning("S2SSession[" + sessionJID + "] received unexpected db:result response on incoming connection");
            }
            return;
        }
        if (s2s != null) {
            StreamEndPoint sep = null;
            sep = packet.getFrom() != null && packet.getFrom().hasNode() ? s2s.getEndPoint(packet.getFrom()) : s2s.getEndPoint();
            if (sep != null) {
                super.handle(sep, packet);
            }
        } else {
            Log.error("[S2SPacketDispatcher] null s2s ");
        }
    }

    static void addDialbackRequest(String id, DialbackResult p) {
        _dialbackRequests.put(id, p);
    }

    static DialbackResult removeDialbackRequest(String id) {
        return (DialbackResult)_dialbackRequests.remove(id);
    }

    public static void doDialbackCheck(Packet vfyPacket, Stream dbStream) {
        DialbackResult ref = (DialbackResult)_dialbackRequests.remove(vfyPacket.getID());
        boolean verified = false;
        if (ref == null) {
            Log.warning("[S2SPacketDispatcher] null dialback reference for " + vfyPacket.getFrom());
        } else {
            verified = DialbackUtilities.validate((Packet)ref, (Packet)vfyPacket);
            Log.debug("[S2SPacketDispatcher] Dialback validation result: " + verified + " ref={from=" + ref.getFrom() + ", to=" + ref.getTo() + ", key=" + ref.normalizeText() + "}  tst={from=" + vfyPacket.getFrom() + ", to=" + vfyPacket.getTo() + ", key=" + vfyPacket.normalizeText() + "}");
        }
        DialbackVerify p = (DialbackVerify)dbStream.getDataFactory().createPacketNode(DialbackVerify.NAME);
        p.setTo(vfyPacket.getFrom());
        p.setFrom(vfyPacket.getTo());
        p.setID(vfyPacket.getID());
        if (verified) {
            p.setType((Packet.Type)DialbackVerify.VALID);
        } else {
            p.setType((Packet.Type)DialbackVerify.INVALID);
        }
        try {
            dbStream.send((Packet)p);
            Log.debug("Verification response packet sent, verified: " + verified);
        }
        catch (StreamException se) {
            Log.printStackTrace((Exception)((Object)se));
        }
    }
}

