/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RosterHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.xmpp.JIDUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.core.PrivacyItem;
import org.jabberstudio.jso.x.core.PrivacyList;
import org.jabberstudio.jso.x.core.PrivacyQuery;
import org.jabberstudio.jso.x.core.RosterItem;
import org.xml.sax.SAXException;

public class PrivacyHandler
extends AbstractHandler {
    UserSettingsStorageProvider us = RealmManager.getUserSettingsStorageProvider();
    protected static final NSI QUERY_NSI = new NSI("query", "jabber:iq:privacy");
    static MonitorTransactionFactory getTranFactory = null;
    static MonitorTransactionFactory setTranFactory = null;

    public void process(StreamEndPoint sep, Packet packet) {
        if (!(sep instanceof ClientSession)) {
            sep.sendResult(packet);
            return;
        }
        ClientSession session = (ClientSession)sep;
        String errorText = null;
        String errorCondition = null;
        PacketError.Type errorType = null;
        StreamElement responseQuery = null;
        LocalUser user = (LocalUser)session.getUser();
        StreamDataFactory sdf = session.getDataFactory();
        MonitorTransaction transaction = null;
        if (!session.validate(packet)) {
            return;
        }
        List queryNodes = packet.listElements(QUERY_NSI);
        PrivacyQuery query = (PrivacyQuery)queryNodes.get(0);
        if (packet.getType() == InfoQuery.SET) {
            if (setTranFactory != null) {
                transaction = setTranFactory.startTransaction();
            }
            responseQuery = sdf.createElementNode(QUERY_NSI, null);
            PrivacyList list = null;
            try {
                List l = query.listElements();
                if (l.size() != 1) {
                    errorType = PacketError.MODIFY;
                    errorCondition = "bad-request";
                    errorText = "Set privacy request with more than one directive";
                } else {
                    String name = null;
                    if (query.hasActive()) {
                        PrivacyQuery privacy = user.getPrivacy(false);
                        name = query.getActive();
                        if (name != null && !name.equals("")) {
                            if (privacy.getPrivacyList(name) != null) {
                                user.activatePrivacyList(name, session);
                            } else {
                                errorType = PacketError.CANCEL;
                                errorCondition = "item-not-found";
                                errorText = "Unknown privacy list: " + name;
                            }
                        } else {
                            user.deactivatePrivacyList(session);
                        }
                        user.releasePrivacy(false);
                        list = null;
                    } else if (query.hasDefault()) {
                        PrivacyQuery privacy = user.getPrivacy(true);
                        name = query.getDefault();
                        String currDefault = privacy.getDefault();
                        if (name != null && !name.equals("")) {
                            if (privacy.getPrivacyList(name) != null) {
                                if (!user.isPrivacyListInUse(currDefault, session)) {
                                    privacy.setDefault(name);
                                    user.savePrivacy();
                                    Log.debug("[Privacy] modified privacy list");
                                } else {
                                    user.releasePrivacy(true);
                                    errorType = PacketError.CANCEL;
                                    errorCondition = "conflict";
                                    errorText = "Privacy list " + name + " is in use by other resources.";
                                }
                            } else {
                                user.releasePrivacy(true);
                                errorType = PacketError.CANCEL;
                                errorCondition = "item-not-found";
                                errorText = "Unknown privacy list: " + name;
                            }
                        } else if (!user.isPrivacyListInUse(currDefault, session)) {
                            privacy.removeDefault();
                            user.savePrivacy();
                            Log.debug("[Privacy] modified privacy list");
                        } else {
                            user.releasePrivacy(true);
                            errorType = PacketError.CANCEL;
                            errorCondition = "conflict";
                            errorText = "Privacy list " + name + " is in use by other resources.";
                        }
                        list = null;
                    } else {
                        list = (PrivacyList)query.listPrivacyLists().get(0);
                        name = list.getAttributeValue("name");
                        if (list.getLocalName().equals("list")) {
                            if (name != null) {
                                boolean modified = true;
                                PrivacyQuery privacy = user.getPrivacy(true);
                                list = query.getPrivacyList(name);
                                PrivacyList current = privacy.getPrivacyList(name);
                                if (current != null) {
                                    privacy.remove((StreamNode)current);
                                }
                                PrivacyList apl = session.getActivePrivacyList();
                                if (!list.listElements().isEmpty()) {
                                    privacy.add((StreamNode)((StreamElement)list.copy()));
                                    if (apl != null && apl.getName().equals(name)) {
                                        Log.debug("[Privacy] Refreshed the active privacy list: " + name);
                                        user.activatePrivacyList(name, session);
                                    }
                                } else if (user.isPrivacyListInUse(name, session)) {
                                    errorType = PacketError.CANCEL;
                                    errorCondition = "conflict";
                                    errorText = "Privacy list " + name + " is in use by other resources.";
                                    privacy.add((StreamNode)current);
                                    modified = false;
                                } else if (current == null) {
                                    errorType = PacketError.CANCEL;
                                    errorCondition = "item-not-found";
                                    errorText = "Privacy list " + name + " does not exists";
                                    privacy.add((StreamNode)current);
                                    modified = false;
                                } else {
                                    if (apl != null && apl.getName().equals(name)) {
                                        user.deactivatePrivacyList(session);
                                    }
                                    if (privacy.getDefault().equals(name)) {
                                        privacy.removeDefault();
                                    }
                                }
                                if (modified) {
                                    user.savePrivacy();
                                    Log.debug("[Privacy] modified/added privacy list: " + list);
                                } else {
                                    user.releasePrivacy(true);
                                }
                            } else {
                                errorType = PacketError.MODIFY;
                                errorCondition = "bad-request";
                                errorText = "missing privacy list name";
                            }
                        } else {
                            user.releasePrivacy(true);
                            errorType = PacketError.MODIFY;
                            errorCondition = "bad-request";
                            errorText = "Unrecognized privacy element: list.getLocalName()";
                        }
                    }
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                errorType = PacketError.CANCEL;
                errorCondition = "internal-server-error";
                errorText = e.getMessage();
            }
            if (errorType == null) {
                if (list != null) {
                    list.clearElements();
                    packet.setFrom(null);
                    user.broadcast(packet);
                }
                session.sendResult(packet, responseQuery, transaction);
            } else {
                session.sendError(packet, errorType, errorCondition, errorText, transaction);
            }
        } else if (packet.getType() == InfoQuery.GET) {
            if (getTranFactory != null) {
                transaction = getTranFactory.startTransaction();
            }
            responseQuery = sdf.createElementNode(QUERY_NSI, null);
            PrivacyQuery privacy = user.getPrivacy(false);
            try {
                List l = query.listElements("list");
                if (l.isEmpty()) {
                    PrivacyList list;
                    Iterator i = privacy.listPrivacyLists().iterator();
                    while (i.hasNext()) {
                        PrivacyList pl = (PrivacyList)((PrivacyList)i.next()).clone();
                        pl.clearElements();
                        responseQuery.add((StreamNode)pl);
                    }
                    String defaultList = privacy.getDefault();
                    if (!defaultList.equals("")) {
                        ((PrivacyQuery)responseQuery).setDefault(defaultList);
                    }
                    if ((list = session.getActivePrivacyList()) != null) {
                        ((PrivacyQuery)responseQuery).setActive(list.getName());
                    }
                } else if (l.size() != 1) {
                    errorType = PacketError.MODIFY;
                    errorCondition = "bad-request";
                    errorText = "Can only request one privacy list.";
                } else {
                    String name = ((StreamElement)l.get(0)).getAttributeValue("name");
                    Log.debug("[Privacy] Retrieving " + name);
                    PrivacyList pl = privacy.getPrivacyList(name);
                    if (pl != null) {
                        Iterator i = pl.listElements("item").iterator();
                        while (i.hasNext()) {
                            Iterator m = ((StreamElement)i.next()).listElements("message").iterator();
                            while (m.hasNext()) {
                                ((StreamElement)m.next()).clearElements();
                            }
                        }
                        responseQuery.add((StreamNode)pl);
                        Log.debug("[Privacy] Returning " + pl);
                    } else {
                        errorType = PacketError.CANCEL;
                        errorCondition = "item-not-found";
                        errorText = "Unknown privacy list: " + name;
                    }
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                errorType = PacketError.CANCEL;
                errorCondition = "internal-server-error";
                errorText = e.getMessage();
            }
            user.releasePrivacy(false);
            if (errorType == null) {
                session.sendResult(packet, responseQuery, transaction);
            } else {
                session.sendError(packet, errorType, errorCondition, errorText, transaction);
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "IQ request types are set or get, period.");
        }
    }

    public static boolean evaluate(Packet packet, LocalUser u, PrivacyList pl, boolean in) {
        List l;
        if (pl == null) {
            return true;
        }
        List privacyItems = pl.listItems();
        Iterator i = privacyItems.iterator();
        while (i.hasNext()) {
            PrivacyItem item = (PrivacyItem)i.next();
            if (item == null) continue;
            Log.debug("PrivacyHandler#evaluate [  " + u.getUID() + " ] type " + item.getType() + " action " + item.getAction() + " value " + item.getValue());
        }
        if (packet instanceof InfoQuery && (((InfoQuery)packet).getType().equals((Object)InfoQuery.RESULT) || ((InfoQuery)packet).getType().equals((Object)Packet.ERROR))) {
            return true;
        }
        if (packet instanceof Presence && (Presence.SUBSCRIBE.equals((Object)packet.getType()) || Presence.SUBSCRIBED.equals((Object)packet.getType()) || Presence.UNSUBSCRIBE.equals((Object)packet.getType()) || Presence.UNSUBSCRIBED.equals((Object)packet.getType()))) {
            return true;
        }
        JID subject = in ? packet.getFrom() : packet.getTo();
        if (subject == null) {
            return true;
        }
        subject = subject.toBareJID();
        PrivacyItem relevant = null;
        boolean allow = true;
        if (pl == null) {
            Log.debug("PrivacyHandler#evaluate [ " + u.getUID() + " ]: Privacy list is null");
        }
        if ((l = pl.listItems()) == null) {
            return true;
        }
        Iterator i2 = l.iterator();
        while (i2.hasNext()) {
            StreamElement rosterItem;
            PrivacyItem item = (PrivacyItem)i2.next();
            if (relevant != null && item.getOrder() >= relevant.getOrder()) continue;
            PrivacyItem.Type type = item.getType();
            boolean itemMatched = false;
            boolean resourceMatched = PrivacyHandler.isResourceMatch(item, packet, in);
            if (!resourceMatched) continue;
            if (type == null) {
                itemMatched = true;
            } else if (type.equals((Object)PrivacyItem.JID)) {
                JID pattern = item.getJIDValue();
                Log.debug("PATTERN : " + pattern + " SUBJECT: " + subject);
                itemMatched = pattern == null ? true : (pattern.getNode() != null && pattern.getNode().length() > 0 ? (pattern.getResource() != null ? pattern.equals(subject) : pattern.equals(subject.toBareJID())) : (pattern.getResource() != null ? PrivacyHandler.checkLDAPGroup(pattern, subject, u) : pattern.getDomain().equals(subject.getDomain())));
            } else if (type.equals((Object)PrivacyItem.GROUP)) {
                rosterItem = u.getRosterItem(subject.toString());
                String pattern = item.getGroupValue();
                if (pattern != null && rosterItem != null && RosterHandler.hasGroup(rosterItem, pattern)) {
                    itemMatched = true;
                }
            } else if (type.equals((Object)PrivacyItem.SUBSCRIPTION)) {
                rosterItem = u.getRosterItem(subject.toString());
                RosterItem.SubscriptionType subType = item.getSubscriptionValue();
                if (rosterItem != null) {
                    if (subType.toString().equals(rosterItem.getAttributeValue("subscription"))) {
                        itemMatched = true;
                    }
                    if ((RosterItem.TO.equals((Object)subType) || RosterItem.FROM.equals((Object)subType)) && RosterItem.BOTH.toString().equals(rosterItem.getAttributeValue("subscription"))) {
                        itemMatched = true;
                    }
                }
            }
            if (!itemMatched) continue;
            relevant = item;
            allow = !item.getAction().equals((Object)PrivacyItem.DENY);
        }
        Log.debug("PrivacyHandler#evaluate [" + u.getUID() + "]  Returning allow " + allow);
        return allow;
    }

    protected static PrivacyQuery buildQuery(String xml, StreamEndPoint session) throws SAXException, IOException, ParserConfigurationException {
        PrivacyQuery privacy = (PrivacyQuery)session.getDataFactory().createExtensionNode(QUERY_NSI, PrivacyQuery.class);
        StreamElement x = session.importElement(PrivacyHandler.parseXML(xml));
        Iterator l = x.listElements().iterator();
        while (l.hasNext()) {
            StreamElement list = (StreamElement)l.next();
            List items = list.listElements();
            if (list.getLocalName().equals("default")) {
                privacy.setDefault(list.getAttributeValue("name"));
                continue;
            }
            PrivacyList pl = privacy.addPrivacyList(list.getAttributeValue("name"));
            Iterator i = list.listElements().iterator();
            while (i.hasNext()) {
                StreamElement item = (StreamElement)i.next();
                PrivacyItem pi = PrivacyItem.DENY.equals((Object)item.getAttributeValue("action")) ? pl.addItem(PrivacyItem.DENY) : pl.addItem(PrivacyItem.ALLOW);
                pi.setOrder(Integer.parseInt(item.getAttributeValue("order")));
                String sType = item.getAttributeValue("type");
                if (PrivacyItem.JID.equals((Object)sType)) {
                    pi.setType(PrivacyItem.JID);
                } else if (PrivacyItem.GROUP.equals((Object)sType)) {
                    pi.setType(PrivacyItem.GROUP);
                } else if (PrivacyItem.SUBSCRIPTION.equals((Object)sType)) {
                    pi.setType(PrivacyItem.SUBSCRIPTION);
                }
                pi.setValue(item.getAttributeValue("value"));
                boolean granular = false;
                pi.setAppliedToPresenceIn(false);
                pi.setAppliedToPresenceOut(false);
                pi.setAppliedToMessage(false);
                pi.setAppliedToIQ(false);
                if (!item.listElements("presence-in").isEmpty()) {
                    pi.setAppliedToPresenceIn(true);
                    granular = true;
                }
                if (!item.listElements("presence-out").isEmpty()) {
                    pi.setAppliedToPresenceOut(true);
                    granular = true;
                }
                if (!item.listElements("message").isEmpty()) {
                    pi.setAppliedToMessage(true);
                    granular = true;
                }
                if (!item.listElements("iq").isEmpty()) {
                    pi.setAppliedToIQ(true);
                    granular = true;
                }
                if (granular) continue;
                pi.setAppliedToPresenceIn(true);
                pi.setAppliedToPresenceOut(true);
                pi.setAppliedToMessage(true);
                pi.setAppliedToIQ(true);
            }
        }
        return privacy;
    }

    private static boolean isResourceMatch(PrivacyItem item, Packet packet, boolean in) {
        boolean resourceMatched = false;
        if (!(item.isAppliedToMessage() || item.isAppliedToIQ() || item.isAppliedToPresenceIn() || item.isAppliedToPresenceOut())) {
            resourceMatched = true;
        } else if (packet instanceof Message && item.isAppliedToMessage()) {
            resourceMatched = true;
        } else if (packet instanceof InfoQuery && item.isAppliedToIQ()) {
            resourceMatched = true;
        } else if (packet instanceof Presence) {
            if (in) {
                if (item.isAppliedToPresenceIn()) {
                    resourceMatched = true;
                }
            } else if (item.isAppliedToPresenceOut()) {
                resourceMatched = true;
            }
        }
        return resourceMatched;
    }

    private static boolean checkLDAPGroup(JID jid, JID subject, LocalUser u) {
        String dn = JIDUtil.decodedResource((JID)jid);
        Log.debug("[PrivateHandler] checkLDAPGroup dn: " + dn);
        NMSGroup group = null;
        try {
            group = RealmManager.getGroup(u, dn, false);
            if (group == null) {
                return jid.equals(subject);
            }
            return group.hasMember(new IMPrincipal(subject.getNode(), subject.getDomain()));
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                getTranFactory = monitor.getTransactionFactory("privacy-get");
                setTranFactory = monitor.getTransactionFactory("privacy-set");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

