/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.GatewayedEndPoint;
import com.iplanet.im.server.GroupChat;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NewsChannel;
import com.iplanet.im.server.NewsHandler;
import com.iplanet.im.server.PrivacyHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.RemoteUser;
import com.iplanet.im.server.RosterHandler;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.ServerSession;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPComponent;
import com.sun.im.provider.RealmException;
import com.sun.im.service.util.StringUtility;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.x.core.RosterItem;
import org.xml.sax.SAXException;

public class PresenceHandler
extends AbstractHandler {
    private RosterHandler rosterHandler;
    private NewsHandler newsHandler;
    static NSI NAME = new NSI("presence", null);
    private static String autoSubscribeName = "iim_server.autosubscribe";
    private boolean bAutoSubscribe = false;
    static MonitorTransactionFactory updateTranFactory = null;
    static MonitorTransactionFactory subscribeTranFactory = null;
    static MonitorTransactionFactory authorizeTranFactory = null;
    static MonitorTransactionFactory unsuTranFactory = null;
    static MonitorTransactionFactory probeTranFactory = null;

    public PresenceHandler(RosterHandler rosterHandler, NewsHandler newsHandler) {
        this.rosterHandler = rosterHandler;
        this.newsHandler = newsHandler;
        ServerConfig sc = ServerConfig.getServerConfig();
        this.bAutoSubscribe = StringUtility.getBoolean((String)sc.getSetting(autoSubscribeName, "false"), (boolean)false);
    }

    protected void update(StreamEndPoint session, Packet packet, ClientPacketDispatcher dispatcher) {
        MonitorTransaction transaction = null;
        if (updateTranFactory != null) {
            transaction = updateTranFactory.startTransaction();
        }
        if (packet.getFrom() == null) {
            packet.setFrom(session.getJID());
        }
        if (packet.getTo() != null) {
            try {
                StreamEndPoint ep;
                BaseUser bu = this.getUser(packet.getTo());
                if (bu != null && (ep = bu.getSession(packet.getTo().getResource())) != null) {
                    if (Presence.UNAVAILABLE.equals((Object)packet.getType())) {
                        session.removeStranger(ep);
                    } else {
                        session.addStranger(ep);
                    }
                    Packet p = ep.duplicate(packet);
                    if (p != null) {
                        ep.send(p, transaction);
                        return;
                    }
                }
            }
            catch (RealmException re) {
                Log.printStackTrace((Exception)((Object)re));
            }
        }
        if (session.getUser() instanceof LocalUser) {
            this.updateLocal(session, packet, (LocalUser)session.getUser(), dispatcher);
        } else {
            Log.debug("[Presence] received update from remote user: " + packet + " current presence=" + session.getPresence());
            try {
                if (this.isFirstAvailablePresence(session, packet)) {
                    Log.debug("[Presence] received first available presence from remote user: ");
                    session.getUser().reloadLatentListeners(session);
                }
                session.updatePresence(packet);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        if (transaction != null) {
            transaction.stop(true);
        }
    }

    private boolean isFirstAvailablePresence(StreamEndPoint session, Packet packet) {
        if ((session.getPresence() == null || Presence.UNAVAILABLE.equals((Object)session.getPresence().getType())) && !Presence.UNAVAILABLE.equals((Object)packet.getType())) {
            Log.debug("[Presence] first available presence for " + session.getJID());
            return true;
        }
        return false;
    }

    private boolean isFirstUnavailablePresence(StreamEndPoint session, Packet packet) {
        return session.getPresence() != null && !Presence.UNAVAILABLE.equals((Object)session.getPresence().getType()) && Presence.UNAVAILABLE.equals((Object)packet.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLocal(StreamEndPoint session, Packet packet, LocalUser user, ClientPacketDispatcher dispatcher) {
        PacketError.Type errorType;
        String errorText;
        block23: {
            errorText = null;
            errorType = null;
            Log.debug("[Presence] received update: " + packet);
            if (!session.validate(packet)) {
                return;
            }
            if (!IMPolicyManager.canPublishPresence(user)) {
                session.sendError(packet, PacketError.CANCEL, "not-allowed", "not authorized to publish presence");
                return;
            }
            try {
                boolean firstAvailablePresence = this.isFirstAvailablePresence(session, packet);
                boolean firstUnavailablePresence = this.isFirstUnavailablePresence(session, packet);
                session.updatePresence(packet);
                if (firstAvailablePresence) {
                    boolean mustSendRoster = true;
                    if (session instanceof ClientSession || session instanceof GatewayedEndPoint && user instanceof LocalUser) {
                        mustSendRoster = session.rosterRequested();
                        Log.debug("[Presence] mustSendRoster=" + mustSendRoster);
                    }
                    StreamElement roster = user.getRoster(session, false);
                    user.releaseRoster();
                    StreamElement newsRoster2 = this.rosterHandler.getNewsRoster(session.getUser(), session);
                    if (roster != null) {
                        LinkedList<S2SSession> remoteServers = new LinkedList<S2SSession>();
                        Iterator i = roster.listElements().iterator();
                        while (i.hasNext()) {
                            StreamElement e = (StreamElement)i.next();
                            String uid = e.getAttributeValue("jid");
                            String subs = e.getAttributeValue("subscription");
                            if (subs == null) continue;
                            try {
                                S2SSession rs;
                                JID jid = new JID(uid);
                                if (XMPPComponent.get(jid) != null) continue;
                                BaseUser u = this.getUser(jid);
                                if (u instanceof RemoteUser && !remoteServers.contains(rs = ((RemoteUser)u).getHomeServer())) {
                                    remoteServers.add(rs);
                                }
                                if (u != null) {
                                    if (u.getSession() instanceof GatewayedEndPoint && !(u instanceof LocalUser)) continue;
                                    Log.debug("[Presence] activating roster entry: " + u.getUID());
                                    if ((RosterItem.BOTH.equals((Object)subs) || RosterItem.TO.equals((Object)subs)) && mustSendRoster) {
                                        u.addListener(session);
                                    }
                                    if (!RosterItem.FROM.equals((Object)subs) && !RosterItem.BOTH.equals((Object)subs) || !(u instanceof LocalUser)) continue;
                                    Iterator iter = u.availableSessionsIterator();
                                    while (iter.hasNext()) {
                                        session.getUser().addListener((EndPointListener)iter.next());
                                    }
                                    continue;
                                }
                                Log.debug("[Presence] cannot locate jid: " + uid);
                            }
                            catch (Exception re) {
                                Log.printStackTrace(re);
                            }
                        }
                        Iterator iter = remoteServers.iterator();
                        while (iter.hasNext()) {
                            S2SSession s2s = (S2SSession)iter.next();
                            s2s.send(session, packet);
                            session.getUser().addListener(s2s);
                        }
                    }
                    user.addListener(session);
                    if (newsRoster2 != null) {
                        this.addRemoveListenerNewsChannel(newsRoster2, session, true);
                    }
                    user.sendOfflinePackets();
                    break block23;
                }
                if (!firstUnavailablePresence) break block23;
                Log.debug("[Presence] first unavailable presence received");
                StreamElement roster = user.getRoster(session, false);
                user.releaseRoster();
                StreamElement newsRoster = this.rosterHandler.getNewsRoster(session.getUser(), session);
                session.clearSubscribedUsers();
                session.removeStrangers(packet);
                user.removeListener(session);
                if (session instanceof GatewayedEndPoint) {
                    LocalUser newsRoster2 = user;
                    synchronized (newsRoster2) {
                        if (user != null) {
                            Log.debug("Remove the resource as it is no longer active");
                            user.removeSession(session);
                            session.setUser(null);
                        }
                    }
                }
                Iterator i = session.clearGroupChats().iterator();
                while (i.hasNext()) {
                    GroupChat gc = (GroupChat)i.next();
                    Presence p = (Presence)session.getDataFactory().createPacketNode(NAME, class$org$jabberstudio$jso$Presence == null ? PresenceHandler.class$("org.jabberstudio.jso.Presence") : class$org$jabberstudio$jso$Presence);
                    p.setType((Packet.Type)Presence.UNAVAILABLE);
                    p.setFrom(session.getJID());
                    p.setTo(gc.getInRoomJID(session.getJID()));
                    gc.removeMember(session, packet, null, false);
                }
                this.addRemoveListenerNewsChannel(newsRoster, session, false);
            }
            catch (Exception se) {
                Log.printStackTrace(se);
                errorText = se.toString();
                errorType = PacketError.CANCEL;
            }
        }
        if (errorType != null) {
            session.sendError(packet, errorType, "internal-server-error", errorText);
        }
    }

    public void sendInitialSubscriptions(StreamEndPoint session, LocalUser user, String domain, JID from) throws Exception {
        StreamDataFactory sdf = session.getDataFactory();
        StreamElement roster = user.getRoster(session, false);
        user.releaseRoster();
        if (roster != null) {
            Iterator i = roster.listElements().iterator();
            while (i.hasNext()) {
                StreamElement e = (StreamElement)i.next();
                String sJID = e.getAttributeValue("jid");
                JID jid = null;
                if (sJID != null) {
                    jid = new JID(sJID);
                }
                String subs = e.getAttributeValue("subscription");
                if (jid == null || !domain.equalsIgnoreCase(jid.getDomain()) || subs == null || !RosterItem.BOTH.equals((Object)subs) && !RosterItem.TO.equals((Object)subs)) continue;
                Presence p = (Presence)sdf.createPacketNode(NAME, class$org$jabberstudio$jso$Presence == null ? PresenceHandler.class$("org.jabberstudio.jso.Presence") : class$org$jabberstudio$jso$Presence);
                p.setType((Packet.Type)Presence.SUBSCRIBE);
                p.setTo(jid);
                p.setFrom(from);
                session.send((Packet)p);
            }
        }
    }

    static Presence getUnavailable(JID from) {
        Presence p = (Presence)NMS.jso.getDataFactory().createPacketNode(NAME, Presence.class);
        p.setFrom(from);
        p.setType((Packet.Type)Presence.UNAVAILABLE);
        return p;
    }

    static void sendPresence(StreamEndPoint session, BaseUser u) throws StreamException {
        Iterator sessions = u.availableSessionsIterator();
        StreamDataFactory sdf = session.getDataFactory();
        if (!sessions.hasNext()) {
            Presence newp = (Presence)sdf.createPacketNode(NAME, Presence.class);
            newp.setType((Packet.Type)Presence.UNAVAILABLE);
            newp.setTo(session.getJID());
            newp.setFrom(u.getJID());
            Log.debug("[Presence] relaying presence from " + u.getJID() + " to " + session.getJID());
            session.send((Packet)newp);
            return;
        }
        while (sessions.hasNext()) {
            Presence newp;
            StreamEndPoint ep = (StreamEndPoint)sessions.next();
            Presence p = ep.getPresence();
            if (p != null) {
                newp = (Presence)p.clone();
            } else {
                newp = (Presence)sdf.createPacketNode(NAME, class$org$jabberstudio$jso$Presence == null ? PresenceHandler.class$("org.jabberstudio.jso.Presence") : class$org$jabberstudio$jso$Presence);
                newp.setType((Packet.Type)Presence.UNAVAILABLE);
            }
            newp.setTo(session.getJID());
            newp.setFrom(ep.getJID());
            if (u instanceof LocalUser && !PrivacyHandler.evaluate((Packet)newp, (LocalUser)u, ep.getActivePrivacyList(), false)) {
                Log.debug("[PresenceHandler#updatePresence:" + u.getJID() + " ] privacy enforced");
                return;
            }
            Log.debug("[Presence] relaying from " + u.getJID() + " to " + session.getJID());
            session.send((Packet)newp);
        }
    }

    protected void autoSubscribed(StreamEndPoint session, JID subscriberJID, JID contactJID, BaseUser subscriber, BaseUser contact) throws Exception {
        if (subscriber instanceof LocalUser) {
            LocalUser lu = (LocalUser)subscriber;
            lu.getRoster(session, true);
            if (lu.getRosterItem(contact.getUID()) == null) {
                RosterItem item = (RosterItem)session.getDataFactory().createElementNode(RosterHandler.ITEM_NAME, RosterItem.class);
                item.setAttributeValue("jid", contact.getUID());
                item.setDisplayName(contact.getDisplayName());
                item.setSubscription(RosterItem.NONE);
                ((LocalUser)subscriber).addRosterItem(contact.getUID(), (StreamElement)item);
                lu.saveRoster();
            } else {
                lu.releaseRoster();
            }
        }
        Presence fake = (Presence)session.getDataFactory().createPacketNode(NAME, Presence.class);
        fake.setTo(subscriberJID);
        fake.setFrom(this.getID(contactJID));
        fake.setType((Packet.Type)Presence.SUBSCRIBED);
        this.subscribedInternal(session, contact, subscriber, (Packet)fake);
    }

    protected void subscribe(StreamEndPoint session, Packet packet) {
        Log.debug("[Presence] subscribe received: " + packet);
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (subscribeTranFactory != null) {
            transaction = subscribeTranFactory.startTransaction();
        }
        String errorText = null;
        String errorCondition = "internal-server-error";
        PacketError.Type errorType = null;
        try {
            StreamDataFactory sdf = session.getDataFactory();
            String contactUID = this.getID(packet.getTo()).toString();
            LocalUser u = RealmManager.getUser(contactUID);
            if (u instanceof LocalUser) {
                JID senderJID = this.getID(session.getJID());
                LocalUser sender = RealmManager.getUser(senderJID.toString());
                Log.debug("[PresenceHandler] Sender is " + senderJID.toString());
                if ((this.bAutoSubscribe || !IMPolicyManager.canManageRoster(u)) && session.getJID().getDomain().equalsIgnoreCase(u.getDomainName())) {
                    this.autoSubscribed(session, session.getJID(), packet.getTo(), session.getUser(), u);
                } else if (this.rosterHandler.ask(session, u, packet)) {
                    if (sender != null && !IMPolicyManager.canWatch(sender)) {
                        errorType = PacketError.AUTH;
                        errorCondition = "not-authorized";
                        errorText = "You are not authorized to access Presence information of other users";
                    } else {
                        packet.setFrom(this.getID(senderJID));
                        Log.debug("[Presence] relaying subscription from " + this.getID(session.getJID()) + " to " + u.getUID());
                        u.broadcast(packet, session.getUser());
                    }
                } else {
                    packet.setTo(session.getJID());
                    packet.setFrom(u.getJID());
                    packet.setType((Packet.Type)Presence.SUBSCRIBED);
                    session.send(packet);
                    this.clearStoredSubscription(u, session.getJID());
                    if (!u.addListener(session)) {
                        PresenceHandler.sendPresence(session, u);
                    }
                }
            } else {
                errorType = PacketError.MODIFY;
                errorCondition = "item-not-found";
                errorText = contactUID + " not found";
            }
        }
        catch (RealmException re) {
            errorText = re.getMessage();
            errorType = PacketError.CANCEL;
            errorCondition = "item-not-found";
            Log.printStackTrace((Exception)((Object)re));
        }
        catch (StreamException se) {
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (Exception e) {
            errorText = e.getMessage();
            errorType = PacketError.CANCEL;
            Log.printStackTrace(e);
        }
        if (errorType != null) {
            session.sendError(packet, errorType, errorCondition, errorText);
            if (transaction != null) {
                transaction.stop(false);
            }
        } else if (transaction != null) {
            transaction.stop(true);
        }
    }

    protected void subscribed(StreamEndPoint session, Packet packet) {
        Log.debug("[Presence] subscribed received: " + packet);
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (authorizeTranFactory != null) {
            transaction = authorizeTranFactory.startTransaction();
        }
        try {
            String watcherUID = this.getID(packet.getTo()).toString();
            LocalUser u = RealmManager.getUser(watcherUID);
            if (u != null) {
                packet.setFrom(session.getUser().getJID());
                this.subscribedInternal(session, session.getUser(), u, packet);
                if (transaction != null) {
                    transaction.stop(true);
                }
            } else {
                session.sendError(packet, PacketError.MODIFY, "item-not-found", watcherUID + " not found.", transaction);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.MODIFY, "internal-server-error", e.toString(), transaction);
        }
    }

    protected void subscribedRemote(StreamEndPoint session, Packet packet, RemoteSession rs) {
        Log.debug("[Presence] subscribed received: " + packet);
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (authorizeTranFactory != null) {
            transaction = authorizeTranFactory.startTransaction();
        }
        try {
            StreamEndPoint ep = rs.getEndPoint(packet.getTo());
            if (ep != null) {
                this.subscribedInternal(session, session.getUser(), ep.getUser(), packet);
                if (transaction != null) {
                    transaction.stop(true);
                }
            } else {
                session.sendError(packet, PacketError.MODIFY, "item-not-found", packet.getTo() + " not found.", transaction);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.MODIFY, "internal-server-error", e.toString(), transaction);
        }
    }

    private void clearStoredSubscription(BaseUser u, JID from) {
        if (u instanceof LocalUser) {
            ((LocalUser)u).deleteStoredSubscription(from);
        }
    }

    private void subscribedInternal(StreamEndPoint session, BaseUser contact, BaseUser subscriber, Packet packet) throws Exception {
        this.clearStoredSubscription(contact, subscriber.getJID());
        subscriber.broadcast(packet);
        this.rosterHandler.updateSubscription(this.getID(packet.getTo()), this.getID(packet.getFrom()), session, true);
        Iterator i = subscriber.sessionsIterator();
        while (i.hasNext()) {
            StreamEndPoint ep = (StreamEndPoint)i.next();
            contact.addListener(ep);
        }
    }

    protected void unsubscribe(StreamEndPoint session, Packet packet) {
        block7: {
            if (!session.validate(packet)) {
                return;
            }
            Log.debug("[Presence] unsubscribe received: " + packet);
            MonitorTransaction transaction = null;
            if (unsuTranFactory != null) {
                transaction = unsuTranFactory.startTransaction();
            }
            try {
                StreamDataFactory sdf = session.getDataFactory();
                this.rosterHandler.updateSubscription(this.getID(packet.getFrom()), this.getID(packet.getTo()), session, false);
                String uid = this.getID(packet.getTo()).toString();
                LocalUser u = RealmManager.getUser(uid);
                if (u != null) {
                    u.broadcast(packet, session.getUser());
                    Presence p = (Presence)sdf.createPacketNode(NAME, Presence.class);
                    p.setTo(session.getJID());
                    p.setFrom(this.getID(packet.getTo()));
                    p.setType((Packet.Type)Presence.UNSUBSCRIBED);
                    session.getUser().broadcast((Packet)p);
                    this.clearStoredSubscription(u, session.getJID());
                    Iterator iter = session.getUser().availableSessionsIterator();
                    while (iter.hasNext()) {
                        u.removeListener((StreamEndPoint)iter.next());
                    }
                }
                if (transaction != null) {
                    transaction.stop(true);
                }
            }
            catch (Exception e) {
                if (transaction == null) break block7;
                transaction.stop(false);
            }
        }
    }

    protected void unsubscribed(StreamEndPoint session, Packet packet) {
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (authorizeTranFactory != null) {
            transaction = authorizeTranFactory.startTransaction();
        }
        Log.debug("[Presence] unsubscribed received: " + packet);
        try {
            String subscriberUID = this.getID(packet.getTo()).toString();
            LocalUser u = RealmManager.getUser(subscriberUID);
            if (u != null) {
                this.unsubscribedInternal(session, packet, u);
                if (transaction != null) {
                    transaction.stop(true);
                }
            } else {
                session.sendError(packet, PacketError.MODIFY, "item-not-found", subscriberUID + " not found.", transaction);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    protected void unsubscribedInternal(StreamEndPoint session, Packet packet, BaseUser subscriber) throws StreamException, SAXException, IOException, ParserConfigurationException, Exception {
        StreamDataFactory sdf = session.getDataFactory();
        subscriber.broadcast(packet);
        this.rosterHandler.updateSubscription(this.getID(packet.getTo()), this.getID(packet.getFrom()), session, false);
        Iterator iter = subscriber.sessionsIterator();
        while (iter.hasNext()) {
            session.getUser().removeListener((EndPointListener)iter.next());
        }
    }

    protected void unsubscribedRemote(StreamEndPoint session, Packet packet, RemoteSession rs) {
        block7: {
            if (!session.validate(packet)) {
                return;
            }
            Log.debug("[Presence] unsubscribed received: " + packet);
            MonitorTransaction transaction = null;
            if (authorizeTranFactory != null) {
                transaction = authorizeTranFactory.startTransaction();
            }
            try {
                StreamEndPoint ep = rs.getEndPoint(packet.getTo());
                if (ep != null) {
                    this.unsubscribedInternal(session, packet, ep.getUser());
                    if (transaction != null) {
                        transaction.stop(true);
                    }
                } else {
                    session.sendError(packet, PacketError.MODIFY, "item-not-found", packet.getTo() + " not found.", transaction);
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                if (transaction == null) break block7;
                transaction.stop(false);
            }
        }
    }

    protected void probe(StreamEndPoint session, Packet packet) {
        if (!session.validate(packet)) {
            return;
        }
        Log.debug("[Presence] probe received: " + packet);
        MonitorTransaction transaction = null;
        if (probeTranFactory != null) {
            transaction = probeTranFactory.startTransaction();
        }
        StreamDataFactory sdf = session.getDataFactory();
        boolean okToDisclose = true;
        try {
            String uid = this.getID(packet.getTo()).toString();
            LocalUser u = RealmManager.getUser(uid);
            if (u == null) {
                session.sendError(packet, PacketError.MODIFY, "item-not-found", uid + " not found.");
                if (transaction != null) {
                    transaction.stop(false);
                }
                return;
            }
            Presence p = null;
            StreamEndPoint ep = u.getSession(packet.getTo().getResource());
            if (ep != null && ep.getPresence() != null) {
                p = (Presence)ep.getPresence().copy();
                p.setFrom(ep.getJID());
            }
            if (!(p == null || session instanceof ServerSession && ((ServerSession)session).isAServer())) {
                if (ep != null && !PrivacyHandler.evaluate((Packet)p, u, ep.getActivePrivacyList(), false)) {
                    Log.debug("[PresenceHandler#updatePresence:" + u.getJID() + " ] privacy enforced");
                    okToDisclose = false;
                }
                if (!this.bAutoSubscribe && okToDisclose) {
                    StreamElement item = ((LocalUser)session.getUser()).getRosterItem(u.getUID());
                    if (item != null) {
                        String subs = item.getAttributeValue("subscription");
                        if (!RosterItem.BOTH.equals((Object)subs) && !RosterItem.TO.equals((Object)subs)) {
                            okToDisclose = false;
                        }
                    } else {
                        okToDisclose = false;
                    }
                }
            }
            if (p == null) {
                p = (Presence)sdf.createPacketNode(NAME, Presence.class);
                p.setFrom(u.getJID());
                p.setType((Packet.Type)Presence.UNAVAILABLE);
            } else if (!okToDisclose) {
                p.setFrom(u.getJID());
                p.setType((Packet.Type)Presence.UNAVAILABLE);
                p.setShow(null);
                p.setStatus(null);
                p.clearElements();
            }
            p.setID(packet.getID());
            p.setTo(session.getJID());
            session.send((Packet)p, transaction);
            if (transaction != null) {
                transaction.stop(true);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            if (transaction != null) {
                transaction.stop(false);
            }
            session.sendError(packet, PacketError.MODIFY, "internal-server-error", e.getMessage());
        }
    }

    private JID getID(JID jid) {
        if (jid == null) {
            return null;
        }
        if (jid.hasNode()) {
            return jid.toBareJID();
        }
        return jid;
    }

    private void addRemoveListenerNewsChannel(StreamElement newsRoster, StreamEndPoint session, boolean add) throws Exception {
        if (newsRoster == null) {
            return;
        }
        StreamElement affiliationsElem = newsRoster.getFirstElement("affiliations");
        String domain = session.getJID().getDomain();
        Iterator i = affiliationsElem.listElements("entity").iterator();
        while (i.hasNext()) {
            StreamElement e = (StreamElement)i.next();
            String nodeName = e.getAttributeValue("node");
            if (!e.getAttributeValue("subscription").equals("subscribed")) continue;
            String nodeId = NewsHandler.encode(nodeName, domain);
            NewsChannel nc = this.newsHandler.getNewsChannel(session, nodeId);
            if (nc != null) {
                Log.debug("Activating news subscription:[" + session.getJID() + "] to " + nodeId);
                if (add) {
                    nc.addListener(session);
                    continue;
                }
                nc.removeListener(session);
                continue;
            }
            Log.debug("[NewsChannel: " + nodeId + "] does not exist or is not loaded during server initialization");
            Log.debug("[NewsChannel: " + nodeId + "] " + session.getJID() + " unable to subscribe");
        }
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                updateTranFactory = monitor.getTransactionFactory("presence");
                probeTranFactory = monitor.getTransactionFactory("presence-probe");
                subscribeTranFactory = monitor.getTransactionFactory("presence-subscribe");
                authorizeTranFactory = monitor.getTransactionFactory("presence-authorize");
                unsuTranFactory = monitor.getTransactionFactory("presence-unsubscribe");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

