/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.FileGroupChatStorage;
import com.iplanet.im.server.FileNewsStorage;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.SearchReply;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.server.util.WildCardPattern;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.provider.NewsStorageProvider;
import com.sun.im.provider.PolicyProvider;
import com.sun.im.provider.Realm;
import com.sun.im.provider.RealmException;
import com.sun.im.provider.RealmSearchResults;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PasswordFileRealm
implements Realm {
    static final String PASSWORD_PROP = "userPassword";
    private static final String userFileName = "passwd";
    private static final String groupFileName = "group";
    private Hashtable groupHT = null;
    private Hashtable userHT = null;
    private Hashtable passwordHT = null;
    long um;
    long gm;
    private boolean mod = false;
    private static PolicyProvider _policyProvider = null;

    public void stop() {
    }

    public void resync() {
        try {
            this.passwordHT = new Hashtable();
            this.userHT = new Hashtable();
            this.groupHT = new Hashtable();
            this.readIn();
        }
        catch (Exception e) {
            Log.error("[PasswordFile] Reload password files failed " + e);
        }
    }

    public CollaborationPrincipal[] expandGroup(CollaborationPrincipal principal, CollaborationGroup nlg) throws RealmException {
        NMSGroup g = this.getGroup(nlg.getName());
        if (g != null) {
            return g.getMembers();
        }
        throw new RealmException("[PasswordFile] " + nlg.getUID() + " not found.");
    }

    public CollaborationGroup getGroup(String dn, String domainName) {
        return null;
    }

    public CollaborationGroup getGroup(CollaborationPrincipal principal, String uid) throws RealmException {
        return this.getGroup(uid);
    }

    public CollaborationPrincipal getPrincipal(CollaborationPrincipal principal, String uid) throws RealmException {
        return this.getPrincipal(principal.getDomainName(), uid);
    }

    public CollaborationPrincipal getPrincipal(String searchBase, String uid) throws RealmException {
        return this.getUser(StringUtility.getLocalPartFromAddress((String)uid));
    }

    public CollaborationPrincipal authenticate(String name, String possiblePass) throws RealmException {
        try {
            LocalUser u = this.getUser(name);
            if (u == null) {
                throw new RealmException("[PasswordFile] " + name + " not found.");
            }
            String realPass = this.getPassword(name);
            if (realPass.equals(possiblePass)) {
                Log.debug("[PasswordFile] authenticated " + name + " using password file");
                u.setProperty(PASSWORD_PROP, realPass);
                return u;
            }
            Log.info("[PasswordFile] authentication failed for " + name);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.error("[PasswordFile] error while authenticating " + name + " : " + e.toString());
        }
        return null;
    }

    private List _searchPrincipals(String pattern, Map principals, boolean byid) {
        LinkedList<IMPrincipal> found = new LinkedList<IMPrincipal>();
        WildCardPattern wcp = new WildCardPattern(pattern);
        Iterator i = principals.values().iterator();
        while (i.hasNext()) {
            IMPrincipal p = (IMPrincipal)i.next();
            if (!byid) {
                if (!wcp.matchIgnoreCase(p.getDisplayName())) continue;
                found.add(p);
                continue;
            }
            if (!wcp.matchIgnoreCase(p.getName())) continue;
            found.add(p);
        }
        return found;
    }

    public RealmSearchResults search(CollaborationPrincipal principal, String pattern, int attributeType, String filter) {
        boolean byid = attributeType == 2;
        return this.search(pattern, byid);
    }

    public RealmSearchResults search(String base, String pattern, int attributeType, String filter) {
        boolean byid = attributeType == 2;
        return this.search(pattern, byid);
    }

    public RealmSearchResults search(String filter, String base) {
        return this.search(filter, false);
    }

    private RealmSearchResults search(String pattern, boolean byid) {
        if (this.userHT == null) {
            this.resync();
        }
        List v = this._searchPrincipals(pattern, this.userHT, byid);
        v.addAll(this._searchPrincipals(pattern, this.groupHT, byid));
        IMPrincipal[] p = new IMPrincipal[v.size()];
        int i = 0;
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            p[i++] = (IMPrincipal)iter.next();
        }
        return new SearchReply(2, p);
    }

    private void readIn() throws RealmException, FileNotFoundException, IOException {
        String line;
        File gf;
        if (this.mod) {
            return;
        }
        File uf = new File(NMS.getConfigDir(), userFileName);
        if (!uf.exists()) {
            uf.createNewFile();
        }
        if (!(gf = new File(NMS.getConfigDir(), groupFileName)).exists()) {
            gf.createNewFile();
        }
        long newum = uf.lastModified();
        long newgm = gf.lastModified();
        if (newum <= this.um && newgm <= this.gm) {
            return;
        }
        this.um = newum;
        this.gm = newgm;
        this.userHT.clear();
        this.groupHT.clear();
        BufferedReader d = new BufferedReader(new FileReader(gf));
        while ((line = d.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            StringTokenizer st = new StringTokenizer(line, ":");
            if (!st.hasMoreTokens()) {
                throw new RealmException("[PasswordFile] Bad format: " + line);
            }
            String uid = st.nextToken();
            uid = uid.trim();
            int n = uid.indexOf(64);
            if (n != -1) {
                throw new RealmException("@ is not allowed in group uid " + uid);
            }
            if (!st.hasMoreTokens()) {
                throw new RealmException("[PasswordFile] Bad format: " + line);
            }
            String displayname = st.nextToken();
            displayname = displayname.trim();
            NMSGroup g = new NMSGroup(uid, NMS.getName(), displayname);
            this.groupHT.put(uid, g);
        }
        d.close();
        d = new BufferedReader(new FileReader(uf));
        while ((line = d.readLine()) != null) {
            if ((line = line.trim()).equals("")) continue;
            int lineIndex = 0;
            int findIndex = line.indexOf(":", lineIndex);
            if (findIndex == -1) {
                throw new RealmException("[PasswordFile] Bad format: " + line);
            }
            String user = line.substring(lineIndex, findIndex);
            lineIndex = findIndex + 1;
            user = user.trim();
            int n = user.indexOf(64);
            if (n != -1) {
                throw new RealmException("@ is not allowed in user uid " + user);
            }
            findIndex = line.indexOf(":", lineIndex);
            if (findIndex == -1) {
                throw new RealmException("[PasswordFile] Bad format: " + line);
            }
            String pass = line.substring(lineIndex, findIndex);
            lineIndex = findIndex + 1;
            pass = pass.trim();
            findIndex = line.indexOf(":", lineIndex);
            if (findIndex == -1) {
                throw new RealmException("[PasswordFile] Bad format: " + line);
            }
            String displayname = line.substring(lineIndex, findIndex);
            lineIndex = findIndex + 1;
            displayname = displayname.trim();
            String g = line.substring(lineIndex, line.length());
            g = g.trim();
            LocalUser nlu = new LocalUser(user, NMS.getName(), displayname);
            StringTokenizer gst = new StringTokenizer(g, ",");
            while (gst.hasMoreElements()) {
                String groupid = gst.nextToken();
                NMSGroup ng = this.getGroup(groupid = groupid.trim());
                if (ng == null) continue;
                ng.addMember(nlu);
            }
            this.passwordHT.put(user, pass);
            this.userHT.put(user, nlu);
            Log.debug("Loaded user from password files: " + nlu.getUID());
        }
    }

    public void saveOut() {
        try {
            File f = new File(NMS.getConfigDir(), groupFileName);
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            Enumeration e = this.groupHT.elements();
            while (e.hasMoreElements()) {
                NMSGroup g = (NMSGroup)e.nextElement();
                out.println(g.getName() + ":" + g.getDisplayName());
            }
            out.close();
            f = new File(NMS.getConfigDir(), userFileName);
            out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            e = this.userHT.elements();
            while (e.hasMoreElements()) {
                LocalUser u = (LocalUser)e.nextElement();
                String pass = this.getPassword(u.getName());
                if (pass == null) {
                    pass = "";
                }
                String groupsString = "";
                NMSGroup[] g = this.getGroups();
                for (int i = 0; i < g.length; ++i) {
                    if (!g[i].hasMember(u)) continue;
                    if (!groupsString.equals("")) {
                        groupsString = groupsString + ",";
                    }
                    groupsString = groupsString + g[i].getName();
                }
                out.println(u.getName() + ":" + pass + ":" + u.getDisplayName() + ":" + groupsString);
            }
            out.close();
        }
        catch (Exception e) {
            Log.error("[PasswordFile] Save failed: " + e.toString());
        }
    }

    public boolean isMemberOfGroup(CollaborationPrincipal p, CollaborationGroup g) throws RealmException {
        return false;
    }

    public NMSGroup addGroup(String uid, String displayname) throws RealmException {
        this.mod = true;
        NMSGroup g = new NMSGroup(uid, NMS.getName(), displayname);
        this.groupHT.put(uid, g);
        return g;
    }

    public LocalUser addUser(String uid, String displayname) throws RealmException {
        if (this.userHT == null) {
            this.resync();
        }
        this.mod = true;
        LocalUser u = new LocalUser(uid, NMS.getName());
        this.userHT.put(uid, u);
        return u;
    }

    public void deleteGroup(String uid) throws RealmException {
        this.mod = true;
        this.groupHT.remove(uid);
    }

    public void deleteUser(String uid) throws RealmException {
        this.mod = true;
        NMSGroup[] ga = this.getGroups();
        for (int i = 0; i < ga.length; ++i) {
            ga[i].removeMember(uid);
        }
    }

    private NMSGroup[] getGroups() throws RealmException {
        return this._getNMSGroups();
    }

    private NMSGroup[] _getNMSGroups() {
        NMSGroup[] ret = new NMSGroup[this.groupHT.size()];
        Enumeration e = this.groupHT.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            NMSGroup g = (NMSGroup)e.nextElement();
            ret[i++] = g;
        }
        return ret;
    }

    private LocalUser getUser(String id) {
        if (this.userHT == null) {
            this.resync();
        }
        return (LocalUser)this.userHT.get(id);
    }

    private String getPassword(String id) {
        if (this.passwordHT == null) {
            this.resync();
        }
        return (String)this.passwordHT.get(id);
    }

    private NMSGroup getGroup(String id) {
        if (this.groupHT == null) {
            this.resync();
        }
        return (NMSGroup)this.groupHT.get(id);
    }

    private LocalUser[] getUsers() {
        LocalUser[] ua = new LocalUser[this.userHT.size()];
        Enumeration e = this.userHT.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            LocalUser u;
            ua[i] = u = (LocalUser)e.nextElement();
            ++i;
        }
        return ua;
    }

    public void setPassword(LocalUser u, String password) {
        this.mod = true;
        this.passwordHT.put(u.getName(), password);
    }

    public String getPassword(LocalUser u) {
        return (String)this.passwordHT.get(u.getName());
    }

    public String getSearchBase(IMPrincipal u) throws RealmException {
        return "";
    }

    public String getSearchBase(String domain) throws RealmException {
        return "";
    }

    public CollaborationPrincipal createUser(String uid, String password, Map attributes) throws RealmException {
        String displayName = (String)attributes.get("cn");
        if (displayName == null) {
            displayName = (String)attributes.get("givenname") + " " + (String)attributes.get("sn");
        }
        LocalUser nlu = new LocalUser(uid, NMS.getName(), displayName);
        this.passwordHT.put(nlu.getName(), password);
        this.userHT.put(nlu.getName(), nlu);
        this.saveOut();
        return nlu;
    }

    public void removeUser(String uid) throws RealmException {
    }

    public boolean changeUserPassword(String uid, String password) throws RealmException {
        return false;
    }

    public String getUserPassword(CollaborationPrincipal p) {
        return p.getProperty(PASSWORD_PROP);
    }

    public UserSettingsStorageProvider getUserSettingsStorageProvider() {
        return UserSettings.get();
    }

    public ConferenceStorageProvider getConferenceStorageProvider() {
        return new FileGroupChatStorage();
    }

    public NewsStorageProvider getNewsStorageProvider() {
        return new FileNewsStorage();
    }

    public PolicyProvider getPolicyProvider() {
        if (_policyProvider == null) {
            _policyProvider = new IMPolicy(false);
        }
        return _policyProvider;
    }

    public String getDomainName(String searchBase) throws RealmException {
        return "";
    }

    public boolean ignoreDomains() {
        return false;
    }
}

