/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.RealmException;
import com.sun.im.service.util.Worker;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;

public class PassThruHandler
extends AbstractHandler {
    public void process(StreamEndPoint session, Packet packet) {
        this.process(session, packet, null);
    }

    public void process(StreamEndPoint session, Packet packet, Worker w) {
        Object errorText = null;
        Object errorType = null;
        Log.debug("[PassThru] new packet received");
        if (!session.validate(packet)) {
            return;
        }
        JID to = packet.getTo();
        if (to != null && to.getNode() != null && to.getNode().length() != 0) {
            try {
                BaseUser u = this.getUser(packet.getTo().toBareJID());
                if (u != null) {
                    this.deliver(session, packet, u, w);
                }
                session.sendError(packet, PacketError.CANCEL, "item-not-found", to.toString() + " not found");
            }
            catch (RealmException re) {
                Log.printStackTrace((Exception)((Object)re));
                session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage());
                return;
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "need to specify client JID receipient for Feture Neg request");
        }
    }
}

