/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.OutConnection;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.S2SPacketDispatcher;
import com.iplanet.im.server.S2SSession;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.dialback.DialbackResult;
import org.jabberstudio.jso.dialback.DialbackUtilities;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;

class OutServerConnection
extends OutConnection
implements Runnable,
StreamStatusListener,
PacketListener,
EndPointListener {
    static final int MAX_PENDING_PACKETS = 60;
    private boolean keepalive;
    S2SSession s2s;
    private boolean _alive = false;
    private LinkedList _pendingPackets = new LinkedList();
    private StartRunnable _startRunnable = new StartRunnable();
    private ClientPacketDispatcher rq = NMS.get().getClientPacketDispatcher();

    protected OutServerConnection(S2SSession session, String host, String domain, boolean usessl, boolean keepalive) {
        super(host, domain, usessl);
        this.keepalive = keepalive;
        this.s2s = session;
        Log.debug("OutServerConnection[" + this.getJID() + "] Creating, host=" + host + " domain=" + domain);
        this.worker.addRunnable((Runnable)this._startRunnable);
    }

    public void packetTransferred(PacketEvent event) {
        Packet packet = event.getData();
        if (event.getType().equals((Object)PacketEvent.RECEIVED)) {
            Log.xfer("[" + this.getJID() + "] Received: " + packet);
            Packet.Type type = packet.getType();
            if (type == Packet.ERROR) {
                Log.debug("OutServerConnection[" + this.getJID() + "] This is an error packet");
            } else {
                if (packet instanceof DialbackResult) {
                    if (type != null) {
                        if (type.equals((Object)DialbackResult.VALID)) {
                            this.dialbackComplete = true;
                            Log.warning("OutServerConnection[" + this.getJID() + "] Dialback successful");
                            this.deliverPendingPackets();
                        } else {
                            Log.warning("OutServerConnection[" + this.getJID() + "] Received an INVALID db:result packet.  Dropping");
                            this.worker.addRunnable(new Runnable(){

                                public void run() {
                                    OutServerConnection.this.close();
                                }
                            });
                        }
                    } else {
                        Log.warning("OutServerConnection[" + this.getJID() + "] Received an initiating db:result packet.  Dropping");
                    }
                    return;
                }
                this.rq.handle(this.s2s.getEndPoint(packet.getFrom()), packet);
            }
        } else {
            Log.xfer("[" + this.getJID() + "] Sent: " + packet);
        }
    }

    void processDialbackResult(DialbackResult resPacket) {
        Packet.Type type = resPacket.getType();
        this.dialbackComplete = true;
        if (type.equals((Object)DialbackResult.VALID)) {
            Log.info("OutServerConnection[" + this.getJID() + "] dialback completed successfully");
        } else {
            Log.warning("OutServerConnection[" + this.getJID() + "] Dialback failed");
            this.close();
        }
    }

    public void run() {
        Log.debug("OutServerConnection[" + this.getJID() + "] processing.");
        this.process();
        Log.debug("OutServerConnection[" + this.getJID() + "] processed.");
    }

    void probe(JID jid) {
        Presence probe = (Presence)this.getDataFactory().createPacketNode(PresenceHandler.NAME, Presence.class);
        probe.setType((Packet.Type)Presence.PROBE);
        probe.setFrom(this.getJID());
        probe.setTo(jid);
        this.send((Packet)probe);
    }

    boolean isReady() {
        return this.dialbackComplete;
    }

    synchronized void addPendingPacket(Packet packet) {
        if (this._pendingPackets.size() < 60) {
            this._pendingPackets.add(this.duplicate(packet));
        }
        if (!this._doNotRetry && !this._alive && this._pendingPackets.size() > 0) {
            this.worker.addRunnable((Runnable)this._startRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverPendingPackets() {
        LinkedList l = null;
        OutServerConnection outServerConnection = this;
        synchronized (outServerConnection) {
            l = this._pendingPackets;
            if (l.size() == 0) {
                return;
            }
            this._pendingPackets = new LinkedList();
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            Packet packet = (Packet)i.next();
            this.send(packet);
        }
    }

    boolean sendNow(Packet packet) throws StreamException {
        boolean sent = false;
        StreamException se = null;
        if (this.dialbackComplete) {
            try {
                sent = super.sendNow(packet);
            }
            catch (StreamException e) {
                se = e;
            }
        } else {
            Log.info("OutServerConnection[" + this.getJID() + "] dialback not complete - cannot send");
        }
        if (!sent) {
            this.addPendingPacket(packet);
        }
        if (se != null) {
            throw se;
        }
        return sent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws UnknownHostException, IOException, StreamException {
        OutServerConnection outServerConnection = this;
        synchronized (outServerConnection) {
            if (this._alive) {
                Log.debug("OutServerConnection[" + this.getJID() + "] Already alive: " + this.hp);
                return;
            }
            this._alive = true;
        }
        if (this._doNotRetry) {
            this._pendingPackets.clear();
            return;
        }
        Log.debug("OutServerConnection[" + this.getJID() + "] Creating stream to " + this.hp);
        this.connect();
        this.open();
        this.s2s.setOutDialbackID(this.getStream().getInboundContext().getID());
        String key = DialbackUtilities.generateDialbackKey((String)this._streamID);
        DialbackResult p = (DialbackResult)this.getDataFactory().createPacketNode(DialbackResult.NAME);
        p.setTo(this._jid);
        p.setKey(key);
        S2SPacketDispatcher.addDialbackRequest(this.getStream().getInboundContext().getID(), p);
        p.setFrom(NMS.getJID());
        this.getStream().send((Packet)p);
        this._reissueWatches();
    }

    public void statusChanged(StreamStatusEvent event) {
        StreamContext sc = event.getContext();
        if (sc.isInbound()) {
            Log.debug("OutServerConnection[" + this.getJID() + "] inbound status changed from " + event.getPreviousStatus() + " to " + event.getNextStatus());
        } else {
            Log.debug("OutServerConnection[" + this.getJID() + "] outbound status changed from " + event.getPreviousStatus() + " to " + event.getNextStatus());
        }
        if (event.getPreviousStatus().equals((Object)Stream.OPENED) && (event.getNextStatus().equals((Object)Stream.CLOSED) || event.getNextStatus().equals((Object)Stream.DISCONNECTED))) {
            this.dialbackComplete = false;
        }
        if (this.getStream() != null && event.getNextStatus().equals((Object)Stream.DISCONNECTED)) {
            this._alive = false;
            this.close();
            if (this.keepalive) {
                new Thread(new SleepAndRetryRunnable()).start();
            }
        }
    }

    private synchronized void _reissueWatches() {
    }

    boolean validate(Packet packet) {
        JID from = packet.getFrom();
        if (from != null) {
            // empty if block
        }
        if (packet.getFrom() == null) {
            packet.setFrom(this.getJID());
        }
        return true;
    }

    class StartRunnable
    implements Runnable {
        StartRunnable() {
        }

        public void run() {
            try {
                Log.debug("OutServerConnection[" + OutServerConnection.this.getJID() + "] Staring connection");
                OutServerConnection.this.start();
            }
            catch (Exception e) {
                OutServerConnection.this._alive = false;
                Log.printStackTrace(e);
                Log.warning("OutServerConnection[" + OutServerConnection.this.getJID() + "] Failed to open stream");
            }
        }
    }

    class SleepAndRetryRunnable
    implements Runnable {
        SleepAndRetryRunnable() {
        }

        public void run() {
            while (OutServerConnection.this.running) {
                try {
                    Thread.sleep(3000L);
                    Log.debug("OutServerConnection[" + OutServerConnection.this.getJID() + "] Retrying connection");
                    OutServerConnection.this.start();
                    return;
                }
                catch (Exception e) {
                    OutServerConnection.this._alive = false;
                    Log.printStackTrace(e);
                    Log.warning("OutServerConnection[" + OutServerConnection.this.getJID() + "] Failed to open stream");
                }
            }
        }
    }
}

