/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.OutConnection;
import com.iplanet.im.server.ServerSession;
import java.io.IOException;
import java.net.UnknownHostException;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.dialback.DialbackResult;
import org.jabberstudio.jso.dialback.DialbackVerify;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;

class OutDialbackConnection
extends OutConnection
implements Runnable,
StreamStatusListener,
PacketListener,
EndPointListener {
    private String dialbackVerifyKey;
    private String _initiatingStreamID;
    boolean dialbackComplete = false;
    DialbackResult.Type dialbackResult = DialbackResult.INVALID;
    ServerSession session;

    protected OutDialbackConnection(ServerSession session, String host, String domain, boolean usessl, String verifyKey, String id) throws UnknownHostException, IOException, StreamException {
        super(host, domain, usessl);
        this.dialbackVerifyKey = verifyKey;
        this._initiatingStreamID = id;
        this.session = session;
        Log.debug("OutDialbackConnection[" + this.getJID() + "] Creating, host=" + host + " domain=" + domain);
        this.start();
    }

    public void packetTransferred(PacketEvent event) {
        Packet packet = event.getData();
        if (event.getType().equals((Object)PacketEvent.RECEIVED)) {
            Log.xfer("[" + this.getJID() + "] Received: " + packet);
            Packet.Type type = packet.getType();
            if (type == Packet.ERROR) {
                Log.debug("OutDialbackConnection[" + this.getJID() + "] This is an error packet");
            } else {
                if (packet instanceof DialbackVerify) {
                    Log.debug("OutDialbackConnection[" + this.getJID() + "] Received verify to=" + packet.getTo() + " from=" + packet.getFrom() + " id=" + packet.getID() + " type=" + type);
                    if (type != null) {
                        this.dialbackComplete = true;
                        this.session.finishDialback((DialbackVerify)packet);
                        this.worker.addRunnable(new Runnable(){

                            public void run() {
                                OutDialbackConnection.this.close();
                            }
                        });
                    } else {
                        Log.warning("OutDialbackConnection[" + this.getJID() + "] Received a dialback-verification request - dropping");
                    }
                    return;
                }
                Log.warning("OutDialbackConnection[" + this.getJID() + "] received an unexpected packet: " + packet);
            }
        } else {
            Log.xfer("[" + this.getJID() + "] Sent: " + packet);
        }
        packet.detach();
    }

    public void run() {
        this.process();
    }

    public void send(Packet packet) {
        if (this.dialbackComplete || packet instanceof DialbackResult || packet instanceof DialbackVerify) {
            try {
                this.getStream().send(packet);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        } else {
            Log.info("OutDialbackConnection[" + this.getJID() + "] dialback not complete - cannot send");
        }
    }

    private void start() throws UnknownHostException, IOException, StreamException {
        Log.debug("OutDialbackConnection[" + this.getJID() + "] Creating stream to " + this.hp);
        this.connect();
        this.open();
        DialbackVerify p = (DialbackVerify)this.getDataFactory().createPacketNode(DialbackVerify.NAME);
        p.setTo(this.getJID());
        p.setKey(this.dialbackVerifyKey);
        p.setID(this._initiatingStreamID);
        p.setFrom(NMS.getJID());
        this.getStream().send((Packet)p);
    }

    public void statusChanged(StreamStatusEvent event) {
        Stream stream;
        StreamContext sc = event.getContext();
        if (sc.isInbound()) {
            Log.debug("OutDialbackConnection[" + this.getJID() + "] inbound status changed from " + event.getPreviousStatus() + " to " + event.getNextStatus());
        } else {
            Log.debug("OutDialbackConnection[" + this.getJID() + "] outbound status changed from " + event.getPreviousStatus() + " to " + event.getNextStatus());
        }
        if (!event.getPreviousStatus().equals((Object)Stream.OPENED) || event.getNextStatus().equals((Object)Stream.CLOSED) || event.getNextStatus().equals((Object)Stream.DISCONNECTED)) {
            // empty if block
        }
        if ((stream = this.getStream()).getInboundStatus().equals((Object)Stream.DISCONNECTED) && stream.getOutboundStatus().equals((Object)Stream.DISCONNECTED)) {
            this.setStream(null);
            if (!this.dialbackComplete) {
                this.session.finishDialback(DialbackResult.INVALID);
                this.worker.addRunnable(new Runnable(){

                    public void run() {
                        OutDialbackConnection.this.close();
                    }
                });
            }
        }
    }
}

