/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.SSLContextManager;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.ServerSession;
import com.iplanet.im.server.ServerSocketListener;
import com.iplanet.im.server.util.LazyDate;
import com.sun.im.service.util.BufferedByteChannel;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.SelectWorker;
import com.sun.im.service.util.StringUtility;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import org.jabberstudio.jso.Stream;

public class NioSelectAcceptor
extends ServerSocketListener {
    SelectWorker nioChannelReader;
    ServerSocketChannel ssChannel;
    Selector acceptSelector;
    String logPrefix;
    boolean stop = false;
    AcceptorThread acceptor;
    boolean _isS2SPort = true;
    boolean usessl = true;
    SSLContext _sslContext = null;
    private static byte[] tic = new byte[]{32, 32};

    public NioSelectAcceptor(HostPort hp, int minThreads, int maxThreads) throws Exception {
        Log.debug("Creating SelectWorker");
        this.nioChannelReader = new SelectWorker(NMS.get().getWorker());
        ServerConfig sc = ServerConfig.getServerConfig();
        this.usessl = StringUtility.getBoolean((String)sc.getSetting("iim_server.usessl", "true"), (boolean)true);
        if (!System.getProperty("java.version").startsWith("1.5")) {
            Log.warning("SSL is not supported in versions prior to 1.5.0");
            this.usessl = false;
        }
        if (this.usessl) {
            this._sslContext = SSLContextManager.getInstance();
            if (this._sslContext == null) {
                this.usessl = false;
            }
        }
        Log.debug("ServerSocketChannel on: " + hp.getHost() + " Port: " + hp.getPort());
        InetSocketAddress sa = new InetSocketAddress(hp.getHost(), hp.getPort());
        this.ssChannel = ServerSocketChannel.open();
        this.ssChannel.socket().bind(sa, 20);
        this.logPrefix = "[NioSelectAcceptor][" + this.ssChannel.socket().getInetAddress().getHostAddress() + ":" + this.ssChannel.socket().getLocalPort() + "] ";
        this.acceptor = new AcceptorThread(this.ssChannel, this);
    }

    public void begin() {
        this.acceptor.start();
        new Thread((Runnable)this.nioChannelReader).start();
        this.startActivityMonitor(new ActivityRunnable());
    }

    public void close() {
        this.nioChannelReader.close();
        this.stop = true;
        try {
            this.acceptSelector.wakeup();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void closeChannel(Object o) {
        this.nioChannelReader.cancel(o);
    }

    ServerSocketChannel GetServerSocketChannel() {
        return this.ssChannel;
    }

    public Object registerForRead(SocketChannel channel, Runnable runnable) throws IOException {
        return this.nioChannelReader.register((SelectableChannel)channel, runnable);
    }

    static /* synthetic */ byte[] access$000() {
        return tic;
    }

    class ActivityRunnable
    implements Runnable {
        ByteBuffer ticbb = ByteBuffer.wrap(NioSelectAcceptor.access$000());

        ActivityRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!NioSelectAcceptor.this.stop) {
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Date d = LazyDate.getDate();
                long now = d.getTime();
                try {
                    Log.debug(NioSelectAcceptor.this.logPrefix + " Starting activity check; inactivity timeout=" + NioSelectAcceptor.this._inactivityTimeout + " now=" + now);
                    int n = 0;
                    Iterator iter = NioSelectAcceptor.this.nioChannelReader.keys().iterator();
                    while (iter.hasNext()) {
                        SelectionKey key = (SelectionKey)iter.next();
                        Object o = NioSelectAcceptor.this.nioChannelReader.attachment((Object)key);
                        if (o instanceof ClientSession) {
                            ++n;
                            ClientSession s = (ClientSession)o;
                            ByteChannel ch = s.getChannel();
                            if (!ch.isOpen()) {
                                Log.debug(NioSelectAcceptor.this.logPrefix + "found closed channel " + s.getJID());
                                s.disconnected();
                                continue;
                            }
                            long inactivity = now - s.getLastActivity();
                            if (inactivity <= NioSelectAcceptor.this._inactivityTimeout) continue;
                            try {
                                Stream stream;
                                Log.debug(NioSelectAcceptor.this.logPrefix + "Testing inactive connection from " + s.getJID());
                                Stream stream2 = stream = s.getStream();
                                synchronized (stream2) {
                                    this.ticbb.rewind();
                                    ch.write(this.ticbb);
                                }
                                s.setLastActivity(now);
                            }
                            catch (IOException ioe) {
                                Log.info(NioSelectAcceptor.this.logPrefix + "Closing inactive connection from " + s.getJID());
                                s.disconnected();
                            }
                            continue;
                        }
                        Log.error(NioSelectAcceptor.this.logPrefix + "attachment not of type session; key =" + key);
                    }
                    Log.debug(NioSelectAcceptor.this.logPrefix + " Completed activity check for " + n + " channels");
                }
                catch (Exception e) {
                    Log.debug(NioSelectAcceptor.this.logPrefix + " Activity check was interrupted: " + e);
                }
            }
        }
    }

    class AcceptorThread
    extends Thread {
        ServerSocketChannel ssc;
        NioSelectAcceptor nioSel;
        Constructor sbcConstructor;

        public AcceptorThread(ServerSocketChannel theSSC, NioSelectAcceptor nsw) throws Exception {
            this.nioSel = nsw;
            NioSelectAcceptor.this.acceptSelector = Selector.open();
            this.ssc = theSSC;
            this.ssc.configureBlocking(false);
            this.ssc.register(NioSelectAcceptor.this.acceptSelector, 16);
            if (NioSelectAcceptor.this.usessl) {
                Class[] paramTypes = new Class[]{ClassLoader.getSystemClassLoader().loadClass("java.nio.channels.ByteChannel"), ClassLoader.getSystemClassLoader().loadClass("javax.net.ssl.SSLContext"), ClassLoader.getSystemClassLoader().loadClass("com.sun.im.service.util.Worker")};
                this.sbcConstructor = Class.forName("com.iplanet.im.server.tiger.SecureByteChannelImpl").getDeclaredConstructor(paramTypes);
            }
        }

        public void run() {
            Log.info(NioSelectAcceptor.this.logPrefix + "Acceptor starting");
            try {
                while (!NioSelectAcceptor.this.stop) {
                    Log.debug("NIODEBUG: before acceptor select");
                    int n = NioSelectAcceptor.this.acceptSelector.select();
                    Log.debug(NioSelectAcceptor.this.logPrefix + "accept selector returned: " + n);
                    this.acceptPendingConnections();
                }
                NioSelectAcceptor.this.acceptSelector.close();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.error(NioSelectAcceptor.this.logPrefix + "accept error : " + e.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void acceptPendingConnections() {
            AcceptorThread acceptorThread = this;
            synchronized (acceptorThread) {
                Iterator<SelectionKey> iter = NioSelectAcceptor.this.acceptSelector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    if (!key.isValid() || !key.isAcceptable()) continue;
                    ServerSocketChannel readyChannel = (ServerSocketChannel)key.channel();
                    SocketChannel incomingChannel = null;
                    ClientSession session = null;
                    try {
                        incomingChannel = readyChannel.accept();
                        InetAddress a = incomingChannel.socket().getInetAddress();
                        Log.info(NioSelectAcceptor.this.logPrefix + "accepted " + a);
                        incomingChannel.configureBlocking(false);
                        ByteChannel chan = incomingChannel;
                        if (NioSelectAcceptor.this.usessl) {
                            Object[] params = new Object[]{incomingChannel, NioSelectAcceptor.this._sslContext, NMS.get().getWorker()};
                            chan = (ByteChannel)this.sbcConstructor.newInstance(params);
                        } else {
                            chan = new BufferedByteChannel((ByteChannel)incomingChannel, NioSelectAcceptor.this.nioChannelReader);
                        }
                        session = NioSelectAcceptor.this._isS2SPort ? new ServerSession(this.nioSel, chan) : new ClientSession(this.nioSel, chan);
                        SelectWorker.Selection sel = null;
                        sel = chan instanceof BufferedByteChannel ? NioSelectAcceptor.this.nioChannelReader.register((SelectableChannel)incomingChannel, (Runnable)session, (BufferedByteChannel)chan) : NioSelectAcceptor.this.nioChannelReader.register((SelectableChannel)incomingChannel, (Runnable)session);
                        session.setSelectionKey(sel);
                        session.start();
                        Log.debug(NioSelectAcceptor.this.logPrefix + "STAT:numSessions = " + NioSelectAcceptor.this.nioChannelReader.keys().size());
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                        Log.error(NioSelectAcceptor.this.logPrefix + "accept error: " + e.toString());
                        if (session != null) {
                            session.disconnected();
                            continue;
                        }
                        if (incomingChannel == null) continue;
                        NioSelectAcceptor.this.nioChannelReader.cancel((Object)incomingChannel);
                    }
                }
            }
        }
    }
}

