/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.Discoverable;
import com.iplanet.im.server.FileNewsStorage;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LDAPNewsStorage;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NewsChannel;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RosterHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.NewsStorageProvider;
import com.sun.im.provider.RealmException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.XMPPNewsMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.pubsub.PubSubEntityElement;
import org.jabberstudio.jso.x.pubsub.PubSubEvent;
import org.jabberstudio.jso.x.pubsub.PubSubItems;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.xml.sax.SAXException;

public class NewsHandler
extends AbstractHandler
implements Discoverable {
    private RosterHandler _rosterHandler;
    protected static String NAMESPACE_CONFERENCE = "jabber:iq:conference";
    protected static String NAMESPACE = "http://jabber.org/protocol/pubsub";
    protected static String NAMESPACE_OWNER = NAMESPACE + "#owner";
    protected static String NAMESPACE_EVENT = NAMESPACE + "#event";
    public static final NSI NSI_PUBSUB = new NSI("pubsub", NAMESPACE);
    public static final NSI NSI_PUBSUB_OWNER = new NSI("pubsub", NAMESPACE_OWNER);
    public static final String NEWS_SERVICEPREFIX = "pubsub.";
    private NewsStorageProvider _storage = this.getStorageProvider();
    Hashtable topics = new Hashtable();

    protected NewsStorageProvider getStorageProvider() {
        if (this._storage == null) {
            try {
                this._storage = NMS.getPropStore() == 1 ? new LDAPNewsStorage() : new FileNewsStorage();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.debug("[NewsHandler] failed to load storage provider: " + e);
            }
        }
        return this._storage;
    }

    public NewsHandler(RosterHandler rhandler) {
        this._rosterHandler = rhandler;
    }

    public boolean isPubSubPacket(Packet packet) {
        if (packet.getExtension("http://jabber.org/protocol/pubsub") != null) {
            return true;
        }
        return packet.getExtension("http://jabber.org/protocol/pubsub#owner") != null;
    }

    public void handle(StreamEndPoint ep, Packet packet) {
        ClientSession session = (ClientSession)ep;
        Log.debug("[NewsChannel#handle] processing ");
        StreamElement pubsubElem = packet.getFirstElement(NSI_PUBSUB);
        if (pubsubElem == null && (pubsubElem = packet.getFirstElement(new NSI("pubsub", "http://jabber.org/protocol/pubsub#owner"))) == null) {
            Log.debug("PubSub is still null");
            return;
        }
        if (!IMPolicyManager.canAccessNews(session.getUser())) {
            session.sendError(packet, PacketError.CANCEL, "not-allowed", "not-authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
            return;
        }
        if (pubsubElem.getFirstElement("create") != null) {
            this.handleCreateNewsChannel(session, packet);
        } else if (pubsubElem.getFirstElement("delete") != null) {
            this.handleDeleteNewsChannel(session, packet);
        } else if (pubsubElem.getFirstElement("subscribe") != null) {
            this.handleSubscribe(session, packet);
        } else if (pubsubElem.getFirstElement("unsubscribe") != null) {
            this.handleUnSubscribe(session, packet);
        } else if (pubsubElem.getFirstElement("publish") != null) {
            this.handleMessageAdded(session, packet);
        } else if (pubsubElem.getFirstElement("retract") != null) {
            this.handleMessageDeleted(session, packet);
        } else if (pubsubElem.getFirstElement("affililiations") != null) {
            this.handleGetUserAffiliations(session, packet);
        } else if (pubsubElem.getFirstElement("entities") != null) {
            this.handleNewsAffiliations(session, packet);
        } else if (pubsubElem.getFirstElement("items") != null) {
            this.handleGetMessages(session, packet);
        } else if (pubsubElem.getFirstElement("affiliations") != null) {
            this.handleGetUserAffiliations(session, packet);
        } else if (pubsubElem.getFirstElement("configure") != null) {
            this.handleNewsConfiguration(session, packet);
        }
    }

    public void handleCreateNewsChannel(ClientSession session, Packet packet) {
        block7: {
            String jid = null;
            Log.debug("[NewsChannel#handleCreateNewsChannel] processing " + packet.toString());
            StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
            String nodeName = pubSubElem.getFirstElement("create").getAttributeValue("node");
            String domain = session.getJID().getDomain();
            jid = NewsHandler.encode(nodeName, domain);
            try {
                NewsChannel nc = this.getNewsChannel(session, jid);
                if (nc != null) {
                    Log.debug("[NewsChannel: " + nc.getUID() + "] already exists");
                    session.sendError(packet, PacketError.CANCEL, "conflict", "conflict", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
                    return;
                }
                if (IMPolicyManager.canManageNews(session.getUser())) {
                    nc = new NewsChannel(jid, this._storage);
                    try {
                        this._storage.create(nc.getJID().toString());
                        this.topics.put(nc.getJID().toString(), nc);
                        Log.debug("initializing the channel");
                        nc.initialize(session);
                        PubSubQuery pubsubquery = (PubSubQuery)session.getDataFactory().createExtensionNode(NSI_PUBSUB, PubSubQuery.class);
                        PubSubEntityElement entityElem = null;
                        entityElem = pubsubquery.createEntityElement(null, session.getJID().toBareJID(), "owner", "none");
                        Log.debug("updating the affiliation");
                        nc.updateAffiliation(session.getJID().toBareJID().toString(), (StreamElement)entityElem, false, session);
                        Log.debug("updating the users news roster");
                        PubSubEntityElement newEntityElem = pubsubquery.createEntityElement(NewsHandler.decode(jid), session.getJID().toBareJID(), "owner", "none");
                        this._rosterHandler.updateNewsRoster(session.getUser(), (StreamElement)newEntityElem, NewsHandler.decode(jid), session, true);
                        if (this._archive.isNewsArchiveEnabled()) {
                            this._archive.onSetup(nc.getUID(), session.getUser().getUID());
                        }
                    }
                    catch (Exception e) {
                        Log.debug("[NewsChannel: " + nc.getUID() + "] unable to initialize the channel: " + e.getMessage());
                        Log.printStackTrace(e);
                    }
                    session.sendResult(packet, null, packet.getTo(), packet.getFrom());
                    break block7;
                }
                Log.debug("[NewsChannel:" + jid + "] rejecting " + session.getJID() + " does not have manage access");
                session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
            }
        }
    }

    public void handlePurgeNewsChannel(ClientSession session, Packet packet) {
        block7: {
            String jid = null;
            StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
            String nodeName = pubSubElem.getFirstElement("purge").getAttributeValue("node");
            String domain = session.getJID().getDomain();
            jid = NewsHandler.encode(nodeName, domain);
            try {
                NewsChannel nc = this.getNewsChannel(session, jid);
                if (nc == null) {
                    Log.debug("[NewsChannel: " + nc.getUID() + "] does not exists");
                    session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node does not exist", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
                    return;
                }
                if (!nc.isPersistent()) {
                    Log.debug("[NewsChannel: " + nc.getUID() + "] is not a persistent channel");
                    session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Not Implemented", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
                    return;
                }
                if (nc.getAccess(session.getJID().toBareJID(), session) >= 14 && IMPolicyManager.canManageNews(session.getUser())) {
                    try {
                        nc.deleteMessages();
                        session.sendResult(packet, null, packet.getTo(), packet.getFrom());
                    }
                    catch (Exception e) {}
                    break block7;
                }
                Log.debug("[NewsChannel: " + nc.getUID() + "] " + session.getJID() + " does not permission to delete");
                session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
                return;
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
            }
        }
    }

    public void handleDeleteNewsChannel(ClientSession session, Packet packet) {
        block6: {
            String jid = null;
            StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
            String nodeName = pubSubElem.getFirstElement("delete").getAttributeValue("node");
            String domain = session.getJID().getDomain();
            jid = NewsHandler.encode(nodeName, domain);
            try {
                NewsChannel nc = this.getNewsChannel(session, jid);
                if (nc == null) {
                    Log.debug("[NewsChannel: " + nc.getUID() + "] does not exists");
                    session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node does not exist", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
                    return;
                }
                if (IMPolicyManager.canManageNews(session.getUser()) && nc.getAccess(session.getJID().toBareJID(), session) >= 14) {
                    Log.debug("removeNewsChannel getting invoked");
                    nc.removeNewsChannel(session, packet);
                    this.topics.remove(nc.getJID().toString());
                    this._storage.destroy(nc.getJID().toString());
                    session.sendResult(packet, null, packet.getTo(), packet.getFrom());
                    if (this._archive.isNewsArchiveEnabled()) {
                        this._archive.onClose(nc.getUID(), session.getUser().getUID());
                    }
                    break block6;
                }
                Log.debug("[NewsChannel: " + nc.getUID() + "] " + session.getJID() + " does not permission to delete");
                session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                return;
            }
            catch (StreamException se) {
                Log.debug("[NewsChannel: " + jid + "] exception in sending the error" + se.getMessage());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.debug("[NewsChannel: " + jid + "] error while removing news channel - " + e.toString());
                session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
            }
        }
    }

    public void handleSubscribe(ClientSession session, Packet packet) {
        StreamElement pubSubElem = packet.getFirstElement(PubSubQuery.NAME);
        String nodeName = pubSubElem.getFirstElement("subscribe").getAttributeValue("node");
        String domain = session.getJID().getDomain();
        String jid = NewsHandler.encode(nodeName, domain);
        String subJid = pubSubElem.getFirstElement("subscribe").getAttributeValue("jid");
        JID subscriberJID = new JID(subJid);
        JID bareSubJID = subscriberJID.toBareJID();
        try {
            NewsChannel nc = this.getNewsChannel(session, jid);
            Log.debug("[NewsChannel: " + nodeName + " test encode] " + jid);
            if (nc == null) {
                Log.debug("[NewsChannel: " + nodeName + "] does not exists");
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node does not exist", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                return;
            }
            if (!bareSubJID.equals(session.getJID().toBareJID())) {
                Log.debug("[NewsChannel: " + nc.getUID() + "] subscriber[ " + bareSubJID + " ] and session JID [" + session.getJID().toBareJID() + "] does not match");
                session.sendError(packet, PacketError.AUTH, "not-authorized", "Not  Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                return;
            }
            Log.debug("[NewsChannel: " + nc.getUID() + "] not a subscriber");
            if (nc.getAccess(session.getJID().toBareJID(), session) >= 2) {
                if (!nc.subApprovalRequired()) {
                    Log.debug("[NewsChannel: " + nc.getUID() + "] subscription approval not required");
                    nc.addSubscriber(session, packet, subscriberJID);
                    PubSubQuery pubsubquery = (PubSubQuery)session.getDataFactory().createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
                    StreamElement entityElem = session.getDataFactory().createElementNode(new NSI("entity", "http://jabber.org/protocol/pubsub"));
                    entityElem.setAttributeValue("subscription", "subscribed");
                    entityElem.setAttributeValue("affiliation", "none");
                    entityElem.setAttributeValue("jid", subscriberJID.toString());
                    entityElem.setAttributeValue("node", nodeName);
                    Log.debug("[NewsChannel: " + nc.getUID() + "] entityElem created" + entityElem.toString());
                    Log.debug("[NewsChannel: " + nc.getUID() + "]" + entityElem.getAttributeValue("subscription"));
                    Log.debug("[NewsChannel: " + nc.getUID() + "] update news roster of user");
                    this._rosterHandler.updateNewsRoster(session.getUser(), entityElem, nodeName, session, false);
                    pubsubquery.add((StreamNode)entityElem);
                    session.sendResult(packet, (StreamElement)pubsubquery, packet.getTo(), packet.getFrom());
                    Packet message = session.getDataFactory().createPacketNode(new NSI("message", null), Message.class);
                    PubSubEvent event = (PubSubEvent)session.getDataFactory().createExtensionNode(PubSubEvent.NAME, PubSubEvent.class);
                    PubSubItems items = event.createPubSubItemsElement(NewsHandler.decode(nc.getFQName()));
                    event.add((StreamNode)items);
                    this.fillMessages((StreamElement)event, nc, session);
                    if (items.listPubSubItems().size() > 0) {
                        message.add((StreamNode)event);
                        message.setTo(packet.getFrom());
                        message.setFrom(packet.getTo());
                        session.send(message);
                    }
                } else {
                    Log.debug("[NewsChannel: " + nc.getUID() + "] requires approval from " + nc.getApprover());
                    StreamElement pubsub = session.getDataFactory().createElementNode(new NSI("pubsub", NAMESPACE));
                    StreamElement entity = session.getDataFactory().createElementNode(new NSI("entity", NAMESPACE));
                    entity.setAttributeValue("node", nodeName);
                    entity.setAttributeValue("jid", subJid);
                    entity.setAttributeValue("affiliation", "none");
                    entity.setAttributeValue("subscription", "pending");
                    pubsub.add((StreamNode)entity);
                    session.sendResult(packet, pubsub, packet.getTo(), packet.getFrom());
                    if (this._archive.isNewsArchiveEnabled()) {
                        this._archive.onSubscribe(nc.getUID(), session.getUser().getUID());
                    }
                }
            } else {
                Log.debug("[NewsChannel: " + nc.getUID() + "] does not exists");
                session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
            }
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel] unable to send error or result to " + session.getJID());
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (Exception e) {
            Log.debug("[NewsChannel: " + jid + "] " + e.getMessage());
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void handleUnSubscribe(ClientSession session, Packet packet) {
        StreamElement pubSubElem = packet.getFirstElement(PubSubQuery.NAME);
        String nodeName = pubSubElem.getFirstElement("unsubscribe").getAttributeValue("node");
        String subJid = pubSubElem.getFirstElement("unsubscribe").getAttributeValue("jid");
        JID subscriberJID = new JID(subJid);
        JID bareSubJID = subscriberJID.toBareJID();
        String domain = session.getJID().getDomain();
        String jid = NewsHandler.encode(nodeName, domain);
        try {
            NewsChannel nc = this.getNewsChannel(session, jid);
            if (nc == null) {
                Log.debug("[NewsChannel: " + nc.getUID() + "] does not exists");
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node does not exist", packet.getTo(), packet.getFrom(), packet.getFirstElement("pubsub"));
                return;
            }
            if (!nc.isSubscriber(subscriberJID, session)) {
                Log.debug("[NewsChannel: " + nc.getUID() + "]" + session.getJID() + " is not a subscriber");
                session.sendError(packet, PacketError.CANCEL, "not-allowed", "You are not a subscriber to this node", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                return;
            }
            nc.removeSubscriber(session, packet);
            PubSubQuery pubsubquery = (PubSubQuery)session.getDataFactory().createExtensionNode(NSI_PUBSUB, PubSubQuery.class);
            StreamElement oldEntityElem = nc.getAffiliation(subJid, session);
            String affiliation = null;
            affiliation = oldEntityElem != null ? oldEntityElem.getAttributeValue("affiliation") : "none";
            Log.debug("[NewsChannel#unsubsribe]: affiliation is " + affiliation);
            PubSubEntityElement entityElem = pubsubquery.createEntityElement(nodeName, subscriberJID, affiliation, "none");
            Log.debug("[NewsChannel: " + nc.getUID() + "] entityElem created" + entityElem.toString());
            Log.debug("[NewsChannel: " + nc.getUID() + "] update news roster of user");
            this._rosterHandler.updateNewsRoster(session.getUser(), (StreamElement)entityElem, nodeName, session, false);
            session.sendResult(packet, null, packet.getTo(), packet.getFrom());
            if (this._archive.isNewsArchiveEnabled()) {
                this._archive.onUnsubscribe(nc.getUID(), session.getUser().getUID());
            }
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel] unable to send error or result to " + session.getJID());
        }
        catch (Exception e) {
            Log.debug("[NewsChannel: " + jid + "] " + e.getMessage());
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void handleGetMessages(ClientSession session, Packet packet) {
        StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
        StreamElement items = pubSubElem.getFirstElement("items");
        if (items == null) {
            Log.debug("[NewsChannel#handleGetMessages:] invalid xml stanza " + packet.toString());
        }
        String nodeName = items.getAttributeValue("node");
        String domain = session.getJID().getDomain();
        try {
            NewsChannel nc = this.getNewsChannel(session, NewsHandler.encode(nodeName, domain));
            if (nc == null) {
                Log.debug("[NewsChannel: " + nc.getUID() + "] does not exists");
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node does not exist", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
            }
            if (nc.isPersistent()) {
                JID to = packet.getTo();
                JID from = packet.getFrom();
                this.fillMessages(pubSubElem, nc, session);
                session.sendResult(packet, null, packet.getTo(), packet.getFrom());
            } else {
                Log.debug("[NewsChannel: " + nc.getUID() + "] is persistent");
                session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Persistent items not implemented", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
            }
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel] unable to send error or result to " + session.getJID());
        }
        catch (Exception e) {
            Log.debug("[NewsChannel: " + nodeName + "] unable to get messages");
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void handleMessageAdded(ClientSession session, Packet packet) {
        StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
        String nodeName = pubSubElem.getFirstElement("publish").getAttributeValue("node");
        String domain = session.getJID().getDomain();
        try {
            NewsChannel nc = this.getNewsChannel(session, NewsHandler.encode(nodeName, domain));
            if (nc == null) {
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node Not Found", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                Log.debug("[NewsChannel: " + nc.getUID() + "]  does not exists");
            }
            if (nc.getAccess(session.getJID().toBareJID(), session) >= 6) {
                nc.addMessage(session, packet);
                session.sendResult(packet, null, packet.getTo(), packet.getFrom());
                if (this._archive.isNewsArchiveEnabled()) {
                    try {
                        XMPPNewsMessage message = new XMPPNewsMessage(session.getDataFactory(), (InfoQuery)packet);
                        this._archive.onNewsMessage(nc.getUID(), (ReadOnlyMessage)message);
                        Log.debug("[NewsChannel: " + nc.getUID() + "] archived message");
                    }
                    catch (Exception ce) {
                        Log.warning("[NewsChannel: " + nc.getUID() + "] failed to archive message: " + packet + " --- " + ce.toString());
                        Log.printStackTrace(ce);
                    }
                }
            } else {
                session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                Log.debug("[NewsChannel: " + nc.getUID() + "] " + session.getUID() + " doess not have permission to post messages");
            }
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel] unable to send error or result to " + session.getJID());
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (Exception e) {
            Log.debug("[NewsChannel: " + nodeName + "] unable to add message");
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void handleMessageDeleted(ClientSession session, Packet packet) {
        Log.debug("[NewsHandler#handleMessageDeleted: invoked]");
        StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
        String nodeName = pubSubElem.getFirstElement("retract").getAttributeValue("node");
        String domain = session.getJID().getDomain();
        try {
            NewsChannel nc = this.getNewsChannel(session, NewsHandler.encode(nodeName, domain));
            if (nc == null) {
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node Not Found", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                Log.debug("[NewsChannel: " + nc.getUID() + "]  does not exists");
                return;
            }
            if (nc.supportDeleteItems()) {
                if (nc.isPersistent()) {
                    if (nc.getAccess(session.getJID().toBareJID(), session) >= 14) {
                        nc.deleteMessage(session, packet);
                        session.sendResult(packet, null, packet.getTo(), packet.getFrom());
                    } else {
                        session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                        Log.debug("[NewsChannel: " + nc.getUID() + "] " + session.getUID() + " does not have permission to delete messages");
                    }
                } else {
                    session.sendError(packet, PacketError.CANCEL, "not-allowed", "Not Allowed", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                    Log.debug("[NewsChannel: " + nc.getUID() + "] is not persistent");
                }
            } else {
                session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Not Implemented", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                Log.debug("[NewsChannel: " + nc.getUID() + "] does not support deleting items");
            }
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel] unable to send error or result to " + session.getJID());
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (Exception e) {
            Log.debug("[NewsChannel: " + nodeName + "] unable to delete message");
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void handleGetUserAffiliations(ClientSession session, Packet packet) {
        Log.debug("[NewsHandler#handleGetUserAffiliations]: processsing");
        try {
            BaseUser user = session.getUser();
            StreamElement elem = this._rosterHandler.getNewsRoster(user, session);
            if (elem != null) {
                Log.debug("[NewsHandler#handleGetUserAffiliations]: processsing " + elem);
            }
            this.removeDeletedNewsChannels(elem, user, session);
            if (elem != null) {
                session.sendResult(packet, elem, packet.getTo(), packet.getFrom());
            } else {
                PubSubQuery pubsubquery = (PubSubQuery)packet.getExtension("http://jabber.org/protocol/pubsub");
                session.sendResult(packet, (StreamElement)pubsubquery, packet.getTo(), packet.getFrom());
            }
        }
        catch (SAXException saxe) {
            Log.debug("[NewsChannel#handleGetUserAffilations] " + saxe.getMessage());
        }
        catch (ParserConfigurationException pce) {
            Log.debug("[NewsChannel#handleGetUserAffilations] " + pce.getMessage());
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel#handleGetUserAffilations] " + se.getMessage());
        }
        catch (IOException ioe) {
            Log.debug("[NewsChannel#handleGetUserAffilations] " + ioe.getMessage());
        }
        catch (Exception e) {
            Log.debug("[NewsChannel#handleGetUserAffilations] " + e.getMessage());
        }
    }

    public void handleNewsAffiliations(ClientSession session, Packet packet) {
        StreamElement pubSubElem = packet.getFirstElement(NSI_PUBSUB);
        String nodeName = pubSubElem.getFirstElement("entities").getAttributeValue("node");
        String domain = session.getJID().getDomain();
        String jid = NewsHandler.encode(nodeName, domain);
        try {
            NewsChannel nc = this.getNewsChannel(session, jid);
            Log.debug("[NewsHandler#handleNewsAffiliations] invoked");
            if (nc == null) {
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node " + jid + " not found");
            } else {
                Packet p = session.getDataFactory().createPacketNode(new NSI("iq", null), InfoQuery.class);
                p.setType((Packet.Type)InfoQuery.RESULT);
                p.setTo(packet.getFrom());
                p.setFrom(packet.getTo());
                p.setID(packet.getID());
                if (packet.getType() == InfoQuery.GET) {
                    p.add((StreamNode)nc.getAffiliations(session));
                    session.send(p);
                } else if (IMPolicyManager.canManageNews(session.getUser()) && nc.getAccess(session.getJID().toBareJID(), session) >= 14) {
                    nc.mergeAffiliations((StreamElement)packet, true, session);
                    this.updateUsersNewsRoster(session, packet);
                    session.send(p);
                } else {
                    session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                }
            }
        }
        catch (StreamException se) {
            Log.debug("[NewsChannel] unable to send error or result to " + session.getJID());
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (Exception e) {
            Log.debug("[NewsChannel: " + jid + "] " + e.getMessage());
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void handleNewsConfiguration(ClientSession session, Packet packet) {
        Extension pubSubElem = packet.getExtension("http://jabber.org/protocol/pubsub#owner");
        StreamElement configureElem = pubSubElem.getFirstElement("configure");
        Log.debug("[NewsHandler#handleNewsConfiguration]: processsing");
        if (configureElem == null) {
            Log.debug("Configure element is missing, syntax error");
            return;
        }
        String nodeName = configureElem.getAttributeValue("node");
        try {
            if (nodeName == null) {
                StreamElement config = NewsChannel.getDefaultConfiguration(session);
                if (config != null) {
                    session.sendResult(packet, config, packet.getTo(), packet.getFrom());
                } else {
                    Log.debug("[NewsHandler]: newschannels cannot be configured");
                    session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Node cannot be configured", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                }
                return;
            }
            String domain = session.getJID().getDomain();
            String jid = NewsHandler.encode(nodeName, domain);
            NewsChannel nc = this.getNewsChannel(session, jid);
            if (nc == null) {
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "Node Not Found", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                Log.debug("[NewsChannel: " + jid + "]  does not exists");
                return;
            }
            if (packet.getType() == InfoQuery.GET) {
                StreamElement config = nc.getConfiguration(session);
                StreamElement configureElement = config.getFirstElement("configure");
                if (configureElement != null) {
                    XDataForm xform = (XDataForm)configureElement.getFirstElement(XDataForm.NAME);
                    xform.setType(XDataForm.FORM);
                    session.sendResult(packet, config, packet.getTo(), packet.getFrom());
                    return;
                }
                Log.debug("[NewsHandler]: newschannels cannot be configured");
                session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Node cannot be configured", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                return;
            }
            if (packet.getType() == InfoQuery.SET) {
                if (IMPolicyManager.canManageNews(session.getUser()) && nc.getAccess(session.getJID().toBareJID(), session) >= 14) {
                    nc.setConfiguration((StreamElement)pubSubElem);
                    session.sendResult(packet, null, packet.getTo(), packet.getFrom());
                } else {
                    session.sendError(packet, PacketError.CANCEL, "not-authorized", "Not Authorized", packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
                }
            } else {
                Log.debug("Exception, stanza error");
            }
        }
        catch (StreamException se) {
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), packet.getTo(), packet.getFrom(), packet.getFirstElement(PubSubQuery.NAME));
        }
    }

    public void process(ClientSession session, Packet packet) {
    }

    private void updateUsersNewsRoster(ClientSession session, Packet packet) {
        Extension pubSubElem = packet.getExtension("http://jabber.org/protocol/pubsub");
        StreamElement entitiesElem = pubSubElem.getFirstElement("entities");
        String nodeName = entitiesElem.getAttributeValue("node");
        String domain = session.getJID().getDomain();
        String nodeId = NewsHandler.encode(nodeName, domain);
        Iterator i = entitiesElem.listElements("entity").iterator();
        while (i.hasNext()) {
            try {
                StreamElement elem = (StreamElement)i.next();
                LocalUser user = RealmManager.getUser(elem.getAttributeValue("jid"));
                if (user == null) continue;
                this._rosterHandler.updateNewsRoster(user, elem, nodeName, session, true);
            }
            catch (SAXException se) {
                Log.debug("[NewsChannel#updateUsersNewsRoster] " + se.getMessage());
                Log.printStackTrace(se);
            }
            catch (RealmException re) {
                Log.debug("[NewsChannel#updateUsersNewsRoster] " + re.getMessage());
                Log.printStackTrace((Exception)((Object)re));
            }
            catch (Exception e) {
                Log.debug("[NewsChannel#updateUsersNewsRoster] " + e.getMessage());
                Log.printStackTrace(e);
            }
        }
    }

    public static String encode(String nodeName, String domain) {
        if (StringUtility.getResource((String)nodeName) != null) {
            JID node = new JID(nodeName);
            domain = node.getDomain();
            nodeName = node.getResource();
        }
        String correctDomain = domain;
        int i = domain.indexOf(NEWS_SERVICEPREFIX);
        if (i < 0) {
            correctDomain = NEWS_SERVICEPREFIX + domain;
        }
        JID encodedNewsChannel = new JID(nodeName, correctDomain, null);
        Log.debug("ENCODED: " + encodedNewsChannel);
        return encodedNewsChannel.toString();
    }

    public static String decode(String jid) {
        JID newsJID = new JID(jid);
        JID decodedNewsChannel = null;
        decodedNewsChannel = newsJID.getNode() != null ? new JID(null, newsJID.getDomain(), newsJID.getNode()) : new JID(jid);
        return decodedNewsChannel.toString();
    }

    public PacketError.Type fillInfo(DiscoInfoQuery query, JID jid, String node, StreamEndPoint session) {
        query.addIdentity(this.getCategory(), this.getType(), this.getName());
        return null;
    }

    public PacketError.Type fillItems(DiscoItemsQuery query, JID jid, String node, StreamEndPoint session) {
        try {
            if (node == null || node.equals("")) {
                String[] id = this._storage.search((CollaborationPrincipal)session.getUser(), "*", false);
                if (id != null) {
                    Log.debug("[NewsHandler#fillItems ] no of newschannels " + id.length);
                } else {
                    Log.debug("[NewsHandler#fillItems ] no of newschannels is null ");
                }
                if (id != null) {
                    for (int i = 0; i < id.length; ++i) {
                        NewsChannel nc = this.getNewsChannel(session, id[i]);
                        if (nc.getAccess(session.getJID().toBareJID(), session) < 2) continue;
                        query.addItem(jid, NewsHandler.decode(id[i]));
                    }
                }
            } else {
                NewsChannel nc = this.getNewsChannel(session, NewsHandler.encode(node, jid.getDomain()));
                String[] messageIds = nc.getMessageIds();
                Log.debug("[NewsHandler#fillItems ] no of messages" + messageIds.length);
                for (int i = 0; i < messageIds.length; ++i) {
                    query.addItem(jid, null, messageIds[i]);
                }
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.error("[NewsHandler#fillItems ] " + e.toString());
            return PacketError.CANCEL;
        }
        return null;
    }

    public PacketError.Type updateItems(DiscoItemsQuery query, JID jid, StreamEndPoint session) {
        return PacketError.MODIFY;
    }

    public PacketError.Type fillAgentInfo(StreamElement agentElement, StreamEndPoint session) {
        return null;
    }

    public String getName() {
        return "Publish/Subscribe Service";
    }

    public String getCategory() {
        return "pubsub";
    }

    public String getType() {
        return "generic";
    }

    public String[] getNamespaces() {
        String[] ns = new String[]{NAMESPACE, NAMESPACE_EVENT, NAMESPACE_OWNER};
        return ns;
    }

    public PacketError.Type fillBrowseInfo(JID jid, StreamElement query, StreamEndPoint session) {
        return null;
    }

    NewsChannel getNewsChannel(StreamEndPoint session, String address) throws Exception {
        String id = address;
        NewsChannel nc = (NewsChannel)this.topics.get(id = StringUtility.appendDomainToAddress((String)id, (String)(NEWS_SERVICEPREFIX + NMS.getName())));
        if (nc == null && this._storage.exists(id)) {
            nc = new NewsChannel(id, this._storage);
            nc.initialize(session);
            this.topics.put(id, nc);
        }
        return nc;
    }

    private void fillMessages(StreamElement packet, NewsChannel nc, ClientSession session) throws SAXException, Exception {
        StreamElement items = packet.getFirstElement("items");
        List itemList = items.listElements("item");
        if (itemList.size() == 0) {
            StreamElement[] messages = nc.getMessages(session);
            for (int i = 0; i < messages.length; ++i) {
                items.add((StreamNode)messages[i]);
            }
        } else {
            Iterator i = itemList.iterator();
            while (i.hasNext()) {
                StreamElement item = (StreamElement)i.next();
                StreamElement message = nc.getMessage(item.getID(), session);
                items.remove((StreamNode)item);
                items.add((StreamNode)message);
            }
        }
    }

    public void removeDeletedNewsChannels(StreamElement newsRoster, BaseUser user, ClientSession session) throws SAXException, Exception {
        ArrayList<String> deletedNewsChannels = new ArrayList<String>();
        if (newsRoster != null) {
            StreamElement entities = newsRoster.getFirstElement("affiliations");
            Iterator i = entities.listElements("entity").iterator();
            while (i.hasNext()) {
                StreamElement newsRosterElem = (StreamElement)i.next();
                String nodeName = newsRosterElem.getAttributeValue("node");
                if (this._storage.exists(NewsHandler.encode(nodeName, null))) continue;
                deletedNewsChannels.add(nodeName);
            }
            String[] nodeNames = new String[deletedNewsChannels.size()];
            nodeNames = deletedNewsChannels.toArray(nodeNames);
            this._rosterHandler.removeNewsRoster(user, nodeNames, newsRoster);
        }
    }
}

