/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.RealmManager;
import com.sun.im.provider.RealmException;
import com.sun.im.service.CollaborationGroup;
import java.util.HashSet;

public class NMSGroup
extends IMPrincipal
implements CollaborationGroup {
    private IMPrincipal[] principals = new IMPrincipal[0];
    private HashSet UIDSet = new HashSet();
    private boolean updateArray = false;
    private String _filter;
    private String _scope;

    public NMSGroup(String dn, String domain, String displayName) {
        super(null, domain, dn, displayName);
    }

    public NMSGroup(String dn, String domain, String displayName, String filter, String scope) {
        super(null, domain, dn, displayName);
        this._filter = filter;
        this._scope = scope;
    }

    public boolean isDynamic() {
        return this._filter != null;
    }

    public String getFilter() {
        return this._filter;
    }

    public String getScope() {
        return this._scope;
    }

    protected void update(IMPrincipal[] p) {
        this.principals = p;
        this.updateSet();
    }

    private void updateSet() {
        this.UIDSet.clear();
        if (this.principals == null) {
            return;
        }
        for (int i = 0; i < this.principals.length; ++i) {
            this.UIDSet.add(this.principals[i].getUID().toLowerCase());
        }
    }

    public synchronized boolean hasMember(IMPrincipal p) throws RealmException {
        Log.debug("searching for " + p.getUID() + " in " + this.getUID());
        if (this.isDynamic()) {
            return RealmManager.isMemberOfGroup(p, this);
        }
        return this.UIDSet.contains(p.getUID().toLowerCase());
    }

    public IMPrincipal[] getMembers() throws RealmException {
        return this.principals;
    }

    public synchronized void addMember(IMPrincipal p) {
        String uid = p.getUID().toLowerCase();
        if (!this.UIDSet.contains(uid)) {
            this.UIDSet.add(uid);
        }
    }

    public synchronized void removeMember(String uid) {
        this.UIDSet.remove(uid.toLowerCase());
    }

    public String toString() {
        return this.toString();
    }
}

