/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MultiplexSocketManager;
import com.iplanet.im.server.NMSSocketCallback;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.Iterator;
import java.util.LinkedList;
import org.jabberstudio.jso.StreamException;

public class MultiplexChannel
extends InputStream
implements ByteChannel {
    MultiplexSocketManager msMgr;
    Integer id;
    String ip;
    NMSSocketCallback callback;
    private int[] header = new int[4];
    int cmdlen;
    int readin;
    int state;
    boolean _alive;
    private LinkedList buffers = new LinkedList();
    private MultiplexChannelOutputStream os;
    ClientSession session;
    private Buffer marked;
    private Buffer current;

    public synchronized int read(ByteBuffer dst) throws IOException {
        int l;
        Buffer buffer;
        int len = dst.remaining();
        for (l = 0; this._alive && l < len && this.current != null; l += buffer.len - buffer.offset) {
            buffer = this.current;
            if (buffer.len - buffer.offset >= len - l) {
                dst.put(buffer.b, buffer.offset, len - l);
                buffer.offset += len - l;
                if (buffer.offset >= buffer.len) {
                    this.advance();
                }
                l = len;
                break;
            }
            dst.put(buffer.b, buffer.offset, buffer.len - buffer.offset);
            buffer.offset = buffer.len;
            this.advance();
        }
        if (this._alive) {
            if (Log.snoop()) {
                Log.debug("mxchnl[" + this.id + "] read " + l + " bytes: " + dst.toString());
            }
            return l;
        }
        return l;
    }

    public synchronized int write(ByteBuffer dst) throws IOException {
        int len = this.send(dst.array(), dst.position(), dst.limit());
        try {
            dst.position(dst.position() + len);
        }
        catch (IllegalArgumentException iae) {
            Log.printStackTrace(iae);
        }
        return len;
    }

    public boolean isOpen() {
        return this._alive;
    }

    public MultiplexChannel(MultiplexSocketManager msMgr, Integer id, String ip) {
        this.id = id;
        this.msMgr = msMgr;
        this.ip = ip;
        this.os = new MultiplexChannelOutputStream(this);
        Log.debug("mxchnl[" + id + "] created");
    }

    public void start() throws Exception {
        this._alive = true;
        this.session = new ClientSession(this);
        this.msMgr.addRunnable(new Runnable(){

            public void run() {
                block4: {
                    try {
                        MultiplexChannel.this.session.start();
                        Log.debug("mxchnl[" + MultiplexChannel.this.id + "] started");
                    }
                    catch (StreamException se) {
                        Log.warning("mxchnl[" + MultiplexChannel.this.id + "] failed to start - invalid data, closing the connection");
                        Log.printStackTrace((Exception)((Object)se));
                        if (MultiplexChannel.this.session != null) {
                            MultiplexChannel.this.session.disconnected();
                        }
                    }
                    catch (Exception e) {
                        Log.warning("mxchnl[" + MultiplexChannel.this.id + "] failed to start: " + e);
                        Log.printStackTrace(e);
                        if (MultiplexChannel.this.session == null) break block4;
                        MultiplexChannel.this.session.disconnected();
                    }
                }
            }
        });
    }

    public int send(byte[] b, int off, int len) throws IOException {
        if (!this._alive) {
            Log.debug("mxchnl[" + this.id + "] not sending - already closed ");
            throw new IOException("mxchnl[" + this.id + "] already closed.");
        }
        if (Log.snoop()) {
            Log.debug("mxchnl[" + this.id + "] sending: " + new String(b, off, len));
        }
        try {
            int wl = this.msMgr.send(this.id, b, off, len);
            return wl;
        }
        catch (IOException ioe) {
            System.out.println("Closed while sending the packet");
            this.close();
            throw ioe;
        }
    }

    public InputStream getInputStream() {
        return this;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void addBuffer(byte[] b, int len) {
        if (Log.snoop()) {
            Log.debug("mxchnl[" + this.id + "] received " + len + " bytes: <" + new String(b) + ">");
        }
        this.state = 1;
        this.addBuffer(b, 0, len);
    }

    private synchronized void addBuffer(byte[] b, int offset, int len) {
        if (Log.snoop()) {
            Log.debug("mxchnl[" + this.id + "] new buffer: " + new String(b, offset, len));
        }
        Buffer buffer = new Buffer(b, offset, len);
        if (this.buffers.size() == 0 || this.current == null) {
            this.current = buffer;
        }
        this.buffers.add(buffer);
        this.notify();
        this.msMgr.addRunnable(this.session);
    }

    public synchronized void close() throws IOException {
        Log.debug("mxchnl[" + this.id + "] closing");
        this.msMgr.close(this.id);
        this._alive = false;
        this.notify();
    }

    public void onClose() {
        Log.debug("mxchnl[" + this.id + "] closed by client.");
        if (this.session != null) {
            this._alive = false;
            this.session.disconnected();
            this.session = null;
        }
    }

    public synchronized int available() {
        if (this.buffers.size() > 0) {
            int len = 0;
            Iterator i = this.buffers.iterator();
            while (i.hasNext()) {
                Buffer b = (Buffer)i.next();
                len += b.len - b.offset;
            }
            return len;
        }
        return 0;
    }

    public synchronized int read() throws IOException {
        while (this._alive) {
            if (this.current != null) {
                byte c = this.current.b[this.current.offset];
                ++this.current.offset;
                if (this.current.offset >= this.current.len) {
                    this.advance();
                }
                return c;
            }
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        return 0;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private void advance() {
        if (this.marked != null) {
            int newIndex = this.buffers.indexOf(this.current) + 1;
            this.current = newIndex < this.buffers.size() ? (Buffer)this.buffers.get(newIndex) : null;
        } else {
            this.buffers.remove(0);
            this.current = this.buffers.size() > 0 ? (Buffer)this.buffers.get(0) : null;
        }
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int l = 0;
        int offset = off;
        while (this._alive && l < len) {
            if (this.current != null) {
                Buffer buffer = this.current;
                if (buffer.len - buffer.offset >= len - l) {
                    System.arraycopy(buffer.b, buffer.offset, b, offset, len - l);
                    buffer.offset += len - l;
                    if (buffer.offset >= buffer.len) {
                        this.advance();
                    }
                    l = len;
                    break;
                }
                System.arraycopy(buffer.b, buffer.offset, b, offset, buffer.len - buffer.offset);
                offset = (l += buffer.len - buffer.offset) + off;
                buffer.offset = buffer.len;
                this.advance();
                continue;
            }
            if (l == 0) continue;
            try {
                this.wait();
            }
            catch (Exception e) {}
        }
        if (this._alive) {
            return l;
        }
        throw new IOException("Out of stream");
    }

    public synchronized void reset() throws IOException {
        if (this.marked == null) {
            throw new IOException("reset to what?");
        }
        this.current = this.marked;
        this.current.offset = this.current.mark;
        this.marked = null;
    }

    public synchronized long skip(long n) throws IOException {
        long skipped = 0L;
        while (this._alive && skipped < n && this.buffers.size() > 0) {
            Buffer buffer = this.current;
            if (n - skipped >= (long)(buffer.len - buffer.offset)) {
                buffer.offset = buffer.len;
                skipped += (long)(buffer.len - buffer.offset);
                this.advance();
                continue;
            }
            buffer.offset = (int)((long)buffer.offset + (n - skipped));
            skipped = n;
        }
        if (this._alive) {
            return skipped;
        }
        throw new IOException("Out of stream");
    }

    public synchronized void mark(int readlimit) {
        Log.debug("mxchnl[" + this.id + "] mark called");
        if (this.marked != null) {
            Buffer b;
            while ((b = (Buffer)this.buffers.get(0)) != this.current) {
                this.buffers.remove(0);
            }
        }
        if (this.buffers.size() > 0) {
            this.current.mark = this.current.offset;
            this.marked = this.current;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void stripHeader(byte[] b, int len) {
        int offset = 0;
        while (offset < len) {
            switch (this.state) {
                case 0: {
                    this.header[this.readin] = b[offset] & 0xFF;
                    ++this.readin;
                    ++offset;
                    if (this.readin != 4) break;
                    this.cmdlen = (this.header[0] << 24) + (this.header[1] << 16) + (this.header[2] << 8) + this.header[3];
                    this.state = 1;
                    this.readin = 0;
                    break;
                }
                case 1: {
                    int buflen = len - offset;
                    this.addBuffer(b, offset, buflen);
                    this.readin += buflen;
                    offset += buflen;
                    if (this.readin != this.cmdlen) break;
                    this.state = 0;
                    this.readin = 0;
                }
            }
        }
    }

    class MultiplexChannelOutputStream
    extends OutputStream {
        MultiplexChannel channel;

        MultiplexChannelOutputStream(MultiplexChannel channel) {
            this.channel = channel;
        }

        public void write(int c) throws IOException {
            byte[] b = new byte[]{(byte)c};
            this.write(b, 0, 1);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.channel.send(b, off, len);
        }

        public void close() {
        }
    }

    class Buffer {
        byte[] b;
        int len;
        int offset = 0;
        int mark = -1;

        Buffer(byte[] b, int offset, int len) {
            this.b = b;
            this.len = len;
            this.offset = offset;
        }
    }
}

