/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.ServerConfig;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import com.sun.mfwk.discovery.MfDiscoveryResponder;
import com.sun.mfwk.trans.MfTransaction;
import com.sun.mfwk.trans.MfTransactionDefinition;
import com.sun.mfwk.trans.MfTransactionFactory;
import com.sun.mfwk.trans.MfTransactionFactoryImpl;
import com.sun.mfwk.trans.MfTransactionMetrics;
import com.sun.mfwk.util.instrum.MfInstrumManagement;
import com.sun.mfwk.util.instrum.MfObjectNameFactory;
import com.sun.mfwk.util.instrum.MfStatus;
import com.sun.mfwk.util.log.MfLogService;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.jmxmp.JMXMPConnectorServer;

public class MonitorImpl
implements MonitorInterface {
    public static final String JMX_DEBUG_PORT = "iim_server.monitor.htmlport";
    public final String __appName = "XMPP";
    private JMXServiceURL addr = null;
    private MBeanServer mbs = null;
    private MfStatus xmppStatusMetrics;
    private MfInstrumManagement xmppmgt;
    private String _instanceVarDir;
    private String instance;

    private MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public MonitorImpl(String instanceVarDir) {
        this._instanceVarDir = instanceVarDir;
        this.instance = new File(instanceVarDir).getName();
        Log.info("[Monitor] initializing instance " + this.instance);
        this.mbs = MBeanServerFactory.createMBeanServer();
        try {
            try {
                MfLogService logSrv = new MfLogService("XMPP");
            }
            catch (Exception e) {
                Log.info("[Monitor] Could not bind to log file XMPP");
            }
            String sHTMLPort = ServerConfig.getServerConfig().getSetting(JMX_DEBUG_PORT, null);
            if (sHTMLPort != null) {
                try {
                    sHTMLPort = sHTMLPort.trim();
                    int iPort = Integer.parseInt(sHTMLPort);
                    HtmlAdaptorServer htmlAdaptor = new HtmlAdaptorServer(iPort);
                    ObjectName oName = new ObjectName("jmx", "type", "htmlAdaptor");
                    this.mbs.registerMBean(htmlAdaptor, oName);
                    htmlAdaptor.start();
                    htmlAdaptor.waitState(0, 0L);
                    Log.debug("JDMK HTML protocol adaptor started on port " + htmlAdaptor.getPort());
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                    Log.warning("Failed to start JDMK HTML protocol adaptor on port " + sHTMLPort);
                }
            }
            JMXServiceURL url = new JMXServiceURL("jmxmp", null, 0);
            JMXMPConnectorServer cs = new JMXMPConnectorServer(url, null);
            ObjectName csName = new ObjectName("jmx:type=cserver,name=jmxmpConnectorServer");
            this.mbs.registerMBean(cs, csName);
            cs.start();
            while (!cs.isActive()) {
                Log.debug("[Monitor] sleeping on rmiConnect");
                MonitorImpl.sleep(200);
            }
            this.addr = cs.getAddress();
            Log.debug("[Monitor] JMXMP connector started, url=" + this.addr);
            String portFileName = this._instanceVarDir + File.separator + "log" + File.separator + "xmppd.jmx";
            try {
                File portFile = new File(portFileName);
                if (portFile.exists()) {
                    portFile.delete();
                }
                portFile.createNewFile();
                portFile.deleteOnExit();
                PrintWriter portOutput = new PrintWriter((Writer)new FileWriter(portFile), true);
                String portLine = this.addr.toString().substring(this.addr.toString().lastIndexOf(":") + 1);
                portOutput.println(portLine);
                portOutput.close();
                Log.debug("[Monitor] created JMX port file: " + portFileName + " containing " + portLine);
            }
            catch (Exception e) {
                Log.error("[Monitor] could not open JMX port file: " + portFileName);
                Log.printStackTrace(e);
            }
            this.xmppStatusMetrics = new MfStatus();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public MonitorTransactionFactory getTransactionFactory(String name) throws Exception {
        return new MonitorTransactionFactoryImpl(name);
    }

    public void starting() {
        try {
            this.mbs.registerMBean(this.xmppStatusMetrics, MfObjectNameFactory.getStatusName());
            Log.info("[Monitor] Setting system operational status to STARTING");
            this.xmppStatusMetrics.setOperationalState(0);
            this.xmppStatusMetrics.setOpsStateLastChange(System.currentTimeMillis());
            this.xmppmgt = new MfInstrumManagement();
            this.mbs.registerMBean(this.xmppmgt, MfObjectNameFactory.getInstrumManagementName());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        String userData = "rmi://localhost/XMPP";
        try {
            MfDiscoveryResponder resp = new MfDiscoveryResponder("XMPP", this.instance, this.addr.toString(), userData.getBytes("US-ASCII"));
            Log.debug("[Monitor] Discovery responder = " + resp);
        }
        catch (IOException ioe) {
            Log.printStackTrace(ioe);
        }
        catch (RuntimeException e) {
            Log.debug("[Monitor] The following exception is normal...");
            Log.printStackTrace(e);
        }
        Log.debug("[Monitor] Sucessfully created the discovery mechanism");
    }

    public void stopping() {
        Log.info("[Monitor] Setting operational status to STOPPING");
        this.xmppStatusMetrics.setOperationalState(2);
        this.xmppStatusMetrics.setOpsStateLastChange(System.currentTimeMillis());
    }

    public void stopped() {
        Log.info("[Monitor] Setting operational status to STOPPED");
        this.xmppStatusMetrics.setOperationalState(3);
        this.xmppStatusMetrics.setOpsStateLastChange(System.currentTimeMillis());
    }

    public void running() {
        Log.info("[Monitor] Setting operational status to RUNNING");
        this.xmppStatusMetrics.setOperationalState(1);
        this.xmppStatusMetrics.setOpsStateLastChange(System.currentTimeMillis());
        this.xmppStatusMetrics.setRunningTime(System.currentTimeMillis());
        this.xmppStatusMetrics.setAvailabilityState(5);
        this.xmppStatusMetrics.setAvailStateLastChange(System.currentTimeMillis());
    }

    private static void sleep(int t) {
        try {
            Thread.sleep(t);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    class MonitorTransactionImpl
    implements MonitorTransaction {
        MfTransaction transaction = null;

        MonitorTransactionImpl(MfTransactionDefinition def, MfTransactionFactory fac) {
            this.transaction = fac.newTransaction(def, null);
            this.transaction.start();
        }

        public void stop(boolean success) {
            this.transaction.stop(success ? 0 : 2);
        }

        public void hold() {
            this.transaction.block();
        }

        public void resume() {
            this.transaction.unblock();
        }
    }

    class MonitorTransactionFactoryImpl
    implements MonitorTransactionFactory {
        MfTransactionDefinition transactionDef;
        MfTransactionFactory tranFactory = new MfTransactionFactoryImpl();

        MonitorTransactionFactoryImpl(String name) throws Exception {
            Log.info("[Monitor] Creating new transaction factory: " + name);
            MfTransactionMetrics serviceMetrics = new MfTransactionMetrics();
            MonitorImpl.this.mbs.registerMBean(serviceMetrics, MfObjectNameFactory.getTransactionMetricsName((String)name));
            serviceMetrics.setOperationalState(1);
            serviceMetrics.setOpsStateLastChange(System.currentTimeMillis());
            serviceMetrics.setAvailabilityState(5);
            serviceMetrics.setAvailStateLastChange(System.currentTimeMillis());
            this.transactionDef = this.tranFactory.newTransactionDefinition(name, "localhost://" + name, serviceMetrics);
        }

        public MonitorTransaction startTransaction() {
            try {
                return new MonitorTransactionImpl(this.transactionDef, this.tranFactory);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                return null;
            }
        }
    }
}

