/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Email;
import com.iplanet.im.server.Log;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.TimeoutException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.security.cert.X509Certificate;

public class Monitor
implements Runnable,
SecureSessionListener {
    long period;
    String service;
    String uid;
    String password;
    String exception;
    boolean raiseTimeout;

    public Monitor(long period, boolean raiseTimeout, String service, String uid, String password) {
        this.period = period > 10000L ? period : 10000L;
        this.service = service;
        this.uid = uid;
        this.password = password;
        this.raiseTimeout = raiseTimeout;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        while (true) {
            this.exception = null;
            try {
                Thread.sleep(this.period);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                fac = new CollaborationSessionFactory();
                s = fac.getSession(this.service, this.uid, this.password, (CollaborationSessionListener)this);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (s != null) {
                    s.logout();
                }
                fac.close();
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof TimeoutException) || this.raiseTimeout) ** break;
                continue;
                w = new StringWriter();
                writer = new PrintWriter((Writer)w, true);
                e.printStackTrace(writer);
                this.exception = w.toString();
                return;
            }
            break;
        }
    }

    public String getException() {
        return this.exception;
    }

    public boolean onX509Certificate(X509Certificate[] chain) {
        return true;
    }

    public void onError(CollaborationException e) {
    }

    public static void usage() {
        System.out.println("Usage: java com.iplanet.im.server.Monitor [options]");
        System.out.println("Options:");
        System.out.println("  --help|-h       // prints help");
        System.out.println("  --ssl           // use SSL");
        System.out.println("  --raisetimeout  // do not ignore timeout exceptions");
        System.out.println("  --server|-s <host:port>");
        System.out.println("  --mail|-m <valid email address for alerts>");
        System.out.println("  --time|-t <sampling period in seconds. default=120>");
        System.out.println("  --factory|-f <session provider class>");
    }

    public static void main(String[] arg) {
        try {
            long period = 120000L;
            String service = null;
            String mail = null;
            boolean raiseTimeout = false;
            Log.setLogLevel(0);
            System.setProperty("com.sun.im.service.CollaborationSessionFactory", "com.iplanet.im.client.api.iIMSecondarySessionFactory");
            for (int i = 0; i < arg.length; ++i) {
                if (arg[i].equalsIgnoreCase("--factory")) {
                    System.setProperty("com.sun.im.service.CollaborationSessionFactory", arg[++i]);
                    continue;
                }
                if (arg[i].equalsIgnoreCase("--mail") || arg[i].equalsIgnoreCase("-m")) {
                    mail = arg[++i];
                    continue;
                }
                if (arg[i].equalsIgnoreCase("--raisetimeout")) {
                    raiseTimeout = true;
                    continue;
                }
                if (arg[i].equalsIgnoreCase("--ssl")) {
                    System.setProperty("com.sun.im.service.CollaborationSessionFactory", "com.iplanet.im.client.api.iIMSecureSecondarySessionFactory");
                    continue;
                }
                if (arg[i].equalsIgnoreCase("--help") || arg[i].equalsIgnoreCase("-h")) {
                    Monitor.usage();
                    System.exit(0);
                    continue;
                }
                if (arg[i].equalsIgnoreCase("--debug") || arg[i].equalsIgnoreCase("-d")) {
                    System.setProperty("com.iplanet.im.client.api.debug", "true");
                    Log.setLogLevel(5);
                    continue;
                }
                if (arg[i].equalsIgnoreCase("--time") || arg[i].equalsIgnoreCase("-t")) {
                    period = Long.parseLong(arg[++i]) * 1000L;
                    continue;
                }
                if (!arg[i].equalsIgnoreCase("--server") && !arg[i].equalsIgnoreCase("-s")) continue;
                service = arg[++i];
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            if (mail == null) {
                System.out.print("alert email address: ");
                mail = reader.readLine();
            }
            if (service == null) {
                System.out.print("IM server/port: ");
                service = reader.readLine();
            }
            System.out.print("login: ");
            String user = reader.readLine();
            System.out.print("password: ");
            String password = reader.readLine();
            String host = "localhost";
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception ne) {
                // empty catch block
            }
            String from = System.getProperty("user.name") + "@" + host;
            while (true) {
                Monitor monitor = new Monitor(period, raiseTimeout, service, user, password);
                Thread t = new Thread(monitor);
                t.start();
                t.join();
                System.out.println("Monitor has returned - send alert email to " + mail);
                Email.send(from, "IM Server Monitor", mail, "IM server outage: " + service, monitor.getException(), false, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

