/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.util.LazyDate;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.varia.NullAppender;

public class Log {
    public static final int FATAL_ERROR = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTICE = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    public static String[] desc = new String[]{"FATAL", "ERROR", "WARNING", "NOTICE", "INFO", "DEBUG"};
    public static Level[] log4jLevel = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.INFO, Level.DEBUG};
    private static Log inst;
    private static boolean _snoop;
    int logLevel;
    PrintStream os;
    Calendar calendar = Calendar.getInstance();
    String[] shortMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    Logger logger = null;
    Logger jsoLogger = null;
    Logger xferLogger = null;
    boolean xferOn = false;
    public static final String LOG4JCONFIG = "iim.log4j.config";
    public static final String INSTANCEDIR = "iim.instancedir";
    public static final String INSTANCEVARDIR = "iim.instancevardir";
    public static final String LOGURL = "iim.log.url";
    public static final String LOGLEVEL = "iim.log.severity";
    public static final String MAXLOGSIZE = "iim.log.maxlogsize";
    public static final String MAXBACKUPS = "iim.log.maxbackups";
    public static final String PREFIX = "iim.log.";
    public static final String MAXLOGSIZE_SUFFIX = ".maxlogsize";
    public static final String LOGLEVEL_SUFFIX = ".severity";
    public static final String MAXBACKUPS_SUFFIX = ".maxbackups";
    public static final String LOGURL_SUFFIX = ".url";
    public static final String JSO_LOGLEVEL = "iim.log.jso.severity";
    public static final String SNOOP = "iim.log.snoop";

    public static void init() {
        Log.init("iim_server");
    }

    public static void init(boolean enableXfer) {
        Log.init("iim_server", enableXfer);
    }

    public static void init(String component) {
        Log.init(component, false);
    }

    public static void init(String component, boolean enableXfer) {
        inst = new Log();
        ServerConfig sc = ServerConfig.getServerConfig();
        Log.inst.jsoLogger = LogManager.getRootLogger();
        Log.inst.logger = component.equals("iim_server") ? LogManager.getLogger((String)"xmppd") : LogManager.getLogger((String)component);
        String instanceVarDir = sc.getSetting(INSTANCEVARDIR, ".");
        String baseDir = sc.getSetting(INSTANCEDIR);
        String log4jConfig = sc.getSetting(LOG4JCONFIG);
        log4jConfig = baseDir + File.separator + "config" + File.separator + log4jConfig;
        String xferFilename = null;
        if (log4jConfig != null && new File(log4jConfig).exists()) {
            new PropertyConfigurator();
            PropertyConfigurator.configure((String)log4jConfig);
            Log.inst.xferOn = true;
            Log.inst.xferLogger = LogManager.getLogger((String)"xmppd.xfer");
        } else {
            String sLevel;
            String filename = sc.getSetting(PREFIX + component + LOGURL_SUFFIX);
            if (filename == null) {
                filename = sc.getSetting(LOGURL);
            }
            if (filename == null) {
                filename = component.equals("iim_server") ? instanceVarDir + File.separator + "log" + File.separator + "xmppd.log" : instanceVarDir + File.separator + "log" + File.separator + component + ".log";
            }
            if (enableXfer && (xferFilename = sc.getSetting("iim.log.xfer.url")) == null) {
                xferFilename = instanceVarDir + File.separator + "log" + File.separator + "xfer.log";
            }
            if ((sLevel = sc.getSetting(PREFIX + component + LOGLEVEL_SUFFIX)) == null || sLevel.trim().length() == 0) {
                sLevel = sc.getSetting(LOGLEVEL, "ERROR").trim();
            }
            Log.setLogLevel(sLevel);
            if (enableXfer) {
                Log.inst.xferOn = true;
                Log.inst.xferLogger = LogManager.getLogger((String)"xmppd.xfer");
            }
            sLevel = sc.getSetting(JSO_LOGLEVEL, "ERROR").trim();
            Log.setJSOLogLevel(sLevel);
            String sLogSize = sc.getSetting(PREFIX + component + MAXLOGSIZE_SUFFIX);
            if (sLogSize == null) {
                sLogSize = sc.getSetting(MAXLOGSIZE);
            }
            if (sLogSize == null) {
                sLogSize = "1000000";
            }
            long maxSize = 0x100000L;
            try {
                maxSize = Long.parseLong(sLogSize.trim());
            }
            catch (Exception e) {
                // empty catch block
            }
            int maxBackups = 7;
            String sMaxBackups = sc.getSetting(MAXBACKUPS, "7").trim();
            sMaxBackups = sc.getSetting(PREFIX + component + MAXBACKUPS_SUFFIX, sMaxBackups).trim();
            try {
                maxBackups = Integer.parseInt(sMaxBackups);
            }
            catch (Exception e) {
                // empty catch block
            }
            PatternLayout layout = new PatternLayout("%d{HH:mm:ss,SSS} %-5p %c [%t] %m%n");
            if (!filename.equalsIgnoreCase("stdout")) {
                try {
                    File f = new File(filename);
                    File dir = f.getParentFile();
                    if (dir != null && !dir.exists()) {
                        dir.mkdirs();
                    }
                    Log.inst.os = new PrintStream(new FileOutputStream(filename, true));
                    RollingFileAppender appender = new RollingFileAppender((Layout)layout, filename, true);
                    appender.setMaximumFileSize(maxSize);
                    appender.setMaxBackupIndex(maxBackups);
                    Log.inst.logger.addAppender((Appender)appender);
                    Log.inst.jsoLogger.addAppender((Appender)new NullAppender());
                }
                catch (Exception e) {
                    Log.error("unable to create log file");
                }
            } else {
                Log.inst.os = System.out;
                ConsoleAppender appender = new ConsoleAppender((Layout)layout);
                Log.inst.logger.addAppender((Appender)appender);
                Log.inst.jsoLogger.addAppender((Appender)appender);
            }
        }
        try {
            _snoop = StringUtility.getBoolean((String)sc.getSetting(SNOOP, "false"));
            if (_snoop) {
                Log.info("Snoop is ON");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static boolean snoop() {
        return _snoop;
    }

    public static File rollover(File f) {
        String path = f.getPath();
        Calendar cal = Calendar.getInstance();
        String ext = "." + cal.get(13) + cal.get(12) + cal.get(10) + cal.get(5) + cal.get(2) + cal.get(1);
        File newFile = new File(path + ext);
        f.renameTo(newFile);
        return new File(path);
    }

    private Log() {
    }

    public static void setLogLevel(int level) {
        if (level < desc.length && level >= 0) {
            Log.inst.logLevel = level;
            Log.inst.logger.setLevel(log4jLevel[level]);
        } else {
            Log.error("unknown log level: " + level);
        }
    }

    public static void setLogLevel(String level) {
        for (int i = 0; i < desc.length; ++i) {
            if (!desc[i].equalsIgnoreCase(level)) continue;
            Log.inst.logLevel = i;
            Log.inst.logger.setLevel(log4jLevel[i]);
            return;
        }
        Log.error("unknown log level: " + level);
    }

    public static void setJSOLogLevel(String level) {
        for (int i = 0; i < desc.length; ++i) {
            if (!desc[i].equalsIgnoreCase(level)) continue;
            Log.inst.jsoLogger.setLevel(log4jLevel[i]);
            return;
        }
        Log.error("unknown log level: " + level);
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    private void addDate(Date d, StringBuffer sbuf) {
        this.calendar.setTime(d);
        int day = this.calendar.get(5);
        if (day < 10) {
            sbuf.append('0');
        }
        sbuf.append(day);
        sbuf.append('/');
        sbuf.append(this.shortMonths[this.calendar.get(2)]);
        sbuf.append('/');
        int year = this.calendar.get(1);
        sbuf.append(year);
        sbuf.append(':');
        int hour = this.calendar.get(11);
        if (hour < 10) {
            sbuf.append('0');
        }
        sbuf.append(hour);
        sbuf.append(':');
        int mins = this.calendar.get(12);
        if (mins < 10) {
            sbuf.append('0');
        }
        sbuf.append(mins);
        sbuf.append(':');
        int secs = this.calendar.get(13);
        if (secs < 10) {
            sbuf.append('0');
        }
        sbuf.append(secs);
        sbuf.append(' ');
        int minutes = (this.calendar.get(15) + this.calendar.get(16)) / 1000 / 60;
        int hours = minutes / 60;
        minutes -= hours * 60;
        if (hours > 0) {
            sbuf.append("+");
        } else {
            sbuf.append("-");
        }
        hours = Math.abs(hours);
        if (hours < 10) {
            sbuf.append('0');
        }
        sbuf.append(hours);
        minutes = Math.abs(minutes);
        if (minutes < 10) {
            sbuf.append('0');
        }
        sbuf.append(minutes);
    }

    private void println(int level, String msg) {
        Date d = LazyDate.getDate();
        StringBuffer out = new StringBuffer("[");
        this.addDate(d, out);
        out.append("] ");
        out.append(desc[level]);
        out.append(": ");
        out.append(msg);
        this.os.println(out.toString());
    }

    public static void printStackTrace(Exception e) {
        Log.inst.logger.debug((Object)e.getMessage(), (Throwable)e);
    }

    public static void printStackTrace(String msg, Exception e) {
        Log.inst.logger.debug((Object)msg, (Throwable)e);
    }

    public static void debug(String msg) {
        Log.inst.logger.debug((Object)msg);
    }

    public static void notice(String msg) {
        Log.inst.logger.info((Object)msg);
    }

    public static void error(String msg) {
        Log.inst.logger.error((Object)msg);
    }

    public static void fatal(String msg) {
        Log.inst.logger.fatal((Object)msg);
    }

    public static void warning(String msg) {
        Log.inst.logger.warn((Object)msg);
    }

    public static void info(String msg) {
        Log.inst.logger.info((Object)msg);
    }

    public static void xfer(String msg) {
        if (Log.inst.xferOn) {
            Log.inst.xferLogger.debug((Object)msg);
        }
    }

    static {
        _snoop = false;
    }
}

