/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.FileGroupChatStorage;
import com.iplanet.im.server.FileNewsStorage;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.IdentityRealm;
import com.iplanet.im.server.LDAPPool;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.SearchReply;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.UserSettings;
import com.sun.im.identity.util.Auth;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.provider.NewsStorageProvider;
import com.sun.im.provider.PolicyProvider;
import com.sun.im.provider.Realm;
import com.sun.im.provider.RealmException;
import com.sun.im.provider.RealmSearchResults;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPRealm
implements Realm {
    private static final String rootConfigName = "iim_ldap.searchbase";
    private static final String serverConfigName = "iim_ldap.host";
    private static final String usesslConfigName = "iim_ldap.usessl";
    private static final String groupSearchFilterName = "iim_ldap.groupbrowsefilter";
    private static final String userSearchFilterName = "iim_ldap.userbrowsefilter";
    private static final String searchByIDFilterName = "iim_ldap.usergroupbyidsearchfilter";
    private static final String searchByNameFilterName = "iim_ldap.usergroupbynamesearchfilter";
    private static final String searchByMailFilterName = "iim_ldap.usergroupbymailsearchfilter";
    private static final String allowWildCardInIdName = "iim_ldap.allowwildcardinuid";
    private static final String loginFilterName = "iim_ldap.loginfilter";
    private static final String userClassName = "iim_ldap.userclass";
    private static final String groupClassName = "iim_ldap.groupclass";
    private static final String groupDisplayAttrName = "iim_ldap.groupdisplay";
    private static final String userAttributesName = "iim_ldap.user.attributes";
    private static final String groupAttributesName = "iim_ldap.group.attributes";
    private static final String userDisplayAttrName = "iim_ldap.userdisplay";
    private static final String userUIDAttrName = "iim_ldap.useruidattr";
    private static final String groupMemberAttrName = "iim_ldap.groupmemberattr";
    private static final String userMailAttrName = "iim_ldap.usermailattr";
    private static final String userPasswordAttrName = "iim_ldap.userpasswordattr";
    private static final String groupMemberURLAttrName = "iim_ldap.groupmemberurlattr";
    private static final String roleFilterAttrName = "iim_ldap.rolefilterattr";
    private static final String roleDNAttrName = "iim_ldap.rolednattr";
    private static final String managedRoleObjectClassName = "iim_ldap.managedroleobjectclass";
    private static final String searchLimitName = "iim_ldap.searchlimit";
    private static final String ignoreDomainsName = "iim_ldap.ignoredomains";
    private static final String groupSearchFilterDef = "(objectclass=groupofuniquenames)";
    private static final String userSearchFilterDef = "(objectclass=inetorgperson)";
    private static final String searchByIDFilterDef = "(|(&(objectclass=groupofuniquenames)(uid={0}))(&(objectclass=inetorgperson)(uid={0})))";
    private static final String searchByMailFilterDef = "(|(&(objectclass=groupofuniquenames)(mail={0}))(&(objectclass=inetorgperson)(mail={0})))";
    private static final String searchByNameFilterDef = "(|(&(objectclass=groupofuniquenames)(cn={0}))(&(objectclass=inetorgperson)(cn={0})))";
    private static final String loginFilterDef = "(&(objectclass=inetorgperson)(uid={0}))";
    private static final String userClassDef = "inetOrgPerson";
    private static final String groupClassDef = "groupOfUniqueNames";
    private static final String orgDepthName = "iim_ldap.orgdepth";
    private static final String groupDisplayAttrDef = "cn";
    private static final String userDisplayAttrDef = "cn";
    private static final String userUIDAttrDef = "uid";
    private static final String userMailAttrDef = "mail";
    private static final String userPasswordAttrDef = "userpassword";
    private static final String groupMemberAttrDef = "uniquemember";
    private static final String groupMemberURLAttrDef = "memberurl";
    private static final String managedRoleObjectClassDef = "nsManagedRoleDefinition";
    private static final String roleFilterAttrDef = "nsRoleFilter";
    private static final String roleDNAttrDef = "nsRoleDN";
    private static final String userDomainAttrDef = "sunPreferredDomain";
    private static int _orgDepth = 0;
    private String[] userAttributeArray = null;
    private String[] groupAttributeArray = null;
    private String[] userGroupAttributeArray = null;
    String root = "";
    boolean _ignoreDomains = false;
    private String server = "";
    private int searchLimit = 40;
    private String groupSearchFilter = "(objectclass=groupofuniquenames)";
    private String userSearchFilter = "(objectclass=inetorgperson)";
    private String loginFilter = "(&(objectclass=inetorgperson)(uid={0}))";
    private String searchByNameFilter = "(|(&(objectclass=groupofuniquenames)(cn={0}))(&(objectclass=inetorgperson)(cn={0})))";
    private String searchByIDFilter = "(|(&(objectclass=groupofuniquenames)(uid={0}))(&(objectclass=inetorgperson)(uid={0})))";
    private String searchByMailFilter = "(|(&(objectclass=groupofuniquenames)(mail={0}))(&(objectclass=inetorgperson)(mail={0})))";
    private ArrayList userClass = new ArrayList();
    private ArrayList groupClass = new ArrayList();
    private boolean allowWildCardInId = false;
    String groupDisplayAttr = "cn";
    String userDisplayAttr = "cn";
    String userUIDAttr = "uid";
    String userMailAttr = "mail";
    String userPasswordAttr = "userpassword";
    String groupMemberAttr = "uniquemember";
    String groupMemberURLAttr = "memberurl";
    String roleFilterAttr = "nsRoleFilter";
    String roleDNAttr = "nsRoleDN";
    private String managedRoleObjectClass = "nsManagedRoleDefinition";
    int authcount;
    LDAPPool ldap = LDAPPool.getDefault();
    boolean _usessl = false;
    HashSet userAttributeSet = new HashSet(7);
    HashSet groupAttributeSet = new HashSet(7);
    Attributes _regisAttributes;
    boolean _regisEnabled = false;
    static String REGISTRATION_PROPERTIES = "registration.properties";
    static String regisEnableName = "iim.register.enable";
    static String regisBaseName = "iim_ldap.register.basedn";
    static String regisDomainName = "iim_ldap.register.domain";
    Name _regisBase;
    String _regisDomain;
    private static PolicyProvider _policyProvider = null;

    public LDAPRealm() throws RealmException, FileNotFoundException, IOException {
        String t;
        Iterator i;
        ServerConfig sc = ServerConfig.getServerConfig();
        this.root = LDAPRealm.removeSpaces(sc.getSetting(rootConfigName, ""));
        this.server = sc.getSetting(serverConfigName, "");
        this.groupSearchFilter = sc.getSetting(groupSearchFilterName, groupSearchFilterDef);
        this.userSearchFilter = sc.getSetting(userSearchFilterName, userSearchFilterDef);
        this.loginFilter = sc.getSetting(loginFilterName, loginFilterDef);
        this.searchByIDFilter = sc.getSetting(searchByIDFilterName, searchByIDFilterDef);
        this.searchByMailFilter = sc.getSetting(searchByMailFilterName, searchByMailFilterDef);
        this.searchByNameFilter = sc.getSetting(searchByNameFilterName, searchByNameFilterDef);
        try {
            this._usessl = StringUtility.getBoolean((String)sc.getSetting(usesslConfigName, "false"));
        }
        catch (Exception se) {
            // empty catch block
        }
        String vals = sc.getSetting(userClassName, userClassDef);
        StringTokenizer st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.userClass.add(st.nextToken().toLowerCase());
        }
        vals = sc.getSetting(groupClassName, groupClassDef);
        st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.groupClass.add(st.nextToken().toLowerCase());
        }
        int ix = 0;
        this.userDisplayAttr = sc.getSetting(userDisplayAttrName, "cn");
        this.userAttributeSet.add(this.userDisplayAttr);
        this.userUIDAttr = sc.getSetting(userUIDAttrName, userUIDAttrDef);
        this.userAttributeSet.add(this.userUIDAttr);
        this.userMailAttr = sc.getSetting(userMailAttrName, userMailAttrDef);
        this.userAttributeSet.add(this.userMailAttr);
        this.userPasswordAttr = sc.getSetting(userPasswordAttrName, userPasswordAttrDef);
        vals = sc.getSetting(userAttributesName, "");
        st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.userAttributeSet.add(st.nextToken().toLowerCase());
        }
        if (NMS.getPropStore() != 1) {
            this.userAttributeArray = new String[this.userAttributeSet.size()];
            i = this.userAttributeSet.iterator();
            while (i.hasNext()) {
                this.userAttributeArray[ix++] = (String)i.next();
            }
        }
        this.groupMemberAttr = sc.getSetting(groupMemberAttrName, groupMemberAttrDef);
        this.groupAttributeSet.add(this.groupMemberAttr);
        this.groupDisplayAttr = sc.getSetting(groupDisplayAttrName, "cn");
        this.groupAttributeSet.add(this.groupDisplayAttr);
        this.groupMemberURLAttr = sc.getSetting(groupMemberURLAttrName, groupMemberURLAttrDef);
        this.groupAttributeSet.add(this.groupMemberURLAttr);
        this.roleFilterAttr = sc.getSetting(roleFilterAttrName, roleFilterAttrDef);
        this.roleDNAttr = sc.getSetting(roleDNAttrName, roleDNAttrDef);
        this.managedRoleObjectClass = sc.getSetting(managedRoleObjectClassName, managedRoleObjectClassDef);
        vals = sc.getSetting(groupAttributesName, "");
        st = new StringTokenizer(vals, ",");
        while (st.hasMoreTokens()) {
            this.groupAttributeSet.add(st.nextToken().toLowerCase());
        }
        this.groupAttributeArray = new String[this.groupAttributeSet.size()];
        ix = 0;
        i = this.groupAttributeSet.iterator();
        while (i.hasNext()) {
            this.groupAttributeArray[ix++] = (String)i.next();
        }
        this.userAttributeSet.addAll(this.groupAttributeSet);
        this.userAttributeSet.add("objectclass");
        this.userGroupAttributeArray = new String[this.userAttributeSet.size()];
        ix = 0;
        i = this.userAttributeSet.iterator();
        while (i.hasNext()) {
            this.userGroupAttributeArray[ix++] = (String)i.next();
        }
        String tsearchLimit = sc.getSetting(searchLimitName);
        if (tsearchLimit != null && tsearchLimit.length() != 0) {
            this.searchLimit = Integer.parseInt(tsearchLimit);
        }
        if ((t = sc.getSetting(allowWildCardInIdName, "false")).equalsIgnoreCase("true")) {
            this.allowWildCardInId = true;
        }
        if ((vals = sc.getSetting(orgDepthName)) != null && vals.length() > 0) {
            _orgDepth = Integer.parseInt(vals);
        }
        this._ignoreDomains = StringUtility.getBoolean((String)sc.getSetting(ignoreDomainsName, "false"), (boolean)false);
        this._regisEnabled = StringUtility.getBoolean((String)sc.getSetting(regisEnableName, "false"));
        if (this._regisEnabled) {
            try {
                vals = sc.getSetting(regisBaseName, null);
                if (vals != null && vals.length() > 0) {
                    NameParser parser = this.ldap.getContext().getNameParser(this.root);
                    this._regisBase = parser.parse(vals);
                } else {
                    Log.error("[LDAP] cannot initialize registration - missing registration base (iim_ldap.register.basedn)");
                    this._regisEnabled = false;
                }
                this._regisDomain = sc.getSetting(regisDomainName, NMS.getName());
                if (this._regisDomain == null || "".equals(this._regisDomain)) {
                    // empty if block
                }
                this._regisAttributes = new BasicAttributes(true);
                Properties props = new Properties();
                FileInputStream is = new FileInputStream(NMS.getConfigDir() + File.separator + REGISTRATION_PROPERTIES);
                props.load(is);
                is.close();
                Iterator<Map.Entry<Object, Object>> i2 = props.entrySet().iterator();
                while (i2.hasNext()) {
                    Map.Entry<Object, Object> entry = i2.next();
                    BasicAttribute a = new BasicAttribute((String)entry.getKey());
                    st = new StringTokenizer((String)entry.getValue(), ",");
                    while (st.hasMoreTokens()) {
                        a.add(st.nextToken().trim());
                    }
                    this._regisAttributes.put(a);
                }
            }
            catch (Exception e) {
                Log.debug("[LDAP] failed to initialize registration: " + e.getMessage());
                Log.printStackTrace(e);
                this._regisEnabled = false;
            }
        }
    }

    public void stop() {
        this.ldap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollaborationPrincipal[] expandGroup(CollaborationPrincipal principal, CollaborationGroup nlg) throws RealmException {
        boolean retry = false;
        String uid = ((NMSGroup)nlg).getDistinguishedName();
        uid = LDAPRealm.removeSpaces(uid);
        String errorMessage = null;
        CollaborationPrincipal[] res = null;
        DirContext dc = null;
        try {
            Attribute attr;
            dc = this.ldap.getContext();
            Attributes attrs = dc.getAttributes(uid, this.groupAttributeArray);
            LinkedList<String> v = new LinkedList<String>();
            if (attrs != null && (attr = attrs.get(this.groupMemberAttr)) != null) {
                NamingEnumeration<?> e = attr.getAll();
                while (e != null && e.hasMore()) {
                    Object s = e.next();
                    v.add(LDAPRealm.removeSpaces(s.toString()));
                }
            }
            if (v.size() > 0) {
                res = new IMPrincipal[v.size()];
            }
            int n = 0;
            Iterator i = v.iterator();
            while (i.hasNext()) {
                CollaborationPrincipal u = this.getPrincipal(principal, (String)i.next());
                res[n++] = u;
            }
            CollaborationPrincipal[] collaborationPrincipalArray = res;
            return collaborationPrincipalArray;
        }
        catch (CommunicationException e) {
            Log.printStackTrace(e);
            errorMessage = "[LDAP] expandGroup(" + uid + "):" + e.toString();
            try {
                dc.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
            dc = null;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            errorMessage = "[LDAP] expandGroup(" + uid + "):" + e.toString();
        }
        finally {
            this.ldap.recycleContext(dc);
        }
        Log.error(errorMessage);
        throw new RealmException(errorMessage);
    }

    private NMSGroup createGroup(Attributes attrs, String name, String domain) throws NamingException, RealmException {
        String displayname = name;
        Attribute attr = attrs.get(this.groupDisplayAttr);
        if (attr != null) {
            displayname = attr.get().toString();
        } else {
            Log.info("[LDAP] " + name + " has no value for " + this.groupDisplayAttr);
        }
        String filter = null;
        String scope = this.getSearchBase(domain);
        attr = attrs.get(this.groupMemberURLAttr);
        if (attr != null && (filter = attr.get().toString()).startsWith("ldap:")) {
            try {
                String[] s = LDAPRealm.parseLDAPURL(filter, this.root);
                scope = s[0];
                filter = s[1];
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                filter = null;
            }
        }
        if (filter == null && (attr = attrs.get(this.roleFilterAttr)) != null) {
            filter = "(" + attr.get().toString() + ")";
        }
        if (filter == null && (attr = attrs.get("objectclass")) != null && attr.contains(this.managedRoleObjectClass)) {
            filter = "(" + this.roleDNAttr + "=" + name + ")";
        }
        NMSGroup g = null;
        if (filter != null) {
            if (filter.length() > 0 && !filter.startsWith("(")) {
                filter = "(" + filter + ")";
            }
            filter = "(&" + filter + this.userSearchFilter + ")";
            Log.debug("[LDAP] Found dynamic group: " + displayname + " <" + name + "> " + filter);
            g = new NMSGroup(name, domain, displayname, filter, scope);
        } else {
            Log.debug("[LDAP] Found static group: " + displayname + " <" + name + ">");
            g = new NMSGroup(name, domain, displayname);
        }
        LDAPRealm.setAttributes(g, attrs);
        return g;
    }

    private LocalUser createUser(Attributes attrs, String defaultUid, String domain) throws NamingException {
        String uid = defaultUid;
        Attribute attr = attrs.get(this.userUIDAttr);
        if (attr != null) {
            uid = attr.get().toString();
        }
        if (uid == null) {
            Log.error("[LDAP] Cannot find a UID attribute for user " + uid);
            return null;
        }
        String displayName = null;
        attr = attrs.get(this.userDisplayAttr);
        if (attr != null) {
            displayName = attr.get().toString().trim();
        }
        String mail = null;
        attr = attrs.get(this.userMailAttr);
        if (attr != null) {
            mail = attr.get().toString().trim();
        }
        LocalUser u = new LocalUser(StringUtility.quoteSpecialCharacters((String)uid), domain, displayName, mail);
        u.setDistinguishedName(defaultUid);
        u.setAttribute("dn", defaultUid);
        LDAPRealm.setAttributes(u, attrs);
        return u;
    }

    public CollaborationGroup getGroup(CollaborationPrincipal principal, String dn) throws RealmException {
        return this.getGroup(this.getSearchBase(principal), dn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CollaborationGroup getGroup(String searchBase, String dn) throws RealmException {
        int retry = 0;
        while (retry < 2) {
            Log.debug("[LDAP] searching group : " + dn);
            DirContext dc = null;
            try {
                dc = this.ldap.getContext();
                Attributes attrs = dc.getAttributes(dn, this.groupAttributeArray);
                if (attrs != null) {
                    NMSGroup nMSGroup = this.createGroup(attrs, dn, this.getDomainName(searchBase));
                    return nMSGroup;
                }
                break;
            }
            catch (CommunicationException e) {
                Log.error("[LDAP] group get attributes failed: " + dn + " " + e);
                try {
                    dc.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
                dc = null;
                ++retry;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                Log.error("[LDAP] group get attributes failed: " + dn + " " + e);
                Log.printStackTrace(e);
                break;
            }
            finally {
                this.ldap.recycleContext(dc);
            }
        }
        return null;
    }

    public CollaborationPrincipal getPrincipal(CollaborationPrincipal principal, String uid) throws RealmException {
        return this.getPrincipal(this.getSearchBase(principal), uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollaborationPrincipal getPrincipal(String searchBase, String uid) throws RealmException {
        int i = uid.indexOf(61);
        if (i == -1) {
            String domain = StringUtility.getDomainFromAddress((String)uid, null);
            if (domain != null && domain.equalsIgnoreCase(this.getDomainName(searchBase))) {
                uid = StringUtility.getLocalPartFromAddress((String)uid);
            }
            String searchfor = StringUtility.replaceString((String)"{0}", (String)StringUtility.unquoteSpecialCharacters((String)uid), (String)this.loginFilter);
            int retry = 0;
            while (retry < 2) {
                DirContext dc2 = null;
                SearchControls con = new SearchControls();
                con.setSearchScope(2);
                con.setReturningAttributes(this.userAttributeArray);
                try {
                    SearchResult si;
                    Attributes attrs;
                    dc2 = this.ldap.getContext();
                    Log.debug("[LDAP] Searching for user by uid: filter=" + searchfor + " base=" + this.root);
                    NamingEnumeration<SearchResult> e = dc2.search(searchBase, searchfor, con);
                    if (e != null && e.hasMore() && (attrs = (si = e.next()).getAttributes()) != null) {
                        Log.debug("[LDAP] User found, uid=" + uid);
                        LocalUser localUser = this.createUser(attrs, this.getAbsoluteName(si, searchBase), this.getDomainName(searchBase));
                        return localUser;
                    }
                    break;
                }
                catch (CommunicationException e) {
                    Log.error("[LDAP] UID search failed: " + uid + " " + e);
                    try {
                        dc2.close();
                    }
                    catch (Exception ce) {
                        // empty catch block
                    }
                    dc2 = null;
                    ++retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception se) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    Log.error("UID search failed: " + uid + " " + e);
                    Log.printStackTrace(e);
                    break;
                }
                finally {
                    this.ldap.recycleContext(dc2);
                }
            }
        } else {
            int retry = 0;
            while (retry < 2) {
                DirContext dc = null;
                Log.debug("[LDAP] Getting displayname for user : " + uid);
                try {
                    dc = this.ldap.getContext();
                    Attributes attrs = dc.getAttributes(uid, this.userAttributeArray);
                    if (attrs != null) {
                        LocalUser dc2 = this.createUser(attrs, uid, this.getDomainName(searchBase));
                        return dc2;
                    }
                    break;
                }
                catch (CommunicationException e) {
                    Log.error("[LDAP] UID get attributes failed: " + uid + " " + e);
                    try {
                        dc.close();
                    }
                    catch (Exception ce) {
                        // empty catch block
                    }
                    dc = null;
                    ++retry;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception se) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                    Log.error("[LDAP] UID get attributes failed: " + uid + " " + e);
                    Log.printStackTrace(e);
                    break;
                }
                finally {
                    this.ldap.recycleContext(dc);
                }
            }
        }
        return null;
    }

    public RealmSearchResults search(CollaborationPrincipal principal, String pattern, int attributeType, String filter) throws RealmException {
        String base = this.getSearchBase(principal);
        return this.search(base, pattern, attributeType, filter);
    }

    public RealmSearchResults search(String base, String pattern, int attributeType, String filter) {
        String searchfor;
        if (this.searchLimit == -1) {
            return new SearchReply(4, null);
        }
        switch (attributeType) {
            case 2: {
                if (!this.allowWildCardInId) {
                    pattern = StringUtility.replaceString((String)"*", (String)"", (String)pattern);
                }
                searchfor = StringUtility.replaceString((String)"{0}", (String)pattern, (String)this.searchByIDFilter);
                break;
            }
            case 4: {
                if (!this.allowWildCardInId) {
                    pattern = StringUtility.replaceString((String)"*", (String)"", (String)pattern);
                }
                searchfor = StringUtility.replaceString((String)"{0}", (String)pattern, (String)this.searchByMailFilter);
                break;
            }
            default: {
                searchfor = StringUtility.replaceString((String)"{0}", (String)pattern, (String)this.searchByNameFilter);
            }
        }
        if (filter != null && filter.length() > 0) {
            searchfor = "(&" + filter + searchfor + ")";
        }
        return this.search(searchfor, base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RealmSearchResults search(String searchFilter, String baseDN) {
        String base = baseDN;
        if (base == null) {
            base = this.root;
        }
        int retry = 0;
        while (retry < 2) {
            DirContext dc = null;
            Vector<IMPrincipal> v = new Vector<IMPrincipal>();
            try {
                dc = this.ldap.getContext();
                SearchControls con = new SearchControls();
                con.setSearchScope(2);
                con.setReturningAttributes(this.userGroupAttributeArray);
                if (this.searchLimit > 0) {
                    con.setCountLimit(this.searchLimit);
                }
                Log.debug("[LDAP] Search: filter=" + searchFilter + " base=" + baseDN);
                NamingEnumeration<SearchResult> e2 = dc.search(baseDN, searchFilter, con);
                while (e2.hasMore()) {
                    boolean userentry = false;
                    boolean groupentry = false;
                    SearchResult si = e2.next();
                    Attributes attrs = si.getAttributes();
                    Attribute objectclass = attrs.get("objectclass");
                    NamingEnumeration<?> values = objectclass.getAll();
                    while (values != null && values.hasMore()) {
                        String attrvalue = values.next().toString().toLowerCase();
                        if (this.userClass.contains(attrvalue)) {
                            userentry = true;
                            break;
                        }
                        if (!this.groupClass.contains(attrvalue)) continue;
                        groupentry = true;
                        break;
                    }
                    if (userentry) {
                        v.add(this.createUser(attrs, this.getAbsoluteName(si, base), this.getDomainName(base)));
                        continue;
                    }
                    if (!groupentry) continue;
                    String uid = this.getAbsoluteName(si, base);
                    v.add(this.createGroup(attrs, uid, this.getDomainName(base)));
                }
                Object[] princ = new IMPrincipal[v.size()];
                v.copyInto(princ);
                SearchReply searchReply = new SearchReply(2, (IMPrincipal[])princ);
                return searchReply;
            }
            catch (InvalidSearchFilterException e) {
                SearchReply e2 = new SearchReply(3, null);
                return e2;
            }
            catch (LimitExceededException e) {
                Object[] princ = new IMPrincipal[v.size()];
                v.copyInto(princ);
                SearchReply searchReply = new SearchReply(1, (IMPrincipal[])princ);
                return searchReply;
            }
            catch (CommunicationException e) {
                Log.error("[LDAP] search failed: " + searchFilter + " " + e);
                try {
                    dc.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
                dc = null;
                ++retry;
            }
            catch (Exception e) {
                Log.warning("[LDAP] search failed: " + searchFilter + " " + e);
                SearchReply searchReply = new SearchReply(5, null);
                return searchReply;
            }
            finally {
                this.ldap.recycleContext(dc);
            }
        }
        return new SearchReply(5, null);
    }

    private String getAbsoluteName(SearchResult si, String searchBase) {
        if (searchBase == null) {
            searchBase = this.root;
        }
        if (si.isRelative()) {
            String relativeName = LDAPRealm.removeSpaces(si.getName());
            if (relativeName.endsWith("\"")) {
                return relativeName.substring(0, relativeName.length() - 1) + "," + searchBase + "\"";
            }
            return relativeName + "," + searchBase;
        }
        return LDAPRealm.removeSpaces(si.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDN(String uid) throws RealmException {
        String searchfor = StringUtility.replaceString((String)"{0}", (String)StringUtility.unquoteSpecialCharacters((String)uid), (String)this.loginFilter);
        int retry = 0;
        while (retry < 2) {
            String string;
            DirContext dc = null;
            SearchControls con = new SearchControls();
            con.setSearchScope(2);
            con.setReturningAttributes(null);
            try {
                dc = this.ldap.getContext();
                Log.debug("[LDAP] getDN: filter=" + searchfor + " base=" + this.root);
                NamingEnumeration<SearchResult> e = dc.search(this.root, searchfor, con);
                if (e != null && e.hasMore()) {
                    string = this.getAbsoluteName(e.next(), this.root);
                    return string;
                }
                string = null;
                return string;
            }
            catch (CommunicationException e) {
                Log.error("[LDAP] UID search failed: " + uid + " " + e);
                try {
                    dc.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
                dc = null;
                ++retry;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                Log.error("[LDAP] UID search failed: " + uid + " " + e);
                Log.printStackTrace(e);
                string = null;
                return string;
            }
            finally {
                this.ldap.recycleContext(dc);
            }
        }
        return null;
    }

    private boolean LDAPSimpleBindAuth(String dn, String possiblePass) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this._usessl) {
            env.put("java.naming.provider.url", "ldaps://" + this.server);
            env.put("java.naming.security.protocol", "ssl");
        } else {
            env.put("java.naming.provider.url", "ldap://" + this.server);
        }
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.principal", dn);
        env.put("java.naming.security.credentials", possiblePass);
        int retry = 0;
        InitialDirContext ctx = null;
        boolean ret = false;
        while (retry < 2) {
            try {
                ctx = new InitialDirContext(env);
                Log.debug("[LDAP] Success Authenticating user " + dn);
                ret = true;
                break;
            }
            catch (CommunicationException e) {
                Log.error("[LDAP] Error Authenticating " + dn + " - CommunicationException - " + e.getMessage());
            }
            catch (Exception e) {
                Log.error("[LDAP] Error Authenticating " + dn + " - " + e.getMessage());
            }
            ++retry;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        return ret;
    }

    boolean checkRequiredClass(LocalUser u, String uid) {
        Set objectClasses = u.getAttributeValues("objectclass");
        if (!objectClasses.contains("sunimuser") || !objectClasses.contains("sunpresenceuser")) {
            Log.info("[LDAP] " + uid + " does not have required objectclass for storing to ldap");
            return false;
        }
        return true;
    }

    public CollaborationPrincipal authenticate(String uid, String possiblePass) throws RealmException {
        if (possiblePass == null || possiblePass.equals("")) {
            return null;
        }
        if (uid.indexOf(42) >= 0) {
            Log.info("[LDAP] Invalid user Id: " + uid);
            return null;
        }
        Log.debug("[LDAP] Authenticating user " + uid);
        ++this.authcount;
        if (this.authcount % 1000 == 0) {
            System.gc();
            System.runFinalization();
        }
        LocalUser u = null;
        try {
            u = this.trySSO(uid, possiblePass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (u != null || SSO.getMode() == -1) {
            return u;
        }
        u = (LocalUser)this.getPrincipal(this.root, uid);
        if (u == null) {
            throw new RealmException("[LDAP] " + uid + " not found.");
        }
        try {
            if (this.LDAPSimpleBindAuth(u.getDistinguishedName(), possiblePass)) {
                if (NMS.getPropStore() == 1 && !this.checkRequiredClass(u, uid)) {
                    return null;
                }
                return u;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public LocalUser trySSO(String uid, String pass) {
        if (SSO.getMode() != 0) {
            try {
                HashMap attributes = new HashMap();
                if (SSO.verify(uid, pass, attributes, this.userAttributeSet)) {
                    String domain = null;
                    String orgDN = null;
                    if (this instanceof IdentityRealm) {
                        orgDN = Auth.getOrganizationDN((String)pass);
                        domain = this.getDomainName(orgDN);
                    } else {
                        domain = NMS.getName();
                    }
                    Object uda = attributes.get(this.userDisplayAttr);
                    String str_uda = uda instanceof Set ? StringUtility.getFirstAttr(uda) : (String)uda;
                    Object uma = attributes.get(this.userMailAttr);
                    String str_uma = uma instanceof Set ? StringUtility.getFirstAttr(uma) : (String)uma;
                    LocalUser u = new LocalUser(StringUtility.quoteSpecialCharacters((String)uid), domain, str_uda, str_uma);
                    u.setAttributes(attributes);
                    return u;
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        return null;
    }

    public static final String removeSpaces(String in) {
        int start = 0;
        int foundAt = in.indexOf(", ", start);
        if (foundAt < 0) {
            return in;
        }
        StringBuffer ret = new StringBuffer();
        do {
            ret.append(in.substring(start, foundAt));
            ret.append(",");
        } while ((foundAt = in.indexOf(", ", start = foundAt + 2)) >= 0);
        ret.append(in.substring(start));
        return ret.toString();
    }

    static void setAttributes(IMPrincipal p, Attributes attrs) {
        NamingEnumeration<? extends Attribute> namingEnumeration = attrs.getAll();
        while (namingEnumeration.hasMoreElements()) {
            Attribute attr = (Attribute)namingEnumeration.nextElement();
            String name = attr.getID();
            try {
                if (attr.size() == 1) {
                    String value = attr.get().toString();
                    if (value == null) continue;
                    p.setAttribute(name, value);
                    p.setAttribute(name.toLowerCase(), value);
                    continue;
                }
                if (attr.size() <= 1) continue;
                NamingEnumeration<?> e = attr.getAll();
                HashSet s = new HashSet();
                while (e != null && e.hasMore()) {
                    s.add(e.next());
                }
                p.setAttributeValues(name, s);
                p.setAttributeValues(name.toLowerCase(), s);
            }
            catch (NamingException e) {}
        }
    }

    static String[] parseLDAPURL(String url, String root) throws Exception {
        String[] result = new String[]{root, ""};
        int index = url.indexOf(47, 7);
        if (index >= 0) {
            int end = url.indexOf(63, index + 1);
            if (end >= 0) {
                result[0] = url.substring(index + 1, end);
                index = url.indexOf(63, end + 1);
                if (index >= 0 && (index = url.indexOf(63, index + 1)) >= 0) {
                    end = url.indexOf(63, index + 1);
                    result[1] = end > 0 ? url.substring(index + 1, end) : url.substring(index + 1);
                }
            } else {
                result[0] = url.substring(index + 1);
                if (result[0].length() < 3) {
                    result[0] = root;
                }
            }
        }
        return result;
    }

    public String getSearchBase(CollaborationPrincipal u) throws RealmException {
        if (_orgDepth == 0 || u == null) {
            return this.root;
        }
        DirContext dc = null;
        try {
            dc = this.ldap.getContext();
            NameParser parser = dc.getNameParser(this.root);
            Name name = parser.parse(((IMPrincipal)u).getDistinguishedName());
            int nComponents = name.size();
            if (nComponents > _orgDepth) {
                for (int i = 1; i <= _orgDepth; ++i) {
                    name.remove(nComponents - i);
                }
            }
            String string = name.toString();
            return string;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            throw new RealmException(e.toString());
        }
        finally {
            this.ldap.recycleContext(dc);
        }
    }

    public String getSearchBase(String domainName) throws RealmException {
        Log.debug("LDAPRealm:getSearchBase(String): " + this.root);
        return this.root;
    }

    public synchronized boolean isMemberOfGroup(CollaborationPrincipal p, CollaborationGroup g) throws RealmException {
        NMSGroup nlg = (NMSGroup)g;
        Log.debug("searching for " + p.getUID() + " in " + nlg.getUID());
        if (nlg.isDynamic()) {
            String uid = StringUtility.getLocalPartFromAddress((String)p.getUID());
            RealmSearchResults reply = this.search(nlg.getScope(), uid, 2, nlg.getFilter());
            return reply.get().length > 0;
        }
        try {
            CollaborationPrincipal[] pa = this.expandGroup(p, g);
            if (pa == null) {
                return false;
            }
            for (int i = 0; i < pa.length; ++i) {
                if (!p.equals(pa[i])) continue;
                return true;
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return false;
    }

    public String getDomainName(String searchBase) throws RealmException {
        Log.debug("[LDAP] getDomainName = " + NMS.getName());
        return NMS.getName();
    }

    public CollaborationPrincipal createUser(String uid, String password, Map attributes) throws RealmException {
        if (!this._regisEnabled) {
            Log.debug("[LDAP] cannot create new user - self-registration is disabled");
            return null;
        }
        try {
            Name dn = ((Name)this._regisBase.clone()).add(this.userUIDAttr + "=" + uid);
            Attributes attrs = (Attributes)this._regisAttributes.clone();
            Iterator i = attributes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                attrs.put((String)entry.getKey(), entry.getValue());
            }
            attrs.put(this.userUIDAttr, uid);
            attrs.put(this.userPasswordAttr, password);
            this.ldap.getContext().bind(dn, null, attrs);
            return this.createUser(attrs, uid, this._regisDomain);
        }
        catch (Exception ne) {
            Log.printStackTrace(ne);
            throw new RealmException(ne);
        }
    }

    public void removeUser(String uid) throws RealmException {
        if (!this._regisEnabled) {
            Log.debug("[LDAP] cannot remove user - self-registration is disabled");
            return;
        }
    }

    public boolean changeUserPassword(String uid, String password) throws RealmException {
        if (!this._regisEnabled) {
            Log.debug("[LDAP] cannot modify user - self-registration is disabled");
            return false;
        }
        return false;
    }

    public String getUserPassword(CollaborationPrincipal p) {
        return p.getProperty(this.userPasswordAttr);
    }

    public UserSettingsStorageProvider getUserSettingsStorageProvider() {
        return UserSettings.get();
    }

    public ConferenceStorageProvider getConferenceStorageProvider() {
        return new FileGroupChatStorage();
    }

    public NewsStorageProvider getNewsStorageProvider() {
        return new FileNewsStorage();
    }

    public PolicyProvider getPolicyProvider() {
        if (_policyProvider == null) {
            _policyProvider = new IMPolicy(false);
        }
        return _policyProvider;
    }

    public boolean ignoreDomains() {
        return this._ignoreDomains;
    }
}

