/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.identity.util.Auth;
import com.sun.im.service.util.StringUtility;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

class LDAPPool {
    private static final String maxContextsName = "iim_ldap.maxconns";
    private static final String usesslConfigName = "iim_ldap.usessl";
    private static final String ldapServerConfigName = "iim_ldap.host";
    private static final String ldapUserConfigName = "iim_ldap.usergroupbinddn";
    private static final String ldapPasswordConfigName = "iim_ldap.usergroupbindcred";
    private static final String useIdentityAdminConfigName = "iim_ldap.useidentityadmin";
    private static int _maxContexts = 10;
    private static LDAPPool _this;
    private static String ldapUserName;
    private static String ldapPassword;
    private Hashtable env;
    private LinkedList _dirContexts = new LinkedList();

    static String getBindDN() {
        return ldapUserName;
    }

    static String getBindPassword() {
        return ldapPassword;
    }

    public static LDAPPool getDefault() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (_this == null) {
            String tmaxContexts;
            ServerConfig sc = ServerConfig.getServerConfig();
            String ldapServer = sc.getSetting(ldapServerConfigName, "");
            ldapUserName = sc.getSetting(ldapUserConfigName, "");
            ldapPassword = sc.getSetting(ldapPasswordConfigName, "");
            boolean useIdentityAdminCreds = false;
            try {
                useIdentityAdminCreds = StringUtility.getBoolean((String)sc.getSetting(useIdentityAdminConfigName));
            }
            catch (Exception ue) {
                // empty catch block
            }
            if (useIdentityAdminCreds) {
                ldapUserName = Auth.getAdminDN();
                ldapPassword = Auth.getAdminPassword();
            }
            boolean usessl = false;
            try {
                usessl = StringUtility.getBoolean((String)sc.getSetting(usesslConfigName, "false"));
            }
            catch (Exception ue) {
                // empty catch block
            }
            if (usessl) {
                env.put("java.naming.provider.url", "ldaps://" + ldapServer);
                env.put("java.naming.security.protocol", "ssl");
            } else {
                env.put("java.naming.provider.url", "ldap://" + ldapServer);
            }
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (ldapUserName.length() > 0) {
                Log.debug("[LDAPPool] binding as " + ldapUserName);
                env.put("java.naming.security.principal", ldapUserName);
                env.put("java.naming.security.credentials", ldapPassword);
            }
            if ((tmaxContexts = sc.getSetting(maxContextsName)) != null && tmaxContexts.length() != 0) {
                _maxContexts = Integer.parseInt(tmaxContexts);
            }
            _this = new LDAPPool(env);
        }
        return _this;
    }

    protected LDAPPool(Hashtable env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirContext getContext() throws Exception {
        Object dc = null;
        LDAPPool lDAPPool = this;
        synchronized (lDAPPool) {
            if (this._dirContexts.size() > 0) {
                return (DirContext)this._dirContexts.remove(0);
            }
        }
        try {
            Log.debug("LDAPPool] creating a new context");
            return new InitialDirContext(this.env);
        }
        catch (Exception e) {
            Log.error("[LDAPGroupChatStorage] Connection error " + e);
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void recycleContext(DirContext dc) {
        if (dc == null) {
            return;
        }
        LDAPPool lDAPPool = this;
        synchronized (lDAPPool) {
            if (this._dirContexts.size() < _maxContexts) {
                this._dirContexts.add(dc);
                return;
            }
        }
        try {
            dc.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        List copy;
        LDAPPool lDAPPool = this;
        synchronized (lDAPPool) {
            copy = (List)this._dirContexts.clone();
            this._dirContexts.clear();
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            DirContext dc = (DirContext)i.next();
            try {
                dc.close();
            }
            catch (Exception e) {
                Log.warning("[LDAP] exception closing all ldap contexts " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Attributes load(String dn) throws Exception {
        DirContext dc = this.getContext();
        try {
            Attributes attributes = dc.getAttributes(dn);
            return attributes;
        }
        catch (Exception e) {
            Attributes attributes = null;
            return attributes;
        }
        finally {
            this.recycleContext(dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(String dn, Map attrMap) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        Iterator iter = attrMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            BasicAttribute a = new BasicAttribute((String)entry.getKey());
            Object o = entry.getValue();
            if (o instanceof String) {
                a.add(o);
            } else if (o instanceof Set) {
                Iterator i = ((Set)o).iterator();
                while (i.hasNext()) {
                    a.add(i.next());
                }
                if (a.size() <= 0) continue;
            }
            attrs.put(a);
        }
        DirContext dc = this.getContext();
        try {
            dc.modifyAttributes(dn, 2, (Attributes)attrs);
        }
        catch (Exception e) {
            Log.error("[LDAPPool] save " + dn + " failed");
        }
        finally {
            this.recycleContext(dc);
        }
    }
}

