/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.FileNewsStorage;
import com.iplanet.im.server.LDAPGroupChatStorage;
import com.sun.im.provider.NewsStorageProvider;
import java.io.File;

public class LDAPNewsStorage
extends LDAPGroupChatStorage
implements NewsStorageProvider {
    private static final String NEWS_OBJECTCLASS = "sunIMNews";
    private static final String NEWS_AFFILIATIONS_ATTR = "sunIMNewsAffiliations";
    private static final String NEWS_CONFIGURATION_ATTR = "sunIMNewsConfiguration";
    private static final String newsFilterConfigName = "iim_ldap.newsfilterattr";
    private static final String newsContainerConfigName = "iim_ldap.newscontainer";
    private static final String newsContainerDef = "ou=sunNews";
    private static final String newsSearchFilterDef = "(&(objectclass=sunIMNews)(uid={0}))";
    FileNewsStorage _fns = new FileNewsStorage();

    public LDAPNewsStorage() throws Exception {
        super(newsContainerDef, newsContainerConfigName, NEWS_OBJECTCLASS, NEWS_AFFILIATIONS_ATTR, NEWS_CONFIGURATION_ATTR, newsFilterConfigName, newsSearchFilterDef, "pubsub");
    }

    public void saveMessage(String id, String msgId, String xml) throws Exception {
        this._fns.saveMessage(id, msgId, xml);
    }

    public void deleteMessage(String id, String msgId) throws Exception {
        this._fns.deleteMessage(id, msgId);
    }

    public void deleteMessages(String id) throws Exception {
        this._fns.deleteMessages(id);
    }

    public String getMessage(String id, String msgId) throws Exception {
        return this._fns.getMessage(id, msgId);
    }

    public String[] getMessageIds(String id) throws Exception {
        File f = this._fns.getDirectory(id, true);
        return this._fns.getMessageIds(id);
    }

    public void destroy(String id) throws Exception {
        super.destroy(id);
        File dir = this._fns.getDirectory(id, true);
        this._fns.removeDirectory(dir);
    }
}

