/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.LDAPPool;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MigrateRoster;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.DNUtil;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPGroupChatStorage
implements ConferenceStorageProvider {
    private static final String CONFERENCE_OBJECTCLASS = "sunIMConference";
    private static final String CN_ATTR = "cn";
    private static final String UID_ATTR = "uid";
    private static final String CONFERENCE_AFFILIATIONS_ATTR = "sunIMConferenceAffiliations";
    private static final String CONFERENCE_CONFIGURATION_ATTR = "sunIMConferenceConfiguration";
    private static final String conferenceFilterConfigName = "iim_ldap.conferencefilterattr";
    private static final String conferenceContainerConfigName = "iim_ldap.conferencecontainer";
    private static final String conferenceContainerDef = "ou=sunConferences";
    private static final String conferenceSearchFilterDef = "(&(objectclass=sunIMConference)(uid={0}))";
    HashSet groupChatAttributeSet = new HashSet(1);
    private String[] groupChatAttributeArray = null;
    String _searchBase;
    String _searchFilter;
    String _affiliationsAttr;
    String _configurationAttr;
    String _objectClass;
    String _container;
    HashMap _groupChats = new HashMap();
    String _domain;
    String _subDomain;
    String _migrateName;
    LDAPPool ldap = LDAPPool.getDefault();

    public LDAPGroupChatStorage() throws Exception {
        this(conferenceContainerDef, conferenceContainerConfigName, CONFERENCE_OBJECTCLASS, CONFERENCE_AFFILIATIONS_ATTR, CONFERENCE_CONFIGURATION_ATTR, conferenceFilterConfigName, conferenceSearchFilterDef, "muc");
    }

    public LDAPGroupChatStorage(String containerDefault, String containerConfigName, String objectClass, String affiliationsAttr, String configurationAttr, String filterConfigName, String filterDefault, String name) throws Exception {
        this.groupChatAttributeSet.add(UID_ATTR);
        this.groupChatAttributeArray = new String[this.groupChatAttributeSet.size()];
        int ix = 0;
        Iterator i = this.groupChatAttributeSet.iterator();
        while (i.hasNext()) {
            this.groupChatAttributeArray[ix++] = (String)i.next();
        }
        this._affiliationsAttr = affiliationsAttr;
        this._configurationAttr = configurationAttr;
        this._objectClass = objectClass;
        ServerConfig sc = ServerConfig.getServerConfig();
        this._container = sc.getSetting(containerConfigName, containerDefault);
        this._searchBase = sc.getSetting("iim_ldap.searchbase", "");
        this._searchBase = this._container + "," + this._searchBase;
        this._searchFilter = sc.getSetting(filterConfigName, filterDefault);
        this._subDomain = name + ".";
        this._domain = name + "." + NMS.getName();
        this._migrateName = name;
        DirContext dc = this.ldap.getContext();
        this.setContainer(dc);
        this.ldap.recycleContext(dc);
    }

    public String loadAffiliations(String id) throws Exception {
        Attribute attr = null;
        Attributes attrs = this.load(id);
        if (attrs != null) {
            attr = attrs.get(this._affiliationsAttr);
        }
        if (attr != null) {
            return attr.get().toString();
        }
        return null;
    }

    public void saveAffiliations(String id, String xml) throws Exception {
        this.save(id, this._affiliationsAttr, xml);
    }

    public String loadConfiguration(String id) throws Exception {
        Attribute attr = null;
        Attributes attrs = this.load(id);
        if (attrs != null) {
            attr = attrs.get(this._configurationAttr);
        }
        if (attr != null) {
            return attr.get().toString();
        }
        return null;
    }

    public void saveConfiguration(String id, String xml) throws Exception {
        this.save(id, this._configurationAttr, xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String id) throws Exception {
        DirContext dc = this.ldap.getContext();
        try {
            dc.unbind("uid=" + DNUtil.escapeDNChars((String)id) + "," + this._searchBase);
        }
        catch (Exception e) {
            Log.error("[LDAPGropuChatStorage] destroy " + id + " failed");
        }
        finally {
            this.ldap.recycleContext(dc);
        }
        this._groupChats.remove(id);
    }

    public boolean exists(String id) {
        try {
            Attributes attrs = (Attributes)this._groupChats.get(id);
            if (attrs != null) {
                return true;
            }
            attrs = this.load(id);
            return attrs != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized void create(String id) throws Exception {
        Attributes attrs = this.load(id);
        if (attrs == null) {
            this.create(id, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void create(String id, String attr, String xml) throws Exception {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute objclass = new BasicAttribute("objectclass");
        objclass.add("top");
        objclass.add(this._objectClass);
        attrs.put(objclass);
        attrs.put(CN_ATTR, StringUtility.getLocalPartFromAddress((String)id));
        attrs.put(UID_ATTR, id);
        if (attr != null && xml != null) {
            attrs.put(attr, xml);
        }
        DirContext dc = this.ldap.getContext();
        this.setContainer(dc);
        try {
            dc.bind("uid=" + DNUtil.escapeDNChars((String)id) + "," + this._searchBase, null, (Attributes)attrs);
        }
        catch (Exception e) {
            Log.error("[LDAPGroupChatStorage] create " + id + " failed");
        }
        finally {
            this.ldap.recycleContext(dc);
        }
    }

    public String[] search(String pattern) {
        return this.search(pattern, false, null);
    }

    public String[] search(CollaborationPrincipal u, String pattern, boolean useDefaultDomain) {
        Log.debug("[LDAPGroupChatStorage] searching items matching " + pattern);
        String userDomain = null;
        userDomain = useDefaultDomain ? NMS.getName() : u.getDomainName();
        return this.search(pattern, true, userDomain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] search(String pattern, boolean compareDomain, String domain) {
        String searchFor = StringUtility.replaceString((String)"{0}", (String)StringUtility.unquoteSpecialCharacters((String)pattern), (String)this._searchFilter);
        int retry = 0;
        LinkedList<String> v = new LinkedList<String>();
        while (retry < 2) {
            DirContext dc = null;
            try {
                dc = this.ldap.getContext();
                SearchControls con = new SearchControls();
                con.setSearchScope(2);
                con.setReturningAttributes(this.groupChatAttributeArray);
                Log.debug("[LDAPGroupChatStorage] Searching by uid: filter=" + searchFor + " base=" + this._searchBase);
                NamingEnumeration<SearchResult> e = dc.search(this._searchBase, searchFor, con);
                while (e != null && e.hasMore()) {
                    SearchResult sr = e.next();
                    Attributes attrs = sr.getAttributes();
                    Attribute attr = null;
                    if (attrs != null) {
                        attr = attrs.get(UID_ATTR);
                    }
                    if (compareDomain) {
                        String room;
                        if (attr == null || !StringUtility.getDomainFromAddress((String)(room = attr.get().toString()), (String)this._domain).equalsIgnoreCase(this._subDomain + domain)) continue;
                        v.add(room);
                        continue;
                    }
                    if (attr == null) continue;
                    v.add(attr.get().toString());
                }
                break;
            }
            catch (CommunicationException e) {
                Log.error("[LDAPGropuChatStorage] search failed: " + pattern + "  " + e);
                try {
                    dc.close();
                }
                catch (Exception ce) {
                    // empty catch block
                }
                dc = null;
                ++retry;
                try {
                    Thread.sleep(500L);
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                Log.error("[LDAPGropuChatStorage] search failed: " + pattern + "  " + e);
                break;
            }
            finally {
                this.ldap.recycleContext(dc);
            }
        }
        if (v.size() > 0) {
            String[] ra = new String[v.size()];
            int i = 0;
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                ra[i++] = (String)iter.next();
            }
            return ra;
        }
        return null;
    }

    Attributes load(String id) throws Exception {
        Attributes attrs = (Attributes)this._groupChats.get(id);
        if (attrs == null && (attrs = this.ldap.load("uid=" + DNUtil.escapeDNChars((String)id) + "," + this._searchBase)) != null) {
            this._groupChats.put(id, attrs);
        }
        return attrs;
    }

    protected void save(String id, String attr, String xml) throws Exception {
        Attributes attrs = this.load(id);
        if (attrs == null) {
            Log.debug("[LDAPGroupChatStorage] object not exist, call create first");
            this.create(id, attr, xml);
        } else {
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put(attr, xml);
            this.ldap.save("uid=" + DNUtil.escapeDNChars((String)id) + "," + this._searchBase, map);
        }
        attrs = (Attributes)this._groupChats.get(id);
        if (attrs != null) {
            attrs.put(attr, xml);
        }
        this._groupChats.put(id, attrs);
    }

    String getId(String id) throws Exception {
        String name = id;
        if (StringUtility.getDomainFromAddress((String)id, (String)NMS.getName()).equalsIgnoreCase(NMS.getName())) {
            name = StringUtility.getLocalPartFromAddress((String)id);
        }
        return name;
    }

    private synchronized void setContainer(DirContext dc) {
        try {
            boolean createContainer = false;
            boolean checkMigrate = false;
            try {
                Attributes a = dc.getAttributes(this._searchBase);
            }
            catch (Exception e) {
                createContainer = true;
                checkMigrate = true;
                Log.debug("[LDAPGroupChatStorage] create container : " + this._searchBase);
            }
            if (createContainer) {
                BasicAttributes attrs = new BasicAttributes(true);
                BasicAttribute obj = new BasicAttribute("objectclass");
                obj.add("top");
                obj.add("organizationalUnit");
                attrs.put(obj);
                attrs.put("ou", this._container);
                try {
                    dc.createSubcontext(this._searchBase, (Attributes)attrs);
                }
                catch (Exception ce) {
                    Log.debug("[LDAPGroupChatStorage] create container " + this._searchBase + " failed");
                }
            }
            try {
                if (checkMigrate) {
                    File f = new File(NMS.getDBDir(), "storage.properties");
                    if (!f.exists()) {
                        return;
                    }
                    FileInputStream is = new FileInputStream(f);
                    Properties p = new Properties();
                    p.load(is);
                    is.close();
                    Log.debug("[LDAPGroupChatStorage] migrate " + f.toString());
                    if ("muc".equals(this._migrateName)) {
                        Properties props = MigrateRoster.migrateMuc(this, p);
                    } else if ("pubsub".equals(this._migrateName)) {
                        Properties props = MigrateRoster.migratePubsub(this, p);
                    }
                }
            }
            catch (Exception me) {
                Log.debug("[LDAPGroupChatStorage] migrate failed: " + me.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

