/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.JMSManager;
import com.iplanet.im.server.JMSMessageListenerFactory;
import com.iplanet.im.server.JMSSubscriber;
import com.iplanet.im.server.Log;
import com.sun.im.service.util.HostPort;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.MessageListener;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

class JMSProvider {
    TopicConnection _tc = null;
    LinkedList _subscribers = new LinkedList();
    Thread _retryThread = null;
    boolean _shutdown = false;
    TopicConnectionFactory _tcf;

    public JMSProvider(String factory, String sHostPort) throws Exception {
        if (sHostPort != null) {
            HostPort hp = new HostPort(sHostPort, 7997);
            System.setProperty("com.iplanet.ens.host", hp.getHostName());
            System.setProperty("com.iplanet.ens.port", Integer.toString(hp.getPort()));
        }
        System.setProperty("com.iplanet.ens.encoding", "UTF-8");
        this._tcf = (TopicConnectionFactory)Class.forName(factory).newInstance();
        try {
            this._tc = this._tcf.createTopicConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startConnection() throws Exception {
        if (this._tc == null) {
            this._tc = this._tcf.createTopicConnection();
        }
        Log.debug("starting JMS TopicConnection");
        this._tc.start();
        Log.debug("started JMS TopicConnection");
        Iterator i = this._subscribers.iterator();
        while (i.hasNext()) {
            JMSSubscriber subs = (JMSSubscriber)i.next();
            subs.start();
        }
    }

    public void start() {
        this._shutdown = false;
        Log.info("Starting JMS provider");
        try {
            this.startConnection();
        }
        catch (Exception e) {
            Log.warning("Failed to start JMS Connection");
            Log.printStackTrace(e);
            this._retryThread = new Thread(new RetryLater());
            this._retryThread.start();
        }
    }

    public void stop() {
        Log.info("Stopping JMS provider");
        this._shutdown = true;
        try {
            if (this._retryThread != null) {
                this._retryThread.join();
            }
            Iterator i = this._subscribers.iterator();
            while (i.hasNext()) {
                JMSSubscriber subs = (JMSSubscriber)i.next();
                subs.close();
            }
            if (this._tc != null) {
                this._tc.stop();
                this._tc = null;
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    public void addSubscriber(String sTopic, String param, JMSMessageListenerFactory mlf) {
        mlf.setContext(this);
        MessageListener l = mlf.getMessageListener(sTopic, param);
        if (l != null) {
            try {
                if (this._tc == null) {
                    this._tc = this._tcf.createTopicConnection();
                }
                JMSSubscriber subs = new JMSSubscriber(this._tc, sTopic, l);
                this._subscribers.add(subs);
            }
            catch (Exception e) {
                Log.warning("Failed to initialize JMS subscriber: " + sTopic);
                Log.printStackTrace(e);
            }
        }
    }

    class RetryLater
    implements Runnable {
        RetryLater() {
        }

        public void run() {
            while (!JMSProvider.this._shutdown) {
                try {
                    JMSProvider.this.startConnection();
                    JMSProvider.this._retryThread = null;
                    break;
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(JMSManager.RETRY_PERIOD);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

