/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.JMSMessageListenerFactory;
import com.iplanet.im.server.JMSProvider;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.service.ApplicationInfo;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.NotificationService;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.util.HostPort;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;

public class JMSManager {
    private static final String PARAM_CONSUMERS = "jms.consumers";
    private static final String PARAM_PROVIDERS = "jms.providers";
    private static final String PARAM_CONSUMER_PREFIX = "jms.consumer.";
    private static final String PARAM_PROVIDER_PREFIX = "jms.provider.";
    private static final String PARAM_BROKER_SUFFIX = ".broker";
    private static final String PARAM_FACTORY_SUFFIX = ".factory";
    private static final String PARAM_PROVIDER_SUFFIX = ".provider";
    private static final String PARAM_DESTINATION_SUFFIX = ".destination";
    private static final String PARAM_PARAMETER_SUFFIX = ".param";
    private static final String PARAM_TYPE_SUFFIX = ".type";
    private HashMap _providers = new HashMap(3);
    public static long RETRY_PERIOD = 30000L;
    public static final String DEFAULT_AGENT_CALENDAR = "agent-calendar.";
    private boolean _shutdown = false;
    private static JMSManager sm_instance;
    private String _serviceURL;
    private String _compJID;
    private String _password;
    private CollaborationSessionFactory _collabFac;
    private boolean _trustAllCerts;
    private NotificationService _notificationService;
    private HostPort _serverHostPort;
    private String _domainName;
    private Object _lock = new Object();
    private String _provider = "com.sun.im.service.xmpp.XMPPComponentSessionProvider";
    private static final String SERVER_USESSLPORT = "iim_server.usesslport";
    private static final String SERVER_PORT = "iim_server.port";
    private static final String SERVER_SSLPORT = "iim_server.sslport";
    private static final String SERVER_DOMAIN_NAME = "iim_server.domainname";
    private static final String CALENDAR_JID = "agent-calendar.jid";
    private static final String CALENDAR_PASSWORD = "agent-calendar.password";
    private static final int SERVER_DEFAULT_NORMAL_PORT = 9909;
    private static final int SERVER_DEFAULT_SSL_PORT = 9910;
    int SERVICE_CONTROL_STOP = 1;
    int SERVICE_CONTROL_PAUSE = 2;
    int SERVICE_CONTROL_CONTINUE = 3;
    Object shutdownLock = new Object();

    private static JMSMessageListenerFactory getMessageListenerFactory(String factory, String topic, String param) {
        try {
            return (JMSMessageListenerFactory)Class.forName(factory).newInstance();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    private JMSManager() {
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-c")) continue;
            if (i + 1 < args.length) {
                ServerConfig.init(args[++i]);
                continue;
            }
            JMSManager.usage();
        }
        Log.init("agent-calendar");
        sm_instance = new JMSManager();
        try {
            sm_instance.initialize();
        }
        catch (Exception e) {
            Log.fatal("Intialization failed");
            Log.printStackTrace(e);
            System.exit(1);
        }
        sm_instance.start();
    }

    private static void usage() {
        System.out.println("Usage: com.iplanet.im.server.JMSManager [-c configfile]");
        System.exit(1);
    }

    public static JMSManager getInstance() {
        return sm_instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initialize() throws Exception {
        String sKey;
        ServerConfig sc = ServerConfig.getServerConfig();
        String s = sc.getSetting(PARAM_PROVIDERS);
        if (s == null) throw new Exception("No Providers found");
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            JMSProvider p;
            sKey = st.nextToken();
            String sFactory = sc.getSetting(PARAM_PROVIDER_PREFIX + sKey + PARAM_FACTORY_SUFFIX, null);
            String sBroker = sc.getSetting(PARAM_PROVIDER_PREFIX + sKey + PARAM_BROKER_SUFFIX, null);
            if (sFactory == null || (p = new JMSProvider(sFactory, sBroker)) == null) continue;
            this._providers.put(sKey, p);
        }
        this._initServerHostPort();
        s = sc.getSetting(PARAM_CONSUMERS);
        if (s == null) throw new Exception("No Consumers found");
        st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            sKey = st.nextToken();
            String sTopic = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_DESTINATION_SUFFIX);
            String sParam = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_PARAMETER_SUFFIX);
            String sFactory = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_FACTORY_SUFFIX);
            JMSMessageListenerFactory mlf = JMSManager.getMessageListenerFactory(sFactory, sTopic, sParam);
            String sProvider = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_PROVIDER_SUFFIX, null);
            if (sProvider == null) continue;
            JMSProvider p = (JMSProvider)this._providers.get(sProvider);
            String sType = sc.getSetting(PARAM_CONSUMER_PREFIX + sKey + PARAM_TYPE_SUFFIX);
            if (!sType.equalsIgnoreCase("topic") || mlf == null) continue;
            p.addSubscriber(sTopic, sParam, mlf);
        }
        this._initServiceURL();
        this._initCompJID();
        this._initPassword();
        this._initDomainName();
        this._initCollabFactory();
        if (!Boolean.valueOf(ServerConfig.getServerConfig().getSetting(SERVER_USESSLPORT, "false")).booleanValue()) return;
        this._initTrustAllCerts();
    }

    public void start() {
        Iterator i = this._providers.values().iterator();
        while (i.hasNext()) {
            JMSProvider p = (JMSProvider)i.next();
            p.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._shutdown = true;
        Iterator i = this._providers.values().iterator();
        while (i.hasNext()) {
            JMSProvider p = (JMSProvider)i.next();
            p.stop();
        }
        Object object = this.shutdownLock;
        synchronized (object) {
            this.shutdownLock.notify();
        }
    }

    public void connectionClosed(Object o) {
        JMSProvider p = (JMSProvider)o;
        p.stop();
        if (!this._shutdown) {
            p.start();
        }
    }

    public HostPort getServerHostPort() {
        return this._serverHostPort;
    }

    public String getServerDomainName() {
        return this._domainName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationService getNotificationService() {
        Object object = this._lock;
        synchronized (object) {
            if (this._notificationService == null) {
                try {
                    CollaborationSession session = this._collabFac.getSession(this._serviceURL, this._compJID, this._password, (CollaborationSessionListener)new SessionHandler());
                    this._notificationService = session.getNotificationService();
                    this._notificationService.initialize(null);
                }
                catch (CollaborationException e) {
                    Log.error("Unable to obtain the Notification Service");
                    Log.printStackTrace((Exception)((Object)e));
                }
            }
            return this._notificationService;
        }
    }

    private void _initServiceURL() {
        this._serviceURL = this.getServerHostPort().toString();
        Log.debug("ServiceURL : " + this._serviceURL);
    }

    private void _initCompJID() {
        this._compJID = ServerConfig.getServerConfig().getSetting(CALENDAR_JID);
        if (this._compJID == null) {
            this._compJID = DEFAULT_AGENT_CALENDAR + this.getServerHostPort().getHostName();
        } else {
            try {
                JID compJID = new JID(this._compJID);
            }
            catch (JIDFormatException jfe) {
                Log.debug("compJID is not in a valid jid format: " + this._compJID);
                this._compJID = DEFAULT_AGENT_CALENDAR + this.getServerHostPort().getHostName();
                Log.debug("Falling back to default compJID: " + this._compJID);
            }
        }
        Log.debug("CompJID: " + this._compJID);
    }

    private void _initPassword() {
        this._password = ServerConfig.getServerConfig().getSetting(CALENDAR_PASSWORD, "");
    }

    private void _initCollabFactory() throws Exception {
        if (Boolean.valueOf(ServerConfig.getServerConfig().getSetting(SERVER_USESSLPORT, "false")).booleanValue()) {
            this._provider = "com.sun.im.service.xmpp.XMPPSecureComponentSessionProvider";
        }
        this._collabFac = new CollaborationSessionFactory(this._provider);
        ApplicationInfo appinfo = new ApplicationInfo();
        appinfo.setCategory("component");
        appinfo.setType("generic");
        appinfo.setName("agent_handler");
        this._collabFac.getCollaborationSessionProvider().setApplicationInfo(appinfo);
        Log.debug("CollabFactory : " + this._provider);
    }

    private void _initServerHostPort() {
        ServerConfig sc = ServerConfig.getServerConfig();
        this._serverHostPort = Boolean.valueOf(sc.getSetting(SERVER_USESSLPORT, "false")) != false ? new HostPort(sc.getSetting(SERVER_SSLPORT), 9910) : new HostPort(sc.getSetting(SERVER_PORT), 9909);
    }

    private void _initTrustAllCerts() throws Exception {
        String serverAddress = InetAddress.getByName(this.getServerHostPort().getHostName()).getHostAddress();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            Log.warning("Unable to get all NetworkInterfaces");
        }
        if (e != null) {
            block2: while (e.hasMoreElements()) {
                NetworkInterface nwi = e.nextElement();
                Enumeration<InetAddress> inetAddrs = nwi.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress addr = inetAddrs.nextElement();
                    if (!addr.getHostAddress().equals(serverAddress)) continue;
                    this._trustAllCerts = true;
                    continue block2;
                }
            }
        }
        Log.debug("TrustAllCerts : " + this._trustAllCerts);
    }

    private void _initDomainName() {
        this._domainName = ServerConfig.getServerConfig().getSetting(SERVER_DOMAIN_NAME);
        if (this._domainName == null) {
            try {
                this._domainName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                this._domainName = "localhost";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doWaitForExitStatus() {
        while (this._shutdown) {
            try {
                Object object = this.shutdownLock;
                synchronized (object) {
                    this.shutdownLock.wait();
                }
            }
            catch (Exception exception) {
            }
        }
        return 1;
    }

    public void dispatchSCMEvent(int i) {
        if (i == this.SERVICE_CONTROL_STOP) {
            this.stop();
        }
    }

    private class SessionHandler
    implements SecureSessionListener {
        private SessionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(CollaborationException e) {
            Object object = JMSManager.this._lock;
            synchronized (object) {
                JMSManager.this._notificationService = null;
            }
            Log.error("Error received on Collaboration Session");
            Log.printStackTrace((Exception)((Object)e));
        }

        public boolean onX509Certificate(X509Certificate[] chain) {
            return JMSManager.this._trustAllCerts;
        }
    }
}

