/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.jabberstudio.jso.JID;

public class IMPrincipal
implements CollaborationPrincipal {
    private String uid;
    JID _jid;
    String emailAddress = null;
    Random _random = new Random(new Random().nextLong());
    private String domain;
    private String displayName;
    private String server;
    private Properties attributes = new Properties();
    private static final String PROP_DN = "dn";

    public IMPrincipal(String node, String domain) {
        this(node, domain, null, null, null);
    }

    public IMPrincipal(String node, String domain, String displayName) {
        this(node, domain, null, displayName, null);
    }

    public IMPrincipal(String node, String domain, String dn, String displayName) {
        this(node, domain, dn, displayName, null);
    }

    public IMPrincipal(String node, String domain, String dn, String displayName, String emailAddress) {
        this.emailAddress = emailAddress;
        this.domain = domain != null && domain.length() > 0 ? domain : NMS.getName();
        this.displayName = displayName;
        String local = node != null ? StringUtility.getLocalPartFromAddress((String)node) : null;
        this._jid = JIDUtil.encodedJID((String)local, (String)domain, (String)dn);
        this.uid = JIDUtil.decodedJID((JID)this._jid);
        if (dn != null) {
            this.setDistinguishedName(dn);
        }
        Log.debug("[IMPrincipal] created " + this.uid);
    }

    public String getUID() {
        return this.uid;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getName() {
        return JIDUtil.decodedNode((JID)this._jid);
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setDomainName(String domain) {
        this.domain = domain;
    }

    public String getDomainName() {
        return this.domain;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getName();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Properties();
        }
        this.attributes.put(name, value);
    }

    public void setAttributes(Map attrs) {
        if (attrs instanceof Properties) {
            this.attributes = (Properties)attrs;
        } else {
            if (this.attributes == null) {
                this.attributes = new Properties();
            }
            this.attributes.putAll((Map<?, ?>)attrs);
        }
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public Enumeration propertyNames() {
        return this.getAttributeNames();
    }

    public Enumeration getAttributeNames() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.propertyNames();
    }

    public void setDistinguishedName(String dn) {
        this.attributes.put(PROP_DN, dn);
    }

    public String getDistinguishedName() {
        return (String)this.attributes.get(PROP_DN);
    }

    public boolean equals(Object other) {
        if (other instanceof CollaborationPrincipal) {
            CollaborationPrincipal p = (CollaborationPrincipal)other;
            return this.getName().equals(p.getName()) && this.getDomainName().equalsIgnoreCase(p.getDomainName());
        }
        return false;
    }

    public Object getValue(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(attributeName);
    }

    public void setProperty(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getProperty(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        String val = null;
        Object o = this.attributes.get(attributeName);
        if (o instanceof Set) {
            Set s = (Set)o;
            if (s != null && !s.isEmpty()) {
                val = (String)s.iterator().next();
            }
        } else {
            val = (String)o;
        }
        return val;
    }

    public Set getAttributeValues(String attributeName) {
        if (this.attributes == null) {
            return null;
        }
        HashSet<Object> val = null;
        Object o = this.attributes.get(attributeName);
        if (o instanceof String) {
            val = new HashSet<Object>();
            val.add(o);
        } else {
            val = (HashSet<Object>)o;
        }
        return val;
    }

    public JID getJID() {
        return this._jid;
    }

    public void setAttributeValues(String attribute, Set values) {
        if (this.attributes == null) {
            this.attributes = new Properties();
        }
        this.attributes.put(attribute, values);
    }
}

