/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ContentFilters;
import com.iplanet.im.server.GroupChat;
import com.iplanet.im.server.GroupChatHandler;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.PassThruHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPByteStream;
import com.sun.im.provider.RealmException;
import com.sun.im.service.util.Worker;
import java.util.Iterator;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;

public class IBBHandler
extends PassThruHandler {
    public static String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final NSI SUN_ATTACH_NAME = new NSI("attach", "sun:xmpp:attach");
    public static NSI DATA_NAME = new NSI("data", NAMESPACE);
    GroupChatHandler groupChatHandler;
    private static Thread lastThread = new Thread(){

        public void run() {
        }
    };

    public IBBHandler(GroupChatHandler gch) {
        this.groupChatHandler = gch;
    }

    public void process(StreamEndPoint session, Packet packet) {
        if (!ContentFilters.enabled() && !this.groupChatHandler.isChatPacket(session, packet)) {
            List list = packet.listElements("open");
            Worker w = null;
            if (list.size() > 0) {
                StreamElement element = (StreamElement)list.get(0);
                String sid = element.getAttributeValue("sid");
                w = session.getWorker(sid);
                super.process(session, packet, w);
            } else {
                list = packet.listElements("close");
                if (list.size() > 0) {
                    StreamElement element = (StreamElement)list.get(0);
                    String sid = element.getAttributeValue("sid");
                    w = session.removeWorker(sid);
                    super.process(session, packet, w);
                    Log.debug("[IBBHandler] Stop the worker thread");
                    w.stop((Runnable)lastThread);
                }
            }
            return;
        }
        Object errorText = null;
        Object errorType = null;
        Log.debug("[IBB] new packet received");
        if (!session.validate(packet)) {
            return;
        }
        JID to = packet.getTo();
        if (to != null && to.getNode() != null && to.getNode().length() != 0) {
            if (ContentFilters.enabled()) {
                Log.debug("[IBB] Content filters is enabled");
                Iterator iter = packet.listElements(null, NAMESPACE).iterator();
                while (iter.hasNext()) {
                    StreamElement element = (StreamElement)iter.next();
                    String sid = element.getAttributeValue("sid");
                    if (element.getLocalName().equals("close")) {
                        Log.debug("[IBB] Received a close stream request: " + sid);
                        session.removeByteStream(sid).close(packet);
                        if (ContentFilters.conversionEnabled()) continue;
                        this.sendIQ(session, packet);
                        continue;
                    }
                    if (!element.getLocalName().equals("open")) continue;
                    Log.debug("[IBB] Received a open stream request: " + sid);
                    XMPPByteStream bs = session.getByteStream(sid);
                    if (bs == null) {
                        bs = new XMPPByteStream(session, packet, element);
                    } else {
                        bs.setOpenPacket(packet);
                        bs.setOpenElement(element);
                    }
                    bs.process();
                    this.sendIQ(session, packet);
                }
            } else {
                this.sendIQ(session, packet);
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "need to specify client JID receipient for Feture Neg request");
        }
    }

    public void sendIQ(StreamEndPoint session, Packet packet) {
        block10: {
            if (this.groupChatHandler.isChatPacket(session, packet)) {
                GroupChat gc;
                if (packet.getType().equals((Object)InfoQuery.SET) && (gc = this.groupChatHandler.getGroupChat(packet.getTo().toBareJID())) != null) {
                    try {
                        if (gc.addMessage(session, packet)) {
                            session.sendResult(packet);
                            break block10;
                        }
                        session.sendError(packet, PacketError.CANCEL, "forbidden", "cannot sent to " + packet.getTo().toString());
                    }
                    catch (StreamException se) {}
                }
            } else {
                try {
                    BaseUser u = this.getUser(packet.getTo().toBareJID());
                    if (u != null) {
                        this.deliver(session, packet, u);
                    } else {
                        session.sendError(packet, PacketError.CANCEL, "item-not-found", packet.getTo().toString() + " not found");
                    }
                }
                catch (RealmException re) {
                    Log.printStackTrace((Exception)((Object)re));
                    session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage());
                    return;
                }
            }
        }
    }

    void processMessage(StreamEndPoint session, Packet packet, MonitorTransaction transaction) {
        if (ContentFilters.enabled()) {
            Iterator iter = packet.listElements(DATA_NAME).iterator();
            while (iter.hasNext()) {
                StreamElement element = (StreamElement)iter.next();
                String sid = element.getAttributeValue("sid");
                XMPPByteStream bs = session.getByteStream(sid);
                if (bs != null) {
                    bs.processData(packet, element, this);
                    continue;
                }
                Log.debug("[IBB] Cannot get the XMPPByteStream: " + sid);
            }
        }
        if (!ContentFilters.conversionEnabled()) {
            this.sendMessage(session, packet, transaction);
        }
    }

    public void sendMessage(StreamEndPoint session, Packet packet) {
        this.sendMessage(session, packet, null);
    }

    public void sendMessage(StreamEndPoint session, Packet packet, MonitorTransaction transaction) {
        if (this.groupChatHandler.isChatPacket(session, packet)) {
            GroupChat gc = this.groupChatHandler.getGroupChat(packet.getTo().toBareJID());
            if (gc != null) {
                try {
                    if (!gc.addMessage(session, packet)) {
                        session.sendError(packet, PacketError.CANCEL, "forbidden", "not allowed to participate this room", gc.getJID(), session.getJID(), null, transaction);
                    }
                }
                catch (StreamException se) {}
            }
        } else {
            List list = packet.listElements(DATA_NAME);
            if (list.size() > 0) {
                StreamElement element = (StreamElement)list.get(0);
                String sid = element.getAttributeValue("sid");
                this.deliver(session, packet, transaction, session.getWorker(sid));
            }
        }
    }
}

