/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;

public class GroupChatHistory {
    private static final NSI NSI_DELAY = new NSI("x", "jabber:x:delay");
    private LinkedList _messages = new LinkedList();
    private int _maxSize = 10;

    GroupChatHistory(int maxSize) {
        this._maxSize = maxSize;
    }

    synchronized void add(StreamEndPoint session, Message packet) {
        if (this._messages.size() >= this._maxSize) {
            this._messages.removeLast();
        }
        this._messages.add(0, new MessageRecord(session, packet));
    }

    synchronized void deliver(StreamEndPoint session, int maxStanzas, int maxChars, long delay) throws StreamException {
        long now = System.currentTimeMillis();
        int size = this._messages.size();
        int n2deliver = 0;
        Iterator i = this._messages.iterator();
        while (i.hasNext()) {
            MessageRecord mrec = (MessageRecord)i.next();
            boolean deliverIt = false;
            if (maxStanzas > 0) {
                --maxStanzas;
            } else if (maxStanzas == 0) break;
            if (maxChars > 0 && (maxChars -= mrec.p.getBody().length()) < 0 || delay > 0L && now - mrec.t > delay) break;
            ++n2deliver;
        }
        Log.debug("[GroupChatHistory] deliver stanzas=" + n2deliver);
        if (n2deliver > 0) {
            Packet[] pa = new Packet[n2deliver];
            int n = n2deliver - 1;
            Iterator i2 = this._messages.iterator();
            while (i2.hasNext() && n >= 0) {
                MessageRecord mrec = (MessageRecord)i2.next();
                mrec.p.setTo(session.getJID());
                pa[n--] = mrec.p;
            }
            session.send(pa);
        }
    }

    class MessageRecord {
        Message p;
        long t;

        MessageRecord(StreamEndPoint session, Message packet) {
            this.p = packet;
            Date date = new Date();
            this.t = date.getTime();
            StreamElement delay = session.getDataFactory().createElementNode(NSI_DELAY);
            delay.setAttributeValue("from", session.getJID().toString());
            this.p.add((StreamNode)delay);
        }
    }
}

