/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.Discoverable;
import com.iplanet.im.server.FileGroupChatStorage;
import com.iplanet.im.server.GroupChat;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LDAPGroupChatStorage;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.provider.RealmException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.XMPPMessage;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;

public class GroupChatHandler
extends AbstractHandler
implements Discoverable {
    static Hashtable groups = new Hashtable();
    protected static String NAMESPACE_CONFERENCE = "jabber:iq:conference";
    protected static String NAMESPACE = "http://jabber.org/protocol/muc";
    protected static String NAMESPACE_USER = NAMESPACE + "#user";
    protected static String NAMESPACE_OWNER = NAMESPACE + "#owner";
    protected static String NAMESPACE_ADMIN = NAMESPACE + "#admin";
    protected static String NAMESPACE_ROOMINFO = NAMESPACE + "#roominfo";
    protected static String NAMESPACE_ROOMCONFIG = NAMESPACE + "#roomconfig";
    protected static NSI NSI_USER = new NSI("x", NAMESPACE_USER);
    protected static NSI NSI_ADMIN = new NSI("query", NAMESPACE_ADMIN);
    protected static NSI NSI_OWNER = new NSI("query", NAMESPACE_OWNER);
    protected static NSI NSI_ITEM = new NSI("item", null);
    private static final String ROOTDIR = "muc";
    private ConferenceStorageProvider storageProvider = this.getStorageProvider();
    static MonitorTransactionFactory msgTranFactory = null;
    static MonitorTransactionFactory preTranFactory = null;
    static MonitorTransactionFactory admTranFactory = null;
    static XDataForm _defaultConfigForm;

    protected ConferenceStorageProvider getStorageProvider() {
        if (this.storageProvider == null) {
            try {
                this.storageProvider = NMS.getPropStore() == 1 ? new LDAPGroupChatStorage() : new FileGroupChatStorage();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.debug("[GroupChatHandler] failed to load storage provider: " + e);
            }
        }
        return this.storageProvider;
    }

    protected GroupChatHandler() {
    }

    public boolean isChatPacket(StreamEndPoint session, Packet packet) {
        JID to = packet.getTo();
        JID from = packet.getFrom();
        if (to != null && this.getGroupChat(to.toBareJID()) != null) {
            return true;
        }
        if (to != null && to.getDomain().equalsIgnoreCase("muc." + NMS.getName())) {
            return true;
        }
        if (to != null && to.getDomain().equalsIgnoreCase("muc." + session.getJID().getDomain())) {
            return true;
        }
        if (to != null && from != null && to.getDomain().equalsIgnoreCase("muc." + from.getDomain())) {
            return true;
        }
        if (from != null && this.getGroupChat(from.toBareJID()) != null) {
            return true;
        }
        if (packet.getExtension(NAMESPACE_USER) != null) {
            return true;
        }
        return packet.getExtension(NAMESPACE) != null;
    }

    public void handleChatPresence(StreamEndPoint session, Packet packet) {
        block30: {
            PacketError.Type errorType = null;
            boolean statusCode = false;
            if (!session.validate(packet)) {
                return;
            }
            JID recipient = packet.getTo();
            try {
                BaseUser u = this.getUser(recipient.toBareJID());
                if (u != null) {
                    u.send(packet);
                    return;
                }
            }
            catch (StreamException se) {
                Log.printStackTrace((Exception)((Object)se));
                return;
            }
            catch (RealmException re) {
                Log.printStackTrace((Exception)((Object)re));
            }
            StreamDataFactory sdf = session.getDataFactory();
            GroupChat group = this.getGroupChat(recipient.toBareJID().toString(), session);
            String nick = recipient.getResource();
            if (group != null) {
                if (Presence.PROBE.equals((Object)packet.getType())) {
                    Log.debug("[GroupChat:" + group.getJID() + "] ignoring presence probe from " + packet.getFrom());
                    return;
                }
                Log.debug("[GroupChat:" + group.getJID() + "] handling presence from " + session.getJID());
                boolean allowed = true;
                if (group.isPersistent()) {
                    if (!IMPolicyManager.canAccessConferenceRooms(session.getUser())) {
                        allowed = false;
                        String reason = "Not authorized to access conference rooms";
                    }
                } else if (!IMPolicyManager.canChat(session.getUser())) {
                    allowed = false;
                    String reason = "Not authorized to chat";
                }
                if (!allowed) {
                    session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized to access Conference rooms");
                    return;
                }
                try {
                    List li;
                    StreamElement item = null;
                    List le = packet.listElements(NSI_USER);
                    if (le.size() == 1 && (li = ((StreamElement)le.get(0)).listElements(NSI_ITEM)).size() == 1) {
                        item = (StreamElement)li.get(0);
                    }
                    if (group.hasMember(nick, session.getJID())) {
                        Log.debug("[GroupChat:" + group.getJID() + "] updating presence " + session.getJID());
                        if (packet.getType() != null && packet.getType().equals((Object)Presence.UNAVAILABLE)) {
                            group.removeMember(session, packet, nick, false);
                        } else {
                            group.updateMember(session, packet, nick, item);
                        }
                        break block30;
                    }
                    Log.debug("[GroupChat:" + group.getJID() + "] joining " + session.getJID());
                    if (!group.hasNickname(nick)) {
                        if (packet.getType() != null) {
                            session.sendError(packet, PacketError.CANCEL, "bad-request", "invalid presence type for non-member", group.getJID(), session.getJID(), null);
                        } else if (!group.addMember(session, packet, nick, false, item)) {
                            session.sendError(packet, PacketError.CANCEL, "not-allowed", "not allowed in this room", group.getJID(), session.getJID(), null);
                        }
                        break block30;
                    }
                    PacketError error = sdf.createPacketError(PacketError.CANCEL, "conflict");
                    Presence newp = (Presence)packet.copy();
                    newp.add((StreamNode)error);
                    newp.setTo(packet.getFrom());
                    newp.setFrom(packet.getTo());
                    session.send((Packet)newp);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                    errorType = PacketError.CANCEL;
                }
            } else {
                Log.debug("[GroupChat:" + recipient.toBareJID() + "] being created by " + session.getJID() + " STAT:numGroupChat= " + groups.size());
                try {
                    Presence newp = (Presence)sdf.createPacketNode(sdf.createNSI("presence", null), Presence.class);
                    newp.setTo(packet.getFrom());
                    newp.setFrom(packet.getTo());
                    StreamElement ext = sdf.createElementNode(NSI_USER);
                    newp.add((StreamNode)ext);
                    if (IMPolicyManager.canChat(session.getUser())) {
                        group = new GroupChat(this, recipient.toBareJID());
                        group.initialize(session);
                        String sJID = group.getJID().toString();
                        groups.put(sJID, group);
                        if (this._archive.enabled()) {
                            this._archive.onSetup(sJID, session.getUser().getUID());
                        }
                        StreamElement itemElement = sdf.createElementNode(new NSI("item", null), null);
                        itemElement.setAttributeValue("affiliation", "owner");
                        itemElement.setAttributeValue("role", "moderator");
                        boolean b = group.addMember(session, packet, nick, false, itemElement);
                        if (!b) {
                            PacketError error = sdf.createPacketError(PacketError.CANCEL, "not-allowed");
                            newp.add((StreamNode)error);
                        } else {
                            StreamElement statusElement = sdf.createElementNode(new NSI("status", null), null);
                            statusElement.setAttributeValue("code", "201");
                            ext.add((StreamNode)statusElement);
                            ext.add((StreamNode)itemElement);
                        }
                    } else {
                        PacketError error = sdf.createPacketError(PacketError.CANCEL, "not-allowed");
                        newp.add((StreamNode)error);
                    }
                    session.send((Packet)newp);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
        }
    }

    public void handleChatMessage(StreamEndPoint session, Packet packet) {
        block37: {
            if (!session.validate(packet)) {
                return;
            }
            JID recipient = packet.getTo();
            GroupChat group = this.getGroupChat(recipient.toBareJID());
            MonitorTransaction transaction = null;
            StreamDataFactory sdf = session.getDataFactory();
            if (group == null) {
                try {
                    BaseUser u = this.getUser(recipient.toBareJID());
                    if (u != null) {
                        u.send(packet);
                        return;
                    }
                }
                catch (StreamException se) {
                    Log.printStackTrace((Exception)((Object)se));
                    return;
                }
                catch (RealmException re) {
                    Log.printStackTrace((Exception)((Object)re));
                }
                session.sendError(packet, PacketError.CANCEL, "item-not-found", "GroupChat " + recipient + " not found");
                return;
            }
            if (msgTranFactory != null) {
                transaction = msgTranFactory.startTransaction();
            }
            Log.debug("[GroupChat:" + group.getJID() + "] adding message from " + session.getJID());
            if (Message.GROUPCHAT.equals((Object)packet.getType())) {
                if (recipient.getResource().length() != 0) {
                    packet.setTo(session.getJID());
                    packet.setFrom(group.getJID());
                    PacketError error = sdf.createPacketError(PacketError.MODIFY, "bad-request");
                    error.setText("use type=chat for side chats.");
                    packet.add((StreamNode)error);
                    try {
                        session.sendNow(packet);
                    }
                    catch (StreamException e) {}
                } else {
                    try {
                        if (!group.addMessage(session, packet)) {
                            session.sendError(packet, PacketError.CANCEL, "forbidden", "not allowed to participate this room", group.getJID(), session.getJID(), null, transaction);
                        } else {
                            if (this._archive.enabled() && !packet.listElements("body").isEmpty()) {
                                XMPPMessage message = new XMPPMessage(session.getDataFactory(), (Packet)((Message)packet));
                                message.setOriginator(session.getJID().toBareJID().toString());
                                this._archive.onConferenceMessage(group.getJID().toString(), (ReadOnlyMessage)message);
                            }
                            if (transaction != null) {
                                transaction.stop(true);
                            }
                        }
                    }
                    catch (Exception e) {
                        session.sendError(packet, PacketError.CANCEL, "internal-server-error", e.toString(), group.getJID(), session.getJID(), null, transaction);
                    }
                }
            } else {
                if (Message.CHAT.equals((Object)packet.getType())) {
                    packet.setTo(group.getMemberJID(recipient.getResource()));
                    try {
                        if (!group.addMessage(session, packet, recipient.getResource())) {
                            session.sendError(packet, PacketError.CANCEL, "not-allowed", "not allowed to participate this room", group.getJID(), session.getJID(), null, transaction);
                        } else if (transaction != null) {
                            transaction.stop(true);
                        }
                        break block37;
                    }
                    catch (Exception e) {
                        if (transaction != null) {
                            transaction.stop(false);
                        }
                        break block37;
                    }
                }
                if (packet.getFirstElement(null, IBBHandler.NAMESPACE) != null) {
                    if (IMPolicyManager.canTransferFiles(session.getUser())) {
                        NMS.get().getClientPacketDispatcher().getIBBHandler().processMessage(session, packet, null);
                    } else {
                        session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized to transfer files", group.getJID(), session.getJID(), null);
                    }
                } else {
                    Iterator i = packet.listElements(NSI_USER).iterator();
                    while (i.hasNext()) {
                        StreamElement ext = (StreamElement)i.next();
                        Log.debug("[GroupChat:" + group.getJID() + "] MUC extension: " + ext);
                        Iterator j = ext.listElements().iterator();
                        while (j.hasNext()) {
                            StreamElement e = (StreamElement)j.next();
                            Log.debug("[GroupChat:" + group.getJID() + "] type=normal element=" + e);
                            if (e.getLocalName().equals("invite")) {
                                this.processInvite(session, packet, e, group, true);
                                continue;
                            }
                            if (!e.getLocalName().equals("decline")) continue;
                            this.processDecline(session, packet, e, group, true);
                        }
                    }
                    List le = packet.listElements("subject");
                    if (le != null && le.size() > 0) {
                        StreamElement subjectElement = (StreamElement)le.get(0);
                        try {
                            if (!group.setSubject(session, packet, subjectElement)) {
                                session.sendError(packet, PacketError.CANCEL, "not-allowed", "not allowed to change subject in this room", group.getJID(), session.getJID(), null);
                            }
                        }
                        catch (StreamException se) {
                            session.sendError(packet, PacketError.CANCEL, "internal-server-error", se.getMessage(), group.getJID(), session.getJID(), null);
                        }
                    }
                }
            }
        }
    }

    protected void processAdminRequest(StreamEndPoint session, Packet packet) {
        StreamDataFactory sdf = session.getDataFactory();
        Object errorText = null;
        Object errorType = null;
        if (!session.validate(packet)) {
            return;
        }
        GroupChat group = this.getGroupChat(packet.getTo().toBareJID());
        if (group == null) {
            session.sendError(packet, PacketError.CANCEL, "item-not-found", "GroupChat " + packet.getTo() + " not found");
            return;
        }
        if (group.isPersistent() && !IMPolicyManager.canManageConferenceRooms(session.getUser())) {
            session.sendError(packet, PacketError.AUTH, "not-authorized", "Not authorized to manage the conferences");
        }
        if (!group.isAdmin(session.getUser().getUID())) {
            session.sendError(packet, PacketError.CANCEL, "forbidden", "Need administrative rights to do this");
            return;
        }
        List queryNodes = packet.listElements("query");
        StreamElement query = (StreamElement)queryNodes.get(0);
        if (packet.getType().equals((Object)InfoQuery.SET)) {
            StreamElement responseQuery = sdf.createElementNode(NSI_ADMIN);
            Iterator j = query.listElements("item").iterator();
            while (j.hasNext()) {
                StreamElement itemElement = (StreamElement)j.next();
                try {
                    if (!group.setMemberRole(session, itemElement)) {
                        responseQuery.add((StreamNode)itemElement);
                        session.sendError(packet, PacketError.CANCEL, "not-allowed", "Insufficient rights to this resource", group.getJID(), null, responseQuery);
                        return;
                    }
                    responseQuery.add((StreamNode)itemElement);
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                    session.sendError(packet, PacketError.MODIFY, "bad-request", e.toString());
                    return;
                }
                session.sendResult(packet, responseQuery, group.getJID(), packet.getFrom());
            }
        } else if (packet.getType().equals((Object)InfoQuery.GET)) {
            try {
                StreamElement responseQuery = sdf.createElementNode(NSI_ADMIN);
                Iterator i = query.listElements().iterator();
                while (i.hasNext()) {
                    StreamElement item = (StreamElement)i.next();
                    group.queryItems(session, responseQuery, item);
                }
                session.sendResult(packet, responseQuery, group.getJID(), packet.getFrom());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                session.sendError(packet, PacketError.MODIFY, "bad-request", "Invalid request");
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "IQ request types are set or get, period.");
        }
    }

    protected void processOwnerRequest(StreamEndPoint session, Packet packet) {
        StreamDataFactory sdf = session.getDataFactory();
        String errorText = null;
        PacketError.Type errorType = null;
        String errorCondition = null;
        if (!session.validate(packet)) {
            return;
        }
        GroupChat group = this.getGroupChat(packet.getTo().toBareJID());
        if (group == null) {
            session.sendError(packet, PacketError.CANCEL, "item-not-found", "GroupChat " + packet.getTo() + " not found");
            return;
        }
        if (!group.isOwner(session.getUser().getUID())) {
            session.sendError(packet, PacketError.CANCEL, "forbidden", "Only a conference owner can do this");
            return;
        }
        List queryNodes = packet.listElements("query");
        StreamElement query = (StreamElement)queryNodes.get(0);
        StreamElement responseQuery = null;
        if (packet.getType().equals((Object)InfoQuery.SET)) {
            block33: {
                try {
                    List destroyElements = query.listElements("destroy");
                    if (!destroyElements.isEmpty()) {
                        if (group.isPersistent()) {
                            if (!IMPolicyManager.canManageConferenceRooms(session.getUser())) {
                                errorType = PacketError.AUTH;
                                errorText = "Not authorized to manage conference rooms.";
                                errorCondition = "not-authorized";
                            } else {
                                this.storageProvider.destroy(group.getJID().toString());
                            }
                        }
                        if (errorType == null) {
                            group.destroy(session, (StreamElement)destroyElements.get(0));
                            String sGroupJID = packet.getTo().toString();
                            groups.remove(sGroupJID);
                            if (this._archive.enabled()) {
                                this._archive.onClose(sGroupJID, session.getUser().getUID());
                            }
                        }
                        break block33;
                    }
                    List l = query.listElements(XDataForm.NAME);
                    if (l.size() == 1) {
                        XDataForm form = (XDataForm)l.get(0);
                        Iterator i = form.listItems().iterator();
                        while (i.hasNext()) {
                            XDataField field = (XDataField)i.next();
                        }
                        if (GroupChatHandler.isPersistent(form)) {
                            if (!IMPolicyManager.canManageConferenceRooms(session.getUser())) {
                                errorType = PacketError.AUTH;
                                errorText = "Not authorized to manage conference rooms.";
                                errorCondition = "not-authorized";
                            } else {
                                this.storageProvider.create(group.getJID().toString());
                                group.saveConfiguration(form);
                            }
                        }
                        break block33;
                    }
                    if (l.size() == 0) {
                        try {
                            if (!group.updateAffiliations(session, query)) {
                                errorType = PacketError.AUTH;
                                errorText = "You cannot remove your owner privilege";
                                errorCondition = "not-authorized";
                            }
                            break block33;
                        }
                        catch (Exception e) {
                            errorType = PacketError.CANCEL;
                            errorCondition = "internal-server-error";
                            errorText = e.getMessage();
                        }
                        break block33;
                    }
                    errorType = PacketError.MODIFY;
                    errorText = "Missing or too many x elements.";
                    errorCondition = "bad-request";
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                    errorType = PacketError.CANCEL;
                    errorCondition = "internal-server-error";
                    errorText = e.getMessage();
                }
            }
            if (errorType == null) {
                session.sendResult(packet);
            } else {
                session.sendError(packet, errorType, errorCondition, errorText);
            }
        } else if (packet.getType().equals((Object)InfoQuery.GET)) {
            responseQuery = sdf.createElementNode(NSI_OWNER);
            try {
                if (query.listElements().size() > 0) {
                    Iterator i = query.listElements().iterator();
                    while (i.hasNext()) {
                        StreamElement item = (StreamElement)i.next();
                        group.queryItems(session, responseQuery, item);
                    }
                } else {
                    responseQuery.add((StreamNode)group.getConfiguration());
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                errorType = PacketError.CANCEL;
                errorText = e.getMessage();
                errorCondition = "internal-server-error";
            }
            if (errorType == null) {
                session.sendResult(packet, responseQuery, group.getJID(), packet.getFrom());
            } else {
                session.sendError(packet, errorType, errorCondition, errorText);
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "IQ request types are set or get, period.");
        }
    }

    void processInvite(StreamEndPoint session, Packet packet, StreamElement inviteElement, GroupChat group, boolean addJabberIQConference) {
        BaseUser u;
        List t;
        StreamElement reasonElement;
        StreamDataFactory sdf = session.getDataFactory();
        String to = inviteElement.getAttributeValue("to");
        JID toJID = new JID(to);
        Log.debug("[GroupChat:" + group.getJID() + "] invite from " + session.getJID() + " to " + toJID);
        if (!IMPolicyManager.canInvite(session.getUser())) {
            session.sendError(packet, PacketError.AUTH, "not-authorized", "Not authorized to invite other user");
        } else {
            Log.debug(session.getUser().getJID() + " has permission to invite");
        }
        if (group.isOutcast(toJID.toBareJID())) {
            Log.info("[GroupChat:" + group.getJID() + "] failed attempt to invite an outcast: " + toJID);
            return;
        }
        if (group.hasMember(null, toJID)) {
            Log.info("[GroupChat:" + group.getJID() + "] inviting already present: " + toJID);
            return;
        }
        Iterator i = inviteElement.listElements("reason").iterator();
        while (i.hasNext()) {
            reasonElement = (StreamElement)i.next();
            Log.debug("[GroupChat:" + group.getJID() + "] invite reason (before) " + reasonElement);
            t = reasonElement.listText();
            if (t == null || t.size() <= 0) continue;
            Log.debug("[GroupChat:" + group.getJID() + "] invite reason (before) " + ((StreamText)t.get(0)).getValue());
        }
        if (addJabberIQConference) {
            StreamElement ext = sdf.createElementNode(new NSI("x", NAMESPACE_CONFERENCE));
            Iterator iter = ((StreamElement)inviteElement.clone()).listElements("reason").iterator();
            while (iter.hasNext()) {
                StreamElement reasonElement2 = (StreamElement)iter.next();
                List t2 = reasonElement2.listText();
                if (t2 == null || t2.size() <= 0) continue;
                ext.add((StreamNode)((StreamText)t2.get(0)));
            }
            packet.add((StreamNode)ext);
        }
        packet.setTo(toJID);
        packet.setFrom(group.getJID());
        inviteElement.setAttributeValue("from", session.getJID().toBareJID().toString());
        inviteElement.setAttributeValue("to", null);
        i = inviteElement.listElements("reason").iterator();
        while (i.hasNext()) {
            reasonElement = (StreamElement)i.next();
            Log.debug("[GroupChat:" + group.getJID() + "] invite reason (after) " + reasonElement);
            t = reasonElement.listText();
            if (t == null || t.size() <= 0) continue;
            Log.debug("[GroupChat:" + group.getJID() + "] invite reason (after) " + ((StreamText)t.get(0)).getValue());
        }
        try {
            u = this.getUser(toJID.toBareJID());
        }
        catch (RealmException re) {
            Log.printStackTrace((Exception)((Object)re));
            return;
        }
        try {
            if (u != null) {
                u.send(packet);
            }
            if (this._archive.enabled()) {
                this._archive.onInvite(group.getJID().toString(), (ReadOnlyMessage)new XMPPMessage(session.getDataFactory(), (Packet)((Message)packet)));
            }
        }
        catch (StreamException se) {
            Log.printStackTrace((Exception)((Object)se));
        }
        catch (CollaborationException ce) {
            Log.printStackTrace((Exception)((Object)ce));
        }
    }

    void processDecline(StreamEndPoint session, Packet packet, StreamElement declineElement, GroupChat group, boolean addJabberIQConference) {
        BaseUser u;
        String to = declineElement.getAttributeValue("to");
        try {
            u = this.getUser(new JID(to).toBareJID());
        }
        catch (RealmException re) {
            Log.printStackTrace((Exception)((Object)re));
            return;
        }
        packet.setTo(new JID(to));
        packet.setFrom(group.getJID());
        declineElement.setAttributeValue("from", session.getJID().toBareJID().toString());
        declineElement.setAttributeValue("to", null);
        try {
            if (u != null) {
                u.send(packet);
            }
        }
        catch (StreamException se) {
            // empty catch block
        }
    }

    GroupChat getGroupChat(JID jid) {
        return this.getGroupChat(jid.toString());
    }

    GroupChat getGroupChat(String address) {
        return (GroupChat)groups.get(address);
    }

    GroupChat getGroupChat(String address, StreamEndPoint session) {
        GroupChat g = (GroupChat)groups.get(address);
        if (g == null) {
            boolean searchDefaultDomain = !(session.getUser() instanceof LocalUser);
            String[] id = this.storageProvider.search((CollaborationPrincipal)session.getUser(), address, searchDefaultDomain);
            if (id == null || id.length == 0) {
                Log.debug("[GroupChat] not found " + address);
            } else if (id.length == 1) {
                g = this.loadGroupChat(id[0], session);
            } else {
                Log.debug("[GroupChat] more than one match for " + address);
            }
        }
        return g;
    }

    synchronized GroupChat loadGroupChat(String address, StreamEndPoint session) {
        GroupChat g = (GroupChat)groups.get(address);
        if (g == null) {
            g = new GroupChat(this, address);
            try {
                g.initialize(session);
                groups.put(address, g);
                if (this._archive.enabled()) {
                    this._archive.onSetup(address, session.getUser().getUID());
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                g = null;
            }
        }
        return g;
    }

    protected void clear() {
        groups.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public PacketError.Type fillInfo(DiscoInfoQuery query, JID jid, String node, StreamEndPoint session) {
        if (!jid.hasNode()) {
            query.addIdentity("conference", "text", this.getName());
            query.addFeature(NAMESPACE);
            return null;
        }
        GroupChat g = (GroupChat)groups.get(jid.toString());
        if (g == null) {
            Log.warning("Unknown public conference: " + jid);
            return PacketError.CANCEL;
        }
        query.addIdentity("conference", "text", this.getName());
        query.addFeature(NAMESPACE);
        if (!g.isPersistent()) {
            query.addFeature("muc_temporary");
            query.addFeature("muc_hidden");
            query.addFeature("muc_nonanonymous");
        } else {
            query.addFeature("muc_persistent");
            query.addFeature("muc_public");
            switch (g.getDefaultAccess()) {
                case 1: {
                    query.addFeature("muc_membersonly");
                    break;
                }
                case 2: {
                    query.addFeature("muc_moderated");
                    break;
                }
                default: {
                    query.addFeature("muc_open");
                    query.addFeature("muc_unmoderated");
                }
            }
        }
        query.add((StreamNode)g.getRoomInfo(session));
        return null;
    }

    public PacketError.Type fillItems(DiscoItemsQuery query, JID jid, String node, StreamEndPoint session) {
        String rule;
        int colon;
        StreamDataFactory sdf = session.getDataFactory();
        JID bareJID = session.getJID().toBareJID();
        String param = null;
        String value = null;
        if (node != null && node.length() > 0 && node.charAt(0) == '{' && (colon = (rule = node.substring(0, node.length() - 1).substring(1)).indexOf(58)) > 0) {
            param = rule.substring(0, colon - 1);
            value = rule.substring(colon + 1);
        }
        if (jid.hasNode()) {
            GroupChat g = this.getGroupChat(jid.toString());
            if (g != null) {
                Log.debug("[GroupChat] retrieving elements for " + jid);
                StreamElement pattern = sdf.createElementNode(NSI_ITEM);
                if (param != null) {
                    pattern.setAttributeValue(param, value);
                }
                g.queryItems(session, (StreamElement)query, pattern);
            }
        } else {
            boolean searchDefaultDomain = !(session.getUser() instanceof LocalUser);
            String[] id = this.storageProvider.search((CollaborationPrincipal)session.getUser(), node, searchDefaultDomain);
            if (id == null) {
                return null;
            }
            Log.debug("[GroupChat] search returned " + id.length + " room(s)");
            for (int i = 0; i < id.length; ++i) {
                GroupChat g = this.loadGroupChat(id[i], session);
                if (g == null) continue;
                if (param != null && value != null) {
                    StreamElement item = g.getAffiliation(bareJID.toString());
                    if (item != null) {
                        if (value.indexOf(item.getAttributeValue(param)) < 0) continue;
                        query.addItem(g.getJID(), null, g.getName());
                        continue;
                    }
                    if (g.affiliation2access(value) != g.getDefaultAccess()) continue;
                    query.addItem(g.getJID(), null, g.getName());
                    continue;
                }
                if (g.isOutcast(bareJID)) continue;
                query.addItem(g.getJID(), null, g.getName());
            }
        }
        return null;
    }

    public PacketError.Type updateItems(DiscoItemsQuery query, JID jid, StreamEndPoint session) {
        return PacketError.MODIFY;
    }

    public String getName() {
        return "Multi User Conference Service";
    }

    public PacketError.Type fillAgentInfo(StreamElement agentElement, StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        agentElement.add((StreamNode)sdf.createElementNode(new NSI("groupchat", null), null));
        StreamElement service = sdf.createElementNode(new NSI("service", null), null);
        service.add((StreamNode)sdf.createText("public"));
        agentElement.add((StreamNode)service);
        return null;
    }

    public String[] getNamespaces() {
        String[] ns = new String[]{NAMESPACE, NAMESPACE_USER, NAMESPACE_ADMIN, NAMESPACE_OWNER, NAMESPACE_CONFERENCE};
        return ns;
    }

    public PacketError.Type fillBrowseInfo(JID jid, StreamElement query, StreamEndPoint session) {
        return null;
    }

    public String getCategory() {
        return "conference";
    }

    public String getType() {
        return "private";
    }

    protected void remove(GroupChat group) {
        String id = group.getJID().toString();
        groups.remove(id);
        Log.debug("[GroupChat:" + group.getJID() + "] removed");
        try {
            if (group.isPersistent()) {
                this.storageProvider.destroy(id);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    protected static XDataForm getDefaultConfigForm(StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        return GroupChatHandler.getDefaultConfigForm(sdf);
    }

    protected static XDataForm getDefaultConfigForm(StreamDataFactory sdf) {
        if (_defaultConfigForm == null) {
            _defaultConfigForm = (XDataForm)sdf.createElementNode(XDataForm.NAME, XDataForm.class);
            _defaultConfigForm.setType(XDataForm.FORM);
            XDataField formType = _defaultConfigForm.addField("FORM_TYPE", XDataField.HIDDEN);
            formType.setValue(NAMESPACE_ROOMCONFIG);
            XDataField persist = _defaultConfigForm.addField("muc#roomconfig_persistentroom", XDataField.BOOLEAN);
            persist.setValue("0");
            XDataField moderated = _defaultConfigForm.addField("muc#roomconfig_moderatedroom", XDataField.BOOLEAN);
            moderated.setValue("0");
            XDataField restricted = _defaultConfigForm.addField("muc#roomconfig_membersonly", XDataField.BOOLEAN);
            restricted.setValue("0");
            XDataField changesubject = _defaultConfigForm.addField("muc#roomconfig_changesubject", XDataField.BOOLEAN);
            changesubject.setValue("0");
        }
        return _defaultConfigForm;
    }

    static boolean isPersistent(XDataForm form) {
        XDataField f = form.getField("muc#roomconfig_persistentroom");
        String bs = form.getFieldValue("muc#roomconfig_persistentroom");
        Log.debug("muc#roomconfig_persistentroom=[" + bs + "]");
        return bs != null && bs.equals("1");
    }

    static boolean isModerated(XDataForm form) {
        String bs = form.getFieldValue("muc#roomconfig_moderatedroom");
        return bs != null && bs.equals("1");
    }

    static boolean isRestricted(XDataForm form) {
        String bs = form.getFieldValue("muc#roomconfig_membersonly");
        return bs != null && bs.equals("1");
    }

    static boolean canChangeSubject(XDataForm form) {
        String bs = form.getFieldValue("muc#roomconfig_changesubject");
        return bs != null && bs.equals("1");
    }

    protected static XDataForm buildConfigForm(StreamEndPoint session, StreamElement config) {
        StreamDataFactory sdf = session.getDataFactory();
        XDataForm form = (XDataForm)sdf.createElementNode(XDataForm.NAME, XDataForm.class);
        form.setType(XDataForm.FORM);
        XDataField formType = form.addField("FORM_TYPE", XDataField.HIDDEN);
        formType.setValue(NAMESPACE_ROOMCONFIG);
        Iterator i = config.listElements().iterator();
        while (i.hasNext()) {
            String var;
            StreamElement elem = (StreamElement)i.next();
            if (!elem.getLocalName().equals("field") || (var = elem.getAttributeValue("var")).equals("FORM_TYPE")) continue;
            if (var.startsWith("muc#owner_")) {
                var = StringUtility.substitute((String)var, (String)"muc#owner_", (String)"muc#roomconfig_");
            }
            XDataField f = form.addField(var, XDataField.BOOLEAN);
            Iterator j = elem.listElements().iterator();
            while (j.hasNext()) {
                f.add((StreamNode)((StreamElement)j.next()));
            }
        }
        return form;
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                msgTranFactory = monitor.getTransactionFactory("muc-message");
                admTranFactory = monitor.getTransactionFactory("muc-admin");
                preTranFactory = monitor.getTransactionFactory("muc-presence");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

