/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPComponentSession;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;

public class GatewayedEndPoint
extends StreamEndPoint {
    private XMPPComponentSession gateway;

    public GatewayedEndPoint() {
    }

    public GatewayedEndPoint(XMPPComponentSession gateway, JID jid) {
        super(jid);
        this.gateway = gateway;
        this.setUser(new BaseUser(jid.getNode(), gateway.getJID().getDomain()));
        this.getUser().addSession(this);
    }

    public GatewayedEndPoint(XMPPComponentSession gateway, JID jid, BaseUser u) {
        super(jid);
        this.gateway = gateway;
        if (u == null) {
            u = new BaseUser(jid.getNode(), jid.getDomain());
        }
        this.setUser(u);
        this.getUser().addSession(this);
        gateway.addGatewayedEndPoint(this);
    }

    public Stream getStream() {
        return this.gateway.getStream();
    }

    boolean validate(Packet packet) {
        if (packet.getFrom() == null) {
            packet.setFrom(this.getJID());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Log.debug("GatewayedEndPoint[" + this.getJID() + "] being closed");
        BaseUser u = this.getUser();
        GatewayedEndPoint gatewayedEndPoint = this;
        synchronized (gatewayedEndPoint) {
            if (u != null) {
                u.removeSession(this);
                this.setUser(null);
            }
        }
        Presence p = this.getUnavailablePresence();
        if (p.getTo() == null) {
            p.setTo(this.getJID());
        }
        this.send((Packet)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedByStream() {
        this.sendUnavailable();
        BaseUser u = this.getUser();
        GatewayedEndPoint gatewayedEndPoint = this;
        synchronized (gatewayedEndPoint) {
            if (u != null) {
                u.removeSession(this);
                this.setUser(null);
            }
        }
    }

    private void sendUnavailable() {
        Presence p = this.getPresence();
        Log.debug("Session[" + this.getJID() + "] DEBUG sendUnavailable p=" + p);
        if (p != null && !Presence.UNAVAILABLE.equals((Object)p.getType())) {
            Log.debug("Session[" + this.getJID() + "] sending unavailable presence on behalf of user");
            p = this.getUnavailablePresence();
            ClientPacketDispatcher rq = this.gateway.getDispatcher();
            rq.presenceHandler.update(this, (Packet)p, rq);
        }
    }
}

