/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.FileGroupChatStorage;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NewsChannel;
import com.sun.im.provider.NewsStorageProvider;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class FileNewsStorage
extends FileGroupChatStorage
implements NewsStorageProvider {
    public static final String MSG_SUFFIX = ".msg";
    private Map _newsChannels = new HashMap();

    public FileNewsStorage() {
        super("pubsub");
    }

    public void saveMessage(String id, String msgId, String xml) throws Exception {
        this.save(id, xml, msgId + MSG_SUFFIX);
    }

    public void deleteMessage(String id, String msgId) throws Exception {
        File f = this.getDirectory(id, false);
        if (!(f = new File(f, msgId + MSG_SUFFIX)).delete()) {
            Log.error("[FileNewsStorage#deleteMessage:" + id + "] failed to delete message id=" + msgId);
            throw new Exception("[FileNewsStorage#deleteMessage:" + id + "] failed to delete message id=" + msgId);
        }
    }

    public void deleteMessages(String id) throws Exception {
        Log.debug("[FileNewsStorage#deleteMessages: " + id + "]");
        String[] fileNames = this.getMessageFileNames(id);
        boolean errorDelete = false;
        File f = this.getDirectory(id, false);
        File msgFile = null;
        for (int i = 0; i < fileNames.length; ++i) {
            msgFile = new File(f, fileNames[i]);
            Log.debug("Deleting the message file : " + fileNames[i]);
            if (msgFile.delete()) continue;
            Log.error("delete failed" + id + " " + fileNames[i]);
            errorDelete = true;
        }
        if (errorDelete) {
            throw new Exception("[FileNewsStorage#deleteMessages:" + id + "] failed to delete message(s)");
        }
    }

    public String getMessage(String id, String msgId) throws SAXException, Exception {
        return this.load(id, msgId + MSG_SUFFIX);
    }

    public String[] getMessageIds(String id) throws Exception {
        ArrayList messages = new ArrayList();
        File f = this.getDirectory(id, false);
        String[] filenames = this.getMessageFileNames(id);
        String[] messageIds = new String[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            messageIds[i] = filenames[i].substring(0, filenames[i].length() - 4);
        }
        return messageIds;
    }

    private String[] getMessageFileNames(String id) throws Exception {
        File f = this.getDirectory(id, false);
        String[] filenames = null;
        filenames = f.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(FileNewsStorage.MSG_SUFFIX);
            }
        });
        return filenames;
    }

    protected String getStorageName(NewsChannel nc) {
        String name = null;
        name = nc.getJID().getDomain().equalsIgnoreCase(NMS.getName()) ? nc.getName() : nc.getUID();
        return name;
    }
}

