/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.MigrateRoster;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.util.WildCardPattern;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class FileGroupChatStorage
implements ConferenceStorageProvider {
    final String AFFILIATIONS_FILENAME = "affiliations.xml";
    final String CONFIGURATION_FILENAME = "configuration.xml";
    Properties _props = new Properties();
    File _f;
    File _rootDir;
    String _domain;
    String _subDomain;
    String _migrateName;

    public FileGroupChatStorage() {
        this("muc");
    }

    public FileGroupChatStorage(String name) {
        this._migrateName = name;
        this._rootDir = new File(NMS.getDBDir(), name);
        if (!this._rootDir.isDirectory() && !this._rootDir.mkdirs()) {
            Log.error("Unable to create root dir:" + this._rootDir.toString());
        }
        Log.debug("[FileGroupChatStorage] root dir = " + this._rootDir.toString());
        this.load(name + ".properties");
        this._subDomain = name + ".";
        this._domain = name + "." + NMS.getName();
    }

    public String loadAffiliations(String id) throws Exception {
        return this.load(id, "affiliations.xml");
    }

    public void saveAffiliations(String id, String xml) throws Exception {
        this.save(id, xml, "affiliations.xml");
    }

    public String loadConfiguration(String id) throws Exception {
        return this.load(id, "configuration.xml");
    }

    public void saveConfiguration(String id, String xml) throws Exception {
        this.save(id, xml, "configuration.xml");
    }

    protected String load(String id, String filename) throws Exception {
        File dir = this.getDirectory(id, false);
        if (!dir.exists()) {
            return null;
        }
        File f = new File(dir, filename);
        if (!f.exists()) {
            return null;
        }
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
            char[] c = new char[(int)f.length()];
            int len = in.read(c, 0, c.length);
            in.close();
            return new String(c, 0, len);
        }
        catch (Exception e) {
            if (in != null) {
                in.close();
            }
            Log.printStackTrace(e);
            Log.error("Removing corrupted file: " + f.getAbsolutePath());
            f.delete();
            return null;
        }
    }

    protected void save(String id, String xml, String filename) throws Exception {
        File dir = this.getDirectory(id, true);
        File f = new File(dir, filename);
        File tmpfile = PlatformUtil.getTempFile((File)f);
        FileOutputStream os = new FileOutputStream(tmpfile);
        os.write(xml.getBytes("UTF-8"));
        os.close();
        if (!PlatformUtil.renameTempFile((File)tmpfile, (File)f)) {
            throw new Exception("Failed to rename " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath());
        }
        Log.debug("FileGroupChatStorage: Saved " + f.getAbsolutePath());
    }

    public void destroy(String id) throws Exception {
        File dir = this.getDirectory(id, false);
        if (dir.exists()) {
            this.removeDirectory(dir);
        }
        this._props.remove(id);
        this.save();
    }

    File getDirectory(String id, boolean create) throws Exception {
        File dir;
        String name = id;
        if (StringUtility.getDomainFromAddress((String)id, (String)NMS.getName()).equalsIgnoreCase(NMS.getName())) {
            name = StringUtility.getLocalPartFromAddress((String)id);
        }
        if (!(dir = new File(this._rootDir, name)).exists()) {
            if (create && !dir.mkdirs()) {
                throw new Exception("Failed to create directory: " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new Exception("Not a directory: " + dir.toString());
        }
        return dir;
    }

    void removeDirectory(File dir) {
        File[] file = dir.listFiles();
        for (int i = 0; i < file.length; ++i) {
            if (file[i].isDirectory()) {
                this.removeDirectory(file[i]);
                continue;
            }
            file[i].delete();
        }
        dir.delete();
    }

    void load(String filename) {
        try {
            this._f = new File(NMS.getDBDir(), filename);
            Log.debug("[FileGroupChatStorage] loaded " + this._f.toString());
            if (!this._f.exists()) {
                this.migrate();
            } else {
                FileInputStream is = new FileInputStream(this._f);
                this._props.load(is);
                is.close();
                Log.debug("[FileGroupChatStorage] loaded " + this._f.toString());
            }
        }
        catch (Exception e) {
            Log.warning("Could not load room list: " + e.toString());
        }
    }

    private void migrate() throws Exception {
        File f = null;
        try {
            f = new File(NMS.getDBDir(), "storage.properties");
            if (!f.exists()) {
                return;
            }
            FileInputStream is = new FileInputStream(f);
            Properties p = new Properties();
            p.load(is);
            is.close();
            Log.debug("[FileGroupChatStorage] loaded " + f.toString());
            if ("muc".equals(this._migrateName)) {
                this._props = MigrateRoster.migrateMuc(this, p);
                this.save();
            } else if ("pubsub".equals(this._migrateName)) {
                this._props = MigrateRoster.migratePubsub(this, p);
                this.save();
            }
        }
        catch (Exception e) {
            Log.info("[FileGroupChatStorage] Failed to migrate: " + e.toString());
        }
    }

    void save() throws IOException {
        this._props.store(new FileOutputStream(this._f), "persistent rooms");
        Log.debug("[FileGroupChatStorage] saved " + this._f.toString());
    }

    public boolean exists(String id) {
        return this._props.get(id) != null;
    }

    public synchronized void create(String id) throws Exception {
        if (this._props.get(id) == null) {
            this._props.put(id, "TBD");
            this.save();
        } else {
            Log.debug("[FileGroupChatStorage] adding " + id + " twice");
        }
    }

    public String[] search(String pattern) {
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            String[] a = new String[]{pattern};
            return a;
        }
        LinkedList<String> v = new LinkedList<String>();
        Iterator<Object> iter = this._props.keySet().iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (!wcp.match(StringUtility.getLocalPartFromAddress((String)s))) continue;
            v.add(s);
        }
        if (v.size() > 0) {
            String[] ra = new String[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (String)iter2.next();
            }
            return ra;
        }
        return null;
    }

    public String[] search(CollaborationPrincipal u, String pattern, boolean useDefaultDomain) {
        Log.debug("[FileGroupChatStorage] searching items matching " + pattern);
        String userDomain = null;
        userDomain = useDefaultDomain ? NMS.getName() : u.getDomainName();
        WildCardPattern wcp = new WildCardPattern(pattern);
        if (wcp.getFilterType() == 4) {
            Log.debug("[FileGroupChatStorage] looking for exact match: " + pattern);
            if (this._props.get(pattern) != null) {
                String[] a = new String[]{pattern};
                if (StringUtility.getDomainFromAddress((String)pattern, (String)this._domain).equalsIgnoreCase(this._subDomain + userDomain)) {
                    return a;
                }
            }
            return null;
        }
        LinkedList<String> v = new LinkedList<String>();
        Iterator<Object> iter = this._props.keySet().iterator();
        while (iter.hasNext()) {
            String id = (String)iter.next();
            if (!StringUtility.getDomainFromAddress((String)id, (String)this._domain).equalsIgnoreCase(this._subDomain + userDomain)) continue;
            Log.debug("[FileGroupChatStorage] match " + pattern + " vs " + id);
            if (!wcp.match(StringUtility.getLocalPartFromAddress((String)id))) continue;
            v.add(id);
        }
        if (v.size() > 0) {
            String[] ra = new String[v.size()];
            int i = 0;
            Iterator iter2 = v.iterator();
            while (iter2.hasNext()) {
                ra[i++] = (String)iter2.next();
            }
            return ra;
        }
        return null;
    }
}

